;***********************Belltsok********************************************

;        PROCESSOR '16F877A'
		list p=16F877A
        INCLUDE <P16F877A.INC>

        __CONFIG _XT_OSC & _WDT_OFF & _PWRTE_OFF & _CP_OFF & _LVP_OFF & _BODEN_OFF
		
	
;**********************Vltozk************************************************

		cblock  0x20
				TIMERTCS		; Timer1 tlcsordulsok szmllja
				TIMERTCS1
				TIMERTCS2
				TULCSORDUL
				TEMP1L			; CCP els rtk tmeneti trol, als bit
				TEMP1H			; CCP els rtk tmeneti trol, fels bit
				TEMP2L			; CCP msodik rtk tmeneti trol, als bit
				TEMP2H			; CCP msodik rtk tmeneti trol, fels bit
				W_TEMP			; W tmeneti trolja
				S_TEMP			; S tmeneti trolja
				TIMEL			; Id als bjt
				TIMEH			; Id fels bjt
				FIRST			; Kiolvass jelzbit
				TIMER1L			; Idtartamszmts, als bjt 
				TIMER1M			; Idtartamszmts, kzps bjt 
				TIMER1H			; Idtartamszmts, fels bjt 
				count           ; Szmll a ciklus-rutinokhoz.
				count1          ; Szmllk a ksleltet rutinhoz.
				counta
				countb
				count2
				tmp1            ; tmeneti trols.
				tmp2
				templcd         ; tmeneti trol a 4 bites mdhoz.
				templcd2
				SZORZO			; Szorz
				r1				; Eredmny, als bjt
				r2				; Eredmny, kzps bjt
				r3				; Eredmny, fels bjt
				bL				; Szorzand, als bjt
				bH				; Szorzand, fels bjt
				nratorH			; Szmll s eredmny fels bjt
				nratorM			; Szmll s eredmny kzps bjt
				nratorL			; Szmll s eredmny als bjt
				denomH			; Nevez fels bjt
				denomM			; Nevez kzps bjt
				denomL			; Nevez als bjt
				remainH			; Maradk fels bjt
				remainM			; Maradk kzps bjt
				remainL			; Maradk als bjt
                BCount          ; Szmll az osztshoz
                shiftH          ; Segdregiszter az osztshoz
                shiftM          ; Segdregiszter az osztshoz
                shiftL          ; Segdregiszter az osztshoz
		endc
		
LCD_PORT Equ PORTD
LCD_TRIS Equ TRISD
LCD_RS   Equ 0x04           ; A Register Select (RS) vonal vltozja.
LCD_E    Equ 0x07           ; Az Enable         (E)  vonal vltozja.

	ORG 0
	goto Init
;*********************Megszakts**********************************************

	ORG 4

MEGSZ:
	movwf	W_TEMP				; a W rtknek mentse
 	movfw	STATUS				; W = STATUS 
 	movwf	S_TEMP				; a STATUS regiszter elmentse
 	
	btfsc	PIR1,0				; Ha 1, akkor Timer1 okozta a megszaktst
	goto	MEGSZ_TIMER
	btfsc	PIR2,0				; Ha 1 akkor CCP okozta a megszaktst
	goto	MEGSZ_CCP
	goto	VEGE
	
MEGSZ_TIMER:	
	incf	TIMERTCS,f			; A Timer1 tlcsordulst szmll vltoz nvelse
	bcf		PIR1,0				; A megszaktst jelz bit trlse
	goto	VEGE
	
MEGSZ_CCP:	
	bcf		STATUS,5			;a 0. adatmemria lap kivlasztsa
 	bcf		PIR2,0				;A megszaktst jelz bit trlse
	btfss	FIRST,0				;az els esemnyt jelz szoftveres jelzbit vizsglata
 	goto	ELSO				;ugrik, ha FIRST,0 = "0"
 	movf	CCPR2L,w			;W = CCPR2L
 	movwf	TEMP2L				;TEMP2L = CCPR2L ("msodik rtk" als bjt elmentve)
 	movf	CCPR2H,w			;W = CCPR2H
 	movwf	TEMP2H				;TEMP2H = CCPR2H ("msodik rtk" fels bjt elmentve)
 	movf	TIMERTCS,w
	movwf	TIMERTCS2
	bcf		PIR2,0  			;a CCPIF jelzbit nullzsa
 	bsf		STATUS,RP0			;az 1. adatmemria lap kivlasztsa
 	clrf	PIE1				;a perifria megszaktsok tiltsa
 	bcf		STATUS,RP0			;a 0. adatmemria lap kivlasztsa
 	clrf	CCP2CON				;a CCP modul kikapcsolsa
 	goto	VEGE		 		;ugrs a megszaktskezel szubrutin vgre
ELSO:	
	movf	CCPR2L,w			;W = CCPR2L
 	movwf	TEMP1L				;TEMP2L = CCPR2L ("elso rtk" als bjt elmentve)
 	movf	CCPR2H,w			;W = CCPR1H
 	movwf	TEMP1H				;TEMP2H = CCPR2H ("elso rtk" fels bjt elmentve)
 	movf	TIMERTCS,w
	movwf	TIMERTCS1
	bsf		FIRST,0				;az els rtk elmentsnek jelzse a szoftvernek
 	bcf		PIR2,0				;a CCPIF jelzbit nullzsa
VEGE:	
	movfw	S_TEMP				;W = STATUS regiszter elmentett rtke
 	movwf	STATUS				;a STATUS regiszter rtknek visszalltsa
 	swapf	W_TEMP,f			;a W_TEMP rtknek bitcserje
	swapf	W_TEMP,w	; hogy ne mdostsa a visszalltott status rtket!
 	
 	retfie	 			;visszatrs a megszaktsbl
;*********************Fprogram************************************************



Init:
	call	LCD_Init			;LCD alaphelyzetbe lltsa	
	clrf	CCP2CON				;a CCP modul kikapcsolsa
 	clrf	T1CON				;Timer 1 kikapcsolva (eloszts 1:1, bels lptets, szinkronizci)
 	clrf	INTCON				;a megszaktsok tiltsa
 	bsf		STATUS,RP0			;az 1. adatmemria lap kivlasztsa
 	bsf		TRISC,2     		;a CCP2 kivezets bemenetknt val belltsa
 	clrf	PIE2				;a perifria megszaktsok tiltsa
 	bcf		STATUS,RP0			;a 0. adatmemria lap kivlasztsa
 	clrf	PIR2				;a perifria megszaktskr jelzbitek nullzsa
 	clrf	FIRST				;a szoftveres jelzbit regiszternek nullzsa
 	bsf		T1CON,0				;a Timer 1 lptetsnek indtsa
 	movlw	0x05				;W = 0x05
 	movwf	CCP2CON				;a Capture zemmd indtsa, kiolvass minden felfut lre
 	bsf		STATUS,RP0			;az 1. adatmemria lap kivlasztsa
 	bsf		PIE2,0				;megszakts engedlyezs CCP2IE="1"
 	bcf		STATUS,RP0			;a 0. adatmemria lap kivlasztsa
 	bsf		INTCON,PEIE			;PEIE="1"; perifria megszaktsok engedlyezse
 	bsf		INTCON,GIE			;GIE="1"; globlis megszakts engedlyezs

;*************** A kt rtk kztti klnbsg meghatrozsa ***
			;Az eredmny a TULCSORDUL, TIMEH, TIMEL regiszterekbe kerl

Kivon:			
 	movf    TIMERTCS2,W    	
    subwf   TIMERTCS1,W    	
	movwf	TULCSORDUL
	movf    TEMP2H,w     		
    subwf   TEMP1H,W
	movwf	TIMEH
	movf    TEMP2L,w     	
    subwf   TEMP1L,W
	movwf	TIMEL
		 
;*************** Idtartamszmts ********************************************
;			Kerk kerlet 1,2 m. Mivel a m/s s km/h kztt 3,6 a vltszm a s s a us kztt 1 000 000,
; gy kell szmolni, hogy 1,2x3 600 000/id (teht 4 320 000/id) . Ez km/h-t ad egsz rtkben.
; szmll: nratorH  nratorM  nratorL
; nevez: denomH   denomM   denomL
; Az eredmny a nratorH  nratorM  nratorL regiszterekbe kerl
Oszt:
	  movlw		b'01000001'		; A szmll 24 bites regiszterbe 4 320 000-et tltnk
	  movwf		nratorH
	  movlw		b'11101011'
	  movwf		nratorM
	  movlw		b'00000000'
	  movwf		nratorL
	  
	  movfw		TULCSORDUL
	  movwf		denomH
	  movfw		TIMEH
	  movwf		denomM
	  movfw		TIMEL
	  movwf		denomL	

Divide_24x24:
      movlw    .24		; set decimal 24 loop count
      movwf    BCount
      movf     nratorH,w ; copy Numerator into Shift Holding ram registers
      movwf    shiftH
      movf     nratorM,w
      movwf    shiftM
      movf     nratorL,w
      movwf    shiftL
      clrf     nratorH	;  clear final Answer Numerator Ram locations
      clrf     nratorM
      clrf     nratorL
      ;
      clrf     remainH  ;  clear final Answer Remainder Ram locations
      clrf     remainM
      clrf     remainL
dloop:
      bcf		STATUS, C  ; bit clear Carry Flag in STATUS register
      rlf		shiftL, f  ; Shift numerator(dividend) Left to move
      rlf		shiftM, f  ; next bit to remainder
      rlf		shiftH, f  ; and shift in next bit of result

      rlf		remainL, f ; shift carry (next Dividend bit) into remainder
      rlf		remainM, f
      rlf		remainH, f
      movf     denomH,w
      subwf    remainH,w  ; subtract divsor(denomH) from(newly shifted left) Remainder HIGH byte.
      btfss    STATUS, Z
      goto     nochk		  ; skip if result was ZERO from good subtraction result
      ;
      movf     denomM,w
      subwf    remainM,w  ; subtract divsor(denomM) from(newly shifted left) Remainder MIDDLE byte.
      btfss    STATUS, Z
      goto     nochk		  ; skip if result was ZERO from good subtraction result
      ;
      movf     denomL,w
      subwf    remainL,w  ; subtract divsor(denomL) from(newly shifted left) Remainder LOW byte.
nochk:
      btfss    STATUS, C   ;  Carry SET? then denom is larger than reemainder
      goto     nogo
      ;
      movf     denomL,w			 
      subwf    remainL, f   	 ; Subtract denominator from remainder value in Low Byte
      btfsc    STATUS, C       ; Carry Set? Then execute fixup code for when a borrow is generated
      goto 		nodec_remainM   ; when no borrow bit is needed from the higher byte positions.
      decf     remainM, f      ; Decrement to Borrow from Middle Byte, because carry was SET.
      movf     remainM,w
      xorlw    0xff				 ; Check if rollover from Borrow occurred. remainM value went from 0 to 0xFF 
      btfsc    STATUS, Z
      decf     remainH, f		 ; ZERO bit set, yes rollover, so Decrement to Borrow from High Byte, too!
nodec_remainM:
      movf     denomM,w
      subwf    remainM, f		 ; Subtract denominator from remainder value in Middle Byte
      btfss    STATUS, C
      decf     remainH ,f      ; Decrement High Byte, to borrow 1 bit
      movf     denomH,w   		 
      subwf    remainH, f      ; Subtract denominator from remainder value in High Byte
      bsf		STATUS, C       ; set CARRY bit to rotate in Numerator Result next.
nogo:
      rlf		nratorL, f  ; rotate Numerator result left 1 bit
      rlf		nratorM, f
      rlf		nratorH, f
      decfsz   BCount, f   ; decrement the Loop Bit Counter
      goto     dloop
      goto      Kivon
	
 	 	 	;*** Konverzi (pldul binris/BCD s BCD/7-szegmens) ***
 	 	 
 	 	 	;*** Kijelzs vezrlse ***
;***********************Szubrutinok s szvegtblk****************************

	
; LCD rutinok

; Alaphelyzetbe lltja az LCD-t (inicializl)
LCD_Init
     movlw   0x20             ; A 4 bites md belltsa.
     call    LCD_Cmd

     movlw   0x28             ; Shift (betemels) belltsa.
     call    LCD_Cmd

     movlw   0x06             ; Karakter md belltsa.
     call    LCD_Cmd

     movlw   0x0c             ; Kijelz ki/be s kurzor parancs.
     call    LCD_Cmd

     call    LCD_Clr          ; Kijelz trlse.

     retlw    0x00

; Parancs-zemmd belltsa.
LCD_Cmd
     movwf   templcd
     swapf   templcd,W        ; Elkldi a fels nibble-t.
     andlw   0x0f             ; Trli a fels 4 bitet a W regiszterbl.
     movwf   LCD_PORT
     bcf     LCD_PORT,LCD_RS  ; RS vonalat nullra lltja.
     call    Pulse_e          ; Magas impulzust kld az Enable lbra.

     movf    templcd,W        ; Elkldi a als nibble-t.
     andlw   0x0f             ; Trli a fels 4 bitet a W regiszterbl.
     movwf   LCD_PORT
     bcf     LCD_PORT,LCD_RS  ; RS vonalat nullra lltja.
     call    Pulse_e          ; Magas impulzust kld az Enable lbra.
     call    Kesleltet5
     retlw   0x00

; Karakter-zemmd belltsa.
LCD_CharD
     addlw   0x30
LCD_Char
     movwf   templcd
     swapf   templcd,W        ; Elkldi a fels nibble-t.
     andlw   0x0f             ; Trli a fels 4 bitet a W regiszterbl.
     movwf   LCD_PORT
     bsf     LCD_PORT,LCD_RS  ; RS vonalat egyre lltja.
     call    Pulse_e          ; Magas impulzust kld az Enable lbra.

     movf    templcd,W        ; Elkldi a als nibble-t.
     andlw   0x0f             ; Trli a fels 4 bitet a W regiszterbl.
     movwf   LCD_PORT
     bsf     LCD_PORT,LCD_RS  ; RS vonalat egyre lltja.
     call    Pulse_e          ; Magas impulzust kld az Enable lbra.
     call    Kesleltet5
     retlw   0x00

; Kurzor pozicionlsa.
LCD_Line1
     movlw   0x80             ; Az 1. sor 1. oszlopba helyezi a kurzort.
     call    LCD_Cmd
     retlw   0x00

LCD_Line2
     movlw   0xc0             ; A 2. sor 1. oszlopba helyezi a kurzort.
     call    LCD_Cmd
     retlw   0x00

LCD_Line1W
     addlw   0x80             ; Az 1. sor W oszlopba helyezi a kurzort
     call    LCD_Cmd
     retlw   0x00

LCD_Line2W
     addlw   0xc0             ; A 2. sor W oszlopba helyezi a kurzort.
     call    LCD_Cmd
     retlw   0x00

LCD_CurOn
     movlw   0x0d             ; Kijelz ki/be s kurzor parancs.
     call    LCD_Cmd
     retlw   0x00

LCD_CurOff
     movlw   0x0c             ; Kijelz ki/be s kurzor parancs.
     call    LCD_Cmd
     retlw   0x00

LCD_Clr
     movlw   0x01             ; Trli a kijelzt.
     call    LCD_Cmd
     retlw   0x00

LCD_HEX
     movwf   tmp1
     swapf   tmp1,w
     andlw   0x0f
     call    HEX_Table
     call    LCD_Char
     movf    tmp1,W
     andlw   0x0f
     call    HEX_Table
     call    LCD_Char
     retlw   0x00

Kesleltet255
     movlw   0xff             ; A ksleltets 255ms.
     goto    K0
Kesleltet100
     movlw   d'100'           ; A ksleltets 100ms.
     goto    K0
Kesleltet50
     movlw   d'50'            ; A ksleltets 50ms.
     goto    K0
Kesleltet20
     movlw   d'20'            ; A ksleltets 20ms.
     goto    K0
Kesleltet5
     movlw   0x05             ; A ksleltets 5.000 ms (4 MHz rajel).
K0
     movwf   count1
K1
     movlw   0xC7             ; A ksleltets 1ms.
     movwf   counta
     movlw   0x01
     movwf   countb
Kesleltet_0
     decfsz  counta,f
     goto    $+2
     decfsz  countb,f
     goto    Kesleltet_0

     decfsz  count1,f
     goto    K1
     retlw   0x00

Pulse_e
     bsf     LCD_PORT,LCD_E   ; Magasra lltja az LCD Enable bemenett.
     nop                      ; Egy raciklus idejre magasan tartja.
     bcf     LCD_PORT,LCD_E   ; Trli az E bemenetet (alacsony szint).
     retlw   0x00

; LCD rutinok vge.
;******************************************
    
HEX_Table
     addwf   PCL,f
     retlw   0x30
     retlw   0x31
     retlw   0x32
     retlw   0x33
     retlw   0x34
     retlw   0x35
     retlw   0x36
     retlw   0x37
     retlw   0x38
     retlw   0x39
     retlw   0x41
     retlw   0x42
     retlw   0x43
     retlw   0x44
     retlw   0x45
     retlw   0x46
HEX_Table_End

	if (high(HEX_Table))!=(high(HEX_Table_End))
		error "HEX_Table table page error"
	endif

Szoveg1
     addwf   PCL,f
     retlw   'A'
     retlw   'k'
     retlw   'k'
     retlw   'u'
     retlw   ':'
	 retlw   ' '
	 retlw   ' '
	 retlw   ' '
	 retlw   '%'
     retlw   0x00
Szoveg1_End

	if (high(Szoveg1))!=(high(Szoveg1_End))
		error "Szoveg1 table page error"
	endif

Szoveg2
     addwf   PCL,f
     retlw   'S'
     retlw   'e'
     retlw   'b'
     retlw   'e'
     retlw   's'
     retlw   's'
     retlw   'e'
     retlw   'g'
     retlw   ':'
     retlw   ' '
     retlw   ' '
     retlw   'k'
     retlw   'm'
     retlw   '/'
     retlw   'h'
     retlw   0x00
Szoveg2_End

	if (high(Szoveg2))!=(high(Szoveg2_End))
		error "Szoveg2 table page error"
	endif

     end