/*
 * Project name:
     Display7seg (Advanced 7Seg. display example)
 * Copyright:
     (c) Mikroelektronika, 2007.
 * Description:
     This code demonstrates  displaying number on four 7-segment display (common
     cathode), in multiplex mode. All 7-segment displays are connected to PORTD
     (RD0..RD7, segment A to RD0, segment B to RD1, etc) with refresh via pins
     RA0..RA3 on PORTA. Number is on for 1 second.
 * Test configuration:
     MCU:             PIC16F877A
     Dev.Board:       EasyPIC5
     Oscillator:      HS, 08.0000 MHz
     Ext. Modules:    -
     SW:              mikroC v7.0
 * NOTES:
     None.
*/

#include "Display_utils.h"

char kraj;
unsigned short zz, j, v;
unsigned int i;
unsigned short por[4];

void interrupt() {
  PORTA = 0;
  PORTD = por[v];
  PORTA = zz;              // turn on appropriate 7seg. display
  zz <<= 1;
  if (zz > 8u)
    zz = 1;                // prepare mask for digit
    
  v++ ;
  if (v > 3u)
    v = 0;                 // turn on 1st, turn off 2nd 7seg.
    
  TMR0   =   0;
  INTCON = 0x20;
}//~

void main() {
  OPTION_REG = 0x80;
  j          =   0;
  v          =   0;
  zz         =   1;
  TMR0       =   0;
  INTCON     = 0xA0;       // Disable PEIE,INTE,RBIE,T0IE
  PORTA      =   0;
  TRISA      =   0;
  PORTD      =   0;
  TRISD      =   0;
  
  i          =   1989;
  do {
    j = i / 1000u ;        // prepare digits for diplays
    kraj = mask(j);
    por[3] = kraj;
    j = (char)(i / 100u) % 10u;
    kraj = mask(j);
    por[2] = kraj;
    j = (char)(i / 10u) % 10u;
    kraj = mask(j);
    por[1] = kraj;
    j = i % 10u;
    kraj = mask(j);
    por[0] = kraj;
    
    Delay_ms(1000);
    
    i++ ;                  // increment counter
    if (i > 9999u)
      i = 0;

  } while(1);              // endless loop
}//~

