#include "animate.h"
#include "node.h"
#include "ledBuffer.h"

animation_t* animateList;
animation_t* freeList;
animation_t nodeArray[3];



// simple animation
const rgb_t Acolour = {.r = 5, .g = 30, .b = 15};
const rgb_t Bcolour = {.r = 1, .g = 13, .b = 5};
const rgb_t Ccolour = {.r = 0, .g = 2, .b = 1};


const ledPixel_t aA = { .rgb = &Acolour, .offset = 0 };
const ledPixel_t aB = { .rgb = &Bcolour, .offset = 0 };
const ledPixel_t aC = { .rgb = &Ccolour, .offset = 0 };

const ledPixel_t b = { .rgb = &Bcolour, .offset = 1 };
const ledPixel_t b1 = { .rgb = &Bcolour, .offset = -1 };
const ledPixel_t c = { .rgb = &Ccolour, .offset = 2 };
const ledPixel_t c1 = { .rgb = &Ccolour, .offset = -2 };
const ledPixel_t Ac = { .rgb = &Ccolour, .offset = 1 };
const ledPixel_t Ac1 = { .rgb = &Ccolour, .offset = -1 };



const node_t nodeA_0 = { .data = (node_t*)&aB, .next = (node_t*)0 };
const node_t nodeB_0 = { .data = (node_t*)&b, .next = (node_t*)&nodeB_1 };
const node_t nodeB_1 = { .data = (node_t*)&b1, .next = (node_t*)&nodeB_2 };
const node_t nodeB_2 = { .data = (node_t*)&aA, .next = (node_t*)0 };
const node_t nodeC_0 = { .data = (node_t*)&c, .next = (node_t*)&nodeC_1 };
const node_t nodeC_1 = { .data = (node_t*)&c1, .next = (node_t*)&nodeC_2 };
const node_t nodeC_2 = { .data = (node_t*)&Ac, .next = (node_t*)&nodeC_3 };
const node_t nodeC_3 = { .data = (node_t*)&Ac1, .next = (node_t*)&nodeC_4 };
const node_t nodeC_4 = { .data = (node_t*)&aB, .next = (node_t*)0 };



const node_t topNodeA = {(node_t*)&nodeA_0,(node_t*)&topNodeB}; 
const node_t topNodeB = {(node_t*)&nodeB_0,(node_t*)&topNodeC}; 
const node_t topNodeC = {(node_t*)&nodeC_0,0}; 


// displays frames of animation. call repeditively
void animate()
{
	if(animateList == 0)
		return; // nothing to do
	else
	{
		animation_t* n = animateList;
	//	while(n)
		{
			// get pixels
			node_t* node;
			
			
			//TODO:: REMOVE ANIMATION FROM LIST ONCE COMPLETE 
			
			
			
			node = (node_t*)n->data->data;
			
			while(node)
			{
				// get led data
				ledPixel_t* pix = (ledPixel_t*)node->data;
				
				// get led position
				signed int pos = n->position;
				pos += pix->offset;
				
				if(pos < 0)
					pos += 60;
					
				// put the data on the frame buffer
				ledBuffer[pos].r = pix->rgb->r;
				ledBuffer[pos].g = pix->rgb->g;
				ledBuffer[pos].b = pix->rgb->b;
				
				// setup ready for maybe another pixel?
				node = node->next;
			}
			
		
			// set next node in chain to display when run again.
			n->data = (node_t*)n->data->next;
			
			node_t* n1 = n->next;
			
			if(n->data == 0)
			{
				n->next = freeList;
				freeList = n;
				animateList = n1;//->next; // update animateList
				//n = 0;
			}
			else
			// get next animation!
				n = n1;//->next;
		}
	}
}


void newAnimation(unsigned char position, node_t* a)
{
		// add animation to the queue
		
		// first get a new node from freeList
		animation_t* n = freeList;
		if(n == 0)
			return;
		
		// Remove it from freeList
		freeList = n->next;
		
		n->data = a; // store the animation ptr
		n->position = position;
		n->next = animateList; // next element is the currunt top.
		
		animateList = n; // new first element
		
}


void initAnimation()
{
	int i;
	for(i = 0; i < sizeof(nodeArray)/sizeof(node_t); i++)
	{
		nodeArray[i].next = &nodeArray[i+1];
	}
	nodeArray[i].next = 0; // null last pointer;
	
	freeList = &nodeArray[0];
	animateList = 0; // init lists
}


void sweepClear(int origin)
{
	return;
	int left,right;
	
	origin = origin % 60;
	
	left = origin;
	right = origin;
	
	clrPixel(origin); // this clears 3 pixels at once, but who's going to notice
	
	do
	{
	
		// right logic
		if(right == 0)
			right = 59;
		else
			right--;
		
		//left logic
		if(left == 59)
			left = 0;
		else
			left++;
			
			
		// clear the pixels
		clrPixel(left);
		clrPixel(right);
		
		// display our hard work
		xmitData((char*)ledBuffer);
		
		
		
		// we might require a delay in here... maybe.
		
	}while(left != right);
	
}


/*
node_t* getNode()
{
	node_t* n = freeList;
	
	*freeList = *freeList->n;
	return n;
}

void freeNode(node_t* n)
{
	n->n = freeList;
	freeList = n;
}

*/
