//******************************************************************************
//
//                         MSP430G2452
//                      +---------------+
//                      |
//             C--------|P1.0
//             C--------|P1.1
//             C--------|P1.2
//             C--------|P1.3
//             C--------|P1.4
//             C--------|P1.5
//                      |
//           C----------|P2.0
//           C----------|P2.1
//           C----------|P2.2
//           C----------|P2.3
//           C----------|P2.4
//           C----------|P2.5
//                      |
//           C----------|P2.6
//           C----------|P2.7
//
//******************************************************************************

#include "structure.h"

//PinOsc P1.0
const struct Element element0 = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT4,
              .maxResponse = 3000, 
              .threshold = 300

};     

const struct Element element1 = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT3,
              .maxResponse = 3000, 
              .threshold = 400

};  
    
const struct Element element2 = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT4,
              .maxResponse = 3000, 
              .threshold = 400

};  
    
const struct Element element3 = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT3,
              .maxResponse = 3000, 
              .threshold = 400 

};      

const struct Element element4 = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT2,
              .maxResponse = 3000, 
              .threshold = 330 

};  
    
const struct Element element5 = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT2,
              .maxResponse = 3000, 
              .threshold = 420 

};  
//PinOsc P2.0
const struct Element element6 = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT1,
              .maxResponse = 3000, 
              .threshold = 380 

};     
const struct Element element7 = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT0,
              .maxResponse = 3000, 
              .threshold = 370 

};  
const struct Element element8 = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT0,
              .maxResponse = 3000, 
              .threshold = 330 

};  
const struct Element element9 = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT1,
              .maxResponse = 300+655, 
              .threshold = 230 

};      
const struct Element elementA = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT6,
              .maxResponse = 100+655, 
              .threshold = 100 

};  

const struct Element elementB = {

              .inputPxselRegister = (uint8_t *)&P3SEL,  
              .inputPxsel2Register = (uint8_t *)&P3SEL2,  
              .inputBits = BIT7,
              .maxResponse = 80+655, 
              .threshold = 80

};
  

const struct Element elementC = {

              .inputPxselRegister = (uint8_t *)&P2SEL,  
              .inputPxsel2Register = (uint8_t *)&P2SEL2,  
              .inputBits = BIT5,
              .maxResponse = 30, 
              .threshold = 50

};      


//*** Sensor     *******************************************************/
// This defines the grouping of sensors, the method to measure change in
// capacitance, and the function of the group

const struct Sensor slider =
               { 
                  .halDefinition = RO_PINOSC_TA0_WDTp,
                  .numElements = 12,
                  .points = 12,
                  //.sensorThreshold = 0,
                  .baseOffset = 0,
                  // Pointers to elements
                  .arrayPtr[0] = &element0,  
				  .arrayPtr[1] = &element1,  
                  .arrayPtr[2] = &element2,  
                  .arrayPtr[3] = &element3,  
                  .arrayPtr[4] = &element4,  
                  .arrayPtr[5] = &element5,  
                  .arrayPtr[6] = &element6,  
                  .arrayPtr[7] = &element7,  
                  .arrayPtr[8] = &element8,  
                  .arrayPtr[9] = &element9,  
                  .arrayPtr[10] = &elementA,  
                  .arrayPtr[11] = &elementB,  

                  // Timer Information
                  .measGateSource= GATE_WDT_ACLK,     //  0->SMCLK, 1-> ACLK
                  .accumulationCycles= WDTp_GATE_64   //64 - Default           
               };
               
               

const struct Sensor button =
               { 
                  .halDefinition = RO_PINOSC_TA0_WDTp,
                  .numElements = 1,
                  .baseOffset = 12,
                  // Pointers to elements  
                  .arrayPtr[0] = &element9,  

                  // Timer Information
                  .measGateSource= GATE_WDT_ACLK,     //  0->SMCLK, 1-> ACLK
                  .accumulationCycles= WDTp_GATE_64   //64 - Default           
               };
               
               
