
#include "colour.h"

void hsl2rgb( hsl_t *s, rgb_t *d )
{
	if(s->s == 0)
	{
		d->r = d->g = d->b = s->l;
	}
	else
	{
		unsigned int q;
		 if(s->l < 128) 
		 { 
		 	long i;
		 	i = (s->l * (256 + s->s));
		 	q = i >> 8;	 
		 }
		 else
		 {
		 	q =  s->l + s->s - ((s->l * s->s) >> 8);
		 }
		
		unsigned int p = (s->l * 2) - q;
		
		d->r = (unsigned char) 0xFF&hue2rgb(p, q, s->h + 85);
		d->g = (unsigned char) 0xFF&hue2rgb(p, q, s->h);
		d->b = (unsigned char) 0xFF&hue2rgb(p, q, s->h - 85);
		
	}
}

unsigned int hue2rgb(unsigned int p, unsigned int q, int t)
{
	if(t < 0)
		t += 256; // 1
	if(t > 256)
		t -= 256;  // 1
	
	if(t < 43) return p + ((long)((q - p) * t) >> 8) * 6;  // 1/6
	if(t < 128) return q; // 1/2
	if(t < 171) return p + ((long)((q - p) * (171 - t)) >> 8) * 6; // 2/3
	
	return p;
}




