#include <msp430.h>
#include "input.h"
#include "capSense/structure.h"
#include "capSense/CTS_Layer.h"



unsigned char lastPosition;
unsigned char inputPosition;
unsigned char event;

unsigned int timeout;

signed char startPosition;

#define TAP_TIMEOUT 3
#define HOLD_TIMEOUT 20

void inputInit()
{
	
	event = NONE;
	inputPosition = ILLEGAL_SLIDER_WHEEL_POSITION;
	// run baseline tracking.
	TI_CAPT_Init_Baseline(&slider);
}

int inputPoll()
{
	event = NONE;
	lastPosition = inputPosition;

	inputPosition = (unsigned char)TI_CAPT_Slider(&slider); // get new position

	if(inputPosition != ILLEGAL_SLIDER_WHEEL_POSITION && lastPosition != ILLEGAL_SLIDER_WHEEL_POSITION)
	{
		timeout++;
		if(timeout > HOLD_TIMEOUT && abs(startPosition - inputPosition) < 1)
		{
			event = HOLD;
		}
	}
	
	if(inputPosition != ILLEGAL_SLIDER_WHEEL_POSITION && lastPosition == ILLEGAL_SLIDER_WHEEL_POSITION)
		event = TOUCHED, startPosition = inputPosition;
		
	if(inputPosition == ILLEGAL_SLIDER_WHEEL_POSITION && lastPosition != ILLEGAL_SLIDER_WHEEL_POSITION)
	{
		event = RELEASED;
	
//	if(event == RELEASED)
//	{
		if(timeout < TAP_TIMEOUT && startPosition == lastPosition)
			event = TAP;
		
	//	timeout = 0;
	}
	
	
	if(inputPosition == ILLEGAL_SLIDER_WHEEL_POSITION && lastPosition == ILLEGAL_SLIDER_WHEEL_POSITION)
		timeout = 0;
	
	return event;
}

unsigned char inputEvent()
{
	return timeout;	
}

signed char inputDelta()
{
	return startPosition - inputPosition;
	//return startPosition;
}

unsigned char inputPos()
{
	return inputPosition;
}

unsigned char inputLast()
{
	return lastPosition;
}

int inputValid(void)
{
	return (inputPosition != ILLEGAL_SLIDER_WHEEL_POSITION);
}

void inputReset()
{
	event = NONE;
	inputPosition = ILLEGAL_SLIDER_WHEEL_POSITION;
}

/*
int dif[12];
	int min[12];
	
void touchCalib()
{
	// take average measurments
	int i;
	TI_CAPT_Init_Baseline(&slider);
	extern int  baseCnt[12];
	extern int measCnt[12];
	
	
	
	for(i = 0; i < 12; i++)
	{
		min[i] = baseCnt[i]*2;
	}
	
	while(1)
	{
	
		// set a breakpoint around here. run a few times. then check dif via debugger.
		
		TI_CAPT_Raw(&slider,measCnt);
		for(i = 0; i < 12; i++)
		{
			if(min[i] >= measCnt[i])
				min[i] = measCnt[i];
		
		
			dif[i] = measCnt[i] - min[i];
		} 
	
	__bis_SR_register(LPM0_bits + GIE);
	__bic_SR_register(GIE);
		
	}
	

}

*/
