#include <msp430.h>

;=----------------------------------------=
; Xmit: send data to WS2812 LEDs
; entry: r15 : first node of list with LED data.
;
; return: -
;
; uses: r4:  raw byte to send
;		r5:  bit counter
;		r6:  '0' bit pattern
;		r7:  '1' bit pattern (these save 2? cycles per loop)
;		r8:  node ptr (copy of r15)
;		r9:  byte counter
; 		r10: total LEDs to xmit
;		r11: led bit counter (r,g,b)
; 		r12: temp byte to transmit
;=----------------------------------------=
.global xmitData
xmitData:
	dint
	push.w 	r12
	push.w 	r10
	push.w  r9
	push.w  r5
	push.w  r4
	mov.w 	#0,r9
	mov.w 	#(60*3)-1,r10

	mov.w 	#8,r5

	clr.w r12

	jmp 	compare


XmitLoop:
	clr.w 	r12
	
	rla.b 	r4
	jnc 	one
	bis.b 	#0xf0,r12
one:
	bis.b 	#0x80,r12
	
	
	mov.b 	r12,&UCA0TXBUF
	
	nop
	nop
	nop
	nop
	
	dec.w 	r5
	jnz 	XmitLoop

	mov.w 	#8,r5	
	
	inc.w 	r9

	
compare:
	mov.b 	@r15+,r4
noData:
	cmp.w 	r9,r10
	jge 	XmitLoop

	pop.w  r4
	pop.w  r5
	pop.w  r9
	pop.w  r10
	pop.w  r12
	eint
	ret


