
#define NUM_LEDS 12
#define LED_DATA BIT2

//unsigned char ledData[NUM_LEDS*3]; 

#include <msp430.h>
#include "stdint.h"

#include "colour.h"
#include "ledBuffer.h"

#include "animate.h"

#include "i2c.h"
#include "accel.h"
#include "input.h"

#include "dco.h"

#include "capSense/structure.h"
#include "capSense/CTS_Layer.h"

volatile int wakeupSource;

enum {TIME = 1,};


char minutes, seconds, hours, scale;

void startup(void);


//int mode;

void xmitData(char* d);

int main(void)
{

	WDTCTL = WDTPW + WDTHOLD;                   // Enable WDT interrupt
	
	//BCSCTL1 = CALBC1_16MHZ;
	//DCOCTL = CALDCO_16MHZ;


	
	P2SEL |= BIT7 | BIT6; // ext osc
	
	
	
	Set_DCO(1024);
	
	BCSCTL1 &= ~DIVA_3;
	BCSCTL2 |= DIVM_0;
	BCSCTL3 = XCAP_2;
	
	
	
	
	//unsigned int i;
	//for(i = 0; i < 6000; i++);
	
	
	
	
	//P2OUT |= BIT7;
	
	P1DIR |= LED_DATA | BIT1;
	

	TA1CCR1 = 1024;
	TA1CCTL1 = CCIE;                             // CCR0 interrupt enabled

	TA1CTL = TASSEL_1 + MC_2 + TACLR;           // ACLK, cont-mode
	
	UCA0CTL1 = UCSWRST;
	UCA0CTL0 = UCCKPL + UCSYNC + UCMSB + UCMST;
	UCA0CTL1 |= UCSSEL_2;
	UCA0BR0 = 1; // 1MHz SCLK for LCD as specified in datasheet. 
	UCA0BR1 = 0;
	
	UCA0CTL1 &= ~UCSWRST;
	
	P1SEL |= LED_DATA;
	P1SEL2 |= LED_DATA;
	
	
	seconds = 0;
	minutes = 0;
	hours = 0;
	
	
//	clrData();	
	
//	xmitData((char*)ledBuffer); // clear the LEDs, this should probably already been done.
	TI_CAPT_Init_Baseline(&slider);
	//TI_CAPT_Init_Baseline(&button);
	// TI_CAPT_Update_Baseline(&slider,5);
	 
		
	inputInit();
//	initAnimation();
//	accelInit();
	
	//touchCalib();
	while(1)
	{
//	startup();
	
	
	
	time();
	
	
	}
	while(1)
	{
	
	 	clrData();	
	 	
	 	
		
	
	xmitData((char*)ledBuffer);
	
	
	// Sleep time! n_n
		__bis_SR_register(LPM0_bits + GIE);

	}
	
	
	//TimerA1();
	}




// TimerA2 CCR1/Overflow Interrupt
__attribute__((interrupt(TIMER1_A1_VECTOR))) void TimerA1(void)
{
    // CCR1
	TA1CCTL1 &= ~CCIFG;
	TA1CCR1 += (3276)/2;
	
	wakeupSource |= TIME;
	LPM0_EXIT;


	if(++scale > 19)
	{
	
	scale = 0;

	if(++seconds > 59)
	{
		seconds = 0;
		if(++minutes > 59)
		{
		minutes = 0;
			if(++hours > 11)
			{
			hours = 0;
			}
		}
	}
	}
	
}

