#include <msp430.h>
#include "i2c.h"
#include "accel.h"

const signed int table[] = {
255,  /* 3 */
252,  /* 9 */
247,  /* 15 */
239,  /* 21 */
228,  /* 27 */
214,  /* 33 */
198,  /* 39 */
181,  /* 45 */
161,  /* 51 */
139,  /* 57 */
116,  /* 63 */
91,  /* 69 */
66,  /* 75 */
40,  /* 81 */
13,  /* 87 */
0,
};

void sin(int u)
{
	u = u % 30;
	if( u >= 15)
		return table[30-u];
	
	return table[u];
		
}


int getRot(struct accel* a)
{
	int rot = 0;
	
	unsigned int x = abs(a->x);
	
	
	//return x%60;
	//if(x < 0)
	//	x = -x; // abs value
		
		
	//rot = x%15;
	
	if(x > table[7])
		x = abs(a->y);
	
		
	while(((int)x < (int)table[rot]) && (rot < 15))
		rot++;
		
	
	
	if(abs(a->x) > table[7])
		rot = 15 - rot;
	
		
	if(a->x < 0) // 3rd/4th quad
	{
		rot = 30 - rot; // traspose onto the right part. 
	}
	if(a->y < 0) // 2nd/3rd quad
	{
		rot = 60 - rot;
	}
	
	//rot = (59 - rot) + 17;//rot % 60; // fit in our space [0,59]
	
	return abs(rot) % 60; // clockwise
	
}

void accelInit()
{
	const unsigned char a[2] = {0x2a,1}; // SET register 2a ()CTRL_REG1
	const unsigned char a2[2] = {0x2a,1}; // SET register 2a ()CTRL_REG1
	
	
	
	TI_USCI_I2C_init(0x1c,40);
	
	__enable_interrupt();
	
	TI_USCI_I2C_transmit(2,a);
	while(TI_USCI_I2C_notready());
	
	//*/
	
	

}

struct accel accValue;

struct accel* getAccel()
{
	return &accValue;
}

void readAccel()
{
	
	unsigned char buffer[8] = {0x00};
	while(TI_USCI_I2C_notready());
	
	
	TI_USCI_I2C_read(buffer,7,buffer);
	
	
	
	while(TI_USCI_I2C_notready());
	
	
	char i;
	for(i = 0; i < 3; i++)
	{
		accValue.raw[i] = (signed char)buffer[1+(i*2)];
		accValue.raw[i] <<= 2;
		accValue.raw[i] |= ((buffer[2+(i*2)]>>6) & 0x03);
	}
	
	// rearrange the variables
	signed int x;
	
	x = accValue.x;
	accValue.x = accValue.y;
	accValue.y = -x;
	accValue.z = -accValue.z;
	
}


int isConnected(void)
{

	unsigned char a1[2] = {0x0b,0}; // SET register 2a ()CTRL_REG1
	
	unsigned char d = 0x0d; // WHA AM I?
	
	TI_USCI_I2C_read(&d,2,a1);
	while(TI_USCI_I2C_notready());
	
	return (*a1 == 0x3A);
}



