//******************************************************************************
// Custom DCO settings- based on TI code example
//
// MSP430F20xx Demo - DCO Calibration Constants Programmer
//
// NOTE: THIS CODE REPLACES THE TI FACTORY-PROGRAMMED DCO CALIBRATION
// CONSTANTS LOCATED IN INFOA WITH NEW VALUES. USE ONLY IF THE ORIGINAL
// CONSTANTS ACCIDENTALLY GOT CORRUPTED OR ERASED.
//
//
// MSP430F20xx
// ---------------
// /|\| XIN|-
// | | | 32kHz
// --|RST XOUT|-
// | |
// | P1.0|--> LED
// | P1.4|--> SMLCK = target DCO
// Orignal Code By
// A. Dannenberg
// Texas Instruments Inc.
// May 2007
// Built with CCE Version: 3.2.0 and IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//******************************************************************************
/*Flash Custom DCO settings, This will replace The default 1MHz */
/* to use
//Custom calibration
BCSCTL1 = CALBC1_1MHZ; // Set range
DCOCTL = CALDCO_1MHZ; // Set DCO step + modulation
*/
//ACLK = LFXT1/8 = 32768/8, MCLK = SMCLK = target DCO
//* External watch crystal installed on XIN XOUT is required for ACLK *//
//******************************************************************************
#include <msp430.h>
#define DELTA_CUSTOM 489 // 489 x 4096Hz = 2002944Hz or 2.02MHz
#define DELTA_8MHZ 1953 // 1953 x 4096Hz = 7.99MHz
#define DELTA_12MHZ 2930 // 2930 x 4096Hz = 12.00MHz
#define DELTA_16MHZ 3906 // 3906 x 4096Hz = 15.99MHz



void Set_DCO(unsigned int Delta) // Set DCO to selected frequency
{
	unsigned int Compare, Oldcapture = 0;
	BCSCTL1 |= DIVA_3; // ACLK = LFXT1CLK/8
	TACCTL0 = CM_1 + CCIS_1 + CAP; // CAP, ACLK
	TACTL = TASSEL_2 + MC_2 + TACLR; // SMCLK, cont-mode, clear
	while (1)
	{
		while (!(CCIFG & TACCTL0)); // Wait until capture occured
		TACCTL0 &= ~CCIFG; // Capture occured, clear flag
		Compare = TACCR0; // Get current captured SMCLK
		Compare = Compare - Oldcapture; // SMCLK difference
		Oldcapture = TACCR0; // Save current captured SMCLK
		if (Delta == Compare)
			break; // If equal, leave "while(1)"
		else if (Delta < Compare)
		{
			DCOCTL--; // DCO is too fast, slow it down
			if (DCOCTL == 0xFF) // Did DCO roll under?
			if (BCSCTL1 & 0x0f)
			BCSCTL1--; // Select lower RSEL
		}
		else
		{
			DCOCTL++; // DCO is too slow, speed it up
			if (DCOCTL == 0x00) // Did DCO roll over?
				if ((BCSCTL1 & 0x0f) != 0x0f)
					BCSCTL1++; // Sel higher RSEL
		}
	}
	TACCTL0 = 0; // Stop TACCR0
	TACTL = 0; // Stop Timer_A
	BCSCTL1 &= ~DIVA_3; // ACLK = LFXT1CLK
}
