// time
#include <msp430.h>
#include "ledBuffer.h"
#include "animate.h"
#include "input.h"

hsl_t secondsColour = {.h = 20, .s = 200, .l = 50};
hsl_t minuteColour = {.h = 80, .s = 220, .l = 50};
hsl_t hourColour = {.h = 220, .s = 190, .l = 50};
extern char minutes, seconds, hours, ampm;



struct setList {
	char max;
	char min;
	char multi;
	hsl_t* colour;
	char* ptr;
	struct setList* next;
};

struct setList timeList2 = {.max = 12, .min = 0, .multi = 5, .colour = &hourColour, .ptr = &hours, .next = 0};
struct setList timeList1 = {.max = 60, .min = 0, .multi = 1, .colour = &minuteColour, .ptr = &minutes, .next = &timeList2};
struct setList timeList = {.max = 60, .min = 0, .multi = 1, .colour = &secondsColour, .ptr = &seconds, .next = &timeList1};



void time(void)
{

	hsl_t c;
	
	c.h = 10;
	c.l = 100;
	c.s = 230;
	
	inputReset();
	
	
	struct setList* setList;
	
	signed int j = 0;
	int e;
	
	//char set = 0;
	__bic_SR_register(GIE);
	
	while(1)
	{
	
		
		e = inputPoll();
		
		
		if(e == TAP) // change mode?
		{
			sweepClear(inputLast());
			return;
		}
		
		
		
		clrData();
		
		if(e == HOLD)
		{
			char i = inputPos();
			ledBuffer[i].r = 0xF0;
			
			setList = &timeList;
			
		}
		else if(e == RELEASED)
		{
			j = seconds;
			signed char d = 0;
			
			
			while(setList)
			{
				e = inputPoll();
				if(e == TAP)
				{
					*(setList->ptr) = j;
					setList = setList->next;
					if(setList == 0)
						break;
						
					j = (*(setList->ptr))%(setList->max);
				}
				else if(e == RELEASED)
				{
					j += d;
					if(j < 0)
					{
						j += 60;
					}
					
					j = j %60;
					d = 0;
				}
				
				if(inputValid()) // don't take delta when data is invalid.
				{
					d = -(inputDelta());
					if(d < 0 )
						d += setList->max;
				}
				else
				{
					d = 0;
				}
				
				
				// show flashing element
				clrData();
				hsl2rgb(setList->colour,&ledBuffer[((j+d) % (setList->max)) * (setList->multi)]);
	
				xmitData((char*)ledBuffer);
	
				__bis_SR_register(LPM0_bits + GIE);
				__bic_SR_register(GIE);
				
				
				
				
			}
		}
		
		char h = (hours*5) + (minutes/12); 
		
		if(h >= 60)
			h-= 60;
		
		hsl2rgb(&hourColour,&ledBuffer[h%60]);
		hsl2rgb(&hourColour,&ledBuffer[(h+1)%60]);
		
		hsl2rgb(&hourColour,&ledBuffer[(h+59)%60]);
		
		
		
		hsl2rgb(&minuteColour,&ledBuffer[minutes]);
		
		
		hsl2rgb(&secondsColour,&ledBuffer[seconds]);
		
		
	 	
			
	
			
			
		
	
	xmitData((char*)ledBuffer);
	
	__bis_SR_register(LPM0_bits + GIE);
	__bic_SR_register(GIE);
					
	}
}
