#include "stdio.h"
#include <inttypes.h>
#include <math.h>

//using namespace std;

const int startingValue = (360+3);
const int stepValue = 6;

int table[15];

int res;

int main(int argc, char *argv[])
{
int i,w;


// simple tool for generating sine tables


printf("signed int table[] = {\n");

double rotation = startingValue % 360;

for(i = 0 ; i < 15; i++)
{

	double r = 256*cos((double)(2 * 3.141 * (rotation))/360);
	

	r = trunc(r);
	// printf("%d,  /* %d */\r\n",(int)r,(int)rotation);
	 table[i] = r;
	 
	//if(i % 8 == 0 && i )
	//	printf("\r\n");

	rotation = (int)(rotation + stepValue) % 360;
}

//printf("};\n\n");

rotation = 0; // center of pixels

for(i = 0; i < 60; i++)
{
	int x = 256*cos((double)(2 * 3.141 * (rotation))/360);
	int y = 256*sin((double)(2 * 3.141 * (rotation))/360);
		
	
	int r = getRot(x,y);
	
	printf("R: %02u : x %03d, y %03d \r\n",r,x,y);	
		
	rotation = (int)(rotation + stepValue) % 360;
}

	
}



int getRot(int in_x, int in_y)
{
	int rot = 0;
	
	unsigned int x = abs(in_x);
	
	
	//return x%60;
	//if(x < 0)
	//	x = -x; // abs value
		
		
	//rot = x%15;
	
	if(x > table[7])
		x = abs(in_y);
	
		
	while(((int)x < (int)table[rot]) && (rot < 15))
		rot++;
		
	
	
	if(abs(in_x) > table[7])
		rot = 15 - rot;
	
		
	if(in_x < 0) // 3rd/4th quad
	{
		rot = 30 - rot; // traspose onto the right part. 
	}
	if(in_y < 0) // 2nd/3rd quad
	{
		rot = 60 - rot;
	}
	
	//rot = (59 - rot) + 17;//rot % 60; // fit in our space [0,59]
	
	return (abs(rot) % 60); // clockwise
	
}
