#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>


#define SPI_DDR  DDRB
#define SPI_PORT PORTB
#define SPI_2311_CS  PB4    // 2311 SPI-t aktivalo Chip Select lab

 
unsigned int Beolvas8bitADC(unsigned char csatorna)
{
ADMUX = (ADMUX & 0b01100000) | csatorna;    //ADC csatorna kivalasztasa
ADCSRA |= (1<<ADSC);    // ADC konverzio elinditasa
while (ADCSRA & (1<<ADSC));    // varas az atalakitasra
ADCSRA |= (1<<ADSC);         // konverzi elindts
while (ADCSRA & (1<<ADSC));    // varas az atalakitasra
return (ADCH);    // ADC ertek kiolvasasa
}

int main()
{

//***************Atmega 16 perifria belltsok*******************
//MOSI es az SCK lab beallitasa kimenetnek,SS(PB4)bell. kimenetnek
 DDRB = (1<<PB5) | (1<<PB7) | (1<<PB4);
//SPI engedelyezese, Master mod, SPI orajel beallitasa (FCPU/16)
 SPCR = (1<<SPE) | (1<<MSTR) | (1<<SPR1);
//*****************************************************************


//ADC CONFIG
ADMUX |= (1<<REFS0)|(1<<ADLAR);    // Vcc mint referencia
ADCSRA = (1<<ADEN) | (1<<ADPS2) | (1<<ADPS1) | (1<<ADPS0);  // ADC engedelyezese, ADC eloosztas = 128 (125 KHz)


unsigned char adatki=180;  //kezd hangrtk 0-255 ~ (100-214) 192=0dB


while(1)
{		  	
  adatki=Beolvas8bitADC(0);
 	


  //**************SPI kommunikci********************	  
  SPI_PORT &= ~(1<<SPI_2311_CS); // 2311 SPI bekapcsolasa (CS lab logikai alacsony szint)
  _delay_us(1);
  
  SPDR = adatki;  //Adattranszfer elinditasa (MOSI)
  
  while(!(SPSR & (1<<SPIF)));   
												
  SPDR = adatki;   //kvetkez bjt kldse
  while(!(SPSR & (1<<SPIF)));  //Varakozas amig az adattranszfer befejezodik

  // 2311 SPI kikapcsolasa, Latch kimenetek bekapcsolasa
  SPI_PORT |= (1<<SPI_2311_CS);


}//while lezr
  
return 0;
}



  

  
