;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    FESZMERO.ASM                                      *
;    Dtum:         2000.11.11.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    FESZLTSGMR PROGRAM                                           *
;    ----------------------                                           *
;    Az A/D konverzi eredmnyt vilgt fnycsk formjban         *
;    az LCD kijelzn jelenti meg. A fnycsk hossza az analg jel    *
;    nagysgval arnyos. 					      *
;    A mintavtel gyakorisgt a TMR0 tlcsordulsa hatrozza meg.    *
;                                                                     *
;**********************************************************************
;
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;------------------------------------------------------------------------------
;
Timer1          equ     32
Timer2          equ     33
Counter		equ	34
OvfCntr		equ	35
;-------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0               ; 0= utasts, 1= adat reg. vlaszts
RdWr		equ	1		; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2               ; 0= LCD tilts, 1= engedlyezs
;-------------------------------------------------------------------------------
;
;
;
;------------------------------------------------------------------------------
;--------------------------------- FPROGRAM ----------------------------------
;------------------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop
;------------------------------------------------------------------------------
; Port bellts
;
		bcf	STATUS,RP0	; bank0 kivlaszts
		bcf	STATUS,RP1
		movlw	B'11000001'	; RC oszcilltor, A/D engedlyezs
		movwf	ADCON0		; 0. csatorna (RA0) kivlaszts
	        clrf    PORTD
                clrf    PORTE
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	B'10000111'	; TMR0 eloszt= 1:256
		movwf	OPTION_REG
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'	; PORTA bemenet
		movwf	TRISA
		clrf	TRISD		; PORTD kimenet
		clrf	TRISE		; PORTE kimenet
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	7		; tlcsorduls szmll kezdeti rtke 
		movwf	OvfCntr		
;-------------------------------------------------------------------------------
; LCD kijelz inicializlsa 
;
	        bcf	PORTE,RS	; LCD parancs kvetkezik
		movlw   56              ; 38h, 8 bit interface set
                call    Write
                call    Kesl		; Busy flag olvasst "helyettesti"
                movlw   56
                call    Write
                movlw   6               ; 06h, Entry mode set: increment
                call    Write
                movlw   12              ; 0dh, Display on, cursor/blink off
                call    Write
                movlw   16              ; 10h, Display/cursor shift: cursor
                call    Write
                movlw   1               ; 01h, Display clear
                call    Write
                call    Kesl2		; Busy flag olvasst "helyettesti"
;-------------------------------------------------------------------------------
; A TMR0 tlcsorduls nem okoz megszaktst, (hiszen azt nem is engedlyeztk)
; de bekvetkeztt a T0IF flag vizsglatval figyeljk.
; A/D konverzit minden 7. TMR0 tlcsordulsra vgznk (kb 0,1 mp-knt).
;
Start		btfss	INTCON,T0IF	; TMR0 tlcsorduls volt?
		goto	Start		; mg nem
;------------------------------------------------------------------------------
		bcf	INTCON,T0IF	; igen, flag trls
		decfsz	OvfCntr,1	; tlcsorduls szmll dekrementlsa
		goto	Start		; mg nem 0
;------------------------------------------------------------------------------
		movlw	7		; mintavtel 10 tlcsordulsonknt
		movwf	OvfCntr		; szmll visszallts
		bsf	ADCON0,GO	; A/D konverzi start
Wait		btfss	PIR1,ADIF	; vrakozs a teljes konverzira
	        goto	Wait
;------------------------------------------------------------------------------
; Szintkijelzs az LCD kijelzn
;
		bcf	PORTE,RS	; LCD parancs
                movlw   1               ; 01h, Display clear
                call    Write
                call    Kesl2		
		bsf	PORTE,RS	; LCD adat kvetkezik
		swapf	ADRESH,0	; ADRESH fels flbjt msols W-be
		andlw	15
		movwf	Counter
		xorlw	0		; ha a fels 4 bit 0, nincs kijelzs
		btfsc	STATUS,Z
		goto	Start
;------------------------------------------------------------------------------
Kijelzes	movlw	255
                call    Write
		decfsz	Counter,1
		goto	Kijelzes
;------------------------------------------------------------------------------
		goto	Start
;------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;---------------------------- SZUBRUTINOK --------------------------------------
;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write           movwf   PORTD
		bsf     PORTE,E
                call    Kesl100		; Busy flag olvasst "helyettesti"
                bcf     PORTE,E
                return
;-------------------------------------------------------------------------------
Kesl100         movlw   165		; 100us ksleltets
                movwf   Timer1
Kesl1		decfsz  Timer1,1
                goto    Kesl1
                return
;-------------------------------------------------------------------------------
Kesl2           clrf    Timer1		; 2ms ksleltets
                movlw	20
		movwf   Timer2
Kesl21          call	Kesl100
                decfsz  Timer2,1
                goto    Kesl21
                return
;-------------------------------------------------------------------------------
Kesl		call	Kesl2
                call    Kesl2
                call    Kesl2
                call    Kesl2
                call    Kesl2
		return			; 5x2ms ksleltets
;-------------------------------------------------------------------------------
		end		

