;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    LCD1.ASM                                          *
;    Dtum:         2000.12.01.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    LCD kijelz vezrl program                                      *
;    ---------------------------                                      *
;    Ktsoros szveg kiiratsa az LCD kijelzre, display-t kb. 0,5mp  *
;    idztssel lptetve.                                            *
;                                                                     *
;**********************************************************************
;
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;-------------------------------------------------------------------------------
;
;                          LCD UTASTSOK                           
;-------------------------------------------------------------------------------
;              LCD kijelz kivezetsei                                                
;   RS   R/W  DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0   Funkci  (vgrehajtsi id)           
;-------------------------------------------------------------------------------
;    0    0   0   0   0   0   0   0   0   1     Display clear        (1,6ms)  
;    0    0   0   0   0   0   0   0   1   x     Display, cursor home (1,6ms)  
;    0    0   0   0   0   0   0   1  I/D  S     Entry mode set       (40us)      
;    0    0   0   0   0   0   1   D   C   B     Display ON/OFF       (40us) 
;    0    0   0   0   0   1  S/C R/L  x   x     Display/Cursor shift (40us)        
;    0    0   0   0   1   DL  N   x   x   x     Function set         (40us)        
;    0    0   0   1   ------ CG ADDR ------     CG RAM address set   (40us) 
;    0    0   1   ------- DD ADDR ---------     DD RAM address set   (40us) 
;    1    0   --------- Write data --------     CG/DD RAM data write (40us) 
;-------------------------------------------------------------------------------
;    0    1   BF  ----- Address counter ---     Busy flag/Addr cnt read (0)
;    1    1   ---------- Read data --------     CG/DD RAM data read  (40us)
;-------------------------------------------------------------------------------
;
;	I/D=1 inkrementls, I/D=0 dekrementls
;	S=1 display lptets, S=0 display "rgztett"
;    	D=1 display on, D=0 display off
;    	C=1 kurzor on, C=0 kurzor off
;    	B=1 karakter a kurzor helyn villog, B=0 nem villog
;    	S/C=1 display lptets, S/C=0 kurzor mozog
;    	R/L=1 lptets jobbra, R/L=0 lptets balra
;    	DL=1 8 bites, DL=0 4 bites interfsz
;    	N=1 kt soros, N=0 egy soros zemmd
;    	CG ADDR : karakter genertor RAM cm
;    	DD ADDR : display adat RAM cm
;
;-------------------------------------------------------------------------------
Timer1          equ     32
Timer2          equ     33
Timer3		equ	34
Counter		equ	35
Pointer		equ	36
Shift_Cntr	equ	37
;-------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0               ; 0= utasts, 1= adat reg. vlaszts
RdWr		equ	1		; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2               ; 0= LCD tilts, 1= engedlyezs
;-------------------------------------------------------------------------------
;
                org     0
		nop
;===============================================================================
; Port bellts
;
	        clrf    PORTD
                clrf    PORTE
Start		bcf	STATUS,RP1	
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'	; PORTA bemenet
		movwf	TRISA
		clrf	TRISD		; PORTD kimenet
		clrf	TRISE		; PORTE kimenet
		bcf	STATUS,RP0	; bank0 kivlaszts
;-------------------------------------------------------------------------------
; LCD kijelz inicializlsa 
;
	        bcf	PORTE,RS	; LCD parancs kvetkezik
		movlw   H'38'           ; 8 bites interfsz, 2 sor
                call    Write
                call    Kesl		; Busy flag olvasst "helyettesti"
                movlw   H'38'
                call    Write
                movlw   6               ; 06h, Entry mode set: increment
                call    Write
                movlw   12              ; 0ch, Display on, blink off
                call    Write
                movlw   16              ; 10h, Display/cursor shift: cursor
                call    Write
                movlw   1               ; 01h, Display clear
                call    Write
                call    Kesl2		; Busy flag olvasst "helyettesti"
;-------------------------------------------------------------------------------
; Adatklds LCD-re
;
                movlw   208             ; LCD cm= msodik LCD sor +16
                call    Write
		bsf	PORTE,RS	; LCD adat kvetkezik
		movlw	16		; 16 adat kiiratsa
		movwf	Counter
		clrf	Pointer
Start1		movf	Pointer,0
		call	LCD_Tabla1
                call    Write
		incf	Pointer,1
		decfsz	Counter,1
		goto	Start1
;-------------------------------------------------------------------------------
; Display lptets
;
		bcf	PORTE,RS	; LCD parancs
		movlw	16
		movwf	Shift_Cntr
Shift_Loop	movlw	H'18'
                call    Write
		call	Shift_Delay
		decfsz	Shift_Cntr,1
		goto	Shift_Loop
;-------------------------------------------------------------------------------
; Adatklds LCD-re
;
		bcf	PORTE,RS	; LCD parancs
                movlw   192             ; LCD cm= msodik LCD sor
                call    Write
		bsf	PORTE,RS	; LCD adat kvetkezik
		movlw	16		; 16 adat kiiratsa
		movwf	Counter
		clrf	Pointer
Start2		movf	Pointer,0
		call	LCD_Tabla1
                call    Write
		incf	Pointer,1
		decfsz	Counter,1
		goto	Start2
;-------------------------------------------------------------------------------
; Display lptets
;
		bcf	PORTE,RS	; LCD parancs
		movlw	3
                call    Write
		call    Kesl2
;-------------------------------------------------------------------------------
; Adatklds LCD-re
;
                movlw   208             ; LCD cm= msodik LCD sor +16
                call    Write
		bsf	PORTE,RS	; LCD adat kvetkezik
		movlw	16		; 16 adat kiiratsa
		movwf	Counter
		clrf	Pointer
Start3		movf	Pointer,0
		call	LCD_Tabla2
                call    Write
		incf	Pointer,1
		decfsz	Counter,1
		goto	Start3
;-------------------------------------------------------------------------------
		bcf	PORTE,RS	; LCD parancs
                movlw   144             ; LCD cm= els LCD sor +16
                call    Write
		bsf	PORTE,RS	; LCD adat kvetkezik
		movlw	16		; 16 adat kiiratsa
		movwf	Counter
		clrf	Pointer
Start4		movf	Pointer,0
		call	LCD_Tabla1
                call    Write
		incf	Pointer,1
		decfsz	Counter,1
		goto	Start4
;-------------------------------------------------------------------------------
; Display lptets
;
		bcf	PORTE,RS	; LCD parancs
		movlw	16
		movwf	Shift_Cntr
Shift_Loop1	movlw	H'18'
                call    Write
		call	Shift_Delay
		decfsz	Shift_Cntr,1
		goto	Shift_Loop1
;-------------------------------------------------------------------------------
Stop		goto	Stop		; resetre vr
;===============================================================================
;
;
;-------------------------------------------------------------------------------
LCD_Tabla1	addwf	PCL,1
		dt	"FD-1 demo panel "
;-------------------------------------------------------------------------------
LCD_Tabla2	addwf	PCL,1
		dt	"szego@umszki.hu "
;-------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write           movwf   PORTD
		bsf     PORTE,E
                call    Kesl100		; Busy flag olvasst "helyettesti"
                bcf     PORTE,E
                return
;-------------------------------------------------------------------------------
Kesl100         movlw   165		; 100us ksleltets
                movwf   Timer1
Kesl1		decfsz  Timer1,1
                goto    Kesl1
                return
;-------------------------------------------------------------------------------
Kesl2           clrf    Timer1		; 2ms ksleltets
                movlw	20
		movwf   Timer2
Kesl21          call	Kesl100
                decfsz  Timer2,1
                goto    Kesl21
                return
;-------------------------------------------------------------------------------
Kesl		call	Kesl2
                call    Kesl2
                call    Kesl2
                call    Kesl2
                call    Kesl2
		return			; 5x2ms ksleltets
;-------------------------------------------------------------------------------
Shift_Delay	movlw	10		; kb. 0,5mp ksleltets
		movwf	Timer3
Delay		decfsz	Timer1,1
		goto	Delay
		decfsz	Timer2,1
		goto	Delay
		decfsz	Timer3,1
		goto	Delay
		return			
;-------------------------------------------------------------------------------
                end

