;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    PWM1.ASM                                          *
;    Dtum:         2000.11.11.                                       *
;    Verziszm:    V1.2                                              *
;    #4                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    PWM DEMO PROGRAM                                                 *
;    ----------------                                                 *
;    A 4x4-es billentyzet valamelyik gombjt lenyomva a panel PWM    *
;    kimenetn a billenty kddal arnyos kitltsi tnyezj         *
;    impulzus sorozatot, mg az analg kimeneten a billenty kddal   *
;    arnyos egyenfeszltsget kapunk.                                *
;                                                                     *
;**********************************************************************
;
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;----------------------------------------------------------------------
;
Rows            equ     34		; sor szmll
Key             equ     35		; billenty kd trolja
Temp		equ	36	
;-------------------------------------------------------------------------------
; PORTA s PORTB kivezetsek, melyek a billentyzetet olvassk
;
#define		Col1 	PORTB,4		; RB4
#define		Col2    PORTB,5		; RB5
#define		Col3    PORTA,3		; RA3
#define		Col4    PORTA,5		; RA5
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;----------------------------- FPROGRAM ---------------------------------------
;-------------------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;-------------------------------------------------------------------------------
; I/O port konfigurls
;
		bsf	STATUS,RP0	
		bcf	STATUS,RP1	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'00111111'	; PORTA bemenet
		movwf	TRISA
		movlw	B'11110000'    	; RB0..3 kimenet, RB4..7 bemenet
		movwf	TRISB
		movlw	B'11111011'	; RC2 kimenet (PWM1)
		movwf	TRISC
		bcf	OPTION_REG,NOT_RBPU	; felhz ellenllsok konfigurlsa
		bcf	STATUS,RP0	; bank0 kivlaszts
;-------------------------------------------------------------------------------
; CCP1 modul programozsa PWM mdban
;
		clrf	PIE1		; perifria megszaktsok tiltsa
		movlw	0xFF		; PR2=0xFF
		movwf	PR2		; a Timer2 peridus regisztere
		bcf	STATUS,RP0	; bank0 kivlaszts
		clrf	CCP1CON
		clrf	TMR2
		movlw	0
		movwf	CCPR1L		; kitltsi tnyez bellts
		movlw	0x2C
		movwf	CCP1CON		; PWM md
		bsf	T2CON,T2CKPS1	; TMR2 eloszt=16
		bsf 	T2CON,TMR2ON	; Timer2 engedlyezs
;-------------------------------------------------------------------------------
Loop		call	Scan		; billentyzet vizsglat
		movf	Key,0		; lenyomott billenty kd -> W
		call	Tabla
		movwf	CCPR1L		; kitltsi tnyez bellts
		goto	Loop		; vrakozs resetre
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;---------------------------- SZUBRUTINOK --------------------------------------
;-------------------------------------------------------------------------------
;
;
;-------------------------------------------------------------------------------
; Billentyzet vizsglat
;
Scan            clrf    Key		; Key vltoz trlse
                movlw   4
                movwf   Rows		; 4 nyomgomb sor van
                movlw   14
                movwf   Temp		; Temp kezdeti rtke 14, gy
		goto	Scan1		; a B portra xxxx1110 kerl ki!
;-----------------------------------------------------------------------------
Scan0		bsf	STATUS,C
		rlf	Temp,1		; Carry belptetse a Temp regiszterbe
Scan1		movf	Temp,0
                movwf   PORTB		; Temp msolsa W-n keresztl PORTB-re
		nop
                btfss   Col1		; els oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col2		; 2. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col3		; 3. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col4		; 4. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                decfsz  Rows,1		; sor szmll cskkents
                goto    Scan0		; mg nem vizsgltunk meg mind a 4 sort
;-----------------------------------------------------------------------------
Press           return
;-----------------------------------------------------------------------------
Tabla		addwf	PCL,1
		retlw	H'00'
		retlw	H'11'
		retlw	H'22'
		retlw	H'33'
		retlw	H'44'
		retlw	H'55'
		retlw	H'66'
		retlw	H'77'
		retlw	H'88'
		retlw	H'99'
		retlw	H'AA'
		retlw	H'BB'
		retlw	H'CC'
		retlw	H'DD'
		retlw	H'EE'
		retlw	H'FF'
		retlw	H'00'
;-----------------------------------------------------------------------------			retlw	H'11'

		end
