;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    SPI.ASM                                           *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    93LC56 MICROWIRE SOROS EEPROM KEZEL PROGRAM                     *
;    --------------------------------------------                     *
;    Az EEPROM CLK, DI, DO vonalait az SPI port kezeli.               *
;    Az EEPROM kivlasztst - a CS jellel - az RA2 vonal vgzi.      *
;                                                                     *
;**********************************************************************
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;
;----------------------------------------------------------------------
Rxdata		equ	0x24		; SPI kimeneti adat
Txdata		equ	0x25		; SPI bemeneti adat
EE_Addr		equ	0x26		; EEPROM cm tmeneti trol
EE_Data		equ	0x27		; EEPROM adat tmeneti trol
Opcode		equ	0x28		; utastskd tmeneti trol
;----------------------------------------------------------------------
; PORTA kivezetsek
;
CS      	equ	2		; RA2, EEPROM Chip select, aktv H
;----------------------------------------------------------------------
; PORTC kivezetsek
;
SDO		equ	5		; RC5, EEPROM DI kivezetsre
SDI		equ	4		; RC4, EEPROM DO kivezetsre
CLK     	equ	3		; RC3, EEPROM CLK kivezetsre
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAMOK ----------------------------
;----------------------------------------------------------------------
		org     0x000          	; reset vektor
		nop			; MPLAB-ICD miatt
;----------------------------------------------------------------------
; Port konfigurls
;
Start		bcf	STATUS,RP0	
		bcf	STATUS,RP1	; bank0 kivlaszts
		clrf	PORTA		; EEPROM nincs kivlasztva
		clrf	PORTC		; EEPROM vonalak inaktvak
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111011'    	; RA2 kimenet
		movwf	TRISA
		movlw	B'11010111'	; RC3, RC5 kimenet
		movwf	TRISC
;----------------------------------------------------------------------
; SPI inicializls
;
		clrf	PIE1		; a perifria megszaktsok tiltsa 
		clrf	INTCON		; 
		clrf	SSPSTAT		; SMP=CKE=0
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	0x32		; SPI master, Fosc/64, CKP=1
		movwf	SSPCON		; SSPEN=1, soros port engedlyezs
;----------------------------------------------------------------------
; Egy bjt rsa az EEPROM-ba
;
		call	Ewen		; EEPROM trls/rs engedlyezse
		movlw	B'00001010'	; Start bit, utastskd s A8 betlts
		movwf	Opcode		; az Opcode regiszterbe
		movlw	0x24		; EEPROM cm betltse az EE_Addr
		movwf	EE_Addr		; regiszterbe
		movlw	0x5A		; adat az EEPROM szmra
		movwf	EE_Data	
		call	Write		; EEPROM rs
		nop			; CS alacsony, majd ismt magas
		bsf	PORTA,CS	;   -> EEPROM nidzts indul
Rdbusy		btfss	PORTC,SDI	; EEPROM ready jel vizsglata
		goto	Rdbusy		; ha SDI=0, mg nem ksz
;----------------------------------------------------------------------
; Egy bjt olvass az EEPROM-bl
; Az olvassnl az rjel polaritst (inaktv szintjt) meg kell fordtani:
; az EEPROM az adatot az rajel felfut lnl teszi a DO kimenetre (SDI vonal),
; a mikrovezrl pedig a lefut lnl olvassa be azt.
;
		bcf	PORTA, CS	; 
		movlw	B'00001100'	; Start bit, utastskd s A8 betlts
		movwf	Opcode		; az Opcode regiszterbe
		movlw	0x24		; EEPROM cm betltse az EE_Addr
		movwf	EE_Addr		; regiszterbe
		call	Read		; EEPROM olvass
		nop			; beolvasott adat -> EE_Data
		nop
Stop		goto	Stop		; vrakozs resetre
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- SZUBRUTINOK ----------------------------
;----------------------------------------------------------------------
;
Ewen		bcf	STATUS,RP0	; bank0 kivlaszts 
		bsf	PORTA,CS	; CS=1, EEPROM kivlaszts
		movlw	B'00001001'	; Start bit, utastskd, A8 kiklds
		call	Output		; kiklds az SPI porton
		movlw	B'10000000'	; tovbbi 1 bit az EWEN kdjhoz
		call	Output		; kiklds az SPI porton
		bcf	PORTA,CS	; EEPROM inaktv
		return
;----------------------------------------------------------------------
Ewds		bcf	STATUS,RP0	; bank0 kivlaszts
		bsf	PORTA,CS	; CS=1, EEPROM kivlaszts
		movlw	B'00001000'	; Start bit, utastskd, A8 kiklds
		call	Output		;
		movlw	B'00000000'	; tovbbi 1 bit az EWDS kdjhoz
		call	Output		; kiklds az SPI porton
		bcf	PORTA,CS	; EEPROM inaktv 
		return
;----------------------------------------------------------------------
Output		movwf	SSPBUF		; betlts az SPI shift regiszterbe	
Loop		bsf	STATUS,RP0	; bank1 kivlaszts
		btfss	SSPSTAT,BF	; ads/vtel ksz?
		goto	Loop		; mg nem
;----------------------------------------------------------------------
		bcf	STATUS,RP0	; bank0 kivlaszts
		movf	SSPBUF,0	; 
		movwf	Rxdata		; a vett adat az Rxdata regiszterbe
		return			; kerl
;----------------------------------------------------------------------
Write		bcf	STATUS,RP0	; bank0 kivlaszts
		bsf	PORTA,CS	; CS=1, EEPROM kivlaszts
		movf	Opcode,0	; rs kd kiklds
		call	Output		;
		movf	EE_Addr,0	; EEPROM cm kiklds
		call	Output		;
		movf	EE_Data,0	; programozand adat
		call	Output		;
		bcf	PORTA,CS
		return
;----------------------------------------------------------------------
Read		bcf	STATUS,RP0	; bank0 kivlaszts
		bsf	PORTA,CS	; CS=1, EEPROM kivlaszts
		movf	Opcode,0	; olvass kd kiklds
		call	Output		;
		movf	EE_Addr, 0	; EEPROM cm kiklds
		call	Output		;
		bcf	SSPCON, CKP	; rajel polarits vlts, CKP=0
		movlw	0x00		; "dummy" adat kiklds
		call	Output		;
		movf	Rxdata,0
		movwf	EE_Data		; beolvasott adat -> EE_Data
		bcf	PORTA,CS	; olvass lezrs, CS=0
		bsf	SSPCON, CKP	; CKP=1, rajel polarts vlts
		return
;----------------------------------------------------------------------		
		end

