;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    RS232_SW.ASM                                      *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    RS-232 INTERFSZ KEZELSE SZOFTVERES RUTINOKKAL                  *
;    -----------------------------------------------                  *
;    A program a 00h...FFh rtkek kztt vltoz Temp regiszter      *
;    tartalmt kldi ki a soros porton 9600 baud sebessggel.         *
;    Szoftveres ad/vev rutinokat hasznl.                           *
;    Az RS232 kommunikci adatformtuma: 9600-1-8-N-1.               *
;                                                                     *
;**********************************************************************
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;----------------------------------------------------------------------
;
Timer1		equ	32
Bit_Cntr	equ	33
Temp1		equ	34
Temp		equ	35
;----------------------------------------------------------------------
; PORTC bitek
;
TxData	equ	6
RxData	equ	7
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop
;----------------------------------------------------------------------
; PORTA, PORTC konfigurls
;
		bsf	STATUS,RP0	
		bcf	STATUS,RP1	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'    	; PORTA bemenet
		movwf	TRISA
		movlw	B'10111111'	; RC6 kimenet (TxD)
		movwf	TRISC
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	64
		movwf	PORTC		; TxD=1 nyugalmi jelszint bellts
;----------------------------------------------------------------------
		clrf	Temp
Loop		incf	Temp,1		; Temp1 inkrementls
		movf	Temp,0		; Temp1 msolsa W-be
		call	RS232_Tx	; RS-232 ads
;		call	RS232_Rx
		goto	Loop		; 
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;---------------------------- SZUBRUTINOK -----------------------------
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
; Egy RS-232 bjt vtele
;
RS232_Rx        btfsc   PORTC,RxData    ; start bit detektls (log0 szint)
                goto    RS232_Rx	; nincs start jel, vrakozik tovbb
;----------------------------------------------------------------------
                call    Start_Delay     ; ft bitidnyi ksleltets
                movlw   8		; bitek szma
                movwf   Bit_Cntr
Rmit            call    Bit_Delay       ; teljes bitidnyi ksleltets
                btfss   PORTC,RxData	; RxD bemenet msolsa C bitbe
		bcf     STATUS,C
                btfsc   PORTC,RxData
		bsf     STATUS,C
		rrf     Temp1,1		; Carry belptetse Temp1-be
		decfsz	Bit_Cntr,1	; sszes bit vtele megtrtnt?
		goto	Rmit		; mg nem
;----------------------------------------------------------------------
                call    Bit_Delay       ; Stop bit ksleltets
		return			; vtel ksz, vett adat Temp1-ben
;----------------------------------------------------------------------
; Egy RS-232 bjt adsa
;
RS232_Tx        movwf   Temp1		; adat msolsa Temp1-be
                movlw   8		; bitek szma
                movwf   Bit_Cntr
                bcf     PORTC,TxData	; Start bit kikldse, log0 szint
                call    Bit_Delay       ; Start bit ksleltets
Xmit            rrf     Temp1,1         ; kilptets LSB elszr, MSB utoljra
                btfss   STATUS,C	; Carry msolsa a TxD kimenetre
		bcf     PORTC,TxData
		btfsc   STATUS,C
		bsf     PORTC,TxData
                call    Bit_Delay       ; bit ksleltets
Xmit2           decfsz  Bit_Cntr,1	; sszes bit adsa megtrtnt?
                goto    Xmit		; mg nem
;----------------------------------------------------------------------
                bsf     PORTC,TxData
                call    Bit_Delay       ; Stop bit kikldse, log1 szint
                return
;----------------------------------------------------------------------
; RS232 startbit ksleltets
;
Start_Delay     movlw   85		; 52 us / 9600 Baud
                movwf   Timer1
Loop2           decfsz  Timer1,1
                goto    Loop2
                return
;----------------------------------------------------------------------
; RS232 bit id bellits
;
Bit_Delay       movlw   172		; 104,2 us / 9600 Baud
                movwf   Timer1 
Loop1           decfsz  Timer1,1
		goto    Loop1
                return
;----------------------------------------------------------------------
		end

