//#######################################################################################################################
//#
//#	  
//#
//#######################################################################################################################


//     \ (  800 )
ISR (TIMER2_COMP_vect)
{
//*************************
//    
//*************************

	static char LedBoardXCoun = 0;				//      
	LedBoardOut (LedBoardXCoun);				//  

	if (LedBoardXCoun == 1)
		if (Flags1 & b1ClockReadEnable)
			IICClockReadData ();				//   (   )

	if ((LedBoardXCoun >= 2) && (LedBoardXCoun <= 5))
		if (Flags1 & b1OneWireGet)				//    
			OneWireIntTermoGet ();				//  - Flags1 &= ~b1OneWireGet; -  

	if (LedBoardXCoun == 6){					//  
		BtnGet ();								//-   
		VarProcessing ();						//-   
	}

	if (++LedBoardXCoun == 8){					//   
		LedBoardXCoun = 0;
		Flags1 |= b1LedBoardPageCompleted;		//    (  )
		ClockBufferProcess ();					//    
	}

}


//-----------------------------------------------------------------------------------------------------------------------
//      
//    ,     DS1307,        
//  ClockGraphBuf.             
//   ,         ClockPosition (0 - )

char* pClockBuf;												//     
void ClockBufferProcess (void) 
{	
	static char ShiftDelay;										//  
	static char ShiftMask;										//  -  ,     (0x01 - 0x80)
	pClockBuf = ClockGraphBuf;									//      

	char Flags = ClockChangeMask;								//  
	if (! ShiftMask)											
		if (Flags){											
			ShiftMask = 1;										//   	
			ShiftDelay = 0;
	}

	if (! ShiftDelay--){
		ShiftDelay = 6;

		//      
		char ShiftTemp;
		if (Flags & 0x20) ShiftTemp = ShiftMask;						//    
		else ShiftTemp = 0;												
		ClockSimbToBuf ((ClockData[2]>>4)+0x30, ShiftTemp);	
		if (Flags & 0x10) ShiftTemp = ShiftMask;						//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[2] & 0x0f)+0x30,ShiftTemp);			
		
		ClockSimbToBuf (':', 0);									//							
	
		if (Flags & 0x08) ShiftTemp = ShiftMask;						//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[1]>>4)+0x30, ShiftTemp);				
		if (Flags & 0x04) ShiftTemp = ShiftMask;						//    	
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[1] & 0x0f)+0x30, ShiftTemp);		

		ClockSimbToBuf (':', 0);									//						
	
		if (Flags & 0x02) ShiftTemp = ShiftMask;						//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[0]>>4)+0x30, ShiftTemp);				
		if (Flags & 0x01) ShiftTemp = ShiftMask;						//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[0] & 0x0f)+0x30, ShiftTemp);	
		
		ShiftMask <<= 1;
		if (! ShiftMask)
			ClockChangeMask = 0; 
	}


	//   -     ,   	
	if (ClockPosition){																				
		char* pLedBoardBuffer = LedBoardBuffer + ClockPosition + LedBoardSimbWidth - 1;	//      
		char* pClockGraphBuf = ClockGraphBuf + sizeof ClockGraphBuf -1;					//    

		for (uint8_t i =sizeof ClockGraphBuf; i; i--){
			if ((pLedBoardBuffer < LedBoardBuffer + ((LedBoardSize + 1) * LedBoardSimbWidth)) &&
			(pLedBoardBuffer >= LedBoardBuffer + LedBoardSimbWidth))
				*pLedBoardBuffer = *pClockGraphBuf;										//      - 

			pLedBoardBuffer--;
			pClockGraphBuf--;
		}
	}
}


//       (    )
//-1    
//-2      (0x01 - 0x80),  0 -  .
//    (1..12)		(11 - (1..10) ) * 12 / 10

void ClockSimbToBuf (char byte, char shift)
{
	char* pSimbMass = SimbMass + ((byte-0x20) * FontSimbWidth);	//      PROGMEM

	for (char i=0; i<FontSimbWidth; i++){						//      
		char temp = pgm_read_byte (pSimbMass++);				
		if (shift){
			*pClockBuf >>= 1;									//      (  )
			if (temp & shift)
				*pClockBuf |= 0x80;
		}
		else
			*pClockBuf = temp;									//      ( )			
		pClockBuf++;	
	}

	for (char i=0; i<(LedBoardSimbWidth-FontSimbWidth); i++)	
		*pClockBuf++ = 0;										//   
}


//-----------------------------------------------------------------------------------------------------------------------
//       (   HC595)
// -   (0-7)     

void LedBoardOut (char NumLine) 
{
	char MaskXRow = (1<<(NumLine));					//  
	char* pLedBoardBuffer = LedBoardBuffer + LedBoardSimbWidth;
												//    
	for (char i=0; i<(LedBoardSize * LedBoardSimbWidth); i++){
		char temp = *pLedBoardBuffer++;
//*************************
		temp >>= 1;			//  7 
//*************************

		if (temp & MaskXRow)					//  
			LedBoardDataPORT |= LedBoardData;
		else	
			LedBoardDataPORT &= ~LedBoardData;			
			
		_delay_us (1);
		LedBoardDataPORT |= LedBoardClc;		// (   )
		_delay_us (1);
		LedBoardDataPORT &= ~LedBoardClc;
	}

	LedBoardRowPORT = 0xFF-LedBoardRowInvert;	//  	
	LedBoardDataPORT |= LedBoardStrobe;			//       -   
	_delay_us (1);
	LedBoardDataPORT &= ~LedBoardStrobe;
	_delay_us (1);
	LedBoardRowPORT = (~LedBoardRowInvert)^MaskXRow;//   
}


//-----------------------------------------------------------------------------------------------------------------------
//          (   100 )
//    ShortXXXX   BtnFlags
//    LongXXXX   BtnFlags

void BtnGet (void)
{	 //   
	#define BtnLockTime 30						/*     (10-100)*/
	#define BtnLongPressTime 2000				/*      (1000 - 2500)*/

	//    (\  )
	static unsigned char BtnLockBit;			// (  )
	static unsigned char BtnLockCoun;			//  (  )
	static unsigned char BtnLongCoun;			//  
	static unsigned char BtnTemp;				// 	 

	//    ( \   )
	static unsigned char BtnLongSpeedTmp;		//   *BtnLongSpeed
	static unsigned char BtnLongTimer;			//   BtnLongSpeedTmp

	//  
	char BtnStack = 0;
	char temp = ~BtnPIN;
	if (temp & Button1)
		BtnStack = 0x01;
	if (temp & Button2)
		BtnStack = 0x02;
	if (temp & Button3)
		BtnStack = 0x04;
	if (temp & Button4)
		BtnStack = 0x08;

	//    
	if (BtnStack){								// 
		BtnTemp = BtnStack;
		BtnStack = 0;

		if (BtnLockCoun < (BtnLockTime/10)){
			BtnLockCoun++;
			return;
		}
		BtnLockBit=1;							// 		
		if (BtnLongCoun >= (BtnLongPressTime/10)){								
			LedBoardFlashCoun = 0;				//    FLASH 
			BtnLongTimer ++;					//     	
			if (! (BtnLongTimer & 0b00001111))	// 0,16    BtnLongSpeed  BtnLongSpeedTemp
				BtnLongSpeed = BtnLongSpeedTmp;
			if (BtnLongTimer == 128)			// 1,28    BtnLongSpeedTemp
			{
				BtnLongTimer = 0;
				if (BtnLongSpeedTmp < 64)
					BtnLongSpeedTmp <<= 1;	
			}
			return;
		}
		BtnLongCoun ++;
		if (BtnLongCoun >= (BtnLongPressTime/10)){
			BtnFlags |= (BtnTemp << 4);			//    ( 4   ButtonByte)
					
			BtnLongSpeed = 1;					//     	
			BtnLongSpeedTmp = 1;						
			BtnLongTimer = 0;
		}
	}		
	else{										// 			
		if (BtnLockCoun != 0){
			BtnLockCoun --;
			return;
		}
		if (! (BtnLockBit))						// 
			return;
		BtnLockBit =0;
		if (BtnLongCoun < (BtnLongPressTime/10)){
			BtnFlags |= (BtnTemp);				//    ( 4   ButtonByte)
			LedBoardFlashCoun = 0;				//    FLASH 
		}
		BtnLongCoun = 0;
		BtnLongSpeed = 0;						//      
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//    (    100)

void VarProcessing (void)
{	 
	if (++ LedBoardFlashCoun == 100)		//  FLASH (   0-99)
		LedBoardFlashCoun = 0;

	if (++ ClockMiliSecond == 120)			//   
		ClockMiliSecond = 0;				//(    - ClockReadData())

	static char OneWireCicle = 0;			//    DS1820 (1 \)
	if (++ OneWireCicle == 100){
		OneWireCicle = 0;		
		Flags1 |= b1OneWireGet;			//  0 -   

		//     1 
		if (BtnTimeOutCoun)					//  timeout-
			BtnTimeOutCoun--;
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//     2-x  DS18B20
//           1wire
//    1            

void OneWireIntTermoGet (void)
{
	static unsigned char step = 0;
	char mask;

	if (step < 16)								// 0  15   1
		mask = OneWireLine1;
	else{
		if (step < 32)							// 16  31   2
			mask = OneWireLine2;
		else
			mask = OneWireLine1 | OneWireLine2;	// 32   
	}

	unsigned char byte;
	byte = pgm_read_byte (&DSReadingMap [step++]);//  ,  1 
	if (byte < 8)								//   DS18B20      OneWireReadBuf[]
		OneWireReadBuf [byte] = OneWireData(0xff, mask);
	if (byte == 0x0b)			
		OneWireReadBuf [8] = OneWireCheckSumm;	// CRC  
	if (byte == 0x0c)			
		OneWireData(0xff, mask);				//    CRC
	if (byte == 0x0d)							
		OneWireReset (mask);					// 1Wire 
	if (byte == 0x0e){
		char OneWireCRC	= OneWireReadBuf[8];
		char* pBufData = OneWireReadBuf;

		for (unsigned char i=0; i<2; i++){
			char DevType = *pBufData++;			// 1wire 
			int termo = 0;						//   
			termo = *pBufData++;				//  
			termo |= (*pBufData++) << 8;		//  
			char Config = *pBufData++;			//  -
			if (OneWireCRC 						//  
			|| !((DevType == 0x28) 				//0x28 -  DS18B20
			|| (DevType == 0x10))) 				//0x10 -  DS18S20
				OneWireErr |= (1<<i);			//   ,   ,     
			else{
				OneWireErr &= ~(1<<i);			//  ,     
				if (DevType == 0x10)
					Config = 0;	
				Config >>= 5;					//     
				Config ^= 0xff;
				Config &= 0x03;

				while (Config--)
					termo <<= 1;				//    12 
				termo *= 10;					//         
				termo /= 16;
				OneWireTermoData [i] = termo;	//  

			}
			OneWireCRC = OneWireCheckSumm;
		}
	}
	if (byte == 0x0f){
		Flags1 &= ~b1OneWireGet;				//  
		step =0;								//  
	}
	if (byte >= 0x10){							//0x33   . 0xCC      . 
		OneWireData (byte, mask);				//0xBE    . 0x44 
		if (byte == 0xBE)
			OneWireCheckSumm = 0;				//     CRC
	}
}


//#######################################################################################################################
//#
//#	END
//#
//#######################################################################################################################

 
