//#######################################################################################################################
//#
//#	  
//#
//#######################################################################################################################


//     \ (  800 )
ISR (TIMER2_COMP_vect)
{
	static char LedBoardXCoun;					//       (0-7   )
	LedBoardOut (LedBoardXCoun);				//  
												// 0-    ,         7- 
	if (LedBoardXCoun == 1)						//  1-  
		if (Flags1 & b1ClockReadEnable)			//   ( )
			IICClockReadData ();				

	if ((LedBoardXCoun >= 2) && (LedBoardXCoun <= 5))//    2-5
		if (Flags1 & b1OneWireGet)				//    ( )
			OneWireIntTermoGet ();				//  - Flags1 &= ~b1OneWireGet; -  

	if (LedBoardXCoun == 6){					//   6
		VarProcessing ();						//-   
	}

	if (++LedBoardXCoun == 8){					//  7-  ().....
		LedBoardXCoun = 0;						
		Flags1 |= b1LedBoardPageCompleted;		//     (  )
		ClockBufferRefresh ();					//    
	}

}


//-----------------------------------------------------------------------------------------------------------------------
//    (    100)

void VarProcessing (void)
{	 
	if (++ ClockMiliSecond == 120)				//   
		ClockMiliSecond = 0;					//(    - ClockReadData())

	static char OneWireCicle = 0;				//    DS1820 (1 \)
	if (++ OneWireCicle == 100){
		OneWireCicle = 0;		
		Flags1 |= b1OneWireGet;					//1    -   
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//      
//    ,     DS1307,        
//  ClockGraphBuf.             
//     ,         ClockPosition (0 - )

char* pClockGraphBuf;							//     

void ClockBufferRefresh (void) 
{	
	static char ShiftDelay;						//   
	static char ShiftMask;						//  -   (    0x01 - 0x80)
	pClockGraphBuf = ClockGraphBuf;				//      

	char Flags = ClockChangeMask;				//  
	if (! ShiftMask)							//   0 (..   ), 
		if (Flags){								//   ,   
			ShiftMask = 1;						//   	
			ShiftDelay = 0;						//    
		}

	if (! ShiftDelay--){
		ShiftDelay = ClockSimbVertScrollSpeed;	// 
		if (ShiftDelay > 12)
			ShiftDelay = 12;					//    0-12

		//      
		char ShiftTemp;											//

		if (Flags & 0x20) ShiftTemp = ShiftMask;				//    
		else ShiftTemp = 0;												
		ClockSimbToBuf ((ClockData[2]>>4)+0x30, ShiftTemp);		
		if (Flags & 0x10) ShiftTemp = ShiftMask;				//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[2] & 0x0f)+0x30,ShiftTemp);			
		
		ClockSimbToBuf (':', 0);								// (0 -  )							
	
		if (Flags & 0x08) ShiftTemp = ShiftMask;				//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[1]>>4)+0x30, ShiftTemp);				
		if (Flags & 0x04) ShiftTemp = ShiftMask;				//    	
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[1] & 0x0f)+0x30, ShiftTemp);		

		ClockSimbToBuf (':', 0);								// (0 -  )
	
		if (Flags & 0x02) ShiftTemp = ShiftMask;				//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[0]>>4)+0x30, ShiftTemp);				
		if (Flags & 0x01) ShiftTemp = ShiftMask;				//    
		else ShiftTemp = 0;
		ClockSimbToBuf ((ClockData[0] & 0x0f)+0x30, ShiftTemp);	
		
		ShiftMask <<= 1;
		if (! ShiftMask)
			ClockChangeMask = 0; 								//    -    
	}


	//   -     ,    	
	if (ClockPosition){																	
		char* pLedBoardBuffer = LedBoardBuffer + ClockPosition + LedBoardSimbWidth - 1;	//      
		char* pClockGraphBuf = ClockGraphBuf + sizeof ClockGraphBuf -1;					//    

		for (uint8_t i =sizeof ClockGraphBuf; i; i--){									//    
			if ((pLedBoardBuffer < LedBoardBuffer + ((LedBoardSize + 1) * LedBoardSimbWidth)) 
			&& (pLedBoardBuffer >= LedBoardBuffer + LedBoardSimbWidth))
				*pLedBoardBuffer = *pClockGraphBuf;										//      - 

			pLedBoardBuffer--;
			pClockGraphBuf--;
		}
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//       (    )
//-1     
//-2      (0x01 - 0x80),  0 -  .
//       pClockBuf
//    (1..12)		(11 - (1..10) ) * 12 / 10
char* pSimbMass;

void ClockSimbToBuf (char byte, char shift)
{												//      PROGMEM
	pSimbMass = SimbMass + ((byte-0x20) * FontSimbWidth);

	//  
	if (ClockSimbScrollEffect == 0){
		shift = 0;
		goto m1;
	}

	//   
	if (ClockSimbScrollEffect == 1){
m1:		for (char i=0; i<FontSimbWidth; i++){	//      
			char temp = pgm_read_byte (pSimbMass++);				
			if (shift){
				*pClockGraphBuf >>= 1;			//      (  )
				if (temp & shift)
					*pClockGraphBuf |= 0x80;
			}
			else
				*pClockGraphBuf = temp;			//      ( )			
			pClockGraphBuf++;	
		}

		for (char i=0; i<(LedBoardSimbWidth-FontSimbWidth); i++)	
			*pClockGraphBuf++ = 0;				//   
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//       (   HC595)
// -   (0-7)     

void LedBoardOut (char NumLine) 
{
	char MaskXRow = (1<<NumLine);				//  
	char* pLedBoardBuffer = LedBoardBuffer + LedBoardSimbWidth;
												//    
	for (uint8_t i=0; i<(LedBoardSize * LedBoardSimbWidth); i++){
		char temp = *pLedBoardBuffer++;

		if (temp & MaskXRow)					//  
			LedBoardDataPORT |= LedBoardData;
		else	
			LedBoardDataPORT &= ~LedBoardData;			
			
		_delay_us (1);
		LedBoardDataPORT |= LedBoardClc;		// (   )
		_delay_us (1);
		LedBoardDataPORT &= ~LedBoardClc;
	}

	LedBoardRowPORT = 0xFF-LedBoardRowInvert;	//  	
	LedBoardDataPORT |= LedBoardStrobe;			//       -   
	_delay_us (1);
	LedBoardDataPORT &= ~LedBoardStrobe;
	_delay_us (1);
	LedBoardRowPORT = (~LedBoardRowInvert)^MaskXRow;//   
}


//-----------------------------------------------------------------------------------------------------------------------
//     2-x  DS18B20
//           1wire
//    1            

char DSReadingMap [] PROGMEM = {// ,      
	0x0D,0x33,0x00,0x0D,0xCC,0xBE,0x01,0x02,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x0B,
	0x0D,0x33,0x04,0x0D,0xCC,0xBE,0x05,0x06,0x0C,0x0C,0x07,0x0C,0x0C,0x0C,0x0C,0x0E,
	0x0D,0xCC,0x44,0x0F
};

void OneWireIntTermoGet (void)
{
	static unsigned char step = 0;				// 
	char DevMask;								//   

	if (step < 16)								// 0  15   1
		DevMask = OneWireLine1;
	else{
		if (step < 32)							// 16  31   2
			DevMask = OneWireLine2;
		else
			DevMask = OneWireLine1 | OneWireLine2;// 32   
	}

	unsigned char byte;
	byte = pgm_read_byte (&DSReadingMap [step++]);//  ,  1 
	if (byte < 8)								//   DS18B20      OneWireReadBuf[]
		OneWireReadBuf [byte] = OneWireData(0xff, DevMask);
	if (byte == 0x0b)			
		OneWireReadBuf [8] = OneWireCheckSumm;	// CRC  
	if (byte == 0x0c)			
		OneWireData(0xff, DevMask);				//    CRC
	if (byte == 0x0d)							
		OneWireReset (DevMask);					// 1Wire 
	if (byte == 0x0e){
		char OneWireCRC	= OneWireReadBuf[8];
		char* pBufData = OneWireReadBuf;

		for (unsigned char i=0; i<2; i++){		//    2- 
			char DevType = *pBufData++;			// 1wire 
			int termo = 0;						//   
			termo = *pBufData++;				//  
			termo |= (*pBufData++) << 8;		//  
			char Config = *pBufData++;			//  -
			if (OneWireCRC 						//  
			|| !((DevType == 0x28) 				//0x28 -  DS18B20
			|| (DevType == 0x10))) 				//0x10 -  DS18S20
				OneWireErr |= (1<<i);			//   ,   ,     
			else{
				OneWireErr &= ~(1<<i);			//  ,     
				if (DevType == 0x10)
					Config = 0;	
				Config >>= 5;					//     
				Config ^= 0xff;
				Config &= 0x03;

				while (Config--)
					termo <<= 1;				//    12 
				termo *= 10;					//         
				termo /= 16;
				OneWireTermoData [i] = termo;	//  

			}
			OneWireCRC = OneWireCheckSumm;
		}
	}
	if (byte == 0x0f){							//    
		Flags1 &= ~b1OneWireGet;				//  
		step =0;								//  
	}
	if (byte >= 0x10){							//0x33   . 0xCC      . 
		OneWireData (byte, DevMask);			//0xBE    . 0x44 
		if (byte == 0xBE)
			OneWireCheckSumm = 0;				//     CRC
	}
}


//#######################################################################################################################
//#
//#	END
//#
//#######################################################################################################################

 
