
#include "io430.h"
#include "DS1821.h"
#include "OneWire.h"
#include "lph8731_v3.h"

unsigned char configuration_register;

unsigned char DS1821_Read(int pin){
    
    unsigned char temperatura = 0;
    unsigned char configuration_register;
    
    if (OW_Reset(pin) == 0){
        OW_Write_Byte(DS1821_ReadTemperature, pin);
        temperatura = OW_Read_Byte(pin);
        do {
            delay_ms(1);
            configuration_register = 0;
            
            OW_Reset(pin);
            OW_Write_Byte(0xAC, pin);
            
            char val=0;
            for (char i = 0; i < 1; i++){
                val |= (unsigned int)(OW_Read_Bit(pin) << i * 8);
            }
            configuration_register = val;
        } while ((configuration_register & (1 << 7)) == 0);
    } else
        temperatura = DS1821_Error;
    return (temperatura);
} // read

unsigned char DS1821_Start_Conv(int pin){
    
    unsigned char presence = 0;
    if (OW_Reset(pin) == 0){
        OW_Write_Byte(DS1821_StartConvTemp, pin);
        presence = DS1821_OK;
    } else
        presence = DS1821_Error;
    
    return (presence);
} // start
    
    