
#include "io430.h"
#include "OneWire.h"
#include "main.h"

unsigned char OW_Reset(int pin){
    
    unsigned char presence = 1;
    
    P1DIR  |=  pin;
    P1OUT  |=  pin;
    P1OUT  &= ~pin;
    
    delay_us(480);     // ~ 480 us
    
    P1OUT  |= pin;
    
    delay_us(70);      // ~ 70 us
    P1DIR  &= ~pin;
    
    if ((P1IN & pin) == 0)
        presence = 0;
    else
        presence = 1;
    
    delay_us(410);     //~ 410 us
    
    return (presence);
} //reset
//*****************************************************************************

void OW_Write_Bit (unsigned char cmd, int pin){
    
    P1DIR |=  pin;
    P1OUT &= ~pin;
    
    delay_us(15);
    
    if (cmd == 1){
        P1OUT |= pin;
        delay_us(60);   //~ 60 us
    } else{
        delay_us(60);   //~ 60 us
        P1OUT |= pin;
    } // if
} // write

//******************************************************************************
unsigned char OW_Read_Bit (int pin){
    
    unsigned char bit_= 0;
    
    P1DIR |= pin;
    P1OUT  &= ~pin;
    delay_us(1);       //~ 1 us
    
    P1OUT  |=  pin;
    P1DIR  &= ~pin;
    delay_us(6);       // ~ 6 us
    
    bit_ = (P1IN & pin);
    
    delay_us(55);      // ~ 55us
    
    return (bit_);
} // read
//*********************************************************************************
void OW_Write_Byte (unsigned char cmd, int pin)
{	
  unsigned char i = 0;
	
  for (i = 0; i < 8; i++)
  {
    OW_Write_Bit(cmd & 0x01, pin);
		
    cmd >>= 1;
  }	
}
//**********************************************************************************

unsigned int OW_Read_Byte(int pin){
  char bits=8;
  int value = 1 << (bits-1);
  int b = 0;
  
  while ( bits > 0 ) {
     b >>= 1;
     
     if ( OW_Read_Bit(pin) ) {
     b |= value;
     }
     
     --bits;
  }

  return b;
}






