#ifndef LPH8731_V3_H_
#define LPH8731_V3_H_

#include "stdint.h"
/* PORT DEFINE */
#define LCD_CS P2OUT_bit.P2
#define LCD_RESET P2OUT_bit.P0
#define LCD_RS P2OUT_bit.P3
#define LCD_CLK P2OUT_bit.P4
#define LCD_DATA P2OUT_bit.P5
/* COLOR DEFINE */
#define BLACK 0x00
#define WHITE 0xff
#define RED   0xe0
#define GREEN 0x1c
#define BLUE  0x03


//void delay_ms(uint16_t delay);

void Lcd_reset();
void Send_Sw_SPI(char RS, char data);
void Lcd_init();
void Pixel(char x, char y, char color);
void Pixel_One(char xs, char ys, char xe, char ye);
void set_color(char color);
void Lcd_clear(char color);
char *itoa(long value);

void Lcd_PutChar(char x, char y, char c, char size, char c_color, char background);
void char_size(char x, char y, char szel, char hossz, char color);
void Lcd_PutStr(char x, char y, char *string, char size, char c_color, char background);

//void drawBMP(char x, char y, const char *image, char frame);

void Line_ver(char x, char y, char size, char color);
void Line_hor(char x, char y, char size, char color);

void hour_print(char x, char y, char sz, char size, char color, char bg);
void szam(char x, char y, int sz, char size, char color, char bg);

void delay_ms(uint16_t delay);

#endif