
#include "io430.h"
#include "lph8731_v3.h"
#include "stdint.h"
#include "font_8x12.h"

char RS_old;
unsigned char byte;

const unsigned char font [][5] ={
    { 0x00, 0x00, 0x00, 0x00, 0x00 },  // sp
    { 0x00, 0x00, 0x2f, 0x00, 0x00 },   // !
    { 0x00, 0x07, 0x00, 0x07, 0x00 },   // "
    { 0x14, 0x7f, 0x14, 0x7f, 0x14 },   // #
    { 0x24, 0x2a, 0x7f, 0x2a, 0x12 },   // $
    { 0xc4, 0xc8, 0x10, 0x26, 0x46 },   // %
    { 0x36, 0x49, 0x55, 0x22, 0x50 },   // &
    { 0x00, 0x05, 0x03, 0x00, 0x00 },   // '
    { 0x00, 0x1c, 0x22, 0x41, 0x00 },   // (
    { 0x00, 0x41, 0x22, 0x1c, 0x00 },   // )
    { 0x14, 0x08, 0x3E, 0x08, 0x14 },   // *
    { 0x08, 0x08, 0x3E, 0x08, 0x08 },   // +
    { 0x00, 0x00, 0x50, 0x30, 0x00 },   // ,
    { 0x10, 0x10, 0x10, 0x10, 0x10 },   // -
    { 0x00, 0x60, 0x60, 0x00, 0x00 },   // .
    { 0x20, 0x10, 0x08, 0x04, 0x02 },   // /
//	
    { 0x3E, 0x51, 0x49, 0x45, 0x3E },   // 0
    { 0x00, 0x42, 0x7F, 0x40, 0x00 },   // 1
    { 0x42, 0x61, 0x51, 0x49, 0x46 },   // 2
    { 0x21, 0x41, 0x45, 0x4B, 0x31 },   // 3
    { 0x18, 0x14, 0x12, 0x7F, 0x10 },   // 4
    { 0x27, 0x45, 0x45, 0x45, 0x39 },   // 5
    { 0x3C, 0x4A, 0x49, 0x49, 0x30 },   // 6
    { 0x01, 0x71, 0x09, 0x05, 0x03 },   // 7
    { 0x36, 0x49, 0x49, 0x49, 0x36 },   // 8
    { 0x06, 0x49, 0x49, 0x29, 0x1E },   // 9
    { 0x00, 0x36, 0x36, 0x00, 0x00 },   // :
    { 0x00, 0x56, 0x36, 0x00, 0x00 },   // ;
    { 0x08, 0x14, 0x22, 0x41, 0x00 },   // <
    { 0x14, 0x14, 0x14, 0x14, 0x14 },   // =
    { 0x00, 0x41, 0x22, 0x14, 0x08 },   // >
    { 0x02, 0x01, 0x51, 0x09, 0x06 },   // ?
	
    { 0x32, 0x49, 0x59, 0x51, 0x3E },   // @
    { 0x7E, 0x11, 0x11, 0x11, 0x7E },   // A
    { 0x7F, 0x49, 0x49, 0x49, 0x36 },   // B
    { 0x3E, 0x41, 0x41, 0x41, 0x22 },   // C
    { 0x7F, 0x41, 0x41, 0x22, 0x1C },   // D
    { 0x7F, 0x49, 0x49, 0x49, 0x41 },   // E
    { 0x7F, 0x09, 0x09, 0x09, 0x01 },   // F
    { 0x3E, 0x41, 0x49, 0x49, 0x7A },   // G
    { 0x7F, 0x08, 0x08, 0x08, 0x7F },   // H
    { 0x00, 0x41, 0x7F, 0x41, 0x00 },   // I
    { 0x20, 0x40, 0x41, 0x3F, 0x01 },   // J
    { 0x7F, 0x08, 0x14, 0x22, 0x41 },   // K
    { 0x7F, 0x40, 0x40, 0x40, 0x40 },   // L
    { 0x7F, 0x02, 0x0C, 0x02, 0x7F },   // M
    { 0x7F, 0x04, 0x08, 0x10, 0x7F },   // N
    { 0x3E, 0x41, 0x41, 0x41, 0x3E },   // O
	
    { 0x7F, 0x09, 0x09, 0x09, 0x06 },   // P
    { 0x3E, 0x41, 0x51, 0x21, 0x5E },   // Q
    { 0x7F, 0x09, 0x19, 0x29, 0x46 },   // R
    { 0x46, 0x49, 0x49, 0x49, 0x31 },   // S
    { 0x01, 0x01, 0x7F, 0x01, 0x01 },   // T
    { 0x3F, 0x40, 0x40, 0x40, 0x3F },   // U
    { 0x1F, 0x20, 0x40, 0x20, 0x1F },   // V
    { 0x3F, 0x40, 0x38, 0x40, 0x3F },   // W
    { 0x63, 0x14, 0x08, 0x14, 0x63 },   // X
    { 0x07, 0x08, 0x70, 0x08, 0x07 },   // Y
    { 0x61, 0x51, 0x49, 0x45, 0x43 },   // Z
    { 0x00, 0x7F, 0x41, 0x41, 0x00 },   // [
    { 0x55, 0x2A, 0x55, 0x2A, 0x55 },   // 55
    { 0x00, 0x41, 0x41, 0x7F, 0x00 },   // ]
    { 0x04, 0x02, 0x01, 0x02, 0x04 },   // ^
    { 0x40, 0x40, 0x40, 0x40, 0x40 },   // _
	
    { 0x00, 0x01, 0x02, 0x04, 0x00 },   // '
    { 0x20, 0x54, 0x54, 0x54, 0x78 },   // a
    { 0x7F, 0x48, 0x44, 0x44, 0x38 },   // b
    { 0x38, 0x44, 0x44, 0x44, 0x20 },   // c
    { 0x38, 0x44, 0x44, 0x48, 0x7F },   // d
    { 0x38, 0x54, 0x54, 0x54, 0x18 },   // e
    { 0x08, 0x7E, 0x09, 0x01, 0x02 },   // f
    { 0x0C, 0x52, 0x52, 0x52, 0x3E },   // g
    { 0x7F, 0x08, 0x04, 0x04, 0x78 },   // h
    { 0x00, 0x44, 0x7D, 0x40, 0x00 },   // i
    { 0x20, 0x40, 0x44, 0x3D, 0x00 },   // j
    { 0x7F, 0x10, 0x28, 0x44, 0x00 },   // k
    { 0x00, 0x41, 0x7F, 0x40, 0x00 },   // l
    { 0x7C, 0x04, 0x18, 0x04, 0x78 },   // m
    { 0x7C, 0x08, 0x04, 0x04, 0x78 },   // n
    { 0x38, 0x44, 0x44, 0x44, 0x38 },   // o
	
    { 0x7C, 0x14, 0x14, 0x14, 0x08 },   // p
    { 0x08, 0x14, 0x14, 0x18, 0x7C },   // q
    { 0x7C, 0x08, 0x04, 0x04, 0x08 },   // r
    { 0x48, 0x54, 0x54, 0x54, 0x20 },   // s
    { 0x04, 0x3F, 0x44, 0x40, 0x20 },   // t
    { 0x3C, 0x40, 0x40, 0x20, 0x7C },   // u
    { 0x1C, 0x20, 0x40, 0x20, 0x1C },   // v
    { 0x3C, 0x40, 0x30, 0x40, 0x3C },   // w
    { 0x44, 0x28, 0x10, 0x28, 0x44 },   // x
    { 0x0C, 0x50, 0x50, 0x50, 0x3C },   // y
    { 0x44, 0x64, 0x54, 0x4C, 0x44 },   // z
    { 0x00, 0x08, 0x36, 0x41, 0x00 },   //{
    { 0x00, 0x00, 0x7f, 0x00, 0x00 },   //|
    { 0x00, 0x41, 0x36, 0x08, 0x00 },   //}
    { 0x06, 0x09, 0x09, 0x06, 0x00 },   //~
};
const unsigned char ekezet[][5] = {
     {0x78, 0x14, 0x12, 0x14, 0x7b},   // 
     {0x7c, 0x54, 0x56, 0x55, 0x56},   //  
     {0x00, 0x44, 0x7e, 0x45, 0x00},   // 
     {0x38, 0x45, 0x44, 0x45, 0x38},   // 
     {0x38, 0x46, 0x45, 0x46, 0x39},   // 
     {0x38, 0x44, 0x46, 0x45, 0x38},   // 
     {0x3c, 0x42, 0x40, 0x42, 0x3c},   // 
     {0x3c, 0x42, 0x41, 0x42, 0x3d},   // 
     {0x3c, 0x40, 0x42, 0x41, 0x3c},   // 
     {0x20, 0x54, 0x56, 0x55, 0x78},   // 
     {0x38, 0x54, 0x56, 0x55, 0x18},   // 
     {0x00, 0x00, 0x7a, 0x01, 0x00},   // 
     {0x30, 0x4a, 0x48, 0x4a, 0x30},   // 
     {0x30, 0x4a, 0x49, 0x4a, 0x31},   // 
     {0x30, 0x48, 0x4a, 0x49, 0x30},   // 
     {0x38, 0x42, 0x40, 0x42, 0x38},   // 
     {0x38, 0x42, 0x41, 0x42, 0x39},   // 
     {0x38, 0x40, 0x42, 0x41, 0x38},   // 
};

void delay_ms(uint16_t delay){
     uint16_t i;
     for(i=0; i<delay; i++) {             //"delay"-szer ismteljk
          __delay_cycles(16000);              //1 ms ksleltets
     }
}
// --- LCD RESET ---
void Lcd_reset(){
     LCD_DATA = 0;
     LCD_RESET = 0;
     delay_ms(100);
     LCD_RESET = 1;
     delay_ms(250);
     LCD_CS = 1;
     __delay_cycles(40);
     LCD_CS = 0;
} // void
// --- LCD szoftveres SPI vezrls ---
void Send_Sw_SPI(char data, char RS){
     
     unsigned char i;
     byte = data;
     
     LCD_CLK = 0;
     LCD_DATA = 0;
     if((RS_old != RS) || (!RS_old && !RS)){
          LCD_CS = 1;
          LCD_RS = RS;
          LCD_CS = 0;
     } // if
     for(i= 0; i < 8; i++){
          LCD_DATA = (byte >> 7);
          LCD_CLK = 1;
          byte = (byte << 1);
          LCD_CLK = 0;
          __delay_cycles(3);
          RS_old=RS;
     } // for
     LCD_DATA = 0;
} // void
// --- Egy pixel kiratsa ---
void Pixel(char x, char y, char color){
     Pixel_One(x, y, x, y);
     set_color(color);
} // void
// --- Pixel pozicja ---
void Pixel_One(char xs, char ys, char xe, char ye){
     Send_Sw_SPI(0x2A, 0);
     Send_Sw_SPI(xs, 1);
     Send_Sw_SPI(xe, 1);

     Send_Sw_SPI(0x2B, 0);
     Send_Sw_SPI(ys, 1);
     Send_Sw_SPI(ye, 1);
} // void
// --- Pixel szne ---
void set_color(char color){
     Send_Sw_SPI(0x2C, 0);
     Send_Sw_SPI(color, 1);
} // void
// --- Kperny trlse ---
void Lcd_clear(char color){
     Pixel_One(0, 1, 100, 80);
     Send_Sw_SPI(0x2C, 0); 
     for(int j=0; j<8080; j++)
          Send_Sw_SPI(color, 1);	  
} // void
// --- Egy karakter kiratsa, X - Y - karakter - mret - karakter szn - httr szn ---
void Lcd_PutChar(char x, char y, char c, char size, char c_color, char background){
     char table;
     char col = 0;
     char row = 0;
     char bit = 0x01;
     while (row < 8){
          while (col < 5){
               if(c>=0x20 && c<=0x7f){
                    table = font[c - 0x20][col];
               }else{
                    table = ekezet[c][col];
               } // else
               if(table & bit){
                    if (size == 1){
                         Pixel(x + col, y + row, c_color);
                    }else {
                        char_size((x + col) * size, (y + row) * size, size, size, c_color);
                    } // else
               }else if(size==1){
                    Pixel(x + col, y + row, background);
               }else{
                   char_size((x + col) * size, (y + row) * size, size, size, background);
               } // else
               col++;
          } // while
          col = 0;
          bit <<= 1;
          row++;
     } // while
} // void
// --- karakter mrete ---
void char_size(char x, char y, char szel, char hossz, char color){
     Pixel_One(x, y, x-1, y-1);//(x + szel), (y + hossz));
     for (char i = 0; i < szel; i++){
          for (char j = 0; j < hossz; j++){
               set_color(color);
          } // for
     } // for
} // void
// --- Tbb karakter kirsa ---
void Lcd_PutStr(char x, char y, char *string, char size, char c_color, char background){
     char xs = x;
     while (*string){
          char c;
          switch(*string){
               case '': c = 0; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 1; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 2; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 3; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 4; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 5; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 6; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 7; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 8; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 9; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 10; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 11; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 12; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 13; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 14; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 15; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 16; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               case '': c = 17; Lcd_PutChar(xs , y , c, size, c_color, background); break;
               default:
                    Lcd_PutChar(xs, y, *string, size, c_color, background); break;
          } // switch
          xs += 6;
          string++;
     } // while
} // void
// --- ra kirsa ---
void hour_print(char x, char y, char sz, char size, char color, char bg){
     char ten, one;
     
     ten = (sz %100) /10;
     Lcd_PutChar(x, y, (ten + 0x30), size, color, bg);

     one = sz %10;
     Lcd_PutChar(x+6, y, (one + 0x30), size, color, bg);
}
// --- szmok kirsa ---
void szam(char x, char y, int sz, char size, char color, char bg){
     char szaz, tiz, egy;
     
     szaz = sz/100;
     Lcd_PutChar(x, y, (szaz + 0x30), size, color, bg);
     
     tiz = (sz %100) /10;
     Lcd_PutChar(x, y, (tiz + 0x30), size, color, bg);

     egy = sz %10;
     Lcd_PutChar(x+6, y, (egy + 0x30), size, color, bg);
}
// --- Vertiklis vonal, X - Y - mret(hossz)- szn ---
void Line_ver(char x, char y, char size, char color){
     
     for(char i=0; i<size; i++){
          Pixel(x, y, color);
          y++;
     } // for
} // void
// --- Horizontlis vonal, X - Y - mret(hossz) - szn ---
void Line_hor(char x, char y, char size, char color){
     
     for(char i=0; i<size; i++){
          Pixel(x, y, color);
          x++;
     } // for
} // void
// --- LCD SETUP ---
void Lcd_init(){
     Send_Sw_SPI(0x01, 0);   // reset sw
     delay_ms(50);
     Send_Sw_SPI(0xc6, 0);   // initial escape
     delay_ms(40);
     Send_Sw_SPI(0xb9, 0);   // Refresh set
     Send_Sw_SPI(0x00, 1);
   
     Send_Sw_SPI(0xb6, 0);   // Display control
     Send_Sw_SPI(0x80, 1);
     Send_Sw_SPI(0x04, 1);
     Send_Sw_SPI(0x0a, 1);
     Send_Sw_SPI(0x54, 1);
     Send_Sw_SPI(0x45, 1);
     Send_Sw_SPI(0x52, 1);
     Send_Sw_SPI(0x43, 1);
   
     Send_Sw_SPI(0xb3, 0);   // Gray scale position set 0
     Send_Sw_SPI(0x02, 1);
     Send_Sw_SPI(0x0a, 1);
     Send_Sw_SPI(0x15, 1);
     Send_Sw_SPI(0x1f, 1);
     Send_Sw_SPI(0x28, 1);
     Send_Sw_SPI(0x30, 1);
     Send_Sw_SPI(0x37, 1);
     Send_Sw_SPI(0x3f, 1);
     Send_Sw_SPI(0x47, 1);
     Send_Sw_SPI(0x4c, 1);
     Send_Sw_SPI(0x54, 1);
  //   Send_Sw_SPI(0x5c, 1);  //
     Send_Sw_SPI(0x65, 1);
     Send_Sw_SPI(0x75, 1);
     Send_Sw_SPI(0x80, 1);
     Send_Sw_SPI(0x85, 1);
   
     Send_Sw_SPI(0xb5, 0);   // Gamma curve
     Send_Sw_SPI(0x01, 1);
   
     Send_Sw_SPI(0xb7, 0);   // Temperature gradient
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     Send_Sw_SPI(0x00, 1);
     
     Send_Sw_SPI(0xbd, 0);   // Common driver output select
     Send_Sw_SPI(0x00, 1);
     
     Send_Sw_SPI(0x36, 0);   // Memory access control
     Send_Sw_SPI(0x48, 1);
     
     Send_Sw_SPI(0x2d, 0);   // Colour set
     Send_Sw_SPI(0x00, 1);   // RED
     Send_Sw_SPI(0x02, 1);
     Send_Sw_SPI(0x04, 1);
     Send_Sw_SPI(0x06, 1);
     Send_Sw_SPI(0x09, 1);
     Send_Sw_SPI(0x0b, 1);
     Send_Sw_SPI(0x0d, 1);
     Send_Sw_SPI(0x0f, 1);
     
     Send_Sw_SPI(0x00, 1);   // GREEN
     Send_Sw_SPI(0x02, 1);
     Send_Sw_SPI(0x04, 1);
     Send_Sw_SPI(0x06, 1);
     Send_Sw_SPI(0x09, 1);
     Send_Sw_SPI(0x0b, 1);
     Send_Sw_SPI(0x0d, 1);
     Send_Sw_SPI(0x0f, 1);
     
     Send_Sw_SPI(0x00, 1);   // BLUE
     Send_Sw_SPI(0x04, 1);
     Send_Sw_SPI(0x0b, 1);
     Send_Sw_SPI(0x0f, 1);
     
     Send_Sw_SPI(0xba, 0);   // Voltage control
     Send_Sw_SPI(0x2f, 1);
     Send_Sw_SPI(0x03, 1);
     
     Send_Sw_SPI(0x25, 0);   // Send_to_lcd contrast
     Send_Sw_SPI(0x65, 1);
     
     Send_Sw_SPI(0xbe, 0);   // Power control
     Send_Sw_SPI(0x54, 1);
//     Send_Sw_SPI(0x58, 1);
     
     Send_Sw_SPI(0x3a, 0);   // interface pixel format
     Send_Sw_SPI(0x02, 1);   // 8-bit
   //  Send_Sw_SPI(0x03, 1);   // 12-bit
     
     Send_Sw_SPI(0x11, 0);   // sleep out
     Send_Sw_SPI(0x03, 0);   // Booster voltage ON
     delay_ms(100);
     Send_Sw_SPI(0x29, 0);   // Display ON
}  // init end
// --- iota (int -> ASCII ---
char *itoa(long value){
     
     static char tarolo[18];
     long value_ori = value;
     
     int c = sizeof(tarolo)-1;
     tarolo[c] = 0;
     
     if(value < 0)
          value = -value;
     do{
          tarolo[--c] = (value % 10) + '0';
          value /= 10;
     }while(value);
     if(value_ori < 0)
         tarolo[--c] = '-';
     return &tarolo[c];
} // void