
#include "io430.h"
#include "lph8731_v3.h"
#include "DS1821.h"
#include "OneWire.h"
#include "main.h"


void delay_us(int us){
    while (us--){
        __delay_cycles(8);
    } //while
} //while

unsigned char ds_value = 0; 

void main( void ){
    
    // Stop watchdog timer to prevent time out reset
    WDTCTL = WDTPW + WDTHOLD;
    
    BCSCTL1 = CALBC1_16MHZ;      // A gyrilag kalibrlt 16 MHz
    DCOCTL = CALDCO_16MHZ;
    // port setup 
  //  P1DIR  |= (DS_1_PIN + DS_2_PIN);              // P1.7 DS1821
 //   P1OUT  |= (DS_1_PIN + DS_2_PIN);

    P2DIR |= 0x3f;     // TXD, LCD_CS, LCD_RESET, LCD_RS, LCD_CLK, LCD_DATA kimenet
    LCD_CS = LCD_RESET = LCD_RS = LCD_CLK = LCD_DATA = 0; // LCD kimenetek alacsony llapotban

    Lcd_reset();     // LCD reset
    Lcd_init();  // LCD setup
    
    Lcd_clear(WHITE);    // LCD kperny trls
    Lcd_PutStr( 3, 10, "Szitkovits Gbor", 1, BLUE, WHITE);
    Lcd_PutStr( 15, 30, "Bojler vezerl", 1, BLUE, WHITE);
    Lcd_PutStr( 25, 40, "2014.11.02-", 1, BLUE, WHITE);
    
    delay_ms(1000);
     
    Lcd_clear(WHITE);     // LCD kperny trls
   // Lcd_PutStr( 5, 5, "Hfok :", 1, BLUE, WHITE);
   // unsigned char configuration_register;
    
    
    
    while(1){
        
        
        ds_value = DS1821_Start_Conv(DS_1_PIN);

        if(ds_value == DS1821_Error){
            Lcd_clear(WHITE);
            Lcd_PutStr( 5, 15, "DS_1 ERROR", 1, RED, WHITE);
        }
        else{
            Lcd_PutStr( 10, 5, " DS_1 : OK", 1, BLUE, WHITE);
            ds_value = DS1821_Read(DS_1_PIN);
            Lcd_PutStr( 5, 30, "DS_1= ", 1, BLUE, WHITE);
            szam(40, 30, ds_value, 1, RED, WHITE);
            Lcd_PutStr( 55, 30, "C~", 1, BLUE, WHITE);
        }
        
     /*   delay_ms(1000);
        
        ds_value = DS1821_Start_Conv(DS_2_PIN);

        if(ds_value == DS1821_Error){
            Lcd_clear(WHITE);
            Lcd_PutStr( 10, 15, "DS_2 ERROR", 1, RED, WHITE);
        }
        else{
            Lcd_PutStr( 10, 15, " DS_2 : OK", 1, BLUE, WHITE);
            ds_value = DS1821_Read(DS_2_PIN);
            Lcd_PutStr( 5, 50, "DS_1= ", 1, BLUE, WHITE);
            szam(40, 50, ds_value, 1, RED, WHITE);
            Lcd_PutStr( 55, 50, "C~", 1, BLUE, WHITE);
        }
        delay_ms(1000);*/

    } //while

}










