.include "m128def.inc"

.org 0x0000 rjmp START		//RESET

.org 0x003C rjmp OLV_KULD	//USART1, Rx Complete

.def temp = R16
.def adatbe	= R19

.equ BaudRate = 103		;9600@16MHz

#define RTC		PORTA,0

START:
	ldi temp,low(ramend)
	out SPL,temp
	ldi temp,high(ramend)
	out SPH,temp

	sbi DDRA,0
	
	ldi temp, (1<<3)	;MISO - kimenet
	out DDRB,temp

	ldi temp,0b00011000	;TxD,Backlight
	out DDRD,temp
	

	ldi temp,0b10011000	;RXINT_enable,TX0_enable,RX0_enable
	sts UCSR1B,temp
	ldi temp,0b00000110	;8bit,1stop bit,no parity
	sts UCSR1C,temp
	ldi temp,high(BaudRate)
	sts UBRR1H,temp
	ldi temp,low(BaudRate)
	sts UBRR1L,temp

	
	
	ldi temp,(1<<SPIE) | (1<<CPHA)	;SPI_enabled,Slave,CPHA
	out SPCR,temp

	sei	

LOOP:
	rjmp LOOP

OLV_KULD:
	lds adatbe,UDR1
	ldi temp,'r'
	cpse adatbe,temp
	reti
	rcall RTC_OLV
	reti

RTC_OLV:
	sbi RTC		;RTC felkeltse

	clr temp	;nullt kld
	out SPDR,temp
FOGAD:
	sbis SPSR,SPIF
	rjmp FOGAD
	in temp,SPDR
	
	cbi RTC
	rcall USB_KULD
	
	ret
	
USB_KULD:
	sts UDR1,temp
TXD_WAIT:	
	lds temp, UCSR1A
	sbrc temp,5
	ret
	rjmp TXD_WAIT
