	list	b=4
        LIST    P=EEPROM8, R=DECIMAL
        INCLUDE "./MEMORY.INC"
        LIST    M=_24LC512

	errorlevel -311			; Disable "Operand of HIGH operator was larger than H'FFFF'"

branch	macro 	address, duration
			db	duration, 0xB0
			db	low(address-($+2)), high(address-($+2))
		endm

bsr		macro 	address, duration
			dt	duration, 0xC8 + (upper(address) & 0x07
			dt	low(address-($+2)), high(address-($+2))
		endm

jsr		macro 	address, duration
			db	duration, 0xC0 + (upper(address) & 0x07)
			db	low(address), high(address)
		endm

do		macro	count, duration
			db	duration, 0xA0
			db	low(count), high(count)
		endm

jump	macro 	address, duration
			db	duration, 0xE0 + (upper(address) & 0x07)
			db	low(address), high(address)
		endm

loop	macro	address, duration
			db	duration, 0x90
			db	low(address-($+2)), high(address-($+2))
		endm

noop	macro	duration
			db	duration, 0x00
			db	0x00, 0x00
		endm

restart	macro	duration
			db	duration, 0xF0
			db	0x00, 0x00
		endm

ret		macro	duration
			db	duration, 0xD0
			db	0x00, 0x00
		endm

speed	macro	scode,duration
			dt	duration, 0xD0
			dt	scode & 0x0F, 0x00
		endm


	org	0x0000
Adr0:			; 5 * 32 bit display pattern
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	jump	Adr2,.200	; Duration * 1ms

Adr1:			; 5 * 32 bit display pattern
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	jump	Adr1,.200	; Duration * 1ms

Adr2:			; 5 * 32 bit display pattern
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	do		.200,.250	; Duration * 1ms

Adr02:			; 5 * 32 bit display pattern
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	noop	.200		; Duration * 1ms

Adr3:			; 5 * 32 bit display pattern
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10011000',b'10011000',b'10011000',b'10011000'
	loop	Adr2,.250	; Duration * 1ms

Adr4:			; 5 * 32 bit display pattern
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	jump	Adr2,.250		; Duration * 1ms

Adr5:			; 5 * 32 bit display pattern
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	noop		 .50		; Duration * 1ms

Adr6:			; 5 * 32 bit display pattern
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	branch	Adr5,.50		; Duration * 1ms

Adr7:			; 5 * 32 bit display pattern
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	jsr		Adr8,.50		; Duration * 1ms

Adr8:			; 5 * 32 bit display pattern
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	db	b'10000000',b'10000000',b'10000000',b'10000000'
	ret			.50			; Duration * 1ms

	end

