		list	b=4
;************************************************************************
;                                                        		       	*
;    Filename:	    Martix_887.asm                                     	*
;    Date:          15/06/2011                                        	*
#define LastUpdate	"2011-07-24";										*
;																		*
#define	VersionMajor	0x01	;										*
#define	VersionMinor	0x07	;										*
;#define	DebugI2C	; comment this line to compile release version		*
;#define	Debug_keys	; comment this line to compile release version		*
;                                                                     	*
;************************************************************************
;  5 x 32 Led matrix display											*
;  On board command interpreter											*
; 	with 16 level return stack											*
;  	with 16 level loopcounter stack										*
;  																		*
;************************************************************************
;                                                                     	*
; Notes:	                                                           	*
;    	Pin assignment                                                	*
;      		Port A            								       	  	*
;				RA0..5 = Raw 0..5 select act. high		output			*
;				RA6.7 = 20MHz oscillator				input			*
;																		*
;      		Port B														*
;				RB0..7 = Column 00..15 drive act. high	output			*
;																		*
;      		Port C														*
;				RC0 = Buttomn 0 act low					input			*
;				RC1 = Buttomn 1 act low					input			*
;				RC2 = Buttomn 2 act low					input			*
;				RC3	= SCL I2C bus signal				input			*
;				RC4	= SDA I2C bus signal				input			*
;				RC5 = Raw select 6 act. high			output			*
;				RC6 = UART transmit output				input			*
;				RC7 = UART receive input				input			*
;                                                                     	*
;      		Port D														*
;				RD0..7 = Column 16..31 drive act. high	output			*
;																		*
;      		Port E														*
;				RE0 = Latch0015							output			*
;				RE1 = Latch1531							output			*
;				RE2 = Speed setting						analog			*
;				RE3 = MCLR								input only pin	*
;                                                                     	*
;************************************************************************
; I2C configuration														*
;  Using 64k EEProms	24FC512											*
;	Slave address		Function										*
;	0x9x - 0x9x+1		Temperature sensor		reserved				*
;	0xA0 - 0xA1			PCF8583 RTC				reserved				*
;	0xA2 - 0xA3			24FC512 onboard									*
;	0xA4 - 0xA5			24FC512 addon board #1							*
;	0xA6 - 0xA7			24FC512 addon board #1							*
;	0xAA - 0xAB			24FC512 addon board #2	reserved				*
;	0xAC - 0xAD			24FC512 addon board #2	reserved				*
;																		*
;  Using 128k EEProms	24FC1025										*
;	Slave address		Function										*
;	0x9x - 0x9x+1		Temperature sensor		reserved				*
;	0xA0 - 0xA1			PCF8583 RTC				reserved				*
;	0xA2 - 0xA3			24FC512 onboard									*
;	0xA4 - 0xA7			24FC1025 addon board #1							*
;																		*
;  Using 128k EEProms	24FC1025										*
;	Slave address		Function										*
;	0x9x - 0x9x+1		Temperature sensor		reserved				*
;	0xA0 - 0xA1			PCF8583 RTC				reserved				*
;	0xA2 - 0xA3			24FC512 onboard									*
;	0xA4 - 0xA7			24FC1025 addon board #1							*
;	0xA8 - 0xAD			24FC1025 addon board #2	reserved				*
;																		*
;	Last 16 bytes of each 64K is reserved								*
;																		*
;************************************************************************
; EEProm data structure													*
;																		*
;	Each insturction has .24 bytes										*
;		byte .00.. .19	- Display data									*
;																		*
;		byte .20		- Duration in 1 ms unit							*
;		byte .21 .. 23	- Instruction									*
;			Code		Paramerets				Desrciption				*
;			byte .21	byte .22	byte .23							*
;			0xFx			-			-		Invalid - Jump 0:00:00	*
;			0xEa		addrl		addrh		Jump a:addrh:addrl		*
;			0xDx			-			-		Return					*
;			0xCa		addrl		addrh		Call / Rcall			*
;												if (a & 8) == 0			*
;												 Call a:addrh:addrl		*
;												else					*
;												 rcall . + addrh:addrl	*
;			0xBx		addrl		addrh		Branch . + addrh:addrl	*
;			0xAx		count					Push LoopCounter		*
;												LoopCounter = count		*
;			0x9x		addrl		addrh		LoopCounter--			*
;												If LoopCounter == 0		*
;												branch. + addrh:addrl	*
;												pop LoopCounter			*
;			0x8x		speed		-			Set speed				*
;																		*
;************************************************************************

; Disabling error messages
	errorlevel -302					; Disable "Register in operand not in bank 0"
	errorlevel -306					; Disable "Crossing page boundary"


	ifdef	__16F887
		list	p=16f887			; 16F886 can be used
		#include <p16f887.inc>		; processor specific variable definitions
#define ProcType	"16F887"
	endif

	ifndef	PORTA
		error	"Incompatible processor type selected"
	endif

	ifdef __16F887
	__CONFIG _CONFIG1, _CP_OFF &_CPD_OFF & _WDT_OFF & _BOR_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF & _IESO_OFF & _FCMEN_OFF & _MCLRE_ON
	__CONFIG _CONFIG2, _WRT_OFF & _BOR40V
	endif

	__idlocs		0x1000 | (VersionMajor << 8) | (VersionMinor)

;#define	Use24FC1025				; Uncomment this line if 24FC1025 to use

RTCAddr		EQU	0xA0+1				; PCF8583
EEpromAddr	EQU	0xA2				; 24FC512 - 64k, 24FC1026 - 128k, 24FC1025 - 128k


; Serial port Baud rate selection
;BaudRate	EQU	.2400				; Set the BaudRate of RS232 communication
;BaudRate	EQU	.4800				; Set the BaudRate of RS232 communication
BaudRate	EQU	.9600				; Set the BaudRate of RS232 communication
;BaudRate	EQU	.19200				; Set the BaudRate of RS232 communication
;BaudRate	EQU	.38400				; Set the BaudRate of RS232 communication

#define	BUTTONCOUNT		.50
#define	BUTTONTIMECOUNT	.50

F_OSC	EQU	.20000000				; Oscillator frequency in Hz
OSC		EQU	F_OSC/4

	ifndef BaudRate
		error "No BaudRate defined"
	endif
	if ( (BaudRate!=.2400) && (BaudRate!=.4800) && (BaudRate!=.9600) && (BaudRate!=.19200) && (BaudRate!=.38400) )
		error "Nonstandard BaudRate defined"
	endif

;***** VARIABLE DEFINITIONS

;Vars in shared memory. This memory is available from any bank

  cblock	0x070
	Scratch							; memory locations for general use
	Scratch2						;
	Scratch3						;
	Scratch4

	I2CData
	I2CWordAddr
	I2CWordAddrH
	I2CSlaveAddr

	flags							; State flags
	BCD								; BCD routine temp var

	pclath_temp						; variable used for context saving
	w_temp							; variable used for context saving
	status_temp						; variable used for context saving
	fsr_temp						; variable used for context saving
; 2 more locations
  endc
	IF fsr_temp > 0x7F
		ERROR "To many variables used in Common RAM"
	ENDIF

  cblock	0x20
	DispBuf:	.20+.4
	ActRaw
	RawSelect
	ActAddress:	.3
	RetStackPt
	LoopStackPt
	LoopCounter
	Speed
	SpeedCounter

;Vars for time-keeping
  ;!! Keep variable order - Timecheck use indirect access to them v
	Second2							; 0..119 counting half seconds
	Minute							; 0.. 59
	Hour							; 0.. 23
	Day								; 1.. Dmon-1
	Month							; 1.. 12
	Year							; 0.. 99
	Century							; 0.. 99
  ;!! Keep variable order - Timecheck use indirect access to them ^

	DMon							; days in current Month + 1
	WDay							; Day of week 0..6

	SubSec_L						; Sub second timer
	SubSec_H

	UartRxChNum						; Uart Rx fifo number of available chars
	UartRxChWp						; Uart Rx fifo write pointer
	UartRxChRp						; Uart Rx fifo read  pointer

	UartTxChNum						; Uart Tx fifo number of available chars
	UartTxChWp						; Uart Tx fifo write pointer
	UartTxChRp						; Uart Tx fifo read  pointer

	Rs232Cmd						; Last command code received from uart
	Rs232ParNum						; Number of paraneters of command
	Rs232Flags						; Command decoding state flags

	Rs232StrPtr						; 16 bit pointer to string to be sent
	Rs232StrPtrH
	Rs232Temp						; Temporary storage in UART routines
	Rs232Temp2						; Temporary storage in UART routines
	Rs232Fsr						; Save for FSR in UART routines
	Rs232Status						; Save for STATUS in UART routines

	AD_State
	AD_Result

; Buttondebounce variables
	ShrSW1
	ShrSW2
	ShrSW3
	CntSW1
	CntSW2
	CntSW3
	ButtonState						; State of buttons Bit 7: Reading of button state needed, 6..4: Held down, 2..0: Pressed
	ButtonCounter

	portc

; 9 more locations

LastBank0:
  endc
	IF LastBank0 > 0x70
		ERROR "To many variables used in Bank0"
	ENDIF

;Vars indirectly accessed are on Bank1
  cblock	0x0A0	; Indirectly accessed
	; Not to use memory 0x0F0..0x0FF  -  it will overwrite 0x070..0x07F
LoopStack:	.16
RetStack:	.3*.16

; 16 more locations

LastBank1:
  endc
	IF  LastBank1 > 0xF0
		ERROR "To many variables used in Bank1"
	ENDIF

  cblock	0x110
					; More RAM space available: 16 for 16F886
; 16 more locations
  endc

  cblock	0x120	; Uart buffers
					; More RAM space available: 80 for 16F886
	UartTxChar:	.32					; Uart Tx fifo

	UartRxChar:	.32					; Uart Rx fifo

; 16 more locations

 	; Not to use memory 0x170..0x17F  -  it will overwrite 0x070..0x07F
LastBank2:
  endc

	IF  LastBank2 > 0x170
		ERROR "To many variables used in Bank2"
	ENDIF

  cblock	0x190
					; More RAM space available: 16 for 16F886
; 16 more locations
  endc

;Vars indirectly accessed are on Bank3
  cblock	0x1A0	; Indirectly accessed
	; Not to use memory 0x1F0..0x1FF  -  it will overwrite 0x070..0x07F

; 80 more locations

LastBank3:
  endc
	IF  LastBank3 > 0x1F0
		ERROR "To many variables used in Bank3"
	ENDIF

;**********************************************************************

; PORTA bits
; RawSel0		EQU		0
; RawSel1		EQU		1
; RawSel2		EQU		2
; RawSel3		EQU		3
; RawSel4		EQU		4
; RawSel5		EQU		5

; PORTB bits
;						7..0		; Led output  7 ..  0 / 23 .. 16

; PortC
bSW1			EQU		0			; Sw1 input
bSW2			EQU		1			; Sw2 input
bSW3			EQU		2			; Sw3 input

; PortD
;						7..0		; Led output 15 ..  8 / 32 .. 24

; PortE
bCp15_00		EQU		0
bCp32_16		EQU		1
aSpeed			EQU		2			; Analog input
;bMclr			EQU		3


; Flags
bStopExec		EQU		0
bSpeedAd		EQU		1

bNewTime		EQU		6			; Check the time
bNewPattern		EQU		7

; CCPR1H
bI2CBusError	EQU		0


; RS232Flags
bCmdExec		EQU		7			; Execution of a command is in progress
bNewRecChr		EQU		6			; New character received

; ButtonState
bButtonRead		EQU		7			; Need to read button state
;bButton3Hold	EQU		6			; Button 3 held down
bButton2Hold	EQU		5			; Button 2 held down
bButton1Hold	EQU		4			; Button 1 held down

;bButton3Down	EQU		2			; Button 3 pressed
bButton2Down	EQU		1			; Button 2 pressed
bButton1Down	EQU		0			; Button 1 pressed

DispDuration	EQU		DispBuf+.20
DispMacro		EQU		DispBuf+.21
DispParameter	EQU		DispBuf+.22

;**********************************************************************
		org     0x0000           	; processor reset vector
		clrf	PORTA
		clrf	PORTB
		clrf	PORTD
		goto    Main            	; go to beginning of program

;**********************************************************************
		org     0x0004           	; interrupt vector location

		movwf	w_temp				; context saveing
		swapf	w_temp, f			; Save W to common RAM
		swapf	STATUS, w			; Get STATUS
		clrf 	STATUS				; select Bank0, IRP=0 for interrupt stuff
		movwf	status_temp			; Save STATUS
		movf	FSR,w				; Save FSR
		movwf	fsr_temp
		movf	PCLATH,w			; Needed only if more Pages used not only Page0
		movwf	pclath_temp
		clrf	PCLATH

INT_TMR2
		btfss	PIR1,TMR2IF			; Interrupt on TMR2? Uses 200uS period
		goto	lTMR2EXIT			; nope, goto next interrupt

		clrf	PORTA				; Disable raw drivers
		bcf		PIR1,TMR2IF			; Clear TMR2 interrupt flag

		decfsz	ButtonCounter,f
		goto	lRefresh

		movlw	BUTTONTIMECOUNT		; Reload button read time counter
		movwf	ButtonCounter
		bsf		ButtonState,bButtonRead; Buttons have to be read

lRefresh
		bcf		STATUS,C
		rlf		RawSelect,f			; Shift raw mask
		btfsc	RawSelect,5
		bsf		RawSelect,0
		movf	RawSelect,w
		andlw	0x1F
		movwf	RawSelect
		
		bcf		PORTE,bCp15_00		; Reset clocks of latches
		bcf		PORTE,bCp32_16
		movf	ActRaw,w			; Set actual raw address
		movwf	FSR
		movf	INDF,w				; Read raw data to display
		movwf	PORTB				; Move low  byte to PORTB  
		incf	FSR,f
		movf	INDF,w
		movwf	PORTD				; Move high byte to PORTD
		incf	FSR,f
		call	Ret
		bsf		PORTE,bCp15_00		; Load latch for bits  0 .. 15
		movf	INDF,w
		movwf	PORTB				; Move low  byte to PORTB
		incf	FSR,f
		movf	INDF,w
		movwf	PORTD				; Move high byte to PORTD
		incf	FSR,f
		call	Ret
		bsf		PORTE,bCp32_16		; Load latch for bits 16 .. 31

		movf	RawSelect,w
		movwf	PORTA				; Turn on current raw driver

		movf	FSR,w
		movwf	ActRaw				; Move actual raw address to next raw
		xorlw	DispBuf+.20
		btfss	STATUS,Z
		goto	lCountSubSec

		movlw	DispBuf
		movwf	ActRaw

		decfsz	SpeedCounter,f
		goto	lDecDuration

		movf	Speed,w
		btfsc	flags,bSpeedAd
		movf	AD_Result,w
		movwf	SpeedCounter

lDecDuration
		decfsz	DispBuf+.20,f		; Decrement duration
		goto	lCountSubSec

		bsf		flags,bNewPattern	; Sign pattern has to be reloaded

lCountSubSec
		incfsz	SubSec_L,f			; Increment 16-bit Sub Second counter
		goto	lTime_1				; still counting
		incfsz	SubSec_H,f			;
		goto	lTime_1				; still counting

		movlw	0x3C				; load counter SubSecond = 0x10000 - 2500 = 0xF63C
		movwf	SubSec_L			;
		movlw	0xF6				;
		movwf	SubSec_H			;

		incf	Second2,f			; Move time
		bsf		flags,bNewTime		; Sign new time for TimeCheck
lTime_1
		movf	AD_State,f			; Decrement A/D state counter
		btfss	STATUS,Z
		decf	AD_State,f

lTMR2EXIT

;--------
INT_UART

		bsf		STATUS,IRP			; Buffers are on Bank2

		btfss	PIR1,RCIF			; Is it a receive interrupt
		goto	INT_UART_TX

		movf	UartRxChWp,w		; Put receive char to buffer if no error
		movwf	FSR
		movf	RCSTA,w				; Check for error
		andlw	(1 << FERR) | (1 << OERR)
		btfss	STATUS,Z
		goto	UART_ERR			; If error not to read char
		movf	RCREG,w				; Read character
		movwf	INDF				; Write it to buffer
		incf	FSR,w				; Move pointer in circular way
		andlw	0x1F
		iorlw	low(UartRxChar)
		movwf	UartRxChWp
		incf	UartRxChNum,f		; Sign one more char in buffer
		bsf		Rs232Flags,bNewRecChr
		goto	INT_UART_TX

UART_ERR							; Receive error, reenable receive
		bcf		RCSTA,CREN			; Turn off receiver
		movf	RCREG,w				; Clear receive interrupt flag, drop character
		bsf		RCSTA,CREN			; Turn on  receiver

INT_UART_TX							; Is it a transmit interrupt
		btfss	PIR1,TXIF
		goto	INT_UART_EX

		movf	UartTxChNum,f		; Get next char from buffer if there is one
		btfsc	STATUS,Z
		goto	INT_TX_NOCHAR		; No more chars in buffer

		movf	UartTxChRp,w		; Get pointer to buffer
		movwf	FSR
		movf	INDF,w				; Get character from buffer
		movwf	TXREG				; Send it
		incf	FSR,w				; Move pointer
		andlw	0x1F				; in circular way
		iorlw	low(UartTxChar)
		movwf	UartTxChRp
		decfsz	UartTxChNum,f		; Sign one char read from buffer
		goto	INT_UART_EX			; Skip disabling transmit interrupt if more chars in buffer

INT_TX_NOCHAR						; No more chars to transmit
		bsf 	STATUS,RP0			; Bank1
		bcf		PIE1,TXIE			; Disable transmit int

INT_UART_EX
;		clrf	STATUS				; Bank0, IRP=0

;--------
INT_EXIT
		movf	pclath_temp,w		; Save variables are in common RAM
		movwf	PCLATH				; Needed only in more Pages used not only Page0
		movf	fsr_temp,w			; Restore FSR
		movwf	FSR
		swapf	status_temp,w		; Restore context for main program
		movwf	STATUS				; This will also restore bank selection and IRP
		swapf	w_temp,w			; Restore W from common RAM
		retfie                  	; Return from interrupt

;**********************************************************************

Main
		clrf	PORTC				; Clear port buffers
		clrf	PORTE

		bsf		STATUS,RP0			; Bank1
		clrf	TRISA				; PORTA 7..0 output
		clrf	TRISB				; PORTB 7..0 output
		bcf		TRISC,RC5			; RC5 output
		clrf	TRISD				; PORTD 7..0 output
		bcf		TRISE,RE0			; RE0 output
		bcf		TRISE,RE1			; RE1 output

		clrf	ADCON1				; A/D left justified, VDD-GND references

	    clrf    SSPSTAT				; Disable SMBus inputs
    	bsf     SSPSTAT,SMP			; Disable slew rate control
	    movlw   0x31				; Divide FOSC/4 by .50
    	movwf   SSPADD				; Setup 100 kHz I2C clock
	    clrf    SSPCON2				; Clear control bits

		bsf		PIE1,TMR2IE			; Enable Peripheral interrupt from TMR2
		movlw	.249				; set frequency for sleep mode
		movwf	PR2					;

	if	BaudRate < .9600			; Set up Baud rate
		bcf		TXSTA,BRGH
		movlw	(F_OSC/.64/BaudRate)-1
	else
		bsf		TXSTA,BRGH
		movlw	(F_OSC/.16/BaudRate)-1
	endif

		movwf	SPBRG
		bsf		TXSTA,TXEN			; Enable transmission

		bsf		PIE1,RCIE			; Enable  receive interrupt
		bcf		PIE1,TXIE			; Disable transmit interrupt

		bsf		STATUS,RP1			; Bank3

		movlw	0x80
		movwf	ANSEL				; Only RE2 analog
		clrf	ANSELH

		clrf	STATUS				; Bank0

		clrf	CCPR1H
		btfsc	PORTC,RC3
		btfss	PORTC,RC4
		bsf		CCPR1H,bI2CBusError

		movlw	b'00101000'
		movwf	SSPCON				; Enable SSP, select I2C Master mode

RamClr
		movlw	0x20				; Clear ram 0x20 .. 0x7F on each bank
		movwf	FSR
RamClrLp
		clrf	INDF
		bsf		FSR,7
		clrf	INDF
		bcf		FSR,7
		incf	FSR,f
		btfss	FSR,7
		goto	RamClrLp
		movlw	1 << IRP
		xorwf	STATUS,f
		btfsc	STATUS,IRP
		goto	RamClr

		movlw	DispBuf				; Init actual raw address
		movwf	ActRaw

		incf	SpeedCounter,f
		incf	Speed,f

		movlw	0x10
		movwf	RawSelect			; Last raw was driven

		movlw	0x0F
		movwf	AD_State
		movwf	portc

		movlw	LoopStack			; Init loop stack pointer
		movwf	LoopStackPt

		movlw	RetStack			; Init return stack pointer
		movwf	RetStackPt

		movlw	0x05				;
		movwf	T2CON				; Timer2=ON, Prescaler = 1/4, Postscaler = 1/1

;		clrf	UartRxChNum			; Init receive fifo
		movlw	low(UartRxChar)
		movwf	UartRxChWp
		movwf	UartRxChRp

;		clrf	UartTxChNum			; Init transmit fifo
		movlw	low(UartTxChar)
		movwf	UartTxChWp
		movwf	UartTxChRp

		bsf		RCSTA,SPEN			; Enable receive
		bsf		RCSTA,CREN

		movlw	(( 1 << ADCS1) | (ANS7 << 2) | (1 << ADON))
		movwf	ADCON0

		call	SEND_MESSAGE

		call	MReset

	ifndef	DebugI2C
		btfss	CCPR1H,bI2CBusError
	else
		clrf	CCPR1H
	endif
		call	ReadNextPattern		; Read the first pattern to display

		movlw	(1 << GIE) | (1 << PEIE)
		movwf	INTCON 				; Enable global, extended peripheral interrupt

		btfsc	CCPR1H,bI2CBusError
		call	I2CBusError


MainLoop
		btfss	ADCON0,GO			; Test for A/D conversion ready
		call	ReadAd				; Read temperature

		btfsc	Rs232Flags,bNewRecChr
		call	UARTCmdDec			; Decode Command received from UART

		btfsc	CCPR1H,bI2CBusError
		goto	MainLoop

		btfss	flags,bStopExec
		btfss	flags,bNewPattern	; Has new pattern to be loaded 
		goto	TestButtons

		call	ReadNextPattern		; Read new pattern
		bcf		flags,bNewPattern	; Clear new pattern to load


TestButtons
		btfss	ButtonState,bButtonRead; If buttons to read
		goto	ChkButtonEnd

		bcf		ButtonState,bButtonRead; Clear flag
		bcf		STATUS,C
	ifdef	Debug_keys
		btfss	portc,bSW1
	else
		btfss	PORTC,bSW1
	endif
		bsf		STATUS,C			; Copy SW1 state to C
		rlf		ShrSW1,f			; Shift into a register to keep 8 samples
		comf	ShrSW1,w
		btfsc	STATUS,Z
		goto	SW1Down
		xorlw	0xFF ^ 0x3F
		movlw	BUTTONCOUNT
		btfsc	STATUS,Z
		movwf	CntSW1				; Reload button counter
		movf	ShrSW1,w
		xorlw	0xFE				; Test for rising edge
		btfss	STATUS,Z
		goto	SW1End
		btfss	ButtonState,bButton1Hold
		goto	SW1Pressed			; If SW1 was not held down, ti was pressed
		bcf		ButtonState,bButton1Hold; Clear hold flag
		goto	SW1End

SW1Down
		decfsz	CntSW1,f			; Decrement button counter
		goto	SW1End
		bsf		ButtonState,bButton1Hold

SW1Pressed
		bsf		ButtonState,bButton1Down
		movlw	BUTTONCOUNT
		movwf	CntSW1
SW1End

		bcf		STATUS,C
	ifdef	Debug_keys
		btfss	portc,bSW2
	else
		btfss	PORTC,bSW2
	endif
		bsf		STATUS,C			; Copy SW1 state to C
		rlf		ShrSW2,f			; Shift into a register to keep 8 samples
		comf	ShrSW2,w
		btfsc	STATUS,Z
		goto	SW2Down
		xorlw	0xFF ^ 0x3F
		movlw	BUTTONCOUNT
		btfsc	STATUS,Z
		movwf	CntSW2				; Reload button counter
		movf	ShrSW2,w
		xorlw	0xFE				; Test for rising edge
		btfss	STATUS,Z
		goto	SW2End
		btfss	ButtonState,bButton2Hold
		goto	SW2Pressed			; If SW2 was not held down, ti was pressed
		bcf		ButtonState,bButton2Hold
		goto	SW2End

SW2Down
		decfsz	CntSW2,f			; Decrement button counter
		goto	SW2End
		bsf		ButtonState,bButton2Hold

SW2Pressed
		bsf		ButtonState,bButton2Down
		movlw	BUTTONCOUNT
		movwf	CntSW2
SW2End

ChkButtonEnd

ChkButton1
		btfss	ButtonState,bButton1Down; If button1 pressed debounced
		goto	ChkButton1End

		bcf		ButtonState,bButton1Down; Clear flag

		call	MReset

ChkButton1End


ChkButton2
		btfss	ButtonState,bButton2Down; If button1 pressed debounced
		goto	ChkButton2End

		bcf		ButtonState,bButton2Down; Clear flag

		clrf	ActAddress+2
		clrf	ActAddress+1
		movlw	.24
		movwf	ActAddress

ChkButton2End
		goto	MainLoop


I2CBusError
		movlw	high(I2CBusErrorMsg); Init string pointer high part
		movwf	Rs232StrPtrH
		movlw	low(I2CBusErrorMsg)	; Init string pointer low  part
		goto	SEND_STRING

ReadNextPattern
		movlw	DispBuf				; Set address of display buffer
		movwf	FSR

		movf	ActAddress,w		; Get word address
		movwf	I2CWordAddr
		movf	ActAddress+1,w
		movwf	I2CWordAddrH

		movf	ActAddress+2,w
		andlw	0x07
		movwf	Scratch
	ifdef	Use24FC1025
		rrf		Scratch,f
		btfsc	STATUS,C
		bsf		Scratch,2
	endif
		bcf		STATUS,C
		rlf		Scratch,w
		addlw	EEpromAddr			; Read from I2C EEProm
		movwf	I2CSlaveAddr

ReadPatternLp
		call	I2CByteRead			; Read a byte
		movwf	INDF				; Store it
		incf	FSR,f				; Move memory pointer
		movlw	DispBuf+.24
		xorwf	FSR,w
		btfss	STATUS,Z			; Check for end of buffer
		goto	ReadPatternLp

		movf	I2CWordAddr,w		; Copy next address to actual address
		movwf	ActAddress
		movf	I2CWordAddrH,w
		movwf	ActAddress+1

		movlw	High(MacroTable)	; Process macro
		movwf	PCLATH
		swapf	DispBuf+.21,w
		andlw	0x0F
		addwf	PCL,f
MacroTable
		return						; 0x0_ Noop				; noop
		return						; 0x1_ Noop				; Not used yet
		return						; 0x2_ Noop				; Not used yet
		return						; 0x3_ Noop				; Not used yet
		return						; 0x4_ Noop				; Not used yet
		return						; 0x5_ Noop				; Not used yet
		return						; 0x6_ Noop				; Not used yet
		return						; 0x7_ Noop				; Not used yet
		goto	MSetSpeed			; 0x8_ Set speed		; speed
		goto	MLoop				; 0x9_ Loop				; loop
		goto	MDo					; 0xA_ Do				; do
		goto	MBranch				; 0xB_ Branch			; branch
		goto	MCall				; 0xC_ Call	/ RCall		; jsr / bsr
		goto	MReturn				; 0xD_ Return			; ret
		goto	MJump				; 0xE_ Jump				; jump
;		goto	MReset				; 0xF_ Reset			; reset
MacroTableEnd:

	if (high(MacroTable)!=high(MacroTableEnd))
		error ("Macro table page error")
	endif

MReset
;		clrf	FSR
;		movlw	0x80
;		call	SetEEadr
;		call	ReadEprom
;		movwf	ActAddress
;		addwf	FSR,f
;		call	ReadEprom
;		movwf	ActAddress+1
;		addwf	FSR,f
;		call	ReadEprom
;		movwf	ActAddress+2
;		addwf	FSR,f
;		call	ReadEprom
;		addwf	FSR,f
;		incf	FSR,w
;		btfsc	STATUS,Z
;		return

		clrf	ActAddress
		clrf	ActAddress+1
		clrf	ActAddress+2
		return

MSetSpeed
		movf	DispBuf+.22,w
		andlw	0x0F
		addlw	1
		movwf	Speed
		btfsc	DispBuf+.22,4
		bsf		flags,bSpeedAd		
		btfss	DispBuf+.22,4
		bcf		flags,bSpeedAd		
		return

MCall
		movf	RetStackPt,w
		movwf	FSR
		movf	ActAddress,w
		movwf	INDF
		incf	FSR,f
		movf	ActAddress+1,w
		movwf	INDF
		incf	FSR,f
		movf	ActAddress+2,w
		movwf	INDF
		incf	FSR,w
		movwf	RetStackPt
		xorlw	RetStack + .3*.16
		movlw	RetStack
		btfsc	STATUS,Z
		movwf	RetStackPt
		btfsc	DispBuf+.21,3
		goto	MBranch

MJump
		movf	DispBuf+.22,w		; Copy address to actual address
		movwf	ActAddress
		movf	DispBuf+.23,w
	ifdef	DebugI2C
		andlw	0x0F
	endif
		movwf	ActAddress+1
		movf	DispBuf+.21,w		; Can jump over 64k boundary
		andlw	0x07
		movwf	ActAddress+2
		return

MLoop
		decfsz	LoopCounter,f		; Decrement loop counter
		goto	MBranch				; and branch if !=0
		decf	LoopStackPt,f
		movf	LoopStackPt,w
		andlw	LoopStack+.15
		iorlw	LoopStack
		movwf	FSR
		movf	INDF,w
		movwf	LoopCounter
		return

MBranch
		movf	DispBuf+.22,w		; Add address to to actual address
		addwf	ActAddress,f
		btfsc	STATUS,C
		incf	ActAddress+1,f
		movf	DispBuf+.23,w
		addwf	ActAddress+1,f		; Can not branch over 64k boundary
		return

MDo
		movf	LoopStackPt,w
		andlw	LoopStack+.15
		movwf	FSR
		movf	LoopCounter,w
		movwf	INDF
		incf	LoopStackPt,f
		bcf		LoopStackPt,4
		movf	DispBuf+.22,w		; Load LoopCounter
		movwf	LoopCounter
		return

MReturn
		movf	RetStackPt,w
		movwf	FSR
		xorlw	RetStack
		movlw	RetStack + .3*.16
		btfsc	STATUS,Z
		movwf	FSR
		decf	FSR,f
		movf	INDF,w
		movwf	ActAddress+2
		decf	FSR,f
		movf	INDF,w
		movwf	ActAddress+1
		decf	FSR,f
		movf	INDF,w
		movwf	ActAddress
		movf	FSR,w
		movwf	RetStackPt
		return

;******************************************************************************
;		Read A/D channel 0
;******************************************************************************

ReadAd
		movf	AD_State,w			; Get A/D state
		btfsc	STATUS,Z
		goto	ADReady				; If A/D state = 0 -> Read result
		btfsc	AD_State,3			; If A/D state < 8 -> Start A/D, A/D state = 0
		return

StartAD
		bsf		ADCON0,GO			; Start A/D conversion
		clrw
SetADState
		movwf	AD_State
		return

ADReady
		movlw	.10
		movwf	Scratch
		movf	ADRESH,w			; Get the 8 bit result
		call	Mpy8x8
		incf	Scratch2,w
		movwf	AD_Result

		movlw	0x0F
		goto	SetADState			; Reinit AD state counter

;******************************************************************************

Mpy8x8:
		clrf	Scratch2
		clrf	Scratch3
		bsf		Scratch3,3

		rrf	 	Scratch,f
LOOP:
		btfsc	STATUS,C
		addwf 	Scratch2,f
		rrf		Scratch2,f
		rrf		Scratch,f

		decfsz 	Scratch3,f
		goto	LOOP
		return

;*****************************************************************

SetEEadr
		bsf		STATUS,RP1			; Bank2
		movwf	EEADR
		clrf	STATUS
		return

ReadEprom
		bsf		STATUS,RP1			; Bank2
		bsf		STATUS,RP0			; Bank3
		bsf		EECON1,RD
		bcf		STATUS,RP0			; Bank2
		movf	EEDATA,w
		incf	EEADR,f
		clrf	STATUS
		return
		
;*****************************************************************

WriteEprom
		bsf		STATUS,RP1			; Bank2
		movwf	EEDATA
		bsf		STATUS,RP0			; Bank3
		bsf		EECON1,WREN			; Enable writes
		movf	INTCON,w			; Save GIE
		movwf	Scratch

		bcf 	INTCON,GIE			; Disable INTs.
WaitGieLow
		btfsc	INTCON,GIE			; SEE AN576
		goto	WaitGieLow

		movlw	0x55				;
		movwf	EECON2				; Write 55h
		movlw	0xAA				;
		movwf	EECON2				; Write AAh
		bsf		EECON1,WR			; Set WR bit to begin write

		btfsc	Scratch,GIE			; Restore GIE
		bsf		INTCON,GIE			; Enable INTs.

WaitEEPromWr
		btfsc	EECON1,WR
		goto	WaitEEPromWr		; Takes about 4ms

		bcf		STATUS,RP0			; Bank2
		incf	EEADR,f

		clrf	STATUS				; Bank0
		return

;*****************************************************************

; Only I2CSlaveAddr, I2CData and I2CWordAddr used in MSSP I2C routines.
; Not to call them from ReDrawClock cycle

;*******************Start bit subroutine**************************
;           This routine generates a Start condition
;           (high-to-low transition of SDA while SCL
;           is still high.
;*****************************************************************
I2CBSTART
		bcf		STATUS,RP1			; Bank0 but keep IRP
		bcf		STATUS,RP0
	    bcf     PIR1,SSPIF			; Clear SSP interrupt flag
	    bsf     STATUS,RP0			; Select Bank1
	    bsf     SSPCON2,SEN			; Generate Start condition
		goto	I2Cbstop_wait0

;*******************Restart bit subroutine**************************
;           This routine generates a Repeated Start
;           condition (high-to-low transition of SDA
;           while SCL is still high.
;*****************************************************************
;I2CBRESTART
;	    bcf     PIR1,SSPIF			; Clear SSP interrupt flag
;	    bsf     STATUS,RP0			; Select Bank1
;	    bsf     SSPCON2,RSEN		; Generate Restart condition
;		goto	I2Cbstop_wait0

;*******************Data transmit subroutine**********************
;           This routine transmits the byte of data
;           stored in w to the I2C serial
;           device.
;*****************************************************************

I2CTXSlaveReadAddr
		movf	I2CSlaveAddr,w		; Load control byte for write
		andlw   0xFE				; Can be removed if all addresses are even

I2CTX
	    bcf		PIR1,SSPIF			; Clear SSP interrupt flag
    	movwf	SSPBUF				; Write byte out to device

		goto	I2Cbstop_wait0		; Wait for oparation completed

;*******************Byte read test subroutine*********************
;           This routine tests the byte read feature
;           of the I2C serial device.  It will read
;           1 byte of data at address I2CAddress from the device.
;*****************************************************************

I2CByteReadSetAddr
		movwf	I2CWordAddr			; Store word address

I2CByteRead							; Returns data just read from RTC, increments word address

	ifdef	DebugI2C
		goto	PRG_read
	endif
		call	I2CBSTART			; Generate Start condition

    	call    I2CTXSlaveReadAddr	; Send control byte to device

		movf	I2CWordAddrH,w		; Get address
    	call    I2CTX				; Send address to device

		movf	I2CWordAddr,w		; Get address
		btfss	I2CSlaveAddr,0
    	call    I2CTX				; Send address to device

;    	call    I2CBRESTART			; Generate Restart condition
	    bcf     PIR1,SSPIF			; Clear SSP interrupt flag
	    bsf     STATUS,RP0			; Select Bank1
	    bsf     SSPCON2,RSEN		; Generate Restart condition
		call	I2Cbstop_wait0
									; Send control byte
		movf	I2CSlaveAddr,w		; Load control byte for read
		iorlw	0x01				; incf I2CSlaveAddr,w can be used instead
    	call    I2CTX				; Send control byte to device

									; Read data byte
    	bcf     PIR1,SSPIF			; Clear SSP interrupt flag
    	bsf     STATUS,RP0			; Select Bank1
    	bsf     SSPCON2,ACKDT		; Select to send NO ACK bit
    	bsf     SSPCON2,RCEN		; Initiate reception of byte

		call	I2Cbstop_wait0		; Wait for operation completed

    	movf    SSPBUF,W			; Copy byte to WREG

    	bcf     PIR1,SSPIF			; Clear SSP interrupt flag
    	bsf     STATUS,RP0			; Select Bank1
    	bsf     SSPCON2,ACKEN		; Generate ACK/NO ACK bit

		call	I2Cbstop_wait0		; Wait for oparation completed

		movwf	I2CData				; Save data

;*******************Stop bit subroutine***************************
;           This routine generates a Stop condition
;           (low-to-high transition of SDA while SCL
;           is still high.
;*****************************************************************
I2CBSTOP
		incfsz	I2CWordAddr,f		; Increment word address
		goto	I2CBStop1
		incf	I2CWordAddrH,f
I2CBStop1

	    bcf     PIR1,SSPIF			; Clear SSP interrupt flag
	    bsf     STATUS,RP0			; Select Bank1
	    bsf     SSPCON2,PEN			; Generate Stop condition

I2Cbstop_wait0
	    bcf     STATUS,RP0			; Select Bank0
bstop_wait
	    btfss   PIR1,SSPIF			; Check if operation completed
	ifdef	DebugI2C
		return
	else
	    goto    bstop_wait			; If not, keep checking
	endif
    	return

;*******************Byte write test subroutine********************
;           This routine tests the byte write feature
;           of the I2C serial device.
;*****************************************************************

I2CBcdWrite
		call	Conv2BCD			; Convert to BCD

I2CByteWrite						; Returns data written to device, increments word address
		movwf	I2CData				; Store data

	    call    I2CBSTART			; Generate Start condition

    	call    I2CTXSlaveReadAddr	; Send control byte to device

		movf	I2CWordAddrH,w		; Get address
		btfss	I2CSlaveAddr,0
	    call    I2CTX

		movf	I2CWordAddr,w		; Get address
	    call    I2CTX

		movf	I2CData,w			; Get data
    	call    I2CTX				; Send data byte to device

	   	goto    I2CBSTOP			; Generate Stop condition

;******************************************************************************
; Convert binary number to BCD

Conv2BCD							; Convert w to BCD (0 <= w <= 99)
		clrf	BCD					; Clear high nibble
l_bcd_1
		addlw	-.10				; Sub .10
		incf	BCD,f				; Inc high nibble
		btfsc	STATUS,C			; Loop if no carry
		goto	l_bcd_1
		addlw	.10					; Re add .10, C=1
		decf	BCD,f				; Correct high nibble
		swapf	BCD,f				; Swap to high part of byte
		addwf	BCD,w				; Add to low nibble, C=0
		return

;******************************************************************************
; Convert BCD number to binary

BcdToBin							; Convert BCD to binary
		movwf	BCD
		andlw	0x0F
		btfsc	BCD,4
		addlw	.10
		btfsc	BCD,5
		addlw	.20
		btfsc	BCD,6
		addlw	.40
		btfsc	BCD,7
		addlw	.80
		return

;******************************************************************************
;	UART functions
;******************************************************************************

;**********************************************************************
; Send a byte in BCD format with uart as two ASCII character
; Keeps IRP, RP1, RP0 bits of STATUS
; Keeps FSR

UART_SEND_BCD
		call	Conv2BCD

;**********************************************************************
; Send a byte with uart as two hex. ASCII character
; Keeps IRP, RP1, RP0 bits of STATUS
; Keeps FSR

UART_SEND_BYTE
		movwf	Scratch				; Save data to send
		swapf	Scratch,w			; Send high nibble first
		call	UART_SEND_NIBBLE
		movf	Scratch,w			; Send low	nibble

;**********************************************************************
; Send a nibble (lower 4 bit of W) with uart as a hex. ASCII character
; Keeps IRP, RP1, RP0 bits of STATUS
; Keeps FSR

UART_SEND_NIBBLE
		andlw	0x0F				; Keep only low nibble
		movwf	Rs232Temp2
		sublw	0x09
		clrw
		btfss	STATUS,C			; If nibble > 9 add 7, and use lower case character
		movlw	0x27
		addwf	Rs232Temp2,w
		addlw	0x30				; Convert to ACSII

;**********************************************************************
; Send a character (w), write it to uart send buffer
; Keeps IRP, RP1, RP0, DC, C bits of STATUS
; Keeps FSR

UART_SEND							; Sends char in w

		btfsc	UartTxChNum,5		; Test number of chars in buff
		goto	UART_SEND

		movwf	Rs232Temp			; Save character to send
		swapf	STATUS,w
		movwf	Rs232Status			; Save Status
		movf	FSR,w				; Save FSR
		movwf	Rs232Fsr

		bsf		STATUS,RP0			; Bank1
		bcf		PIE1,TXIE			; Disable TX interrupt
		bcf		STATUS,RP0			; Bank0

		bsf		STATUS,IRP			; Buffer in on Bank2

		movf	UartTxChWp,w		; Get write pointer
		movwf	FSR

		movf	Rs232Temp,w			; Get char to send
		movwf	INDF				; Store it in out buffer
		incf	FSR,w				; Move the pointer
		andlw	0x1F				; in circular way
		iorlw	low(UartTxChar)
		movwf	UartTxChWp
		incf	UartTxChNum,f		; Increment number of avaible characters

		bsf		STATUS,RP0			; Bank1
		bsf		PIE1,TXIE			; Enable TX interrupt

UART_Exit
		bcf		STATUS,RP0			; Bank0
		movf	Rs232Fsr,w			; Restore FSR
		movwf	FSR
		swapf	Rs232Status,w		; Restore STATUS
		movwf	STATUS				; Restore IRP, Bank selection
		movf	Rs232Temp,w			; Get char sent / just received
		return

;**********************************************************************
; Get a byte from receive buffer and convert it form BCD to bin
; Keeps IRP, RP1, RP0 bits of STATUS
; Keeps FSR

UART_REC_BCD
		call	UART_REC_BYTE
		goto	BcdToBin

;**********************************************************************
; Get a byte from receive buffer
; Keeps IRP, RP1, RP0 bits of STATUS
; Keeps FSR

UART_REC_BYTE
		clrf	Rs232Temp2			; Clear data to be read
		call	UART_REC_NIBBLE		; Receive high nibble
		movwf	Rs232Temp2
		swapf	Rs232Temp2,f		; Swap to high nibble

UART_REC_NIBBLE
		call	UART_RECEIVE
		btfsc	Rs232Temp,6			; Check for 'A'..'F' or 'a'..'f'
		addlw	-7
		addlw	-0x30
		andlw	0x0F				; Keep low nibble
		addwf	Rs232Temp2,w
		return

;**********************************************************************
; Get a character from receive buffer
; Keeps IRP, RP1, RP0, DC bits of STATUS
; Keeps FSR

UART_RECEIVE						; Gets char into w, C == 1 if no char was in fifo

		bsf		STATUS,C			; Set no character received
		swapf	STATUS,w			; Save STATUS
		movwf	Rs232Status
		movf	FSR,w				; Save FSR
		movwf	Rs232Fsr

		bsf		STATUS,IRP			; Buffer in on Bank2

		bsf		STATUS,RP0			; Bank1
		bcf		PIE1,RCIE			; Disable RC interrupt
		bcf		STATUS,RP0			; Bank0

		clrf	Rs232Temp
		movf	UartRxChNum,w		; Check number of avaible chars
		btfsc	STATUS,Z
		goto	NO_REC_CHAR			; Jump if no character avaible

		movf	UartRxChRp,w		; Get read pointer
		movwf	FSR

		movf	INDF,w				; Read it from buffer
		movwf	Rs232Temp
		incf	FSR,w				; Move the pointer
		andlw	0x1F				; in circular way
		iorlw	low(UartRxChar)
		movwf	UartRxChRp
		decf	UartRxChNum,f		; Decrement number of avaible characters
		bcf		Rs232Status,C+4		; Valid character received - !Status was swapped!

NO_REC_CHAR
		bsf		STATUS,RP0			; Bank1
		bsf		PIE1,RCIE			; Enable RC interrupt

		goto	UART_Exit			; Restore STATUS and FSR

;******************************************************************************
; Command decoding

UARTCmdDec
		bcf		Rs232Flags,bNewRecChr
		movlw	high(CmdParNum)
		movwf	PCLATH

		btfsc	Rs232Flags,bCmdExec	; If command execution in progress
		goto	GetParam			; Get parameters of command

GetCommand
		call	UART_RECEIVE		; Get the command character
		btfsc	STATUS,C			; Was there character available
		return						; Return if not
		addlw	-'`'				; Check the range '`', 'a'...'z'
		btfss	STATUS,C
		return
		movwf	Rs232Cmd			; Save code of command
		addlw	-(0x7F+1-'`')
		btfsc	STATUS,C
		return
		movf	Rs232Cmd,w			; Get code of command
		call	CmdParNum			; Get number of parameters
		movwf	Rs232ParNum
		bsf		Rs232Flags,bCmdExec	; Sign command execution in progress

GetParam
		movf	Rs232ParNum,w		; Are there enought parameters in buffer
		subwf	UartRxChNum,w
		btfss	STATUS,C
		return						; Return if not

CmdParOk
		movf	Rs232Cmd,w			; Get command code
		bcf		Rs232Flags,bCmdExec	; No command execution in progress

		goto	CmdExec				; Execute it and return to caller at the end of execution

;**********************************************************************

UART_SEND_COMMAND
		movf	Rs232Cmd,w
		addlw	'@'					; Answare code in uppercase
		goto	UART_SEND

;**********************************************************************
; Send init message

Connect
		movlw	high(InitMsg)		; Init string pointer high part
		movwf	Rs232StrPtrH
		movlw	low(InitMsg)		; Init string pointer low  part
		goto	SEND_STRING

SEND_MESSAGE
		movlw	high(InitMsg+1)		; Init string pointer high part
		movwf	Rs232StrPtrH
		movlw	low(InitMsg+1)		; Init string pointer low  part

;**********************************************************************
; Send a string (high part of address must be in Rs232StrPtrH)

SEND_STRING
		movwf	Rs232StrPtr			; Save string pointer low  part
lString0
		call	MsgTabl				; Get next character
		movwf	Rs232Temp2			; Save it
		andlw	0x7F				; Mask bit7 off
		call	UART_SEND			; Send character
		btfss	Rs232Temp2,7		; Check for end of string mark
		goto	lString0			; Loop for all characters
		return

;******************************************************************************
; Command routines
;******************************************************************************

;******************************************************************************
; Send version

SendVer
		call	UART_SEND_COMMAND
		movlw	VersionMajor		; Send major version
		call	UART_SEND_BYTE
		movlw	'.'
		call	UART_SEND
		movlw	VersionMinor		; Send minor version
UART_SEND_BYTE_CR
		call	UART_SEND_BYTE		; Send a byte and a Cr Lf
SendCrLf
		movlw	high(CrLf)			; Send a Cr Lf sequence
		movwf	Rs232StrPtrH
		movlw	low(CrLf)
		goto	SEND_STRING

;******************************************************************************
; Init I2C slave and word address

InitI2CAdrs
		call	UART_REC_BYTE		; Get slave address
		andlw	0xFE				; Mask R/W bit off
		movwf	I2CSlaveAddr
		call	UART_REC_BYTE		; Get word address high
		movwf	I2CWordAddrH
		call	UART_REC_BYTE		; Get word address low
		movwf	I2CWordAddr
		return

;******************************************************************************
; Set reg on I2C bus

SetI2C
		call	InitI2CAdrs
		movlw	.8
		movwf	FSR
SetI2CLp
		call	UART_REC_BYTE		; Get data to be written
		call	I2CByteWrite		; Write it, increments I2CWordAdr
		call	Wait5ms
		decfsz	FSR,f
		goto	SetI2CLp

		movlw	-.8
		addwf	I2CWordAddr,f
		btfss	STATUS,C
		decf	I2CWordAddrH,f
		goto	SendI2CReg

;******************************************************************************
; Get reg on I2C bus

GetI2C
		call	InitI2CAdrs
SendI2CReg
		call	UART_SEND_COMMAND
		movf	I2CSlaveAddr,w
		call	UART_SEND_BYTE		; Send slave address
		movf	I2CWordAddrH,w
		call	UART_SEND_BYTE		; Send word address high
		movf	I2CWordAddr,w
		call	UART_SEND_BYTE		; Send word address low
		movlw	.8
		movwf	FSR
GetI2CLp
		call	I2CByteRead			; Read the data
		call	UART_SEND_BYTE		; Send it
		decfsz	FSR,f
		goto	GetI2CLp

		goto	SendCrLf

;******************************************************************************

SetStart
		call	UART_REC_BYTE		; Get controll byte
		movwf	Scratch3
		movlw	0x80
		call	SetEEadr
		btfss	Scratch3,7
		goto	GetStart
		
		clrf	FSR
		call	UART_REC_BYTE		; Get address
		addwf	FSR,f
		call	WriteEprom
		call	UART_REC_BYTE		; Get address
		addwf	FSR,f
		call	WriteEprom
		call	UART_REC_BYTE		; Get address
		addwf	FSR,f
		call	WriteEprom
		comf	FSR,w
		call	WriteEprom

GetStart
		call	UART_SEND_COMMAND
		movlw	0x80
		call	SetEEadr
		call	ReadEprom
		call	UART_SEND_BYTE
		call	ReadEprom
		call	UART_SEND_BYTE
		call	ReadEprom
		call	UART_SEND_BYTE
		call	ReadEprom
		goto	UART_SEND_BYTE_CR

;******************************************************************************

SetReg
		call	InitFSR
		call	UART_REC_BYTE
		movwf	INDF
		goto	SendReg
		
GetReg
		call	InitFSR
SendReg
		call	UART_SEND_COMMAND
		movf	Scratch3,w
		call	UART_SEND_BYTE
		movf	FSR,w
		call	UART_SEND_BYTE
		movf	INDF,w
		clrf	STATUS
		goto	UART_SEND_BYTE_CR

InitFSR
		call	UART_REC_BYTE
		movwf	Scratch3
		call	UART_REC_BYTE
		movwf	FSR
		clrf	STATUS
		btfsc	Scratch3,0
		bsf		STATUS,IRP
		return

;******************************************************************************

SetBuf
		call	InitBufPtr
SetBufLp	
		call	UART_REC_BYTE
		movwf	INDF
		incf	FSR,f
		decfsz	Scratch3,f
		goto	SetBufLp
		movf	Scratch2,w
		call	InitBufPtr2

SendBuf
		call	UART_SEND_COMMAND
		movf	Scratch2,w
		call	UART_SEND_BYTE

GetBufLp
		movf	INDF,w
		incf	FSR,f	
		call	UART_SEND_BYTE
		decfsz	Scratch3,f
		goto	GetBufLp
		goto	SendCrLf

InitBufPtr		
		call	UART_REC_BYTE
		andlw	0x07
		movwf	Scratch2
InitBufPtr2
		movwf	FSR
		addwf	FSR,f
		movf	FSR,w
		addwf	FSR,w
		addlw	DispBuf
		movwf	FSR
		movlw	.4
		movwf	Scratch3
		return

GetBuf
		call	InitBufPtr
		goto	SendBuf		

;******************************************************************************

SetSpeed
		call	UART_REC_BYTE
		andlw	0x0F
		addlw	1
		movwf	Speed

GetSpeed
		call	UART_SEND_COMMAND
		decf	Speed,w
		goto	UART_SEND_BYTE_CR

;******************************************************************************

SetFlag
		call	UART_REC_BYTE
		bcf		INTCON,PEIE
		xorwf	flags,w
		andlw	0x0F
		xorwf	flags,f
		bsf		INTCON,PEIE

GetFlag
		call	UART_SEND_COMMAND
		movf	flags,w
		goto	UART_SEND_BYTE_CR

;******************************************************************************

GetAddr
		call	UART_SEND_COMMAND
		movf	ActAddress+2,w
		call	UART_SEND_BYTE
		movf	ActAddress+1,w
		call	UART_SEND_BYTE
		movf	ActAddress,w
		goto	UART_SEND_BYTE_CR

;******************************************************************************

PRG_read

		call	DoRead
		clrf	PCLATH
		incfsz	I2CWordAddr,f
		return
		incf	I2CWordAddrH,f
		return

DoRead
		movlw	0x10
		addwf	I2CWordAddrH,w
		movwf	PCLATH
		movf	I2CWordAddr,w
		movwf	PCL

		
Wait5ms
		movlw	.4
		movwf	Scratch
Wait5msLoop
		call	Wait1ms
		decfsz	Scratch,f
		goto	Wait5msLoop	
		nop
Wait1ms
		movlw	.180
		movwf	Scratch2
Wait1msLoop
		call	Wait5us
		decfsz	Scratch2,f
		goto	Wait1msLoop

Wait5us
		call	Ret
		call	Ret
		call	Ret
		call	Ret
		call	Ret
Ret		
		nop
		return	

	org	0x780

;******************************************************************************
; String tables

InitMsg								; String tables (last character of string has bit7 set)
	dt	"CLed Matrix 5 x 32"
CrLf
	retlw	0x0d
	retlw	0x8a					; Sign end of string - bit7 set

I2CBusErrorMsg
	dt	"I2C bus error"
	retlw	0x0d
	retlw	0x8a					; Sign end of string - bit7 set

;******************************************************************************

	org	0x7B6

;******************************************************************************
; Jump tables

;******************************************************************************
; Return parameter count of a command

CmdParNum
	addwf	PCL,f
	retlw	0		;'`'	0x60
	retlw	.2		;'a'	0x61
	retlw	.10		;'b'	0x62
	retlw	0		;'c'	0x63
	retlw	.6		;'d'	0x64
	retlw	.4		;'e'	0x65
	retlw	.2		;'f'	0x66
	retlw	0		;'g'	0x67
	retlw	0		;'h'	0x68
	retlw	0		;'i'	0x69
	retlw	0		;'j'	0x6A
	retlw	0		;'k'	0x6B
	retlw	0		;'l'	0x6C
	retlw	0		;'m'	0x6D
	retlw	0		;'n'	0x6E
	retlw	0		;'o'	0x6F
	retlw	.2		;'p'	0x70
	retlw	0		;'q'	0x71
	retlw	.6		;'r'	0x72
	retlw	.8		;'s'	0x73
	retlw	0		;'t'	0x74
	retlw	0		;'u'	0x75
	retlw	0		;'v'	0x76
	retlw	.22		;'w'	0x77
	retlw	0		;'x'	0x78
	retlw	0		;'y'	0x79
	retlw	0		;'z'	0x7A
	retlw	0		;'{'	0x7B
	retlw	0		;'|'	0x7C
	retlw	0		;'}'	0x7D
	retlw	0		;'~'	0x7E
	retlw	0		;''	0x7F

;******************************************************************************
; Go to execution routine of a command

CmdExec
	addwf	PCL,f			;	; Commands and parameters		; Answare

			return			;`	;

 			goto	GetBuf	;a	;

			goto	SetBuf	;b	;

 			goto	Connect	;c	;

			goto	SetReg	;d	;

			goto	GetReg	;e	;

			goto	SetFlag	;f	;

			goto	GetFlag	;g	;

			return			;h	;

 			return			;i	;

 			return			;j	;

			return			;k	;

			return			;l	;

 			return			;m	;

			return			;n	;

 			return			;o	;

			goto	SetSpeed;p	;

			goto	GetSpeed;q	;

			goto	GetI2C	;r	;

			goto	SetStart;s	;

			return			;t	;

 			return			;u	;

			goto	SendVer	;v	;

			goto	SetI2C	;w	;

 			return			;x	;

 			return			;y	;

			goto	GetAddr	;z	;

			return			;{	;

			return			;|	;

			return			;}	;

			return			;~	;

			return			;	;

	org		0x7F8

;******************************************************************************
; Get next character of a string

MsgTabl
		movf	Rs232StrPtrH,w		; Get string pointer high byte
		movwf	PCLATH				; Load it to PCLATH
		movf	Rs232StrPtr,w		; Get string pointer low  byte
		incfsz	Rs232StrPtr,f		; Increment pointer as
		goto	lString1
		incf	Rs232StrPtrH,f		; 16 bit number
lString1
		movwf	PCL					; Computed goto to string table
		return						; movwf	PCL cannot be the last instruction

;====== E N D   O F   2 K  P A G E ============================================

	org	0x0800

;====== E N D   O F   2 K  P A G E ============================================


	ifdef	DebugI2C
		include "24FC512_H2o.asm"
	endif

;******************************************************************************

;******************************************************************************
;		Define EEProm content
;******************************************************************************


		ORG		0x2100			; Start of message 1 in EEPROM
		de		"LED matrix ",LastUpdate," ",ProcType," V",VersionMajor+.48,".",((VersionMinor/.16)+.48),((VersionMinor%.16)+.48)

		org		0x2180
		de		0x00,0x00,0x00,0xFF

	ifdef DebugI2C
		messg	"Don't program this compilation to chip, I2C rutines are debug verisons"
	endif

	ifdef DebugKeys
		messg	"Don't program this compilation to chip, Button reading rutines are debug verisons"
	endif

	END                     		; directive 'end of program'
