#include <stdio.h>
#include <stdlib.h>
#include<pic16f628a.h>
#include<htc.h>

__CONFIG(WDTE_OFF & FOSC_XT & CP_OFF & LVP_OFF & BOREN_OFF & MCLRE_ON & PWRTE_ON);

int szamlalo = 0;
int perc = 1;
int masodperc = 3;
#define GOMB_PERC_ALLIT RA1
#define GOMB_MASODPERC_ALLIT RA2
#define GOMB_NULLAZAS RA3
#define GOMB_START RA4
#define GOMB_STOP RA5
#define GOMB_LEHAJTOTT_AJTO RA6

static void interrupt isr(void){
    RB6 = 1;
    szamlalo++;
    if(szamlalo == 1000){
        if(masodperc > 0){
            masodperc--;
        }else if(masodperc == 0 && perc > 0){
            masodperc = 60;
            perc--;
        }else if((perc + masodperc) == 0){
            TMR2IE = 0;
            RB6 = 0;
        }
        szamlalo = 0;
    }
}

void stop(){
    if((perc + masodperc) > 0){ //ha meg nem tellett le az ido, akkor varakozunk
        while(GOMB_START){
            while(!GOMB_NULLAZAS){ //ha kozben nullzunk, akkor a megszaktjuk az idozito
                perc = 0;
                masodperc = 0;
            }
            if(!GOMB_START){ //levilagitas folytatasa
                TMR2IE = 1; // Timer2 indts
            }
            if((perc + masodperc) == 0){ //ha megallitas utan nullazzuk az idot
                break;
            }
        }
    }else{
        TMR2IE = 0; // Timer2 lelltsa
        RB6 = 0;
    }
}

int main() {
    TRISA = 0xFFFF;  //A lbai bemenet lettek lltva
    TRISB = 0x0000;  //B lbai kimenetekre lettek lltva
    PR2 = 249; // Timer2 PR2 8bites peridus regiszter
    T2CON = 5; // T2CON regiszter
    TMR2IE = 0; // TMR2IE megszaktst engedlyez bit (lelltva a Timer2)
    PEIE = 1; // Peripheral interrupt engedlyezse
    GIE = 1; // Globlis interrupt engedlyezse
    while(1){
        if(!GOMB_PERC_ALLIT){
            while(GOMB_PERC_ALLIT);
            perc++;
        }
        if(!GOMB_MASODPERC_ALLIT){
            while(GOMB_MASODPERC_ALLIT);
            masodperc++;
        }
        if(!GOMB_NULLAZAS){
            while(GOMB_NULLAZAS);
            perc = 0;
            masodperc = 0;
        }
        if(!GOMB_START){
            while(GOMB_START);
            szamlalo = 0;
            TMR2IE = 1; // Timer2 indts
        }
        if(!GOMB_STOP){
            while(GOMB_STOP);
            stop();
        }
    }
}