Dim blnDebug
Dim strFileName

Dim i
Dim strArg

Public pi

pi = 3.141592653689

SetLocale("en-gb")
   
strFileName = "input.txt"

Set a_strArgs = WScript.Arguments
For i = 0 To a_strArgs.Count - 1

   Select Case LCase(a_strArgs.Item(i))

   Case "-d", "/d"
   ' debug mode
      blnDebug = True

   Case "-f", "/f"
   ' filename specified
      If i = a_strArgs.Count-1 Then
         WScript.StdErr.WriteLine("Filename not specified.")
      Else
         i = i + 1
         If Left(a_strArgs.Item(i), 1) = "-" Or Left(a_strArgs.Item(i), 1) = "/" Then
            WScript.StdErr.WriteLine("Invalid filename.")
         Else
            strFileName = a_strArgs(i)
         End If
      End If

   Case Else
      WScript.StdErr.Write Line("Invalid argument: " & a_strArgs(i))

   End Select
     
Next

WScript.StdErr.WriteLine "Debug mode: " & blnDebug
WScript.StdErr.WriteLine "Filename: " & strFileName

Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objFile = objFSO.OpenTextFile(strFileName, 1)



' initial parameters

'default line width
line = 3

' approx. central point of an A4 in mm
xorg = 148
yorg = 105

' pointer's centre in mm
porgx = 0
porgy = 0

' scale arc's centre in mm
sorgx = 0
sorgy = 0

' scale's angle (begin, end in degrees)
pangb = 135
pange = 45

' ticks' properties (length, width in mm)
tmajl = 2
tmajw = 2

tminl = 1
tminw = 1

tnuml = 4
tnumw = 3

' tick generation properties (first, distance in units)
gmajf = 0
gmajd = 0.5

gminf = 0
gmind = 0.1

gnumf = 0
gnumd = 1


WScript.Echo chr(27) & "E"
WScript.Echo chr(27) & "%0B"
WScript.Echo "IN;"

' set up pens

For i=0 to 6
   WScript.Echo "SP " & i & ";"
   WScript.Echo "PW " & i*0.1 & ";"
   WScript.Echo "PT " & i*0.1 & ";"
Next


Do Until objFile.AtEndOfStream

   strCharacters = objFile.ReadLine
   If blnDebug Then
      WScript.StdErr.WriteLine strCharacters
   End If

   a_Items = Split(strCharacters, ";")
   strCharacters1 = Trim(Replace(a_Items(0), vbTab, " "))

   Do
      strCharacters = strCharacters1
      strCharacters1 = Replace(strCharacters, "  ", " ")
   Loop Until strCharacters = strCharacters1

   a_Items = Split(strCharacters, " ")

   If UBound(a_Items) >= 0 Then

      Select Case LCase(a_Items(0))

      Case "fram"
         do_fram(a_Items)
      Case "hole"
         do_hole(a_Items)
      Case "text"
         do_text(a_Items)

      Case "porg"
         do_porg(a_Items)
      Case "sorg"
         do_sorg(a_Items)
      Case "pang"
         do_pang(a_Items)

      Case "tmaj"
         do_tmaj(a_Items)
      Case "tmin"
         do_tmin(a_Items)
      Case "tnum"
         do_tnum(a_Items)

      Case "gmaj"
         do_gmaj(a_Items)
      Case "gmin"
         do_gmin(a_Items)
      Case "gnum"
         do_gnum(a_Items)

      Case "glin"
         do_glin(a_Items)

      Case "sarc"
         do_sarc(a_Items)
      Case "smaj"
         do_smaj(a_Items)
      Case "smin"
         do_smin(a_Items)
      Case "snum"
         do_snum(a_Items)

      Case Else
         WScript.StdErr.WriteLine "Invalid command: " & a_Items(0)
      End Select

   End If

Loop



Sub check_paramnum(byRef a, byval n)
   If UBound(a) <> n Then
      WScript.StdErr.WriteLine "Incorrect number of parameters: " & UBound(a) & " instead of " & n
      WScript.Quit
   End If
End Sub

Sub do_fram(byRef a)
   check_paramnum a, 4
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing frame: " & a(1) & ";" & a(2) & " - " & a(3) & ";" & a(4)
   End If
   setwidth line
   WScript.Echo "PU " & 40*(xorg + a(1)) & " " & 40*(yorg + a(2)) & ";"
   WScript.Echo "PD;EA " & 40*(xorg + a(3)) & " " & 40*(yorg + a(4)) & ";"
End Sub


Sub do_hole(byRef a)
   check_paramnum a, 3
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing hole: " & a(1) & ";" & a(2) & " - dia " & a(3)
   End If
   setwidth line
   WScript.Echo "PU " & 40*(xorg + a(1)) & " " & 40*(yorg + a(2)) & ";"
   WScript.Echo "PD;CI " & 20*a(3) & ";"
End Sub

Sub do_text(byRef a)
   check_paramnum a, 3
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing text: " & a(1) & ";" & a(2) & " - """ & a(3) & """"
   End If
End Sub

Sub do_porg(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up pointer's origin: " & a(1) & ";" & a(2)
   End If
   porgx = a(1)
   porgy = a(2)
End Sub

Sub do_sorg(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up arc's origin: " & a(1) & ";" & a(2)
   End If
   sorgx = a(1)
   sorgy = a(2)
End Sub

Sub do_pang(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up pointer's angles: " & a(1) & ";" & a(2)
   End If
   pangb = a(1)
   pange = a(2)
End Sub

Sub do_tmaj(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up major ticks' properties: " & a(1) & ";" & a(2)
   End If
   tmajl = a(1)
   tmajw = a(2)
End Sub

Sub do_tmin(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up minor ticks' properties: " & a(1) & ";" & a(2)
   End If
   tminl = a(1)
   tminw = a(2)
End Sub

Sub do_tnum(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up numeric ticks' properties: " & a(1) & ";" & a(2)
   End If
   tnuml = a(1)
   tnumw = a(2)
End Sub

Sub do_gmaj(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up generated major ticks' properties: " & a(1) & ";" & a(2)
   End If
   gmajf = a(1)
   gmajd = a(2)
End Sub

Sub do_gmin(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up generated minor ticks' properties: " & a(1) & ";" & a(2)
   End If
   gminf = a(1)
   gmind = a(2)
End Sub

Sub do_gnum(byRef a)
   check_paramnum a, 2
   If blnDebug Then
      WScript.StdErr.WriteLine "Setting up generated numeric ticks' properties: " & a(1) & ";" & a(2)
   End If
   gnumf = a(1)
   gnumd = a(2)
End Sub

Sub do_glin(byRef a)
   check_paramnum a, 4
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing generated linear scale: dist " & a(1) & ", up " & a(2) & ", values (" & a(3) & ")-(" & a(4) & ")"
   End If

   Dim b()
   ReDim b(3)
   b(1) = a(1)
   b(2) = 0
   b(3) = 100
   do_sarc b

   ReDim b(2)

   b(1) = a(1)
   b(2) = a(2)
 
   a3 = 1*a(3)
   a4 = 1*a(4)

   v = gmajd*int(a3/gmajd)

   If v<a3 Then
      v = v + gmajd
   End If

   If blnDebug Then
      WScript.StdErr.WriteLine "v low high: " & v & ", " & a3 & ", " & a4
   End If

   If blnDebug Then
      cond1 = (v >= a3)
      cond2 = (v <= a4)
      WScript.StdErr.WriteLine "conditions: " & cond1 & cond2
   End If

   n = 2
   Do While (v >= a3) and (v <= a4)
      n = n + 1
      Redim Preserve b(n)
      b(n) = 100*(v-a3)/(a4-a3)

      If blnDebug Then
         WScript.StdErr.WriteLine "Generate major tick: " & n & ". value " & b(n)
      End If

      v = v + gmajd
   Loop

   do_smaj b


   ReDim b(2)

   b(1) = a(1)
   b(2) = a(2)
 
   a3 = 1*a(3)
   a4 = 1*a(4)

   v = gmind*int(a3/gmind)

   If v<a3 Then
      v = v + gmind
   End If

   If blnDebug Then
      WScript.StdErr.WriteLine "v low high: " & v & ", " & a3 & ", " & a4
   End If

   If blnDebug Then
      cond1 = (v >= a3)
      cond2 = (v <= a4)
      WScript.StdErr.WriteLine "conditions: " & cond1 & cond2
   End If

   n = 2
   Do While (v >= a3) and (v <= a4)
      n = n + 1
      Redim Preserve b(n)
      b(n) = 100*(v-a3)/(a4-a3)

      If blnDebug Then
         WScript.StdErr.WriteLine "Generate minor tick: " & n & ". value " & b(n)
      End If

      v = v + gmind
   Loop

   do_smin b

   ReDim b(2)

   b(1) = a(1)
   b(2) = a(2)
 
   a3 = 1*a(3)
   a4 = 1*a(4)

   v = gnumd*int(a3/gnumd)

   If v<a3 Then
      v = v + gnumd
   End If

   If blnDebug Then
      WScript.StdErr.WriteLine "v low high: " & v & ", " & a3 & ", " & a4
   End If

   If blnDebug Then
      cond1 = (v >= a3)
      cond2 = (v <= a4)
      WScript.StdErr.WriteLine "conditions: " & cond1 & cond2
   End If

   n = 2
   Do While (v >= a3) and (v <= a4)
      n = n + 2
      Redim Preserve b(n)
      b(n-1) = 100*(v-a3)/(a4-a3)
      b(n) = v

      If blnDebug Then
         WScript.StdErr.WriteLine "Generate minor tick: " & n & ". value " & b(n)
      End If

      v = v + gnumd
   Loop

   do_snum b

End Sub

Sub do_sarc(byRef a)
   check_paramnum a, 3
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing scale arc: dist " & a(1) & ", from " & a(2) & ", to " & a(3)
   End If
   '
   ' porg(0;0), sorg(0,y0)!!!
   ' v1,2 = y0*sin(alfa) +/- sqrt( y0^2*sin^2(alfa) - (y0^2-d^2) ) 
   '
   '
   d = a(1) - sorgy
   c = 2*pi/360

   ang1 = (pangb + (pange-pangb)*a(2)/100)
   ang2 = (pangb + (pange-pangb)*a(3)/100)

   dis = sorgy*sorgy * sin(ang1*c)*sin(ang1*c) - sorgy*sorgy + d*d
   v1 = sorgy * sin(ang1*c) + sqr(dis)
   x1 = v1*cos(ang1*c)
   y1 = v1*sin(ang1*c)

   dis = sorgy*sorgy * sin(ang2*c)*sin(ang2*c) - sorgy*sorgy + d*d
   v2 = sorgy * sin(ang2*c) + sqr(dis)
   x2 = v2*cos(ang2*c)
   y2 = v2*sin(ang2*c)

   ang1 = arctan(x1, y1 - sorgy) / c
   ang2 = arctan(x2, y2 - sorgy) / c

   setwidth line
   WScript.Echo "PU " & (x1+xorg)*40 & " " & (y1+yorg)*40 & ";"
   WScript.Echo "PD;AA " & (0+xorg)*40 & " " & (sorgy+yorg)*40 & " " & ang2-ang1 & " 1;"

End Sub

Sub do_smaj(byRef a)
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing major ticks: count " & UBound(a)
   End If

   d = a(1) - sorgy
   u = a(2)
   c = 2*pi/360

   setwidth tmajw
   For i=3 To UBound(a)
      ang1 = (pangb + (pange-pangb)*a(i)/100)

      dis = sorgy*sorgy * sin(ang1*c)*sin(ang1*c) - sorgy*sorgy + d*d
      v1 = sorgy * sin(ang1*c) + sqr(dis)
      x1 = v1*cos(ang1*c)
      y1 = v1*sin(ang1*c)

      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 atn(y1/x1) " & x1 & "," & y1 & "," & atn(y1/x1)
      End If
      ang2 = arctan(x1, y1)
      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 ang2 " & x1 & "," & y1 & "," & ang2
      End If

      dst2 = sqr(x1*x1 + y1*y1)
      If u Then
         dst2 = dst2 + tmajl
      Else
         dst2 = dst2 - tmajl
      End If
      x2 = dst2*cos(ang2)
      y2 = dst2*sin(ang2)

      WScript.Echo "PU " & (x1+xorg)*40 & " " & (y1+yorg)*40 & ";"
      WScript.Echo "PD " & (x2+xorg)*40 & " " & (y2+yorg)*40 & ";"
   Next

End Sub

Sub do_smin(byRef a)
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing minor ticks: count " & UBound(a)
   End If
   d = a(1) - sorgy
   u = a(2)
   c = 2*pi/360

   setwidth tminw
   For i=3 To UBound(a)
      ang1 = (pangb + (pange-pangb)*a(i)/100)

      dis = sorgy*sorgy * sin(ang1*c)*sin(ang1*c) - sorgy*sorgy + d*d
      v1 = sorgy * sin(ang1*c) + sqr(dis)
      x1 = v1*cos(ang1*c)
      y1 = v1*sin(ang1*c)

      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 atn(y1/x1) " & x1 & "," & y1 & "," & atn(y1/x1)
      End If
      ang2 = arctan(x1, y1)
      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 ang2 " & x1 & "," & y1 & "," & ang2
      End If

      dst2 = sqr(x1*x1 + y1*y1)
      If u Then
         dst2 = dst2 + tminl
      Else
         dst2 = dst2 - tminl
      End If
      x2 = dst2*cos(ang2)
      y2 = dst2*sin(ang2)
 
      WScript.Echo "PU " & (x1+xorg)*40 & " " & (y1+yorg)*40 & ";"
      WScript.Echo "PD " & (x2+xorg)*40 & " " & (y2+yorg)*40 & ";"
   Next

End Sub

Sub do_snum(byRef a)
   If UBound(a)/2 <> Int(UBound(a)/2) Then
      WScript.StdErr.WriteLine "Incorrect number of parameters: " & UBound(a) & " is not 2*n"
      WScript.Quit
   End If
   If blnDebug Then
      WScript.StdErr.WriteLine "Drawing numeric ticks: count " & UBound(a)/2
   End If

   d = a(1) - sorgy
   u = a(2)
   c = 2*pi/360

   setwidth tnumw
   For i=3 To UBound(a) Step 2
      ang1 = (pangb + (pange-pangb)*a(i)/100)

      dis = sorgy*sorgy * sin(ang1*c)*sin(ang1*c) - sorgy*sorgy + d*d
      v1 = sorgy * sin(ang1*c) + sqr(dis)
      x1 = v1*cos(ang1*c)
      y1 = v1*sin(ang1*c)

      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 atn(y1/x1) " & x1 & "," & y1 & "," & atn(y1/x1)
      End If
      If blnDebug Then
         WScript.StdErr.WriteLine "x1 y1 ang2 " & x1 & "," & y1 & "," & ang2
      End If

      dst2 = sqr(x1*x1 + y1*y1)
      If u Then
         dst2 = dst2 + 1*tnuml
      Else
         dst2 = dst2 - 1*tnuml
      End If
      x2 = dst2*cos(ang1*c)
      y2 = dst2*sin(ang1*c)

      ang2 = arctan(x1, y1-sorgy)
 
      WScript.Echo "PU " & (x1+xorg)*40 & " " & (y1+yorg)*40 & ";"
      WScript.Echo "PD " & (x2+xorg)*40 & " " & (y2+yorg)*40 & ";"
      WScript.Echo "CS 0;SS;ES-0.3;DT@;"
      If (u) Then
         WScript.Echo "LO14;"
      Else
         WScript.Echo "LO16;"
      End If
'      WScript.Echo "DI " & sin(ang2)*100 & " " & -cos(ang2)*100 & ";"
      WScript.Echo "DI " & sin(ang1*c)*100 & " " & -cos(ang1*c)*100 & ";"
      WScript.Echo "SI " & FormatNumber(tnuml*7/140,6) & " " & FormatNumber(tnuml*10/140,6) & ";"
      WScript.Echo "LB" & Replace(a(i+1), "_", " ") & "@;"
   Next

End Sub

Function arctan(byVal x0, byVal y0)
   Dim c

   If x0 = 0 Then
      c = pi/2*sgn(y0)
   Else
      c = atn(y0/x0)
      If x0<0 Then
         c = c+pi
      End If
   End If
   If c<0 Then
      c = c+2*pi
   End If

   arctan = c

   If blnDebug Then
      WScript.StdErr.WriteLine "x0 y0 atn(y0/x0) " & x0 & "," & y0 & "," & c
   End If

End Function

Sub setwidth(byVal w)
   WScript.Echo "SP " & w & ";"
   WScript.Echo "PW " & 0.2*w & ";"
   WScript.Echo "PT " & w & ";"
'   WScript.Echo "SP 1;"
'   WScript.Echo "PW " & w & ";"
'   WScript.Echo "PT " & w & ";"
End Sub

