////////////////////////////////////////////////////////////////
// 					DCF77 dekdol unit
//				 Topor Zoltn - 2007. febr.
//			   http://www.hobbielektronika.hu/
////////////////////////////////////////////////////////////////

// #define DECODE_DATE

int parity_cou = 0;
int  dcf_index = 0;
int dcf_diff = 0;
int dcf_diff_store = 0;

struct Ttime {
	unsigned int minute,hour,sec
#ifdef	DECODE_DATE
	,year,day,month,week_day
#endif
	;
	boolean HasNewTime;
	boolean isSummer;
	boolean TimeZoneChg;
	boolean ReserveAntenna;
};
struct Ttime dcf_time;
struct Ttime time;

boolean ParityOK = false;

////////////////////////////////////////////////////////////////
void Check_dcf_time() {
////////////////////////////////////////////////////////////////
   // a tli-nyri idszmts miatti az rs tllsnl lehet gondja 
   // br ha egyms utn ktszer bejn azt is korriglja
   // ha az tllsra figyelmeztet jelzbitet (16) 
   // s az elz llapotot (17-18) is figyelem megoldhat ... LESZ!! 
   // egyenlre pr perccel ksbb ll t
   if(volt_mar_dcf) {
      // az eltrs percekben
      dcf_diff=((dcf_time.hour*60)+dcf_time.minute)-((time.hour*60)+time.minute);
      // a pros parits ellenrzs miatt ha egy bit marad ki parits hibs lesz
      // ha tbb 2-nl mindenkppen tbbel fog eltrni, gy a 2 perc eltrs elfogadhat
      // ennl nagyobb klmbsg gyse lesz, ehez hnapokig kell dcf nlkl mennie
      // ha mgis volna a msodik j csomaggal gyis belltja
      if(abs(dcf_diff)>2) {
         dcf_time.HasNewTime=false;
         // nincs mentett eltrs adat
         if(dcf_diff_store==0) {
            dcf_diff_store = dcf_diff;
         } else {
            // volt mr egy adat, s ugyan annyival tr el mint a mostani, ez a j
            // persze feltve hogy kt egymst kvet j paritscsomag nem ppen ugyangy srlt
            // br ez nem valszn, de tapasztalat szerint elfordul
			// mivel a dtumot nem figyelem ezzel a mdszerrel, jellemzen a dtum mszkl el, mert a paritsa kt hibs bitnl OK lesz
			// azt is meg kne oldani.... taln majd ksbb....
			// ---- kis segtsg:
			// ha valakinek van ambcija hozz, a dtumot sszeadhatja +hh+nn
			// mivel a max dtum 99.12.31 ez (99+12+31=142) bven elfr egy byte-ban, ez trolhat, s 
			// nem ugyan ez jn, a CRC OK ellenre is biztosan hibs.
			// ezzel ugyan kizrjuk az jfli szinkronizlst, de marad mn napi 1439 lehetsge
			// szerintem megri, mert gy kisebb a valsznsge hogy agymens dtumra ll be
            dcf_time.HasNewTime = (dcf_diff==dcf_diff_store);
            dcf_diff_store=0;
         }
      }
   }
}

////////////////////////////////////////////////////////////////
void dcf77_alt_decode(boolean b) {
////////////////////////////////////////////////////////////////

	switch(dcf_index) {
		case 15: dcf_time.ReserveAntenna = b;					  break;
		case 16: dcf_time.TimeZoneChg = b;						  break;
		case 17: dcf_time.isSummer = b;							  break;

		case 20: ParityOK = b; parity_cou = 0;					  break;	/* ez mindig 1 ez a start */
		case 21: dcf_time.minute = b; 	if(b)   parity_cou++;	  break;
		case 22: if(b) {dcf_time.minute += 2;   parity_cou++;}	  break;
		case 23: if(b) {dcf_time.minute += 4;   parity_cou++;}	  break;
		case 24: if(b) {dcf_time.minute += 8;   parity_cou++;}	  break;
		case 25: if(b) {dcf_time.minute += 10;  parity_cou++;}	  break;
		case 26: if(b) {dcf_time.minute += 20;  parity_cou++;}	  break;
		case 27: if(b) {dcf_time.minute += 40;  parity_cou++;}	  break;
		case 28: ParityOK &= (b+parity_cou)%2==0; parity_cou = 0; break;

		case 29: dcf_time.hour = b;		if(b)   parity_cou++;	  break;
		case 30: if(b) {dcf_time.hour += 2;     parity_cou++;}	  break;
		case 31: if(b) {dcf_time.hour += 4;     parity_cou++;}	  break;
		case 32: if(b) {dcf_time.hour += 8;     parity_cou++;}	  break;
		case 33: if(b) {dcf_time.hour += 10;    parity_cou++;}	  break;
		case 34: if(b) {dcf_time.hour += 20;    parity_cou++;}	  break;
		case 35: ParityOK &= (b+parity_cou)%2==0; parity_cou = 0; break;
		#ifdef	DECODE_DATE
		case 36: dcf_time.day = b; 		if(b)   parity_cou++;	  break;
		case 37: if(b) {dcf_time.day += 2;      parity_cou++;}	  break;
		case 38: if(b) {dcf_time.day += 4;      parity_cou++;}	  break;
		case 39: if(b) {dcf_time.day += 8;      parity_cou++;}	  break;
		case 40: if(b) {dcf_time.day += 10;     parity_cou++;}	  break;
		case 41: if(b) {dcf_time.day += 20;     parity_cou++;}	  break;

		case 42: dcf_time.week_day = b; if(b)   parity_cou++;	  break;
		case 43: if(b) {dcf_time.week_day += 2; parity_cou++;}	  break;
		case 44: if(b) {dcf_time.week_day += 4; parity_cou++;}	  break;

		case 45: dcf_time.month = b;  	if(b)   parity_cou++;	  break;
		case 46: if(b) {dcf_time.month += 2;    parity_cou++;}	  break;
		case 47: if(b) {dcf_time.month += 4;    parity_cou++;}	  break;
		case 48: if(b) {dcf_time.month += 8;    parity_cou++;}	  break;
		case 49: if(b) {dcf_time.month += 10;   parity_cou++;}	  break;

		case 50: dcf_time.year = b;  	if(b)   parity_cou++;	  break;
		case 51: if(b) {dcf_time.year += 2;     parity_cou++;}	  break;
		case 52: if(b) {dcf_time.year += 4;     parity_cou++;}	  break;
		case 53: if(b) {dcf_time.year += 8;     parity_cou++;}	  break;
		case 54: if(b) {dcf_time.year += 10;    parity_cou++;}	  break;
		case 55: if(b) {dcf_time.year += 20;    parity_cou++;}	  break;
		case 56: if(b) {dcf_time.year += 40;    parity_cou++;}	  break;
		case 57: if(b) {dcf_time.year += 80;    parity_cou++;}	  break;
		case 58: ParityOK &= (b+parity_cou)%2==0;
		#endif
	}
}

////////////////////////////////////////////////////////////////
void dcf77_isr() {
////////////////////////////////////////////////////////////////
	if(TickCount > 1500) {
		//ha kimaradt egy... vagyis ez mr az j perc
		//els tick-je
		TickCount = 0;	//elszr ez kell, mert ezutni is id... taln
		dcf_index = 0;
		if(!volt_mar_dcf) time.sec = 0;
		if(dcf_time.minute > 59)  ParityOk = false;
		if(dcf_time.hour > 24) 	  ParityOk = false;
		#ifdef	DECODE_DATE
		if(dcf_time.day > 31) 	  ParityOk = false;
		if(dcf_time.day < 1) 	  ParityOk = false;
		if(dcf_time.week_day > 7) ParityOk = false;
		if(dcf_time.month > 12)	  ParityOk = false;
		if(dcf_time.month < 1)	  ParityOk = false;
		if(dcf_time.year < 8)	  ParityOk = false;  //2008 eltti
		if(dcf_time.year > 99)	  ParityOk = false;
		#endif
		dcf_time.HasNewTime = ParityOk;
    if(ParityOk) Check_dcf_time();
		ParityOK = false;
	} else if(TickCount > 300) {
		//ilyenkor mr tuti nincs semmi
		TickCount = 0;
	}
}

////////////////////////////////////////////////////////////////
void dcf77_get_input() {
////////////////////////////////////////////////////////////////
	//150 ms-enknt hvdik meg. Ha akkor 1-es akkor 1-es jtt
	//ha 0-s lenne, akkor ilyenkor az mr 0 lenne...
	//ezutn hagyjuk a timert tovbb ketyegni
	dcf77_alt_decode(input(PIN_B0));
	dcf_index++;
}
