#include <stdio.h>
#include <stdlib.h>
#include <htc.h> // Itt automatikusan vllassza ki a kontrollert

__CONFIG(WDTE_OFF & FOSC_XT & CP_OFF & LVP_OFF & BOREN_OFF & MCLRE_ON & PWRTE_ON); // eredeti
//__CONFIG(UNPROTECT & LVPDIS & BORDIS & MCLRDIS & PWRTEN & WDTDIS & XT); // Ezt kiveheted ha nekem nem megy

#define _XTAL_FREQ 4000000
#define DATA RB0
#define CLK RB1
#define ENABLE RB2
#define LED RB3
#define readbit(data,bitno) ((data>>bitno)&0x01) // Digit kijelzs makrja
int szamlalo = 0;
int szam = 0;

unsigned char Digit[10] = {0x03,0x9F,0x25,0x0D,0x99,0x49,0x41,0x1F,0x01,0x09};

void digit_display(int dignum){
    ENABLE = 1;
    CLK=0;
    for(int i = 0; i < 8; i++){
        DATA = readbit(Digit[dignum], i);
        __delay_ms(10);
        CLK = 1;
        __delay_ms(10);
        CLK = 0;
    }
    ENABLE = 0;
}

static void interrupt isr(void){
    szamlalo++;
    if(szamlalo == 1000){
        if(LED == 0){
            LED = 1;
        }else{
            LED = 0;
        }
        if(szam > 9){
            szam = 0;
        }
        digit_display(szam);
        szam++;
        szamlalo = 0;
    }
    TMR2IF = 0;
}

int main() {
    TRISA = 0xFF;  //A lbai bemenet lettek lltva
    PORTA = 0; // Port alacsony szinten
    PORTB = 0x00;
    TRISB = 0x00; // B lbai kimenetek
    CMCON = 7; // Comparator kikapcsolva
    CCP1CON = 0; // Capt/Comp/PWM kikapcsolva
    INTCON = 0;	// sszes interrupt lb kikapcsolva
    PR2 = 249; // Timer2 PR2 8bites peridus regiszter
    T2CON = 5; // T2CON regiszter
    TMR2IE = 2; // TMR2IE megszaktst engedlyez? bit (lelltva a Timer2)
    PEIE = 1; // Peripheral interrupt engedlyezse
    GIE = 1; // Globlis interrupt engedlyezse
    DATA = 1;
    ENABLE = 0;
    CLK = 0;
    while(1){
        TMR2IE = 1;
    }
}