#include <SD.h>

// Grafiktest 1.8 Zoll TFT-Farb-Display (HY-1.8 SPI)
 
#define cs   10 // Arduino-Pin an Display CS   
#define dc   9  // Arduino-Pin an 
#define rst  8  // Arduino Reset-Pin
#define SD_CS 4
 
#include <Adafruit_GFX.h>    // Adafruit Grafik-Bibliothek
#include <Adafruit_ST7735.h> // Adafruit ST7735-Bibliothek
#include <SPI.h>
 
Adafruit_ST7735 tft = Adafruit_ST7735(cs, dc, rst);  // Display-Bibliothek Setup
 
void setup(void) {
  pinMode(SD_CS,OUTPUT);
  tft.initR(INITR_BLACKTAB);   // ST7735-Chip initialisieren
  Serial.begin(9600);
  delay(10);
  if (!SD.begin(SD_CS)) {
    Serial.println("failed!");
    return;
  }
  else Serial.println("SD card opened");
}


long ido=0;
void loop() {
 int teszt=3;
 Serial.println(millis()-ido,DEC);
 ido=millis();
 SPI.setClockDivider(SPI_CLOCK_DIV2);  //2 4 8 16 32 64 128
 //div2 - 1190 ms  // 190 ms
 //div4 - 1243 ms  // 243 ms
 //div8 - 1348 ms
  if (teszt==1)
  {
  int warten=0;
  int warten_ende=0;
  // Bildschirm mit Farbe fuellen
  // fillScreen(farbe);
  tft.fillScreen(ST7735_BLACK);
 
  delay(warten); // 2 Sekunden warten
  
  // Fontgroesse setzen
  // setTextSize(groesse);
  tft.setTextSize(2);
  
  // Schrift umbrechen?
  // setTextWrap(true);   true=Ja, false=Nein
  tft.setTextWrap(true); 
  
  // Textposition setzen
  // setCursor(x,y);
  tft.setCursor(24,4);
 
  // Textfarbe setzen
  // setTextColor(farbe);
  tft.setTextColor(ST7735_WHITE);
  
  // Text ausgeben
  // print(text);
  tft.print("Hallo !");
 
  delay(warten); // 2 Sekunden warten
  
  // Linie zeichnen
  // drawLine(x_start,y_start,x_ende,y_ende,farbe);
  tft.drawLine(10,24,118,24,ST7735_GREEN);
 
  delay(warten); // 2 Sekunden warten
    
  // Ein Rechteck zeichnen 
  // drawRect(x_oben_links,y_oben_links,weite,hoehe,farbe);
  tft.drawRect(4,35,120,20,ST7735_RED); 
  
  delay(warten); // 2 Sekunden warten
 
  // Ein gefuelltes Rechteck zeichnen 
  // drawRect(x_oben_links,y_oben_links,weite,hoehe,farbe);
  tft.fillRect(10,40,108,10,ST7735_YELLOW);
 
  delay(warten); // 2 Sekunden warten
 
  // Ein Rechteck zeichnen 
  // drawRoundRect(x_oben_links,y_oben_links,weite,hoehe,rundung,farbe);
  tft.drawRoundRect(4,65,120,20,5,ST7735_MAGENTA); 
  
  delay(warten);
  
  // Einen Kreis zeichnen 
  // drawCircle(x_oben_links,y_oben_links,radius,farbe);
  tft.drawCircle(64,115, 20, ST7735_CYAN);
  
  delay(warten); // 2 Sekunden warten
  
  // Einen gefuellten Kreis zeichnen 
  // fillCircle(x_oben_links,y_oben_links,radius,farbe);
  tft.fillCircle(64,115, 10, ST7735_BLUE);
  
  delay(warten); // 2 Sekunden warten
 
  // Neue Fontgroesse setzen
  // setTextSize(groesse);
  tft.setTextSize(1);
  
  // Neue Textfarbe setzen
  // setTextColor(farbe);
  tft.setTextColor(ST7735_GREEN);
  
  // Neue Textposition setzen
  // setCursor(x,y);
  tft.setCursor(14,147);
  
  // Text ausgeben
  // print(text);
  tft.print("blog.simtronyx.de");
  
  delay(warten_ende); // 8 Sekunden warten
  
  // Gesamtes Display invertieren?
  // invertDisplay(true);   true=Ja, false=Nein
  tft.invertDisplay(true);
  
  delay(warten); // 1 Sekunde warten
  
  // Gesamtes Display invertieren?
  // invertDisplay(false);   true=Ja, false=Nein
  tft.invertDisplay(false);
 
  delay(warten); // 1 Sekunde warten
  }
  
  
  
  ///////////////////////////////////////////////
  if (teszt==2)
  {// This keeps repeating ...

  Serial.println("loop() - starting (again) ...");



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  // Hello

  Serial.println("Hello message");

  tft.setTextSize(1);

  tft.setCursor(0, 50);

  tft.setTextColor(ST7735_WHITE);

  tft.print("   Tweaking");

  tft.setTextColor( tft.Color565( 0xFF, 0xCC, 0x00) );

  tft.print("4");

  tft.setTextColor(ST7735_WHITE);

  tft.println("All.com");

  tft.setTextSize(1);

  tft.println("     Display Demo");

  delay(3000);



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  // Draw some pixels

  Serial.println("Draw 4 pixels");

  tft.drawPixel(10,10,ST7735_WHITE);

  tft.drawPixel(100,100,ST7735_GREEN);

  tft.drawPixel(10,50,ST7735_RED);

  tft.drawPixel(100,50,ST7735_YELLOW);

  delay(3000);



  // Draw some lines

  Serial.println("Draw some lines");

  tft.drawLine(10,10,100,100,ST7735_WHITE);

  tft.drawLine(100,100,10,50,ST7735_GREEN);

  tft.drawLine(10,50,100,50,ST7735_RED);

  tft.drawLine(100,50,10,10,ST7735_YELLOW);

  delay(3000);



  // Draw some rectangles

  Serial.println("Draw some rectangles, with delay between open and filled rectangle");

  tft.drawRect(20,20,100,100,ST7735_RED);

  tft.drawRect(40,10,10,100,ST7735_YELLOW);

  delay(2000);

  tft.fillRect(50,10,50,20,ST7735_RED);

  tft.fillRect(80,80,10,10,ST7735_YELLOW);

  delay(3000);



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  // Draw some circles

  Serial.println("Draw some circles, with delay between open and filled cicle");

  tft.drawCircle(70,70,10,ST7735_WHITE);

  tft.drawCircle(70,70,50,ST7735_RED);

  delay(2000);

  tft.fillCircle(20,20,50,ST7735_YELLOW);

  tft.fillCircle(20,20,10,ST7735_BLUE);

  delay(3000);



  // Draw some triangles

  Serial.println("Draw some triangles, with delay between open and filled triangles");

  tft.drawTriangle(64,100, 64,150, 100,150, ST7735_YELLOW);

  tft.drawTriangle(64,100, 44,150, 84,150,  ST7735_RED);

  delay(1000);

  tft.fillTriangle(64,100, 64,150, 100,150, ST7735_YELLOW);

  tft.fillTriangle(64,100, 44,150, 84,150,  ST7735_RED);

  delay(3000);



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  // Draw rectangles with rounded corners for a dialog

  // Big box

  Serial.println("Display panic message!");

  tft.fillRoundRect( 14,16, 100, 100, 8, tft.Color565( 0xC4, 0xC4, 0xC4) );

  tft.drawRoundRect( 14,16, 100, 100, 8, tft.Color565( 0x99, 0x99, 0x99) );

  // Title

  tft.fillRoundRect( 20,8, 60, 20, 4, tft.Color565( 0xFF, 0, 0) );

  tft.drawRoundRect( 20,8, 60, 20, 4, tft.Color565( 0x99, 0x99, 0x99) );

  // Title text

  tft.setCursor(28, 14);

  tft.setTextColor(ST7735_WHITE);

  tft.print("WARNING");

  // Message

  tft.setTextColor(ST7735_RED);

  tft.setCursor(22, 38);

  tft.print("Something is");

  tft.setCursor(22, 48);

  tft.print("very wrong!");

  tft.setCursor(22, 68);

  tft.print("OMG - PANIC !");

  tft.setCursor(22, 88);

  tft.print("We're out of");

  tft.setCursor(22, 98);

  tft.print("COFFEE!!!");

  delay(3000);



  // Display blinking -- invert or normal

  Serial.println("Display blinking ...");

  for(int i=0; i<10; i++)

  {

    tft.invertDisplay(true);

    delay(500);

    tft.invertDisplay(false);

    delay(500);

  }  

  delay(3000);



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  // Write a long text with word wrap

  tft.setTextColor(ST7735_WHITE);

  tft.setCursor(0, 0);

  tft.print("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur adipiscing ante sed nibh tincidunt feugiat. Maecenas enim massa, fringilla sed malesuada et, malesuada sit amet turpis. Sed porttitor neque ut ante pretium vitae malesuada nunc bibendum. Nullam aliquet ultrices massa eu hendrerit. Ut sed nisi lorem. In vestibulum purus a tortor imperdiet posuere. ");

  delay(2000);



  // Clear screen

  Serial.println("Fill screen with BLACK");

  tft.fillScreen(ST7735_BLACK);



  Serial.println("Test font sizes");

  tft.setTextWrap(true);

  tft.setTextColor(ST7735_WHITE);

  tft.setCursor(0, 0);

  delay(1000);



  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.println("1 (default)");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(2);

  tft.println("2");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(3);

  tft.println("3");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(4);

  tft.println("4");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(5);

  tft.println("5");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(6);

  tft.println("6");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(7);

  tft.println("7");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(8);

  tft.println("8");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(9);

  tft.println("9");

  delay(1000);



  tft.fillScreen(ST7735_BLACK);

  tft.setCursor(0, 0);

  tft.setTextSize(1);

  tft.println("Fontsize:");

  tft.setCursor(0, 30);

  tft.setTextSize(10);

  tft.println("10");

  delay(3000);
  }
  if (teszt==3)
  {
    tft.fillScreen(ST7735_BLACK);
    bmpDraw("rita.bmp",0,0);
    delay(8000);
  }
}

#define BUFFPIXEL 20

void bmpDraw(char *filename, uint8_t x, uint8_t y) {

  File     bmpFile;
  int      bmpWidth, bmpHeight;   // W+H in pixels
  uint8_t  bmpDepth;              // Bit depth (currently must be 24)
  uint32_t bmpImageoffset;        // Start of image data in file
  uint32_t rowSize;               // Not always = bmpWidth; may have padding
  uint8_t  sdbuffer[3*BUFFPIXEL]; // pixel buffer (R+G+B per pixel)
  uint8_t  buffidx = sizeof(sdbuffer); // Current position in sdbuffer
  boolean  goodBmp = false;       // Set to true on valid header parse
  boolean  flip    = true;        // BMP is stored bottom-to-top
  int      w, h, row, col;
  uint8_t  r, g, b;
  uint32_t pos = 0, startTime = millis();

  if((x >= tft.width()) || (y >= tft.height())) return;

  Serial.println();
  Serial.print("Loading image '");
  Serial.print(filename);
  Serial.println('\'');

  // Open requested file on SD card
  if ((bmpFile = SD.open(filename)) == NULL) {
    Serial.print("File not found");
    return;
  }

  // Parse BMP header
  if(read16(bmpFile) == 0x4D42) { // BMP signature
    Serial.print("File size: "); 
    Serial.println(read32(bmpFile));
    (void)read32(bmpFile); // Read & ignore creator bytes
    bmpImageoffset = read32(bmpFile); // Start of image data
    Serial.print("Image Offset: "); 
    Serial.println(bmpImageoffset, DEC);
    // Read DIB header
    Serial.print("Header size: "); 
    Serial.println(read32(bmpFile));
    bmpWidth  = read32(bmpFile);
    bmpHeight = read32(bmpFile);
    if(read16(bmpFile) == 1) { // # planes -- must be '1'
      bmpDepth = read16(bmpFile); // bits per pixel
      Serial.print("Bit Depth: "); 
      Serial.println(bmpDepth);
      if((bmpDepth == 24) && (read32(bmpFile) == 0)) { // 0 = uncompressed

        goodBmp = true; // Supported BMP format -- proceed!
        Serial.print("Image size: ");
        Serial.print(bmpWidth);
        Serial.print('x');
        Serial.println(bmpHeight);

        // BMP rows are padded (if needed) to 4-byte boundary
        rowSize = (bmpWidth * 3 + 3) & ~3;

        // If bmpHeight is negative, image is in top-down order.
        // This is not canon but has been observed in the wild.
        if(bmpHeight < 0) {
          bmpHeight = -bmpHeight;
          flip      = false;
        }

        // Crop area to be loaded
        w = bmpWidth;
        h = bmpHeight;
        if((x+w-1) >= tft.width())  w = tft.width()  - x;
        if((y+h-1) >= tft.height()) h = tft.height() - y;

        // Set TFT address window to clipped image bounds
        tft.setAddrWindow(x, y, x+w-1, y+h-1);

        for (row=0; row<h; row++) { // For each scanline...

          // Seek to start of scan line. .
          if(flip) // Bitmap is stored bottom-to-top order (normal BMP)
            pos = bmpImageoffset + (bmpHeight - 1 - row) * rowSize;
          else     // Bitmap is stored top-to-bottom
          pos = bmpImageoffset + row * rowSize;
          if(bmpFile.position() != pos) { // Need seek?
            bmpFile.seek(pos);
            buffidx = sizeof(sdbuffer); // Force buffer reload
          }

          for (col=0; col<w; col++) { // For each pixel...
            // Time to read more pixel data?
            if (buffidx >= sizeof(sdbuffer)) { // Indeed
              bmpFile.read(sdbuffer, sizeof(sdbuffer));
              buffidx = 0; // Set index to beginning
            }

            // Convert pixel from BMP to TFT format, push to display
            b = sdbuffer[buffidx++];
            g = sdbuffer[buffidx++];
            r = sdbuffer[buffidx++];
            tft.pushColor(tft.Color565(r,g,b));
          } // end pixel
        } // end scanline
        Serial.print("Loaded in ");
        Serial.print(millis() - startTime);
        Serial.println(" ms");
      } // end goodBmp
    }
  }

  bmpFile.close();
  if(!goodBmp) Serial.println("BMP format not recognized.");
}

uint16_t read16(File f) {
  uint16_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read(); // MSB
  return result;
}

uint32_t read32(File f) {
  uint32_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read();
  ((uint8_t *)&result)[2] = f.read();
  ((uint8_t *)&result)[3] = f.read(); // MSB
  return result;
}
