#include "systick_kesleltetes.h"
#include "stm32f10x.h"                  // Device header

u32 szamlalo;

void SysTick_Inditasa(void)
{
	SysTick->LOAD  = (SystemCoreClock / 1000000) - 1;							//reload regiszter belltsa (1us)
	NVIC_SetPriority (SysTick_IRQn, (1<<__NVIC_PRIO_BITS) - 1);		//megszakts priorits belltsa
	SysTick->VAL   = 0;																						//szmll nullzsa
	SET_BIT(SysTick->CTRL, SysTick_CTRL_CLKSOURCE_Msk);						//szmll rajele AHB
	SET_BIT(SysTick->CTRL, SysTick_CTRL_TICKINT_Msk);							//tlcsorduls megszakts engedlyezse
}

void SysTick_Kesleltetes_us(u32 ido)
{
	szamlalo = ido;
	SET_BIT(SysTick->CTRL, SysTick_CTRL_ENABLE_Msk);
	while(szamlalo);
	CLEAR_BIT(SysTick->CTRL, SysTick_CTRL_ENABLE_Msk);
}

void SysTick_Kesleltetes_ms(u32 ido)
{
	while(ido--)
	{
		szamlalo = 1000;
		SET_BIT(SysTick->CTRL, SysTick_CTRL_ENABLE_Msk);
		while(szamlalo);
		CLEAR_BIT(SysTick->CTRL, SysTick_CTRL_ENABLE_Msk);
	}
}

void SysTick_Handler(void)
{
	if(szamlalo)
	{
		szamlalo--;
	}
}
