#include "stm32f10x.h"
#include "vga.h"

GPIO_InitTypeDef GPIO_InitStructure;
TIM_TimeBaseInitTypeDef TIMER_InitStructure;
TIM_OCInitTypeDef  TIM_OCInitStructure;
NVIC_InitTypeDef NVIC_InitStructure;
DMA_InitTypeDef DMA_InitStructure;

volatile u8 x_index = 0;
volatile u8 y_index = 0;

volatile u8 kep_memoria[MAGASSAG][SZELESSEG];

void VGA_beallitasa(void)
{
	TIM2_beallitasa();
	TIM3_beallitasa();
	kep_kimenet_beallitasa();
	DMA_beallitasa();
	
	VGA_kepernyo_torles();
}

void TIM2_beallitasa(void)
{
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);	//rajel
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	//port kimenet rajel
	
	//H szinkron
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;							//TIM2_CH1
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	//TIM2 idoalap
	TIMER_InitStructure.TIM_Prescaler = 0;
	TIMER_InitStructure.TIM_CounterMode = TIM_CounterMode_Up;
	TIMER_InitStructure.TIM_Period = H_SOR-1;
	TIMER_InitStructure.TIM_ClockDivision = TIM_CKD_DIV1;
	TIMER_InitStructure.TIM_RepetitionCounter = 0;
	TIM_TimeBaseInit(TIM2, &TIMER_InitStructure);
	
	//TIM2 PWM md
	TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_Toggle;
  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;	//kimeneti fokozat be
  TIM_OCInitStructure.TIM_Pulse = H_1;
	TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_Low;
  TIM_OC1Init(TIM2, &TIM_OCInitStructure);
	
	TIM_ITConfig(TIM2, TIM_IT_Update,ENABLE);	//tulcsorduls megszakts be
	TIM_ITConfig(TIM2, TIM_IT_CC1,ENABLE);	//tulcsorduls megszakts be
	
	NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
	
	//TIM2 Master
	TIM_SelectMasterSlaveMode(TIM2, TIM_MasterSlaveMode_Enable);
	TIM_SelectOutputTrigger(TIM2, TIM_TRGOSource_Update);
	
	TIM_Cmd(TIM2, ENABLE);
}

void TIM3_beallitasa(void)
{
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM3, ENABLE);	//rajel
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	//port kimenet rajel
	
	//H szinkron
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;							//TIM3_CH1
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	//TIM3 idoalap
	TIMER_InitStructure.TIM_Prescaler = 0;
	TIMER_InitStructure.TIM_CounterMode = TIM_CounterMode_Up;
	TIMER_InitStructure.TIM_Period = V_KEP-1;
	TIMER_InitStructure.TIM_ClockDivision = TIM_CKD_DIV1;
	TIMER_InitStructure.TIM_RepetitionCounter = 0;
	TIM_TimeBaseInit(TIM3, &TIMER_InitStructure);
	
	//TIM3 PWM md
	TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_Toggle;
  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;	//kimeneti fokozat be
  TIM_OCInitStructure.TIM_Pulse = V_1;
	TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_Low;
  TIM_OC1Init(TIM3, &TIM_OCInitStructure);
	
	TIM_ITConfig(TIM3, TIM_IT_Update,ENABLE);	//tulcsorduls megszakts be
	TIM_ITConfig(TIM3, TIM_IT_CC1,ENABLE);	//tulcsorduls megszakts be
	
	NVIC_InitStructure.NVIC_IRQChannel = TIM3_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
	
	//TIM3 Slave
	TIM_SelectSlaveMode(TIM3, TIM_SlaveMode_Gated);
	TIM_SelectInputTrigger(TIM3, TIM_TS_ITR1);

	TIM_Cmd(TIM3, ENABLE);
}

void kep_kimenet_beallitasa(void)
{
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	//port kimenet rajel
	
	//H szinkron
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
}

void DMA_beallitasa(void)
{
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
	
	/* DMA1 Channel5 configuration ----------------------------------------------*/
  DMA_DeInit(DMA1_Channel1);
  DMA_InitStructure.DMA_PeripheralBaseAddr = (u32) &GPIOA->ODR;
  DMA_InitStructure.DMA_MemoryBaseAddr = (u32) &kep_memoria[0][0];
  DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralDST;
  DMA_InitStructure.DMA_BufferSize = SZELESSEG;
  DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
  DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
  DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
  DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_Byte;
  DMA_InitStructure.DMA_Mode = DMA_Mode_Normal;
  DMA_InitStructure.DMA_Priority = DMA_Priority_VeryHigh;
  DMA_InitStructure.DMA_M2M = DMA_M2M_Enable;
  DMA_Init(DMA1_Channel1, &DMA_InitStructure);
	
	//Enable DMA1 channel IRQ Channel */
	NVIC_InitStructure.NVIC_IRQChannel = DMA1_Channel1_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);
	
	DMA_ITConfig(DMA1_Channel1, DMA_IT_TC, ENABLE);
}

void TIM2_IRQHandler()
{	
	if ( TIM2->SR & TIM_IT_Update )
	{
		if(TIM3->CNT < 480)
		{
			DMA1_Channel1->CCR |= DMA_CCR1_EN;
		}
		else
		{
			GPIOA->ODR = 0;
		}
		
		TIM2->SR = ~TIM_IT_Update;
		return;
	}
	
	if ( TIM2->SR & TIM_IT_CC1 )
	{
		if(TIM2->CCR1 == H_1)
		{
			TIM2->CCR1 = H_2;
		}
		else
		{
			TIM2->CCR1 = H_1;
		}
			
		TIM2->SR = ~TIM_IT_CC1;
		
		return;
	}
}

void TIM3_IRQHandler()
{	
	if ( TIM3->SR & TIM_IT_CC1 )
	{
		if(TIM3->CCR1 == V_1)
		{
			TIM3->CCR1 = V_2;
		}
		else
		{
			TIM3->CCR1 = V_1;
		}
			
		TIM3->SR = ~TIM_IT_CC1;
		
		return;
	}
	
	if ( TIM3->SR & TIM_IT_Update )
  {
		TIM3->SR = ~TIM_IT_Update;
		return;
  }
}

void DMA1_Channel1_IRQHandler(void)
{
	GPIOA->ODR = 0;
	
  if(DMA1->ISR & DMA1_IT_TC1)
  {
		DMA1_Channel1->CCR &= (uint16_t)(~DMA_CCR1_EN);
		DMA1_Channel1->CMAR = (uint32_t) &kep_memoria[((TIM3->CNT)+1)/4][0];
		DMA1_Channel1->CNDTR = SZELESSEG;
    DMA1->IFCR = ~DMA1_IT_TC1;
  }
}

void VGA_kepernyo_torles(void)
{
	for(y_index = 0;y_index<MAGASSAG;y_index++)
	{
		for(x_index = 0;x_index<SZELESSEG;x_index++)
		{
			kep_memoria[y_index][x_index] = 0;
		}
	}
}
