//#######################################################################################################################
//#
//#	 - , ,   ..
//#
//#######################################################################################################################


// 
#define F_CPU 8000000
#include <util/delay.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h> 						//eeprom_read_byte(), eeprom_write_byte(), eeprom_read_word(), eeprom_write_word()
#include <avr/pgmspace.h>
#include <string.h>


typedef enum 
{
	HORIZONTAL_TO_RIGHT=0,
	HORIZONTAL_TO_LEFT,
	HORIZONTAL_FROM_MID,
	HORIZONTAL_TO_MID,
	HORIZONTAL_HALF0,
	HORIZONTAL_HALF1,
	HORIZONTAL_HALF2,
	VERTICAL_TO_TOP,
	VERTICAL_TO_BOTTOM,
	VERTICAL_FROM_MID,
	VERTICAL_TO_MID,
	VERTICAL_HALF0,
	VERTICAL_HALF1,
	VERTICAL_HALF2,
	COLLAPSE,
	EXPLODE
} PRINT_MODE;

PRINT_MODE print_mode;


//-----------------------------------------------------------------------------------------------------------------------
//
#define INLINE   inline __attribute__((__always_inline__))
#define NOINLINE __attribute__((__noinline__))

#define LedBoardRowInvert	255				
#define	LedBoardSize 		8					
#define LedBoardSimbWidth 	6					
#define FontSimbWidth 		5					
#define TimeOutConst 		60					


//-----------------------------------------------------------------------------------------------------------------------
#define Flags1   TWBR							
	#define b1LedBoardPageCompleted	(1<<0)		
	#define b1OneWireGet			(1<<1)		
	#define b1ClockReadEnable		(1<<2)		
	#define b1ClockChange			(1<<3)		

#define BtnFlags   TWAR							
	#define ShortUp			(1<<3)				
	#define ShortLeft		(1<<2)				
	#define ShortRight		(1<<1)				
	#define ShortDown		(1<<0)				
	#define LongUp			(1<<7)				
	#define LongLeft		(1<<6)				
	#define LongRight		(1<<5)				
	#define LongDown		(1<<4)				

	#define MAX_EXPLODE_PIX 200

	typedef struct
	{
		unsigned char x;
		unsigned char y;	//y s irny y:0,1,2 bit, irny 3,4,5,6 van-e pixel : 7 bit
		unsigned char irany;
	} EXPLODE_PIX;


volatile uint8_t BtnLongSpeed;							
volatile char BtnTimeOutCoun;							

char LedBoardBuffer [(LedBoardSize+2)*LedBoardSimbWidth];
char LedBoardHorScrollSpeed = 50;						
char LedBoardVertScrollSpeed = 25;						
char LedBoardFlashCoun = 0;								

char ClockSimbVertScrollSpeed = 6;						
char ClockMiliSecond;									
char ClockData [7] =									
	{0x00,0x00,0x00,0x01,0x01,0x01,0x12};				
char ClockGraphBuf [LedBoardSimbWidth*8];				
char puffer_GraphBuf [LedBoardSimbWidth*8];				
EXPLODE_PIX explode_Graph [MAX_EXPLODE_PIX];	
int  ClockPosition = 0;									
char ClockChangeMask = 0;								
							
char OneWireErr;										
char OneWireCheckSumm;									
char OneWireReadBuf [9];								
int  OneWireTermoData [2];								


//-----------------------------------------------------------------------------------------------------------------------
// 	
static void LedBoardIntPrint (signed int integer, uint8_t IntPos, uint8_t IntLength, uint8_t DotPosition);
static void Sajat_SimbPrint (unsigned char simbol, unsigned char position);
static void LedBoardSimbPrint (unsigned char simbol, unsigned char position);
static void Under_Line(char *under_line,unsigned char position);
static void LedBoardMessageShow (char *pAdrTxt);

static void LedBoardMessageScrollLeft (char *pAdrTxt);
static void LedBoard1PixScrollLeft (void);
//static void LedBoard1PixScrollRight (void);

static void LedBoardTermoShow (char Position, uint8_t NumDev);
static void LedBoardTermoScrollLeft (uint8_t NumDev);

static void LedBoardClockShow (uint8_t Position);
static void LedBoardClockScrollLeft (void);

static void LedBoardClearScrollLeft (void);

static void LedBoardOut (char NumLine);
static void Magic_Write (char *pAdrTxt,PRINT_MODE pr_mode );
static void Magic_Clear(PRINT_MODE pr_mode);

static void IICStart (void);					//  I2C
static void IICStop (void);

static void IICClockReadData (void);			//-     DS1307
static void IICClockWriteData (void);

static void ClockBufferProcess (void);
static void ClockSimbToBuf (char byte, char Shift, char change);

static char IICByteWrite (char);
static char IICByteRead (char);
static char IICBit (char);

static uint8_t OneWireData (uint8_t, char);
static void OneWireIntTermoGet (void);
static void OneWireReset (char);
static void CheckSumm (char);

static void Delay (unsigned char);
static void VarProcessing (void);
static void MainInit (void);

static void BtnGet (void);						//-  

void demo();
void demo2();
void demo3();
void demo4();
void demo5();

//-----------------------------------------------------------------------------------------------------------------------
//  PROGRAM MEMORY					
char SimbMass [] PROGMEM = {							// 
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA,0x00,0x00,	// !32
	0x00,0xC0,0x00,0xC0,0x00,0x28,0xFE,0x28,0xFE,0x28,	//"#34
	0x24,0x54,0xFE,0x54,0x48,0xC4,0xC8,0x10,0x26,0x46,	//$%36
	0x6C,0x92,0xAA,0x44,0x0A,0x00,0xA0,0xC0,0x00,0x00,	//&'38
	0x00,0x38,0x44,0x82,0x00,0x00,0x82,0x44,0x38,0x00,	//()40
	0x28,0x10,0x7C,0x10,0x28,0x10,0x10,0x7C,0x10,0x10,	//*+42
	0x00,0x05,0x06,0x00,0x00,0x10,0x10,0x10,0x10,0x10,	//,-44
	0x00,0x06,0x06,0x00,0x00,0x04,0x08,0x10,0x20,0x40,	//./46
	0x7C,0x8A,0x92,0xA2,0x7C,0x00,0x42,0xFE,0x02,0x00,	//0148
	0x42,0x86,0x8A,0x92,0x62,0x84,0x82,0xA2,0xD2,0x8C,	//2350
	0x18,0x28,0x48,0xFE,0x08,0xE4,0xA2,0xA2,0xA2,0x9C,	//4552
	0x3C,0x52,0x92,0x92,0x0C,0xC0,0x80,0x8E,0x90,0xE0,	//6754
	0x6C,0x92,0x92,0x92,0x6C,0x60,0x92,0x92,0x94,0x78,	//8956
	0x00,0x6C,0x6C,0x00,0x00,0x00,0x6A,0x6C,0x00,0x00,	//:;58
	0x10,0x28,0x44,0x82,0x00,0x28,0x28,0x28,0x28,0x28,	//<=60
	0x00,0x82,0x44,0x28,0x10,0x40,0x80,0x8A,0x90,0x60,	//>?62
	0x4C,0x92,0x9E,0x82,0x7C,0x7E,0x88,0x88,0x88,0x7E,	//@A64
	0xFE,0x92,0x92,0x92,0x6C,0x7C,0x82,0x82,0x82,0x44,	//BC66
	0xFE,0x82,0x82,0x44,0x38,0xFE,0x92,0x92,0x92,0x82,	//DE68
	0xFE,0x90,0x90,0x90,0x80,0x7C,0x82,0x92,0x92,0x5E,	//FG70
	0xFE,0x10,0x10,0x10,0xFE,0x00,0x82,0xFE,0x82,0x00,	//HI72
	0x04,0x02,0x82,0xFC,0x80,0xFE,0x10,0x28,0x44,0x82,	//JK74
	0xFE,0x02,0x02,0x02,0x02,0xFE,0x40,0x30,0x40,0xFE,	//LM76
	0xFE,0x20,0x10,0x08,0xFE,0x7C,0x82,0x82,0x82,0x7C,	//NO78
	0xFE,0x90,0x90,0x90,0x60,0x7C,0x82,0x8A,0x84,0x7A,	//PQ80
	0xFE,0x90,0x98,0x94,0x62,0x62,0x92,0x92,0x92,0x8C,	//RS82
	0x80,0x80,0xFE,0x80,0x80,0xFC,0x02,0x02,0x02,0xFC,	//TU84
	0xF8,0x04,0x02,0x04,0xF8,0xFC,0x02,0x1C,0x02,0xFC,	//VW86
	0xC6,0x28,0x10,0x28,0xC6,0xE0,0x10,0x0E,0x10,0xE0,	//XY88
	0x86,0x8A,0x92,0xA2,0xC2,0xFE,0x82,0x82,0x00,0x00,	//Z[90
	0xA8,0x68,0x3E,0x68,0xA8,0x00,0x82,0x82,0xFE,0x00,	//\]92
	0x20,0x40,0x80,0x40,0x20,0x02,0x02,0x02,0x02,0x00,	//^_94
	0x00,0x60,0x90,0x60,0x00,0x04,0x2A,0x2A,0x2A,0x1E,	//`a96
	0xFE,0x12,0x22,0x22,0x1C,0x1C,0x22,0x22,0x22,0x04,	//bc98
	0x1C,0x22,0x22,0x12,0xFE,0x1C,0x2A,0x2A,0x2A,0x18,	//de100
	0x10,0x7E,0x90,0x80,0x40,0x30,0x4A,0x4A,0x4A,0x7C,	//fg102
	0xFE,0x10,0x20,0x20,0x1E,0x00,0x22,0xBE,0x02,0x00,	//hi104
	0x04,0x02,0x22,0xBC,0x00,0xFE,0x08,0x14,0x22,0x00,	//jk106
	0x00,0x82,0xFE,0x02,0x00,0x3E,0x20,0x18,0x20,0x1E,	//lm108
	0x3E,0x10,0x20,0x20,0x1E,0x1C,0x22,0x22,0x22,0x1C,	//no110
	0x3E,0x28,0x28,0x28,0x10,0x10,0x28,0x28,0x18,0x3E,	//pq112
	0x3E,0x10,0x20,0x20,0x10,0x12,0x2A,0x2A,0x2A,0x04,	//rs114
	0x20,0xFC,0x22,0x02,0x04,0x3C,0x02,0x02,0x04,0x3E,	//tu116
	0x38,0x04,0x02,0x04,0x38,0x3C,0x02,0x1C,0x02,0x3C,	//vw118
	0x22,0x14,0x08,0x14,0x22,0x30,0x0A,0x0A,0x0A,0x3C,	//xy120
	0x22,0x26,0x2A,0x32,0x22,0x00,0x10,0x6C,0x82,0x00,	//z{122
	0x00,0x00,0xFE,0x00,0x00,0x00,0x82,0x6C,0x10,0x00,	//|}124
	0x10,0x10,0x54,0x38,0x10,0x10,0x38,0x54,0x10,0x10,	//~126
	0x7E,0x88,0x88,0x88,0x7E,0xFE,0x92,0x92,0x92,0xCC,	//128
	0xFE,0x92,0x92,0x92,0x6C,0xFE,0x80,0x80,0x80,0xC0,	//129
	0x07,0x8A,0xF2,0x82,0xFF,0xFE,0x92,0x92,0x92,0x82,	//130
	0xEE,0x10,0xFE,0x10,0xEE,0x82,0x92,0x92,0x92,0x7C,	//132
	0xFE,0x08,0x10,0x20,0xFE,0x3E,0x84,0x48,0x90,0x3E,	//134
	0xFE,0x10,0x28,0x44,0x82,0x04,0x82,0xFC,0x80,0xFE,	//136
	0xFE,0x40,0x30,0x40,0xFE,0xFE,0x10,0x10,0x10,0xFE,	//138
	0x7C,0x82,0x82,0x82,0x7C,0xFE,0x80,0x80,0x80,0xFE,	//140
	0xFE,0x90,0x90,0x90,0x60,0x7C,0x82,0x82,0x82,0x44,	//142
	0x80,0x80,0xFE,0x80,0x80,0xE2,0x14,0x08,0x10,0xE0,	//144
	0x38,0x44,0xFE,0x44,0x38,0xC6,0x28,0x10,0x28,0xC6,	//146
	0xFC,0x04,0x04,0x04,0xFE,0xE0,0x10,0x10,0x10,0xFE,	//148
	0xFE,0x02,0xFE,0x02,0xFE,0xFC,0x04,0xFC,0x04,0xFE,	//150
	0x80,0xFE,0x12,0x12,0x0C,0xFE,0x12,0x0C,0x00,0xFE,	//152
	0xFE,0x12,0x12,0x12,0x0C,0x44,0x82,0x92,0x92,0x7C,	//154
	0xFE,0x10,0x7C,0x82,0x7C,0x62,0x94,0x98,0x90,0xFE,	//156
	0x04,0x2A,0x2A,0x2A,0x1E,0x3C,0x52,0x52,0x92,0x8C,	//158
	0x3E,0x2A,0x2A,0x2A,0x14,0x3E,0x20,0x20,0x20,0x30,	//160
	0x27,0x2A,0x32,0x22,0x3F,0x1C,0x2A,0x2A,0x2A,0x18,	//162
	0x36,0x08,0x3E,0x08,0x36,0x22,0x22,0x2A,0x2A,0x14,	//164
	0x3E,0x04,0x08,0x10,0x3E,0x1E,0x42,0x24,0x48,0x1E,	//166
	0x3E,0x08,0x14,0x22,0x00,0x04,0x22,0x3C,0x20,0x3E,	//168
	0x3E,0x10,0x08,0x10,0x3E,0x3E,0x08,0x08,0x08,0x3E,	//170
	0x1C,0x22,0x22,0x22,0x1C,0x3E,0x20,0x20,0x20,0x3E,	//172
	0x3E,0x28,0x28,0x28,0x10,0x1C,0x22,0x22,0x22,0x04,	//174
	0x20,0x20,0x3E,0x20,0x20,0x30,0x0A,0x0A,0x0A,0x3C,	//176
	0x18,0x24,0x7E,0x24,0x18,0x22,0x14,0x08,0x14,0x22,	//178
	0x3C,0x04,0x04,0x04,0x3E,0x30,0x08,0x08,0x08,0x3E,	//180
	0x3E,0x02,0x3E,0x02,0x3E,0x3E,0x02,0x3E,0x02,0x3F,	//182
	0x20,0x3E,0x0A,0x0A,0x04,0x3E,0x0A,0x04,0x00,0x3E,	//184
	0x3E,0x0A,0x0A,0x04,0x00,0x14,0x22,0x2A,0x2A,0x1C,	//186
	0x3E,0x08,0x1C,0x22,0x1C,0x10,0x2A,0x2C,0x28,0x3E	//188
};			
							
//	159	  160
//	167	 	130
//	171	   161
//	177	- 
//	180	
//	179	-  139
//	184	  163
//	186	
//	185	  133
//	129	0
//	135	  144
//	139	
//	145	
//	148	  153
//	147	
//	152	
//	154	  154
//	153	

char DSReadingMap [] PROGMEM = {
	0x0D,0x33,0x00,0x0D,0xCC,0xBE,0x01,0x02,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x0B,
	0x0D,0x33,0x04,0x0D,0xCC,0xBE,0x05,0x06,0x0C,0x0C,0x07,0x0C,0x0C,0x0C,0x0C,0x0E,
	0x0D,0xCC,0x44,0x0F
};


//-----------------------------------------------------------------------------------------------------------------------
 void MainInit (void)
{

	#define LedBoardRowPORT 	PORTD				
	#define LedBoardRowDDR 		DDRD				
	#define LedBoardDataPORT 	PORTB				
	#define LedBoardDataDDR 	DDRB				
	#define LedBoardData 		(1<<6)				
	#define LedBoardClc 		(1<<7)				
	#define LedBoardStrobe 		(1<<5)				
	#define LedBoardOn	 		(1<<4)				
	//-------------- Pitty eleje
	#define PittyDDR			DDRB
	#define PittyPORT			PORTB
	#define	PittyPin			(1<<3)				
	PittyDDR|=PittyPin;								
	//-------------- Pitty vge

	LedBoardRowDDR = 0xFF;							
	LedBoardDataDDR |= LedBoardData|LedBoardClc		
	|LedBoardStrobe|LedBoardOn;

	#define BtnPORT 			PORTC				
	#define BtnDDR 				DDRC				
	#define BtnPIN 				PINC				
	#define Button1				(1<<2)				
	#define Button2				(1<<3)				
	#define Button3				(1<<4)				
	#define Button4				(1<<5)				

	BtnPORT |= Button1|Button2|Button3|Button4;		


	#define IICDDR				DDRC				
	#define IICPORT				PORTC				
	#define IICPIN				PINC				
	#define IICData				(1<<0)				
	#define IICClc				(1<<1)				


	#define OneWireDDR			DDRB				
	#define OneWirePORT			PORTB				
	#define OneWirePIN			PINB				
	#define OneWireLine1 		(1<<0)				
	#define OneWireLine2 		(1<<1)				


	DDRB  |= 0x0c;								

	
	TIMSK2 = (1 << OCIE2A);	 							
	TCCR2A = (1<<WGM21);								
	TCCR2B = (1<<CS22) | (1 << CS21);								
	OCR2A  = 38;									

	#define Fenyero		OCR1B
	TCCR1A=(1<<COM1B1)|(1<<WGM10);	
	TCCR1B=(1<<WGM12)|(1<<CS10);				
	Fenyero=240;
	DDRB|=(1<<PB2);

	Flags1 = 0;									
	BtnFlags = 0;

	sei ();										

	LedBoardDataPORT |= LedBoardOn;				
	Flags1 |= b1ClockReadEnable;				
	
}


typedef enum 
{
	MENU=0,
	SET_TIME,
	SET_DATE,
	SET_BRIGHT,
	NEED_TEMP_IN,
	NEED_TEMP_OUT,
	NEED_DATE,
	NO_MENU,
} MENU_STATE;

typedef enum 
{
	NORMAL=0,
	SET_MENU,
} STATE;

typedef enum 
{
	NO_TIME=0,
	HOUR,
	MIN,
	SEC,
} TIME_STATE;


typedef enum 
{
	NO_DATE=0,
	YEAR,
	MONTH,
	DAY,
} DATE_STATE;

typedef enum 
{
	TEMP_IN=0,
	TEMP_OUT,
} TEMP_MEASURE;

typedef enum 
{
	WELLCOME1=0,
	WELLCOME2,
	WELLCOME3,
} WELLCOME;

WELLCOME wellcome_num = WELLCOME1;

STATE state=NORMAL;
MENU_STATE menu_state = MENU;
TIME_STATE time_state = NO_TIME;
DATE_STATE date_state = NO_DATE;

char Need_temp_in 	= 1;
char Need_temp_out 	= 1;
char Need_date 		= 0;
char bright_state	= 1;
