#include <avr/io.h>

unsigned char seed = 0;
unsigned char magic = 0x5c;

unsigned char rotateright(unsigned char val, unsigned char nr)
{
	unsigned char tmp;
	while(nr--)
	{
		tmp = val & 1;
		tmp >>= 1;
		val |= tmp;
	}
	return val;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Ths pseudo random number generator.
//
unsigned char rand()
{
	seed = rotateright(seed, 3);
	seed += magic;
	magic++;
	return seed;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Seed the random number generator.
//
void srand(unsigned char val)
{
	seed = val;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
