#include "xprintf.h"
#include "random.h"
#include <string.h>
#include "string.h"
#include <avr/eeprom.h>
#include "demos.h"

char buffer[50];

void LedBoardSimbPrint (unsigned char simbol, unsigned char position)
{
	if (position > (LedBoardSize+1))
		return;

	char* pPosition = position * LedBoardSimbWidth + LedBoardBuffer;
	
	if (simbol < 0x20)
		simbol = 0x20;
		
	//if (simbol >= 0xc0)
	//	simbol -= 0x40;

	char *pSimbol = (simbol - 0x20) * FontSimbWidth + SimbMass;		
	char change = 0;
	for (char i=0; i<FontSimbWidth; i++)							
	{
		if(menu_state  < NO_MENU) Under_Line(&change,position);
		
		*pPosition++ = pgm_read_byte (pSimbol++)|change;
	}
	for (char i=0; i<(LedBoardSimbWidth-FontSimbWidth); i++)		
		*pPosition++ = 0;
}

void Under_Line(char *under_line,unsigned char position)
{
	//*under_line = 0;
	if((date_state == YEAR) && (position < 3))
	{
		*under_line=1; 
	} else 
	{	
		if((date_state == MONTH) && ((position == 4) || (position == 5)))
		{
			*under_line=1; 
		} else
		{
			if((date_state == DAY) && ((position == 7) || (position == 8)))
			{
				*under_line=1;
			}
		}
	}
	if((time_state == HOUR) && ((position == 1) || (position == 2)))
	{
		*under_line=1; 
	} else 
	{	
		if((time_state == MIN) && ((position == 4) || (position == 5)))
		{
			*under_line=1; 
		} else
		{
			if((time_state == SEC) && ((position == 7) || (position == 8)))
			{
				*under_line=1;
			}
		}
	}
	if((menu_state == NEED_TEMP_IN) && (Need_temp_in == 1) && (position == 5))
	{
		*under_line=1;
	} else
	if((menu_state == NEED_TEMP_IN) && (Need_temp_in == 0) && (position == 7))
	{
		*under_line=1;
	} else
	if((menu_state == NEED_TEMP_OUT) && (Need_temp_out == 1) && (position == 5))
	{
		*under_line=1;
	} else
	if((menu_state == NEED_TEMP_OUT) && (Need_temp_out == 0) && (position == 7))
	{
		*under_line=1;
	} else
	if((menu_state == NEED_DATE) && (Need_date == 1) && (position == 6))
	{
		*under_line=1;
	} else
	if((menu_state == NEED_DATE) && (Need_date == 0) && (position == 8))
	{
		*under_line=1;
	}
	if((menu_state == POINT_STYLE) && (Point_style+4 == position))
	{
		*under_line=1;
	}
}


//-----------------------------------------------------------------------------------------------------------------------

void LedBoardMessageShow (char *pAdrTxt)
{
	unsigned char position = 1;
	while (1){
		if (position > LedBoardSize)
			return;											
		char byte = pgm_read_byte (pAdrTxt++);
		if (! byte)
			return;											
		LedBoardSimbPrint (byte, position++);				
	} 
}

void LedBoardMessageShow_no_PGM (char *pAdrTxt)
{
	unsigned char position = 1;
	while (1){
		if (position > LedBoardSize)
			return;											
		char byte = *pAdrTxt++;
		if (! byte)
			return;											
		LedBoardSimbPrint (byte, position++);				
	} 
}


//-----------------------------------------------------------------------------------------------------------------------

void LedBoardMessageScrollLeft (char *pAdrTxt)
{
	while (1){
		char byte = pgm_read_byte (pAdrTxt++);
		if (! byte)											
			return;

		LedBoardSimbPrint (byte, LedBoardSize+1);			

		for (char i=0; i<LedBoardSimbWidth; i++)			
			LedBoard1PixScrollLeft ();	
	}
}

void LedBoard1PixScrollLeft (void)
{
	unsigned char speed = 100/LedBoardHorScrollSpeed;			
	for (char z=0; z<speed; z++){	
		while (! (Flags1 & b1LedBoardPageCompleted)){}			
		Flags1 &= ~b1LedBoardPageCompleted;						
	}

	char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth;			
	char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+1;		
	unsigned char Length = (LedBoardSize+1)*LedBoardSimbWidth-1;
	for (char z=0; z<Length; z++)								
		*pLineBuf1++ = *pLineBuf2++;
	*pLineBuf1 = 0;

	if (ClockPosition)										
		ClockPosition--;
}


void LedBoardClearScrollLeft (void)
{
	LedBoardSimbPrint (' ', LedBoardSize+1);
	unsigned char Length = LedBoardSize * LedBoardSimbWidth;
	for (char i=0; i<Length; i++)
		LedBoard1PixScrollLeft ();	
}


//-----------------------------------------------------------------------------------------------------------------------


char TxtError	[] PROGMEM = "   ERROR";

void LedBoardTermoShow (char Position, uint8_t NumDev)
{
	if (OneWireErr & (1<<NumDev))
		LedBoardMessageShow (TxtError);							
	else{
		LedBoardSimbPrint (' ', Position);						
		LedBoardIntPrint(OneWireTermoData[NumDev],Position+1, 5, 1);
		if ((Position+6) <= (LedBoardSize+1))
			LedBoardSimbPrint ('`', Position+6);
		if ((Position+7) <= (LedBoardSize+1))
			LedBoardSimbPrint ('C', Position+7);
	}
}


void LedBoardTermoScrollLeft (uint8_t NumDev)
{
	if (OneWireErr & (1<<NumDev))
		LedBoardMessageScrollLeft (TxtError);					
	else{
		for (char i=9; i>1; i--){								
			LedBoardTermoShow (i, NumDev);						
			for (char x=0; x<LedBoardSimbWidth; x++)			
				LedBoard1PixScrollLeft ();	
		}
	}
}


//----------------------------------------------------------------------------------------------
void LedBoardClockShow (uint8_t Position)
{
	if ((Position > 0) && (Position <= LedBoardSize+1))
		ClockPosition = (Position +7) * LedBoardSimbWidth;
}


//----------------------------------------------------------------------------------------------
void LedBoardClockScrollLeft (void)
{
	LedBoardClockShow (9);
	LedBoardClearScrollLeft ();
}


//-----------------------------------------------------------------------------------------------------------------------
NOINLINE void Delay (unsigned char second)
{
	for (unsigned char i=0; i<second; i++)		
		_delay_ms (1000);
}


//-----------------------------------------------------------------------------------------------------------------------
void LedBoardIntPrint (signed int integer, uint8_t IntPos, uint8_t IntLength, uint8_t DotPosition)
{												
	char IntBuf [IntLength];					
	char* pIntBuf = IntBuf+IntLength-1; 		
	uint8_t DigitCoun = 0;						

	uint8_t negative = 0;						
	if (integer < 0){							
		integer ^= 0xffff;
		integer++;
		negative = 1;									
	}

	for (uint8_t i=0; i<IntLength; i++){		
		*pIntBuf-- = integer %10+0x30;			
		integer /= 10;							
		DigitCoun ++;
		if (! integer)
			break;
	}
			
	if (DotPosition){							
		while (DotPosition > DigitCoun){		
			*pIntBuf-- = 0x30;				
			DigitCoun++;
		}
												
		if (DotPosition == DigitCoun){			
			*pIntBuf-- = '.'; 
			*pIntBuf-- = 0x30;	
			DigitCoun += 2;
			goto m1;
		} 
		
		// if (DotPos < DigitCoun) 				
		char *pMoveCntr = pIntBuf--;			
		char MoveVal = DigitCoun-DotPosition;	
		for (char i=0; i<MoveVal; i++){
			char temp = *(pMoveCntr+1);
			*pMoveCntr++ = temp;
		}

		*pMoveCntr = '.';						
		DigitCoun++;
	}

m1:	if (negative){								
		*pIntBuf-- = '-'; 
		DigitCoun++;
	}

	while (DigitCoun++ < IntLength)				
		*pIntBuf-- = 0x20;

	for (uint8_t i=0; i<IntLength; i++){		
		if ((IntPos+i) <= (LedBoardSize+1))
			LedBoardSimbPrint (IntBuf [i], IntPos+i);
	}
}


//#######################################################################################################################
//#
//#	1 WIRE
//#
//#######################################################################################################################

void OneWireReset (char mask)
{
	OneWireDDR |= (mask);						
	_delay_us (480);

	OneWireDDR &= ~(mask);						
	_delay_us (480); 
}


//-----------------------------------------------------------------------------------------------------------------------
unsigned char OneWireData (unsigned char OutByte, char mask)
{
	char InByte =0;								

	for (unsigned char i = 0; i<8; i++){
		
		InByte >>= 1;
		cli ();
		OneWireDDR |= mask;						
		if (OutByte & 0x01){
			
			_delay_us (5);				
			OneWireDDR &= ~mask;				
			_delay_us (5);
	
			if (OneWirePIN & mask)				
				InByte |= 0x80;					
			sei ();

			_delay_us (70);
		}
		else{
			
			_delay_us (75);				
			OneWireDDR &= ~mask;				
			sei ();
			_delay_us (5);
		}

		OutByte >>= 1;
	}
	CheckSumm (InByte);							
	return InByte;
}


//-----------------------------------------------------------------------------------------------------------------------

void CheckSumm(char data)
{
	for (char i=0; i<8; i++){
		char temp = data;
		temp ^= OneWireCheckSumm;

		if (temp & 0x01){
			OneWireCheckSumm ^= 0x18;
			temp = 0x80;
		}
		else
			temp = 0;

		OneWireCheckSumm >>= 1;
		OneWireCheckSumm |= temp;
		data >>= 1;
	}
}


//#######################################################################################################################
//#
//#	I2C RTC (DS1307)
//#
//#######################################################################################################################
void IICClockReadData (void)
{
	IICStart();
	IICByteWrite (0xD0);						
	IICByteWrite (0x00);						

	IICStart();
	IICByteWrite (0xD1);						

	char temp;									
	char Accumulate = 0;						
	char NumBit = (1<<0);						
	char* pClockData = ClockData;				

	for (char i = 0; i<6; i++){					
		temp = IICByteRead (0);					

		if (i == 0){							
			if (temp != *pClockData){	
				Flags1 |= b1ClockChange;		
				ClockMiliSecond = 0;			
			}
		}

		if (i < 3){								
			if ((temp & 0x0F) != (*pClockData & 0x0F))
				Accumulate |= NumBit;
			NumBit <<= 1;
			if ((temp & 0xF0) != (*pClockData & 0xF0))
				Accumulate |= NumBit;
			NumBit <<= 1;
		}

		*pClockData++ = temp;					
	}
	*pClockData = IICByteRead (1);				
	IICStop(); 

	ClockChangeMask |= Accumulate;				
}


void IICClockWriteData (void)
{
	IICStart();
	IICByteWrite (0xD0);					
	IICByteWrite (0x00);					

	for (unsigned char i = 0; i<7; i++)
		IICByteWrite (ClockData [i]);		

	IICStop();
}


char ConvBinDecToHex (char byte)
{				
	char result = 10 * (byte >> 4);
	result += (byte & 0x0f);
	return result; 
}


char ConvHexToBinDec (char byte){
	char result = byte %10;
	result |= ((byte/10) << 4);
	return result; 
}


//#######################################################################################################################
//#
//# I2C coomunication
//#
//#######################################################################################################################
NOINLINE void Delay2Mks (void)
{
	_delay_us (2);
}

void IICStart (void)
{
	IICDDR &= ~(IICData | IICClc);
	Delay2Mks();

	IICDDR |= IICData;							
	Delay2Mks();

	IICDDR |= IICClc;							
	Delay2Mks();			
}

void IICStop (void)
{
	IICDDR |= (IICData | IICClc);
	Delay2Mks();

	IICDDR &= ~IICClc;							
	Delay2Mks();

	IICDDR &= ~IICData;							
	Delay2Mks();			
}

char IICByteWrite (char byte)
{
	for (char i = 0; i<8; i++)
		byte = IICBit (byte);

	byte = 0x80;								
	return IICBit (byte);						
}


char IICByteRead (char bit)
{
	char byte = 0xFF;
	for (char i = 0; i<8; i++)
		byte = IICBit (byte);

	bit <<= 7;
	IICBit (bit);								
	return byte;								
}


char IICBit (char byte)						
{
	if (byte & 0x80)						
		IICDDR &= ~IICData; 				
	else 
		IICDDR |= IICData;					
	Delay2Mks();

	IICDDR &= ~IICClc;						
	while (! (IICPIN & IICClc)){}			
	Delay2Mks();

	char temp;	
	if (IICPIN & IICData)					
		temp = 1;
	else
		temp = 0;
	IICDDR |= IICClc;						

	byte <<= 1;
	byte |= temp;
	return byte;
}

//-----------------------------------------------------------------------------------------------------------------

void speed_step(unsigned char speed)
{
	//unsigned char speed = 100/(LedBoardHorScrollSpeed*szorzo);	
	
	for (char z=0; z<speed; z++)
	{	
		while (! (Flags1 & b1LedBoardPageCompleted)){}		
		Flags1 &= ~b1LedBoardPageCompleted;					
	}
}


void Sajat_SimbPrint (unsigned char simbol, unsigned char position)
{
	if (position > (LedBoardSize+1))
		return;

	char* pPosition = position * LedBoardSimbWidth + puffer_GraphBuf; 
	
	if (simbol < 0x20)
		simbol = 0x20;
	if (simbol >= 0xc0)
		simbol -= 0x40;
	char *pSimbol = (simbol - 0x20) * FontSimbWidth + SimbMass;		
	
	for (char i=0; i < FontSimbWidth; i++)							
	{
		*pPosition++ = pgm_read_byte (pSimbol++);
	}
}

void horizontal_kiir(char h_mode)
{
	//					kiir
	
	unsigned char hl=240,hr=15;
	switch(h_mode)
	{
		case 0 :
		{
			hl=170,hr=85;
			break;
		}
		case 1 :
		{
			hl=240,hr=15;
			break;
		}
		case 2 :
		{
			hl=15,hr=240;
			break;
		}
	}
	//jobbrl-balra(7,6,5,4 bitek -> 128,64,32,16=240)
	char* pGL = puffer_GraphBuf;
	char* pLBL = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
	//balrl-jobbra(3,2,1,0 bitek -> 8,4,2,1=15)
	char* pGR = puffer_GraphBuf+(LedBoardSize)*LedBoardSimbWidth-1;
	char* pLBR = LedBoardBuffer+LedBoardSimbWidth;
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	for(char i=0;i < Length+1; i++)
	{
		speed_step(2);
		char* pLineBuf1L = LedBoardBuffer+LedBoardSimbWidth;			
		char* pLineBuf2L = LedBoardBuffer+LedBoardSimbWidth+1;	

		char* pLineBuf1R = LedBoardBuffer+LedBoardSimbWidth+Length;			
		char* pLineBuf2R = LedBoardBuffer+LedBoardSimbWidth+Length-1;			
			
		for (char z=0; z < Length+1; z++)	
		{							
			(*pLineBuf1L)&=~hl;
			(*pLineBuf1L++)|=(*pLineBuf2L++)&hl;
			(*pLineBuf1R)&=~hr;
			(*pLineBuf1R--)|=(*pLineBuf2R--)&hr;
		}
		(*pLBL)=(*pGL++)&hl;
		
		(*pLBR)=(*pGR--)&hr;
	}
	(*pLBR)=(*++pGR);
} 

void horizontal_torol(char h_mode)
{
	//					Torol
	//jobbrl-balra(7,6,5,4 bitek -> 128,64,32,16=240)
	unsigned char hl=240,hr=15;
	switch(h_mode)
	{
		case 0 :
		{
			hl=170,hr=85;
			break;
		}
		case 1 :
		{
			hl=240,hr=15;
			break;
		}
		case 2 :
		{
			hl=15,hr=240;
			break;
		}
	}
	
	char* pLBL = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
	//balrl-jobbra(3,2,1,0 bitek -> 8,4,2,1=15)
	
	char* pLBR = LedBoardBuffer+LedBoardSimbWidth;
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	for(char i=0;i < Length+1; i++)
	{
		speed_step(2);
		char* pLineBuf1L = LedBoardBuffer+LedBoardSimbWidth;			
		char* pLineBuf2L = LedBoardBuffer+LedBoardSimbWidth+1;	

		char* pLineBuf1R = LedBoardBuffer+LedBoardSimbWidth+Length;			
		char* pLineBuf2R = LedBoardBuffer+LedBoardSimbWidth+Length-1;			
			
		for (char z=0; z < Length+1; z++)	
		{							
			(*pLineBuf1L)&=~hl;
			(*pLineBuf1L++)|=(*pLineBuf2L++)&hl;
			(*pLineBuf1R)&=~hr;
			(*pLineBuf1R--)|=(*pLineBuf2R--)&hr;
		}
		(*pLBL)&=~hl;
		
		(*pLBR)&=~hr;
	}
} 

void rotor_clear_right()
{
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	char *pSimbol = Rotor_Buff;		
	char* pLB = LedBoardBuffer+LedBoardSimbWidth;
	char c;
	char* pG = puffer_GraphBuf;
	for(unsigned char b=0;b < Length+1; b++)
		*pG++=*pLB;
	
	for(unsigned char b=0;b < 16; b++)
	{
		//char* pLB = LedBoardBuffer+LedBoardSimbWidth;
			
		for(unsigned char o=0;o < 6; o++)
		{	
			c=pgm_read_byte (pSimbol++);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=c;
			}	
			
			speed_step(1);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]^=c;
			}
		
			//speed_step(1);
			for(unsigned char i=0;i < 8; i++)
			{	
				char v=c&puffer_GraphBuf[o+i*6];	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]&=~v;
			}
			//speed_step(1);
		}
	}
}

void rotor_clear_left()
{
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	char* pLB = LedBoardBuffer+LedBoardSimbWidth;
	char *pSimbol = Rotor_Buff;	
	char c;
	char* pG = puffer_GraphBuf;
	for(unsigned char b=0;b < Length+1; b++)
		*pG++=*pLB;
	
	for(unsigned char b=0;b < 16; b++)
	{		
		for(unsigned char o=0;o < 6; o++)
		{	
			c=pgm_read_byte (&Rotor_Buff[15-b][o]);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=c;
			}	
			
			speed_step(1);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]^=c;
			}
		
			//speed_step(1);
			for(unsigned char i=0;i < 8; i++)
			{	
				char v=c&puffer_GraphBuf[o+i*6];	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]&=~v;
			}
			//speed_step(1);
		}
	}
}

void rotor_clear(char right)
{
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	char* pLB = LedBoardBuffer+LedBoardSimbWidth;
	char c;
	char* pG = puffer_GraphBuf;
	for(unsigned char b=0;b < Length+1; b++)
		*pG++=*pLB;
	
	for(unsigned char b=0;b < 16; b++)
	{		
		for(unsigned char o=0;o < 6; o++)
		{	
			if(right) c=pgm_read_byte (&Rotor_Buff[b][o]); else c=pgm_read_byte (&Rotor_Buff[15-b][o]);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=c;
			}	
			
			speed_step(1);
			
			for(unsigned char i=0;i < 8; i++)
			{	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]^=c;
			}
		
			//speed_step(1);
			for(unsigned char i=0;i < 8; i++)
			{	
				char v=c&puffer_GraphBuf[o+i*6];	
				LedBoardBuffer[LedBoardSimbWidth+o+i*6]&=~v;
			}
			//speed_step(1);
		}
	}
}

static void Magic_Write(char *pAdrTxt,PRINT_MODE pr_mode )
{
	ClockPosition=0;
	unsigned char position = 0;
	while (1)
	{
		if (position > LedBoardSize)
			return;											
		char byte = *pAdrTxt++;
		if (! byte)
			break;				
		Sajat_SimbPrint (byte, position++);				
	} 

	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	switch(pr_mode)
	{
		case HORIZONTAL_TO_LEFT : //balra halad
		{	
			char* pG = puffer_GraphBuf;
			char* pLB = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
			for(char i=0;i < Length+1; i++)
			{
				
				speed_step(2);
				char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth;			
				char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+1;		
				
				for (char z=0; z < Length; z++)								
					*pLineBuf1++ = *pLineBuf2++;
				*pLB = *pG++;
			}
			break;
		}
		case HORIZONTAL_TO_RIGHT :	//jobbra halad
		{
			char* pG = puffer_GraphBuf+(LedBoardSize)*LedBoardSimbWidth-1;
			char* pLB = LedBoardBuffer+LedBoardSimbWidth;
			for(char i=0;i < Length+1; i++)
			{
				speed_step(2);
				
				char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth+Length;			
				char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+Length-1;			
				for (char z=0; z < Length; z++)								
					*pLineBuf1-- = *pLineBuf2--;
				*pLB = *pG--;
			}	
			break;
		}
		case HORIZONTAL_FROM_MID :
		{
			char* pGL  = puffer_GraphBuf;
			char* pGR  = puffer_GraphBuf+(LedBoardSize)*LedBoardSimbWidth-1;
			char* pLBL = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-1;
			char* pLBR = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2;
			
			for(char i=0;i < ((Length+1)/2); i++)
			{
				speed_step(2);
				char* pLineBuf1L = LedBoardBuffer+LedBoardSimbWidth;
				char* pLineBuf2L = LedBoardBuffer+LedBoardSimbWidth+1;
				
				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1L++ = *pLineBuf2L++;
				*pLBL = *pGL++;

				char* pLineBuf1R = LedBoardBuffer+LedBoardSimbWidth+Length;			
				char* pLineBuf2R = LedBoardBuffer+LedBoardSimbWidth+Length-1;

				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1R-- = *pLineBuf2R--;
				*pLBR = *pGR--;
			}	
			break;
		}
		case HORIZONTAL_TO_MID :
		{
			char* pGL = puffer_GraphBuf+(LedBoardSize*LedBoardSimbWidth)/2;
			char* pGR = puffer_GraphBuf+(LedBoardSize*LedBoardSimbWidth)/2-1;
			char* pLBR = LedBoardBuffer+LedBoardSimbWidth;
			char* pLBL = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
			for(char i=0;i < ((Length+1)/2); i++)
			{
				speed_step(2);
				char* pLineBuf1L = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2;		
				char* pLineBuf2L = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2+1;	
				
				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1L++ = *pLineBuf2L++;
				*pLBL = *pGL++;

				char* pLineBuf1R = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-1;
				char* pLineBuf2R = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-2;

				for (char z=0; z < ((Length+1)/2)-1; z++)								
					*pLineBuf1R-- = *pLineBuf2R--;
				*pLBR = *pGR--;
			}	
			break;
		}
		case HORIZONTAL_HALF0:
		{
			horizontal_kiir(0);
			break;
		}
		case HORIZONTAL_HALF1:
		{
			horizontal_kiir(1);
			break;
		}
		case HORIZONTAL_HALF2:
		{
			horizontal_kiir(2);
			break;
		}
		case VERTICAL_TO_BOTTOM :		//fentrl->le
		{
					
			for(unsigned char bit=7;bit > 0; bit--)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				speed_step(4);
				
				for(unsigned char x=0;x < Length+1; x++)
				{
					*pLB>>=1;
					if(*pG++&(1 << (8-bit)))
					{
						*pLB|=128;
					}
					*pLB++;
				}
				
			}
			break;
		}
		case VERTICAL_TO_TOP :
		{
			for(unsigned char bit=0;bit < 7; bit++)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(*pG++&(1 << (7-bit)))
					{
						*pLB|=1;
					}
					*pLB++<<=1;
				}
			}
			break;
		}
		case VERTICAL_FROM_MID :
		{
			for(unsigned char bit=0;bit < 4; bit++)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				speed_step(6);
				
				for(unsigned char x=0;x < Length+1; x++)
				{
					unsigned char b=((*pLB & 15)/2)+((*pLB & 240)*2);
					*pLB=b;
					if(*pG&(1 << (7-bit)))
					{
						*pLB|=16;
					} else *pLB&=~16;
					if(*pG++&(1 << (bit)))
					{
						*pLB|=8;
					}  else *pLB&=~8;
					*pLB++;
				}
			}

			break;
		}
		case VERTICAL_TO_MID :
		{
			for(char y=4;y > 0; y--)
			{
				char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth;			
				char* pLineBuf2 = puffer_GraphBuf;
				speed_step(6);
				for(char x=0;x < Length+1; x++)
				{
					*pLineBuf1|=(*pLineBuf2)&(1 << (4-y));
					*pLineBuf1++|=(*pLineBuf2++)&(1 << (3+y));
				}
			}
			break;
		}
		case VERTICAL_HALF0:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				//					kiir
				//lentrl felfel
				char* pLB_TO_TOP = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				char* pLB_TO_BOTTOM = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if((x%2))
					{
						*pLB_TO_TOP<<=1;
						if((*pG++)&(1 << (7-bit)))	//7,6,5,4,3,2,1,0
						{
							*pLB_TO_TOP|=1;
						}
						
					} else
					{
						
						*pLB_TO_BOTTOM>>=1;
						if((*pG++)&(1 << bit))	//0,1,2,3,4,5,6,7
						{
							*pLB_TO_BOTTOM|=128;
						}
					}	
					*pLB_TO_TOP++;
					*pLB_TO_BOTTOM++;
				}
			}
			break;
		}
		case VERTICAL_HALF1:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				//					kiir
				//lentrl felfel
				char* pLB_TO_TOP = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				char* pLB_TO_BOTTOM = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(x < Length/2)
					{
						*pLB_TO_TOP<<=1;
						if((*pG++)&(1 << (7-bit)))	//7,6,5,4,3,2,1,0
						{
							*pLB_TO_TOP|=1;
						}
						
					} else
					{
						
						*pLB_TO_BOTTOM>>=1;
						if((*pG++)&(1 << bit))	//0,1,2,3,4,5,6,7
						{
							*pLB_TO_BOTTOM|=128;
						}
					}	
					*pLB_TO_TOP++;
					*pLB_TO_BOTTOM++;
				}
			}
			break;
		}
		case VERTICAL_HALF2:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				//					kiir
				//lentrl felfel
				char* pLB_TO_TOP = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				char* pLB_TO_BOTTOM = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(x >= Length/2)
					{
						*pLB_TO_TOP<<=1;
						if((*pG++)&(1 << (7-bit)))	//6,5,4,3,2,1,0
						{
							*pLB_TO_TOP|=1;
						}
						
					} else
					{
						
						*pLB_TO_BOTTOM>>=1;
						if((*pG++)&(1 << bit))	//0,1,2,3,4,5,6,7
						{
							*pLB_TO_BOTTOM|=128;
						}
					}	
					*pLB_TO_TOP++;
					*pLB_TO_BOTTOM++;
				}
			}
			break;
		}
		case COLLAPSE:
		{
			break;
		}
		case EXPLODE:
		{
			break;
		}	
		case ROTOR_RIGHT :
		{
			char* pG2 = puffer_GraphBuf2;
			char* pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
				*pG2++=*pG++;

			rotor_clear(1);

			pG2 = puffer_GraphBuf2;
			pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
			{
				*pG++=*pG2++;
			}
			char *pSimbol = Rotor_Buff;		

			for(unsigned char b=0;b < 16; b++)
			{
				//char* pLB = LedBoardBuffer+LedBoardSimbWidth;	
				for(unsigned char o=0;o < 6; o++)
				{	
					char c=pgm_read_byte (pSimbol++);
					for(unsigned char i=0;i < 8; i++)
					{	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=c;
					}	
					speed_step(1);
					for(unsigned char i=0;i < 8; i++)
					{	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]^=c;
					}
					//speed_step(1);
					for(unsigned char i=0;i < 8; i++)
					{	
						char v=c&puffer_GraphBuf[o+i*6];	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=v;
					}
				}
			}
			break;
		}
		case ROTOR_LEFT :
		{
			char* pG2 = puffer_GraphBuf2;
			char* pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
				*pG2++=*pG++;

			rotor_clear(0);

			pG2 = puffer_GraphBuf2;
			pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
			{
				*pG++=*pG2++;
			}

			for(unsigned char b=0;b < 16; b++)
			{
				for(unsigned char o=0;o < 6; o++)
				{	
					char c=pgm_read_byte (&Rotor_Buff[15-b][o]);
					for(unsigned char i=0;i < 8; i++)
					{	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=c;
					}	
					speed_step(1);
					for(unsigned char i=0;i < 8; i++)
					{	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]^=c;
					}
					//speed_step(1);
					for(unsigned char i=0;i < 8; i++)
					{	
						char v=c&puffer_GraphBuf[o+i*6];	
						LedBoardBuffer[LedBoardSimbWidth+o+i*6]|=v;
					}
				}
			}
			break;
		}
	}
	ClockPosition=0;
}

static void Magic_Clear(PRINT_MODE pr_mode)
{
	unsigned char Length = LedBoardSize*LedBoardSimbWidth-1;
	ClockPosition=0;	
	switch(pr_mode)
	{
		case HORIZONTAL_TO_LEFT : //balra halad
		{	
			char* pLB = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
			for(char i=0;i < Length+1; i++)
			{
				
				speed_step(2);
				char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth;			
				char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+1;		
				
				for (char z=0; z < Length; z++)								
					*pLineBuf1++ = *pLineBuf2++;
				*pLB = 0;
			}
			break;
		}
		case HORIZONTAL_TO_RIGHT :	//jobbra halad
		{
			char* pLB = LedBoardBuffer+LedBoardSimbWidth;
			for(char i=0;i < Length+1; i++)
			{
				speed_step(2);
				
				char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth+Length;			
				char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+Length-1;			
				for (char z=0; z < Length; z++)								
					*pLineBuf1-- = *pLineBuf2--;
				*pLB = 0;
			}	
			break;
		}
		case HORIZONTAL_FROM_MID :
		{
			char* pLBL = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-1;
			char* pLBR = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2;
			
			for(char i=0;i < ((Length+1)/2); i++)
			{
				speed_step(2);
				char* pLineBuf1L = LedBoardBuffer+LedBoardSimbWidth;
				char* pLineBuf2L = LedBoardBuffer+LedBoardSimbWidth+1;
				
				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1L++ = *pLineBuf2L++;
				*pLBL = 0;

				char* pLineBuf1R = LedBoardBuffer+LedBoardSimbWidth+Length;			
				char* pLineBuf2R = LedBoardBuffer+LedBoardSimbWidth+Length-1;

				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1R-- = *pLineBuf2R--;
				*pLBR = 0;
			}	
			break;
		}
		case HORIZONTAL_TO_MID :
		{
			char* pLBR = LedBoardBuffer+LedBoardSimbWidth;
			char* pLBL = LedBoardBuffer+(LedBoardSize+1)*LedBoardSimbWidth-1;
			for(char i=0;i < ((Length+1)/2); i++)
			{
				speed_step(2);
				char* pLineBuf1L = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2;		
				char* pLineBuf2L = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2+1;	
				
				for (char z=0; z < ((Length+1)/2); z++)								
					*pLineBuf1L++ = *pLineBuf2L++;
				*pLBL = 0;

				char* pLineBuf1R = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-1;
				char* pLineBuf2R = LedBoardBuffer+((LedBoardSize+2)*LedBoardSimbWidth)/2-2;

				for (char z=0; z < ((Length+1)/2)-1; z++)								
					*pLineBuf1R-- = *pLineBuf2R--;
				*pLBR = 0;
			}	
			break;
		}
		case HORIZONTAL_HALF0:
		{	
			horizontal_torol(0);
			break;
		}
		case HORIZONTAL_HALF1:
		{	
			horizontal_torol(1);
			break;
		}
		case HORIZONTAL_HALF2:
		{	
			horizontal_torol(2);
			break;
		}
		case VERTICAL_TO_BOTTOM :		//fentrl->le
		{
					
			for(unsigned char bit=8;bit > 0; bit--)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				speed_step(6);
				
				for(unsigned char x=0;x < Length+1; x++)
				{
					*pLB++>>=1;
				}
			}
			break;
		}
		case VERTICAL_TO_TOP :
		{
			for(unsigned char bit=0;bit < 7; bit++)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				speed_step(6);
				for(unsigned char x=0;x < Length+1; x++)
				{
					*pLB++<<=1;
				}
			}
			break;
		}
		case VERTICAL_FROM_MID :
		{
			for(unsigned char bit=0;bit < 4; bit++)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				speed_step(6);
				for(unsigned char x=0;x < Length+1; x++)
				{
					*pLB&=~(1 << (4+bit));
					*pLB&=~(1 << (3-bit));
					*pLB++;
				}
			}

			break;
		}
		case VERTICAL_TO_MID :
		{
			for(char y=4;y > 0; y--)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
				speed_step(6);
				for(char x=0;x < Length+1; x++)
				{
					*pLB&=~(1 << (4-y));
					*pLB&=~(1 << (3+y));
					*pLB++;
				}
			}
			break;
		}
		case VERTICAL_HALF0:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				char* pLB = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(6);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(!(x%2))
					{
						(*pLB++)<<=1;
					} else
					{
						(*pLB++)>>=1;
					}
				}
			}
			break;
		}
		case VERTICAL_HALF1:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				char* pLB_TO_TOP = LedBoardBuffer+LedBoardSimbWidth;
				char* pLB_TO_BOTTOM = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(x < Length/2)
					{
						*pLB_TO_TOP<<=1;						
					} else
					{
						*pLB_TO_BOTTOM>>=1;
					}	
					*pLB_TO_TOP++;
					*pLB_TO_BOTTOM++;
				}
			}
			break;
		}
		case VERTICAL_HALF2:
		{
			for(unsigned char bit=0;bit < 8; bit++)
			{
				char* pLB_TO_TOP = LedBoardBuffer+LedBoardSimbWidth;
				char* pLB_TO_BOTTOM = LedBoardBuffer+LedBoardSimbWidth;
			
				speed_step(4);
				for(unsigned char x=0;x < Length+1; x++)
				{
					if(x >= Length/2)
					{
						*pLB_TO_TOP<<=1;
					} else
					{
						*pLB_TO_BOTTOM>>=1;
					}	
					*pLB_TO_TOP++;
					*pLB_TO_BOTTOM++;
				}
			}
			break;
		}
		case COLLAPSE :
		{	
			unsigned char b = 0;
			signed char delta;
			srand(0x42);
			for(unsigned char db=0;db < 5; db++)
			{
				for(unsigned char bit=7;bit > 1; bit--)
				{	
					speed_step(4);
					for(unsigned char x=0;x < Length+1; x++)
					{
						b=0;
						if(LedBoardBuffer[x+LedBoardSimbWidth]&(1 << bit))
						{
							unsigned char r = rand();
							if(r < 52) {delta=-2;} else 
								if(r < 104) {delta=-1;} else 
									if(r < 156) {delta=0;} else 
										if(r < 208) {delta=1;} else  {delta=2;}
							b=0;
							while ((LedBoardBuffer[x+LedBoardSimbWidth+delta]&(1 << (b)))&&(b<bit)) {b++;}
							if(b < bit)
							{
								
								LedBoardBuffer[x+LedBoardSimbWidth+delta]|=(1 << b);
								LedBoardBuffer[x+LedBoardSimbWidth]&=~(1 << bit);
							}
						}
					}
				}
			}

			break;
		}
		case EXPLODE :
		{	
			// kezd adatok feltltse
			for(unsigned char i=0;i < Length; i++)
				puffer_GraphBuf[i]=0;
			for(unsigned char i=0;i < MAX_EXPLODE_PIX; i++)
			{
				explode_Graph[i].x=0;
				explode_Graph[i].y=0;
				explode_Graph[i].irany=0;
			}
			unsigned char max_pix=0;
			char* pLB = LedBoardBuffer+LedBoardSimbWidth;
			for(unsigned char x=0;x < Length+1; x++)
			{
				for(char bit = 0; bit < 8; bit++)
					if(*pLB&(1 << bit))
					{
						explode_Graph[max_pix].x=x;
						explode_Graph[max_pix].y=bit;
						explode_Graph[max_pix].irany=(1+(rand()/36));
						if(max_pix < MAX_EXPLODE_PIX) max_pix++;
					} 

					*pLB++;
			}
			Delay (1);			
			//-------------
			unsigned char is_pixel=0;
			while(is_pixel<60)
			{
				
				for(unsigned char pix=0; pix < max_pix;pix++)
				{	
					switch(explode_Graph[pix].irany)
					{
						case 1:
						case 4:
						case 6:
						{
							if(explode_Graph[pix].x > 0) explode_Graph[pix].x--; else explode_Graph[pix].irany=9;
							break;
						}
						case 3:
						case 5:
						case 8:
						{
							if(explode_Graph[pix].x < Length) explode_Graph[pix].x++; else explode_Graph[pix].irany=9;
							break;
						}
					}
					switch(explode_Graph[pix].irany)
					{
						case 1:
						case 2:
						case 3:
						{	
							//if(explode_Graph[pix].irany !=9)
							{
								explode_Graph[pix].y-=8;
								if(explode_Graph[pix].y < 240 )
								{
									explode_Graph[pix].y|=248;
									if((explode_Graph[pix].y&0x07) < 7) 
									{
										explode_Graph[pix].y++; 
									} else 
									{
										explode_Graph[pix].irany=9;
									}
								}	
							} 
							break;
						}
						case 6:
						case 7:
						case 8:
						{
							//if(explode_Graph[pix].irany !=9)
							{
								explode_Graph[pix].y-=8;
								if(explode_Graph[pix].y < 240 )
								{
									explode_Graph[pix].y|=248;
									if((explode_Graph[pix].y&0x07) > 0) 
									{
										explode_Graph[pix].y--; 
									} else 
									{
										explode_Graph[pix].irany=9;
									}
								}	
							} 
							break;
						}
					}
					if(pix == 31) srand(explode_Graph[pix].y);
					if(explode_Graph[pix].irany < 9) 
					{
						
						puffer_GraphBuf[explode_Graph[pix].x]|=(1 << (explode_Graph[pix].y&7));
					}
				}
				* pLB = LedBoardBuffer+LedBoardSimbWidth;
				char* pG = puffer_GraphBuf;
				
				for(unsigned char x=0;x < Length+1; x++)
				{
					LedBoardBuffer[x+6]=puffer_GraphBuf[x];			
				}
				for(unsigned char x=0;x < Length+1; x++)
				{
					*pG++=0;
				}	
				speed_step(2);
				is_pixel++;
			}
			break;
		}
		case ROTOR_RIGHT :
		{	
			rotor_clear(1);
			char* pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
				*pG++=0;
			break;
		}
		case ROTOR_LEFT :
		{	
			rotor_clear(0);
			char* pG = puffer_GraphBuf;
			for(unsigned char b=0;b < Length+1; b++)
				*pG++=0;
			break;
		}
		
	}
}



//-------------------------------------------------- menu ------------------------------------------------
// akcik :
// BtnMask == LongUp -> belps a MEN-be
//itt a le s a fel gombokkal lehet lpkedni a menpontok kztt : ("SET TIME", "SET DATE", "SET BR". (fnyer, ha nem az 555-rl mkdik),  "IN Y/N","OUT Y/N", "DATE Y/N )"
// az adott menpontba a bal, vagy jobb nyomgombok rvid megnyomsval lehet belpni
// idbellts "SET TIME"  : belps utn a jobbra, balra gombokkal lehet kivlasztani, azt a mennyisget (ra, perc, msodperc), amit vltoztatni szeretnnk
// a kivlasztst als sorban alhzs jelzi. Ekkor a fel, le gombokkal lehet lptetni. A msodpercet nem lehet egyesvel vltoztatni, hanem a fel, le gombokkal nullzni lehet
// kilpni a jobbra gomb hossz megnyomsval lehet
// Dtum bellts "SET DATE" : a logikja ugyanaz, mint az idbelltsnak teht jobbra, balra gombokkal kivlasztjuk a mdostand mennyisget, majd a fel, le gombokkal mdostjuk
// kilps szintn a a jobbra gomb hossz megnyomsval
// Fnyer bellts "SET BR." : belps a jobbra, balra gombokkal, mdosts a fel, le gombokkal, kilps a jobbra gomb hossz megnyomsval 
// A bels hmr kijelzsnek engedlyezse/tiltsa " IN Y/N" : nem kell a men pontba kln belpni, hanem a bal, jobb gombokkal kell kijellni, hogy az Y(es), vagy a N(o)
//  legyen kivlasztva, ezutn a fel, le gombokkal a elz, kvetkez menpontra lehet lpni
// A kls hmr kijelzsnek engedlyezse/tiltsa "OUT Y/N" : a logika megrgyezik az elz pontban lertakkal
// A dtum kijelzsnek engedlyezse/tiltsa "DATE Y/N" : a logika megrgyezik az elz pontban lertakkal


unsigned sec,min,hour,wday,day=25,month=1,year=15;


void time_to_rtc()
{
	ClockData[0] = sec / 10 * 16 + sec % 10;
	ClockData[1] = min / 10 * 16 + min % 10;
	ClockData[2] = hour / 10 * 16 + hour % 10;
}

void date_to_rtc()
{
	ClockData[3] = wday & 7;
	ClockData[4] = (day / 10) * 16 + day % 10;
	ClockData[5] = (month / 10) * 16 + month % 10;
	ClockData[6] = (year/ 10) * 16 + (year % 10);
}

void rtc_to_time()
{
	
	min = (ClockData[1] & 0x0F) + (ClockData[1] >> 4) * 10;
	hour = (ClockData[2] & 0x0F) + ((ClockData[2] >> 4) & 3) * 10;
}

void rtc_to_date()
{
	wday = (ClockData[3] & 0x07);
	day = (ClockData[4] & 0x0F) + ((ClockData[4] >> 4) & 3) * 10;
	month = (ClockData[5] & 0x0F) + ((ClockData[5] >> 4) & 1) * 10;
	year =  (ClockData[6] & 0x0F) + (ClockData[6] >> 4) * 10;
}


void date_show() 
{
	xsprintf(buffer,"%02d.%02d.%02d",year,month,day);
	LedBoardMessageShow_no_PGM(buffer);
}

void time_show() 
{
	time_to_rtc();
	IICClockWriteData();
	xsprintf(buffer,"%02d:%02d:%02d",hour,min,sec);
	LedBoardMessageShow_no_PGM(buffer);
	ClockPosition=0;
}

void time_save() 
{
	time_to_rtc();
	IICClockWriteData();
}


void bright_show()
{
	ClockPosition=0;
	xsprintf(buffer,"%03d     ",255-Fenyero);
	LedBoardMessageShow_no_PGM(buffer);
}

void Set_Time()
{
	char BtnMask;
	char rtc_flag;
	
	BtnFlags =0;	
	time_state=HOUR;
	rtc_to_time();
	xsprintf(buffer,"%02d:%02d:%02d",hour,min,sec);
	LedBoardMessageShow_no_PGM(buffer);
	ClockPosition=0;
	sec=(ClockData[0]&0x0f)+((ClockData[0] >> 4) & 7) * 10;
	do
	{
		BtnMask = BtnFlags;
		BtnFlags =0;
		rtc_flag=Flags1;
		if(rtc_flag & b1ClockChange)
		{
			if(sec++ == 59) sec=0;
			rtc_to_time();
			xsprintf(buffer,"%02d:%02d:%02d",hour,min,sec);
			LedBoardMessageShow_no_PGM(buffer);
			Flags1&=~b1ClockChange;
		}
		switch(time_state)
		{
			case NO_TIME :
			{
				break;
			}
			case HOUR :
			{
				if(BtnMask == ShortUp)
				{
					rtc_to_time();
					hour++;
					if(hour == 24) hour=0;
					time_show();
				}
				if(BtnMask == ShortDown)
				{
					rtc_to_time();
					hour--;
					if(hour == 0) hour=23;
					time_show();
				}
				if(BtnMask == ShortRight)
				{
					time_state=MIN;
					time_show();
				}
				if(BtnMask == ShortLeft)
				{
					time_state=SEC;
					time_show();
				}
				break;
			}
			case MIN :
			{
				if(BtnMask == ShortUp)
				{
					rtc_to_time();
					min++;
					if(min == 59) hour=0;
					time_show();
				}
				if(BtnMask == ShortDown)
				{
					rtc_to_time();
					if((min--) == 0)
					{
						min=0;
						if(hour == 0) min=23;

					}
					time_show();
				}
				if(BtnMask == ShortRight)
				{
					time_state=SEC;
					time_show();
				}
				if(BtnMask == ShortLeft)
				{
					time_state=HOUR;
					time_show();
				}
				break;
			}
			case SEC :
			{
				if((BtnMask == ShortUp) || (BtnMask == ShortDown))
				{
					sec=0;
					time_save();
				}	
				if(BtnMask == ShortRight)
				{
					time_state=HOUR;
					time_show();
				}
				if(BtnMask == ShortLeft)
				{
					time_state=MIN;
					time_show();
				}
				break;
			}
		}	
	}while(BtnMask != LongRight);
	time_state=NO_TIME;
	Magic_Clear(rand()/15);
	LedBoardMessageScrollLeft((PGM_P)pgm_read_word(&menu_text[menu_state]));
}

void Set_Date()
{
	char BtnMask;
	BtnFlags =0;
	date_state=YEAR;
	rtc_to_date();
	date_show();
	do
	{
		BtnMask = BtnFlags;
		BtnFlags =0;
		switch(date_state)
		{
			case NO_DATE :
			{
				break;
			}
			case YEAR :
			{
				if(BtnMask == ShortUp)
				{
					year++;
					date_show();
				}	
				if(BtnMask == ShortDown)
				{
					year--;
					date_show();
				}	
				if(BtnMask == ShortRight)
				{
					date_state=MONTH;
					date_show();
				}
				if(BtnMask == ShortLeft)
				{
					date_state=DAY;
					date_show();
				}
				break;
			}
			case MONTH :
			{
				if(BtnMask == ShortUp)
				{
					month++;
					if(month > 12) month=1;
					date_show();
				}	
				if(BtnMask == ShortDown)
				{
					if(month == 1) month=12; else month--;
					date_show();
				}		
				if(BtnMask == ShortRight)
				{
					date_state=DAY;
					date_show();
				}	
				if(BtnMask == ShortLeft)
				{
					date_state=YEAR;
					date_show();
				}
				break;
			}
			case DAY :
			{
				if(BtnMask == ShortUp)
				{
					day++;
					if(day > 31) day=1;
					date_show();
				}	
				if(BtnMask == ShortDown)
				{
					if(day == 1) day=31; else day--;
					date_show();
				}	
				if(BtnMask == ShortRight)
				{
					date_state=YEAR;
					date_show();
				}
				if(BtnMask == ShortLeft)
				{
					date_state=MONTH;
					date_show();
				}
				break;
			}
		}
	} while(BtnMask != LongRight);
	date_state=NO_DATE;
	date_to_rtc();
	IICClockWriteData();
	Magic_Clear(rand()/15);
	LedBoardMessageScrollLeft((PGM_P)pgm_read_word(&menu_text[menu_state]));
}

void Set_Bright()
{
	bright_state=1;
	bright_show();
	char BtnMask;
	do
	{
		BtnMask = BtnFlags;
		BtnFlags =0;
		if(BtnMask == ShortUp)
		{
			if(Fenyero > 0) Fenyero--; else Fenyero=0;
			bright_show();
		}	
		if(BtnMask == ShortDown)
		{
			if(Fenyero < 254) Fenyero++;
			bright_show();
		}	
		if (BtnMask == LongRight)
		{	
			bright_state=0;
			menu_state=NO_MENU;
		}
	} while(bright_state);
	Magic_Clear(rand()/15);
	LedBoardMessageScrollLeft((PGM_P)pgm_read_word(&menu_text[menu_state]));
}

void Need(char *data)
{
	char BtnMask;
	do
	{
		BtnMask = BtnFlags;
		BtnFlags =0;
		if((BtnMask == ShortLeft) || (BtnMask == ShortRight))
		{
			if(*data)
			{
				*data=0;	
			} else *data=1;
			LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
		}	
	} while((BtnMask != ShortUp) && (BtnMask != ShortDown) && (BtnMask != LongRight));
	if(BtnMask== ShortDown) 
	{
		if(menu_state < NEED_DATE) menu_state++; else menu_state=SET_TIME;
	}
	if(BtnMask == ShortUp)
	{
		if(menu_state > SET_TIME) menu_state--; else menu_state=NEED_DATE;
	}
	if(BtnMask == LongRight)
	{
		menu_state=NO_MENU;
	}
	Magic_Clear(rand()/15);
	LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
	//BtnFlags=BtnMask;
}

void Point_Style(char *data)
{
	char BtnMask;
	do
	{
		BtnMask = BtnFlags;
		BtnFlags =0;
		if(BtnMask == ShortLeft)
		{
			if(*data) *data=*data-1; else *data=4;
			LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
		}	
		if(BtnMask == ShortRight)
		{
			if((*data) < 4) *data=*data+1; else *data=0;
			LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
		}	
	} while((BtnMask != ShortUp) && (BtnMask != ShortDown) && (BtnMask != LongRight));
	if(BtnMask== ShortDown) 
	{
		menu_state=SET_TIME;
	}
	if(BtnMask == ShortUp)
	{
		menu_state=NEED_DATE;
	}
	Magic_Clear(rand()/15);
	if(BtnMask == LongRight)
	{
		menu_state=NO_MENU;
	}
	LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
	//BtnFlags=BtnMask;
}


void Show_Temp(TEMP_MEASURE num)
{
	Magic_Clear(rand()/15);
	LedBoardMessageScrollLeft ((PGM_P)pgm_read_word(&text_text[num]));
	LedBoardTermoScrollLeft (num);
	Delay (2);
	Magic_Clear(rand()/15);
	LedBoardClockScrollLeft ();
}


void Show_Date()
{
	rtc_to_date();
	ClockPosition=0;
	Magic_Clear(rand()/15);
	xsprintf(buffer,"%02d.%02d.%02d\0",year,month,day);
	Magic_Write(buffer,rand()/17);
	Delay (1);
	Magic_Clear(rand()/15);
	LedBoardClockScrollLeft ();
}

void Show_Welcome()
{
	ClockPosition=0;
	Magic_Clear(rand()/15);
	LedBoardMessageScrollLeft ((PGM_P)pgm_read_word(&welcome_text[wellcome_num]));
	Delay (2);
	Magic_Clear(rand()/1);
	LedBoardClockScrollLeft ();
}

extern char TxtTitle	[] PROGMEM;
extern void demo();

void menu()
{
	char BtnMask = BtnFlags;
	BtnFlags =0;
	unsigned char rtc_flag;
	
	switch(state)
	{
		case NORMAL :
		{
			if (BtnMask == LongUp)			//GO TO THE MENU
			{
				state=SET_MENU;
			} else
			if (BtnMask == LongDown)		//DEMO5
			{
				demo5();
				
			} else
			if (BtnMask == LongLeft)		//DEMO4
			{
				demo4();
			} else
			{
				
				if(BtnMask == ShortUp)		//DEMO1	
				{	
					demo1();
				}
				if(BtnMask == ShortRight)	//DEMO2
				{	
					demo2();
				}
				if(BtnMask == ShortLeft)	//DEMO3
				{	
					demo3();
				}
				if(BtnMask == ShortDown)	//WELCOME TEXT
				{	
					Show_Welcome(wellcome_num);
					if(wellcome_num < WELLCOME3) wellcome_num++; else wellcome_num=WELLCOME1;
				}
				rtc_flag=Flags1;
				if(rtc_flag & b1ClockChange)
				{
					sec=(ClockData[0]&0x0f)+((ClockData[0] >> 4) & 7) * 10;
					if((sec == 15) && Need_temp_in)
					{
						Show_Temp(TEMP_IN);
					}	
					if((sec == 30)  && Need_temp_out)
					{
						Show_Temp(TEMP_OUT);
					}	
					if((sec == 45) && Need_date)
					{
						Show_Date();
					}	
				}
			}
			break;	
		}
		case SET_MENU:
		{	
			ClockPosition=0;
			Magic_Clear(rand()/15);
			LedBoardMessageScrollLeft((PGM_P)pgm_read_word(&menu_text[MENU]));
			menu_state=MENU;
			do
			{
				BtnMask = BtnFlags;
				BtnFlags =0;
				if(BtnMask == ShortDown)
				{
					if(menu_state < POINT_STYLE) menu_state++; else menu_state=SET_TIME;
					BtnMask=0;
					Magic_Clear(rand()/15);
					LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
		
				} else
				if(BtnMask == ShortUp)
				{
					if(menu_state > SET_TIME) menu_state--; else menu_state=POINT_STYLE;
					BtnMask=0;
					Magic_Clear(rand()/15);
					LedBoardMessageShow((PGM_P)pgm_read_word(&menu_text[menu_state]));
		
				} else
				if (BtnMask == LongRight)
				{
					menu_state=NO_MENU;
					Magic_Clear(rand()/15);
					BtnMask=0;
				} else

				if((BtnMask == ShortRight) || (BtnMask == ShortLeft))	
				{
					
					switch(menu_state)
					{
						case MENU :
						{
							break;
						}
						case NO_MENU :
						{
							break;
						}
						case SET_TIME:
						{		
							BtnMask=0;
							Set_Time();
							break;
						}
						case SET_DATE:
						{
							BtnMask=0;
							Set_Date();
							break;
						}
						case SET_BRIGHT :
						{	
							BtnMask=0;
							Set_Bright();
							break;
						}
						case NEED_TEMP_IN :
						{	
							BtnFlags=BtnMask;
							Need(&Need_temp_in);
							break;
						}	
						case NEED_TEMP_OUT :
						{	
							BtnFlags=BtnMask;
							Need(&Need_temp_out);
							break;
						}
						case NEED_DATE :
						{	
							BtnFlags=BtnMask;
							Need(&Need_date);
							break;
						}
						case POINT_STYLE :
						{	
							BtnFlags=BtnMask;
							Point_Style(&Point_style);
							break;
						}
					}
				}
			} while(menu_state != NO_MENU);
			eeprom_write_byte((unsigned char*)0, Need_temp_in); 
			eeprom_write_byte((unsigned char*)1, Need_temp_out); 
			eeprom_write_byte((unsigned char*)2, Need_date);  
			eeprom_write_byte((unsigned char*)3, Point_style);  
			state=NORMAL;
			ClockPosition=48;
			break;
		}	
	}
}

