#define VERSION_NUMBER 0x0103
#define PRODUCT_NAME "dmn-edc 1.03"

#define NUMBER_OF_CYLINDERS 5
#define NEEDLELIFTSENSOR_CYLINDER 3
#define FIRING_ORDER {4,5,3,1,2} /* Starting on with cylinder where needle sensor is */
//#define ATDC_MARK 115 /* Position of each cylinder's timing mark on flywheel/crankshaft, 115 = 11.5° after TDC. Time difference between needle lift sensor trigger and this mark is used to calculate timing */
#define BTDC_MARK 605 /* Position of each cylinder's timing mark on flywheel/crankshaft, 60.5= 60.5° before TDC. Time difference between needle lift sensor trigger and this mark is used to calculate timing */
#define FLYWHEEL_MARK_ANGLE (360 / NUMBER_OF_CYLINDERS)

#define ANALOG_INPUT_HIGH_STATE_LIMIT 975 /* if analog input is above this limit, assume no sensor is connected and internal pullup resistor feeds the almost +5v */
#define DUAL_TPS_ALLOWED_ERROR_MARGIN 40

#define N108_MAX_DUTY_CYCLE 242
#define N108_MIN_DUTY_CYCLE 0

#define TPS_LIMP_MODE_AMOUNT 68
#define TPS_SAFETY_BITS_IDLESW 1
#define TPS_SAFETY_BITS_DUAL 2

#define PIN_RPM 2 /* do not change! */ 
#define PIN_NEEDLELIFTSENSOR 3 /* do not change! */ 
#define PIN_FUELTEMP A4
#define PIN_ENGINETEMP A6
#define PIN_AIRTEMP A2
#define PIN_TPS A0
#define PIN_TPS2 A7
#define PIN_MAP A5
#define PIN_QA_FEEDBACK A1
#define PIN_TPS_IDLE 52
 
//#define PIN_QA_REFERENCE_WAVE 52

// 3,4 or 5 (timer3)
#define PIN_QA_PWMCONTROL 5

// 6,7 or 8 (timer4)
#define PIN_TIMING_PWMCONTROL 6
//#define PIN_REFPULSE 7

#define PIN_BATTERY_VOLTAGE A7
#define PIN_INJECTION_THRESHOLD_VOLTAGE A8
#define PIN_TPS_IDLE 0
#define PIN_TPS_FULL 0
#define PIN_BRAKE_SWITCH 0
#define PIN_FUEL_SOLENOID 0
#define PIN_N75 8
#define PIN_GLOW_RELAY 10
#define PIN_RPM_OUT 12
#define PIN_AUX1 44 // Timer 5
#define PIN_AUX2 45
#define PIN_AUX3 46

#define PIN_SRA_FEEDBACK A15
#define PIN_SRA_OUTPUT1 4// 7 // move to timer5??
#define PIN_SRA_OUTPUT2 7 // 4
#define PIN_SRA_ENABLE 53

#define KEY_UP 'k'
#define KEY_DOWN 'j'
#define KEY_LEFT 'h'
#define KEY_RIGHT 'l'

#define DUMP_START 1
#define DUMP_INPROGRESS 2
#define DUMP_FINISHED 4
#define DUMP_SIZE 250

#define MAP_AXIS_NONE 0xFF
#define MAP_AXIS_RAW 0x00
#define MAP_AXIS_RPM 0x01
#define MAP_AXIS_TPS 0x02
#define MAP_AXIS_KPA 0x03
#define MAP_AXIS_CELSIUS 0x04
#define MAP_AXIS_VOLTAGE 0x05
#define MAP_AXIS_DUTY_CYCLE 0x06
#define MAP_AXIS_IDLERPM 0x07
#define MAP_AXIS_INJECTION_TIMING 0x08
#define MAP_AXIS_INJECTED_FUEL 0x09
#define MAP_AXIS_SECONDS 0x10
#define MAP_AXIS_FUEL_TRIM_AMOUNT 0x11

#define BOOST_MAX_CLIP 1
#define BOOST_MIN_CLIP 2
#define BOOST_OK 0

#define TACHO_TIMER_PIN_HZ 490 

#define VNT_OPEN_DELAY_ON_IDLE	240 // 0 - disable
#define FAST_START_DELAY 340

#define AVG_TABLE_SIZE_TPS 4


#define SENSOR_FAIL_COUNT 300

// defines for setting and clearing register bits
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif
