// Diagnostic trouble code(s)
//
// Stores DTC on eeprom. Only one error per power-on period is registered (unless DTC is cleared). Count of errors are stored in eeprom too.


#ifndef DTH_H
#define DTH_H

#include "Arduino.h"

#define DTC_FILE_4BYTE_ID "DT01"
#define DTC_EEPROM_OFFSET (4096 - 512)

#define DTC_NO_ERROR 0
#define DTC_INTERNAL_ERROR 1
#define DTC_CONFIGURATION_ERROR 2
#define DTC_TRAP_1 3
#define DTC_TRAP_2 4
#define DTC_TRAP_3 5
#define DTC_TRAP_4 6
#define DTC_TRAP_5 7
#define DTC_INTERNAL_UNUSED_1 8
#define DTC_STORAGE_MISMATCH 9
#define DTC_TPS_UNCONNECTED 10
#define DTC_TPS2_UNCONNECTED 11
#define DTC_MAP_UNCONNECTED 12
#define DTC_QUANTITY_ADJUSTER_UNCONNECTED 13
#define DTC_NEEDLESENSOR_UNPLAUSIBLE_SIGNAL 14
#define DTC_RPM_UNPLAUSIBLE_SIGNAL 15
#define DTC_ENGINE_TEMP_UNCONNECTED 16
#define DTC_FUEL_TEMP_UNCONNECTED 17
#define DTC_AIR_TEMP_UNCONNECTED 18
#define DTC_TPS_UNPLAUSIBLE 19

#define DTC_CONFIGURATION_MISMATCH 20


#define MAX_DTCS 256
#define MAX_DTC_LEN 60

//prog_uchar DTC_CODES[] PROGMEM = "z";

static prog_uchar DTC_CODES[MAX_DTCS][MAX_DTC_LEN] PROGMEM = 
{ 
    "No error.", //0
    "Internal error.", //1   
    "Default settings loaded.", //2
    "Diagnostic trap #1", //3
    "Diagnostic trap #2", //4
    "Diagnostic trap #3", //5
    "Diagnostic trap #4", //6
    "Diagnostic trap #5", //7
    "Unknown DTC code 8", // 8
    "DTC Storage mismatch", // 9
    "TPS#1 unconnected", // 10
    "TPS#2 unconnected", // 11
    "MAP unconnected", // 12 
    "Quantity Adjuster unconnected", // 13
    "Unplausible needle lift sensor signal", // 14
    "Unplausible RPM sensor signal", // 15
    "Engine temperature sensor unconnected", // 16
    "Fuel temperature sensor unconnected", // 17
    "Air temperature sensor unconnected", // 18
    "TPS signal unplausible", // 19
    "Configuration mismatch", // 20
    "Unknown DTC Code 21", // 21
    "Unknown DTC Code 22", // 22
    "Unknown DTC Code 23", // 23
    "Unknown DTC Code 24", // 24
    "Unknown DTC Code 25", // 25
    "Unknown DTC Code 26", // 26
    "Unknown DTC Code 27", // 27
    "Unknown DTC Code 28", // 28
    "Unknown DTC Code 29", // 29
    "Unknown DTC Code 30", // 30
    "Unknown DTC Code 31", // 31
    "Unknown DTC Code 32", // 32
    "Unknown DTC Code 33", // 33
    "Unknown DTC Code 34", // 34
    "Unknown DTC Code 35", // 35
    "Unknown DTC Code 36", // 36
    "Unknown DTC Code 37", // 37
    "Unknown DTC Code 38", // 38
    "Unknown DTC Code 39", // 39
    "Unknown DTC Code 40", // 40
    "Unknown DTC Code 41", // 41
    "Unknown DTC Code 42", // 42
    "Unknown DTC Code 43", // 43
    "Unknown DTC Code 44", // 44
    "Unknown DTC Code 45", // 45
    "Unknown DTC Code 46", // 46
    "Unknown DTC Code 47", // 47
    "Unknown DTC Code 48", // 48
    "Unknown DTC Code 49", // 49
    "Unknown DTC Code 50", // 50
    "Unknown DTC Code 51", // 51
    "Unknown DTC Code 52", // 52
    "Unknown DTC Code 53", // 53
    "Unknown DTC Code 54", // 54
    "Unknown DTC Code 55", // 55
    "Unknown DTC Code 56", // 56
    "Unknown DTC Code 57", // 57
    "Unknown DTC Code 58", // 58
    "Unknown DTC Code 59", // 59
    "Unknown DTC Code 60", // 60
    "Unknown DTC Code 61", // 61
    "Unknown DTC Code 62", // 62
    "Unknown DTC Code 63", // 63
    "Unknown DTC Code 64", // 64
    "Unknown DTC Code 65", // 65
    "Unknown DTC Code 66", // 66
    "Unknown DTC Code 67", // 67
    "Unknown DTC Code 68", // 68
    "Unknown DTC Code 69", // 69
    "Unknown DTC Code 70", // 70
    "Unknown DTC Code 71", // 71
    "Unknown DTC Code 72", // 72
    "Unknown DTC Code 73", // 73
    "Unknown DTC Code 74", // 74
    "Unknown DTC Code 75", // 75
    "Unknown DTC Code 76", // 76
    "Unknown DTC Code 77", // 77
    "Unknown DTC Code 78", // 78
    "Unknown DTC Code 79", // 79
    "Unknown DTC Code 80", // 80
    "Unknown DTC Code 81", // 81
    "Unknown DTC Code 82", // 82
    "Unknown DTC Code 83", // 83
    "Unknown DTC Code 84", // 84
    "Unknown DTC Code 85", // 85
    "Unknown DTC Code 86", // 86
    "Unknown DTC Code 87", // 87
    "Unknown DTC Code 88", // 88
    "Unknown DTC Code 89", // 89
    "Unknown DTC Code 90", // 90
    "Unknown DTC Code 91", // 91
    "Unknown DTC Code 92", // 92
    "Unknown DTC Code 93", // 93
    "Unknown DTC Code 94", // 94
    "Unknown DTC Code 95", // 95
    "Unknown DTC Code 96", // 96
    "Unknown DTC Code 97", // 97
    "Unknown DTC Code 98", // 98
    "Unknown DTC Code 99", // 99
    "Unknown DTC Code 100", // 100
    "Unknown DTC Code 101", // 101
    "Unknown DTC Code 102", // 102
    "Unknown DTC Code 103", // 103
    "Unknown DTC Code 104", // 104
    "Unknown DTC Code 105", // 105
    "Unknown DTC Code 106", // 106
    "Unknown DTC Code 107", // 107
    "Unknown DTC Code 108", // 108
    "Unknown DTC Code 109", // 109
    "Unknown DTC Code 110", // 110
    "Unknown DTC Code 111", // 111
    "Unknown DTC Code 112", // 112
    "Unknown DTC Code 113", // 113
    "Unknown DTC Code 114", // 114
    "Unknown DTC Code 115", // 115
    "Unknown DTC Code 116", // 116
    "Unknown DTC Code 117", // 117
    "Unknown DTC Code 118", // 118
    "Unknown DTC Code 119", // 119
    "Unknown DTC Code 120", // 120
    "Unknown DTC Code 121", // 121
    "Unknown DTC Code 122", // 122
    "Unknown DTC Code 123", // 123
    "Unknown DTC Code 124", // 124
    "Unknown DTC Code 125", // 125
    "Unknown DTC Code 126", // 126
    "Unknown DTC Code 127", // 127
    "Unknown DTC Code 128", // 128
    "Unknown DTC Code 129", // 129
    "Unknown DTC Code 130", // 130
    "Unknown DTC Code 131", // 131
    "Unknown DTC Code 132", // 132
    "Unknown DTC Code 133", // 133
    "Unknown DTC Code 134", // 134
    "Unknown DTC Code 135", // 135
    "Unknown DTC Code 136", // 136
    "Unknown DTC Code 137", // 137
    "Unknown DTC Code 138", // 138
    "Unknown DTC Code 139", // 139
    "Unknown DTC Code 140", // 140
    "Unknown DTC Code 141", // 141
    "Unknown DTC Code 142", // 142
    "Unknown DTC Code 143", // 143
    "Unknown DTC Code 144", // 144
    "Unknown DTC Code 145", // 145
    "Unknown DTC Code 146", // 146
    "Unknown DTC Code 147", // 147
    "Unknown DTC Code 148", // 148
    "Unknown DTC Code 149", // 149
    "Unknown DTC Code 150", // 150
    "Unknown DTC Code 151", // 151
    "Unknown DTC Code 152", // 152
    "Unknown DTC Code 153", // 153
    "Unknown DTC Code 154", // 154
    "Unknown DTC Code 155", // 155
    "Unknown DTC Code 156", // 156
    "Unknown DTC Code 157", // 157
    "Unknown DTC Code 158", // 158
    "Unknown DTC Code 159", // 159
    "Unknown DTC Code 160", // 160
    "Unknown DTC Code 161", // 161
    "Unknown DTC Code 162", // 162
    "Unknown DTC Code 163", // 163
    "Unknown DTC Code 164", // 164
    "Unknown DTC Code 165", // 165
    "Unknown DTC Code 166", // 166
    "Unknown DTC Code 167", // 167
    "Unknown DTC Code 168", // 168
    "Unknown DTC Code 169", // 169
    "Unknown DTC Code 170", // 170
    "Unknown DTC Code 171", // 171
    "Unknown DTC Code 172", // 172
    "Unknown DTC Code 173", // 173
    "Unknown DTC Code 174", // 174
    "Unknown DTC Code 175", // 175
    "Unknown DTC Code 176", // 176
    "Unknown DTC Code 177", // 177
    "Unknown DTC Code 178", // 178
    "Unknown DTC Code 179", // 179
    "Unknown DTC Code 180", // 180
    "Unknown DTC Code 181", // 181
    "Unknown DTC Code 182", // 182
    "Unknown DTC Code 183", // 183
    "Unknown DTC Code 184", // 184
    "Unknown DTC Code 185", // 185
    "Unknown DTC Code 186", // 186
    "Unknown DTC Code 187", // 187
    "Unknown DTC Code 188", // 188
    "Unknown DTC Code 189", // 189
    "Unknown DTC Code 190", // 190
    "Unknown DTC Code 191", // 191
    "Unknown DTC Code 192", // 192
    "Unknown DTC Code 193", // 193
    "Unknown DTC Code 194", // 194
    "Unknown DTC Code 195", // 195
    "Unknown DTC Code 196", // 196
    "Unknown DTC Code 197", // 197
    "Unknown DTC Code 198", // 198
    "Unknown DTC Code 199", // 199
    "Unknown DTC Code 200", // 200
    "Unknown DTC Code 201", // 201
    "Unknown DTC Code 202", // 202
    "Unknown DTC Code 203", // 203
    "Unknown DTC Code 204", // 204
    "Unknown DTC Code 205", // 205
    "Unknown DTC Code 206", // 206
    "Unknown DTC Code 207", // 207
    "Unknown DTC Code 208", // 208
    "Unknown DTC Code 209", // 209
    "Unknown DTC Code 210", // 210
    "Unknown DTC Code 211", // 211
    "Unknown DTC Code 212", // 212
    "Unknown DTC Code 213", // 213
    "Unknown DTC Code 214", // 214
    "Unknown DTC Code 215", // 215
    "Unknown DTC Code 216", // 216
    "Unknown DTC Code 217", // 217
    "Unknown DTC Code 218", // 218
    "Unknown DTC Code 219", // 219
    "Unknown DTC Code 220", // 220
    "Unknown DTC Code 221", // 221
    "Unknown DTC Code 222", // 222
    "Unknown DTC Code 223", // 223
    "Unknown DTC Code 224", // 224
    "Unknown DTC Code 225", // 225
    "Unknown DTC Code 226", // 226
    "Unknown DTC Code 227", // 227
    "Unknown DTC Code 228", // 228
    "Unknown DTC Code 229", // 229
    "Unknown DTC Code 230", // 230
    "Unknown DTC Code 231", // 231
    "Unknown DTC Code 232", // 232
    "Unknown DTC Code 233", // 233
    "Unknown DTC Code 234", // 234
    "Unknown DTC Code 235", // 235
    "Unknown DTC Code 236", // 236
    "Unknown DTC Code 237", // 237
    "Unknown DTC Code 238", // 238
    "Unknown DTC Code 239", // 239
    "Unknown DTC Code 240", // 240
    "Unknown DTC Code 241", // 241
    "Unknown DTC Code 242", // 242
    "Unknown DTC Code 243", // 243
    "Unknown DTC Code 244", // 244
    "Unknown DTC Code 245", // 245
    "Unknown DTC Code 246", // 246
    "Unknown DTC Code 247", // 247
    "Unknown DTC Code 248", // 248
    "Unknown DTC Code 249", // 249
    "Unknown DTC Code 250", // 250
    "Unknown DTC Code 251", // 251
    "Unknown DTC Code 252", // 252
    "Unknown DTC Code 253", // 253
    "Unknown DTC Code 254", // 254
    "Unknown DTC Code 255", // 255
};

class DTC {
private:
    long lastSave;
    int iterator;
    bool isTouched;
    
    unsigned char errorCodesOnStartup[MAX_DTCS];    
    unsigned char errorCodesCurrent[MAX_DTCS];
    char errorBuf[MAX_DTC_LEN];
    void saveToEEPROM();
    void load();
public:
    DTC();   
    bool seekNextError();
    char *getName();
    unsigned char getCount();
    int getIndex();
    void setError(unsigned int dtc);
    void resetAll();
    void save();
    boolean isErrorActive(unsigned int dtc);
    
};

extern DTC dtc;

#endif


