#include "SimpleRotatingActuator.h"
#include "defines.h"
#include "Arduino.h"
#include "Core.h"


SimpleRotatingActuator::SimpleRotatingActuator(int *minPos,int *maxPos,int *inverseOperation) {
	this->maxPos = maxPos;
	this->minPos = minPos;
	this->inverseOperation = inverseOperation;
}

void SimpleRotatingActuator::setPosition(unsigned char pos) {
	// map 0..255 to "range"
	targetPos = map((*inverseOperation?255-pos:pos), 0, 255, *minPos, *maxPos);
	core.controls[Core::valueSRATarget] = targetPos;	
}

void SimpleRotatingActuator::calculate() {

	currentPos = analogRead(PIN_SRA_FEEDBACK);

	core.controls[Core::valueSRAPosition] = currentPos;
  
	error=(targetPos-currentPos);

	integral = integral+(error*0.02);
	output = integral+error*1.924;

	if (integral>255) integral=255;  
	if (integral<-255) integral=-255;

  
	PWM = abs(output);

 	if (PWM>255)
 		PWM=255;
 	
 	if (targetPos > currentPos-hysteresis && targetPos< currentPos+hysteresis) {
    	hold();
  	} else {
  		if (currentPos < targetPos) {
   			if (currentPos<*maxPos) {
				forward();
 			} else {
				hold();
			}
  		} else {  
			if (currentPos>*minPos) {
				backward();  
			} else {
				hold();
			}  
  		}
  	}
}

void SimpleRotatingActuator::forward() {
	analogWrite(PIN_SRA_OUTPUT1,0);  
	analogWrite(PIN_SRA_OUTPUT2,PWM);

}
void SimpleRotatingActuator::backward() {
	analogWrite(PIN_SRA_OUTPUT2,0);  
	analogWrite(PIN_SRA_OUTPUT1,PWM);
}
void SimpleRotatingActuator::hold() {
	analogWrite(PIN_SRA_OUTPUT2,0);  
	analogWrite(PIN_SRA_OUTPUT1,0);  
}

void SimpleRotatingActuator::enable() {
	digitalWrite(PIN_SRA_ENABLE,HIGH);
}

void SimpleRotatingActuator::disable() {
	digitalWrite(PIN_SRA_ENABLE,LOW);	
}