//************************************************************************************
//**  
//**  File name:     F:\Books and Apps\Electronics\FlowCodeAVR4\Examples\TUT_33.c
//**  Generated by:  Flowcode v4.3.6.61
//**  Date:          Friday, June 04, 2010 20:47:58
//**  Licence:       Student
//**  Registered to: paul bunion
//**  
//**  
//**     NOT FOR COMMERCIAL USE
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_AVR

//Defines for microcontroller
#define MX_AVR
#define MX_EE
#define MX_EE_SIZE 1024
#define MX_SPI
#define MX_SPI_B
#define MX_SPI_SDI 6
#define MX_SPI_SDO 5
#define MX_SPI_SCK 7
#define MX_UART
#define MX_UART_ID
#define MX_UART_UCSRC
#define MX_UART_D
#define MX_UART_TX 1
#define MX_UART_RX 0
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 1
#define MX_I2C_SCL 0
#define MX_PWM
#define MX_PWM_PORT PORTD
#define MX_PWM_CNT 2
#define MX_PWM_TRIS1 DDRD
#define MX_PWM_1 5
#define MX_PWM_TRIS2 DDRD
#define MX_PWM_2 4
#define MX_PWMTYPE 1

//Functions
#define F_CPU 20000000UL
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <avr\io.h>
#include <avr\interrupt.h>
#include <avr\eeprom.h>
#include <avr\wdt.h>
#include <MX_util\delay.h>
#include <MX_util\bit_cmds.h>

//Configuration data
#pragma DATA 0x0, 0xdf
#pragma DATA 0x1, 0xff
#pragma DATA 0x2, 0xff

//Internal functions
#include "C:\Program Files\Matrix Multimedia\Flowcode AVR V4\FCD\internals.h"

//Macro function declarations


//Variable declarations
volatile char FCV_RESULT;
volatile char FCV_NO1;
volatile char FCV_NO2;


//Defines:

/**** Macro Substitutions ****
PORTB = D1 Port
DDRB = D1 Data Direction
PORTB = D2 Port
DDRB = D2 Data Direction
PORTB = D3 Port
DDRB = D3 Data Direction
PORTB = D4 Port
DDRB = D4 Data Direction
PORTB = RS Port
DDRB = RS Data Direction
PORTB = E Port
DDRB = E Data Direction
0 = Data 1_Pin
1 = Data 2 Pin
2 = Data 3 Pin
3 = Data 4 Pin
4 = RS Pin
5 = Enable Pin
LCD_1311622 = Unique Component Reference Number
2 = Row Count
16 = Column Count
******************************/

	//component connections
	#define LCD_1311622_PORT0    PORTB
	#define LCD_1311622_DDR0    DDRB
	#define LCD_1311622_PORT1    PORTB
	#define LCD_1311622_DDR1    DDRB
	#define LCD_1311622_PORT2    PORTB
	#define LCD_1311622_DDR2    DDRB
	#define LCD_1311622_PORT3    PORTB
	#define LCD_1311622_DDR3    DDRB
	#define LCD_1311622_PORT4    PORTB
	#define LCD_1311622_DDR4    DDRB
	#define LCD_1311622_PORT5    PORTB
	#define LCD_1311622_DDR5    DDRB
	#define LCD_1311622_BIT0    	0
	#define LCD_1311622_BIT1    	1
	#define LCD_1311622_BIT2    	2
	#define LCD_1311622_BIT3    	3
	#define LCD_1311622_RS      	4
	#define LCD_1311622_E       	5
	#define LCD_1311622_ROWCNT	2
	#define LCD_1311622_COLCNT	16

    #define LCD_1311622_DELAY   delay_us(100)




//LCDDisplay(0): //Macro function declarations

static void FCD_LCDDisplay0_RawSend(char in, char mask);
static void FCD_LCDDisplay0_Start();
static void FCD_LCDDisplay0_Clear();
static void FCD_LCDDisplay0_PrintASCII(char Character);
static void FCD_LCDDisplay0_Command(char in);
static void FCD_LCDDisplay0_Cursor(char x, char y);
static void FCD_LCDDisplay0_PrintNumber(short Number);
static void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String);
static void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions);
static void FCD_LCDDisplay0_ClearLine(char Line);
static void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7);

//Supplementary defines
//Adds two numbers together
char Add_Nums(char Num1, char Num2);

//Subtracts one number from a second
char Sub_Nums(char Num1, char Num2);



//LCDDisplay(0): //Macro implementations


static void FCD_LCDDisplay0_RawSend(char in, char mask)
{
		unsigned char pt;

		clear_bit(LCD_1311622_PORT0, LCD_1311622_BIT0);
		clear_bit(LCD_1311622_PORT1, LCD_1311622_BIT1);
		clear_bit(LCD_1311622_PORT2, LCD_1311622_BIT2);
		clear_bit(LCD_1311622_PORT3, LCD_1311622_BIT3);
		clear_bit(LCD_1311622_PORT4, LCD_1311622_RS);
		clear_bit(LCD_1311622_PORT5, LCD_1311622_E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    set_bit(LCD_1311622_PORT0, LCD_1311622_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_1311622_PORT1, LCD_1311622_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_1311622_PORT2, LCD_1311622_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_1311622_PORT3, LCD_1311622_BIT3);
		if (mask)
		    set_bit(LCD_1311622_PORT4, LCD_1311622_RS);
		LCD_1311622_DELAY;
		set_bit (LCD_1311622_PORT5, LCD_1311622_E);
		LCD_1311622_DELAY;
		clear_bit (LCD_1311622_PORT5, LCD_1311622_E);
		pt = (in & 0x0f);
		LCD_1311622_DELAY;
		clear_bit(LCD_1311622_PORT0, LCD_1311622_BIT0);
		clear_bit(LCD_1311622_PORT1, LCD_1311622_BIT1);
		clear_bit(LCD_1311622_PORT2, LCD_1311622_BIT2);
		clear_bit(LCD_1311622_PORT3, LCD_1311622_BIT3);
		clear_bit(LCD_1311622_PORT4, LCD_1311622_RS);
		clear_bit(LCD_1311622_PORT5, LCD_1311622_E);
		if (pt & 0x01)
		    set_bit(LCD_1311622_PORT0, LCD_1311622_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_1311622_PORT1, LCD_1311622_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_1311622_PORT2, LCD_1311622_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_1311622_PORT3, LCD_1311622_BIT3);
		if (mask)
		    set_bit(LCD_1311622_PORT4, LCD_1311622_RS);
		LCD_1311622_DELAY;
		set_bit (LCD_1311622_PORT5, LCD_1311622_E);
		LCD_1311622_DELAY;
		clear_bit (LCD_1311622_PORT5, LCD_1311622_E);
		LCD_1311622_DELAY;
}

static void FCD_LCDDisplay0_Start()
{
	
		set_bit(LCD_1311622_DDR0, LCD_1311622_BIT0);
		set_bit(LCD_1311622_DDR1, LCD_1311622_BIT1);
		set_bit(LCD_1311622_DDR2, LCD_1311622_BIT2);
		set_bit(LCD_1311622_DDR3, LCD_1311622_BIT3);
		set_bit(LCD_1311622_DDR4, LCD_1311622_RS);
		set_bit(LCD_1311622_DDR5, LCD_1311622_E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_Clear()
{
	
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_PrintASCII(char Character)
{
	
		FCD_LCDDisplay0_RawSend(Character, 0x10);

}

static void FCD_LCDDisplay0_Command(char in)
{
	
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_Cursor(char x, char y)
{
	
	  #if (LCD_1311622_ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_1311622_ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_1311622_ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_1311622_COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_1311622_COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_PrintNumber(short Number)
{
	
		short tmp_int;
		char tmp_byte;
		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);

}

static void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String)
{
	
		char idx;
		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx]==0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}

}

static void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions)
{
	
		char cmd = 0;
		char count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}

}

static void FCD_LCDDisplay0_ClearLine(char Line)
{
	
		char count;
		char rowcount;

		//Define number of columns per line
		#if (LCD_1311622_ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_1311622_ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_1311622_ROWCNT == 4)
			#if (LCD_1311622_COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_1311622_COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);

}

static void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7)
{
	   //set CGRAM address
	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);
}

//Macro implementations

//Supplementary implementations
#include "TUT_33_Inc_Code.c"

int main()
{
	
	//Initialisation
	MCUSR=0x00;
	wdt_disable();


	//Interrupt initialisation code
	
	//Comment:
	//Included Code Example
	//Open the Inc_Code.C file to see the two simple functions that
	//are utilized via the C code blocks.
	//The .C file is included into the program using the following
	//#include "Inc_Code.C"
	//This can be found in the Supplementary Code window under
	//View -> Project Options -> Supplementary Code


	//LCD Warmup Delay
	//Delay: 50 ms
	delay_ms(50);


	//Init LCD
	//Call Component Macro: LCDDisplay(0)::Start
	FCD_LCDDisplay0_Start();


	//Init Variables
	//Calculation:
	//  No1 = 37
	//  No2 = 21
	FCV_NO1 = 37;
	FCV_NO2 = 21;
	

	//Print out "No1"
	//Call Component Macro: LCDDisplay(0)::PrintNumber(No1)
	FCD_LCDDisplay0_PrintNumber(FCV_NO1);


	//Print out " + "
	//Call Component Macro: LCDDisplay(0)::PrintString(" + ")
	FCD_LCDDisplay0_PrintString(" + ",3);


	//Print out No2
	//Call Component Macro: LCDDisplay(0)::PrintNumber(No2)
	FCD_LCDDisplay0_PrintNumber(FCV_NO2);


	//Print out " = "
	//Call Component Macro: LCDDisplay(0)::PrintString(" = ")
	FCD_LCDDisplay0_PrintString(" = ",3);


	//Comment:
	//The Flowcode simulator cannot simulate the C code block so the 
	//simulated output will always be 0. 
	//However the Program works 100% when sent to the PIC.
	//The .C file can be used to house stored functions which 
	//can be called upon whenever they are needed.


	//Calculate result using supp code
	//C Code:
	FCV_RESULT = Add_Nums(FCV_NO1, FCV_NO2);

	// Note that when using a C code block, Flowcode variables 
	// have the prefix FCV_ for Flowcode Variable and they are
	// also capitalised.


	//Print out result
	//Call Component Macro: LCDDisplay(0)::PrintASCII(Result)
	FCD_LCDDisplay0_PrintASCII(FCV_RESULT);


	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::Cursor(0, 1)
	FCD_LCDDisplay0_Cursor(0, 1);


	//Print out "No1"
	//Call Component Macro: LCDDisplay(0)::PrintNumber(No1)
	FCD_LCDDisplay0_PrintNumber(FCV_NO1);


	//Print out " - "
	//Call Component Macro: LCDDisplay(0)::PrintString(" - ")
	FCD_LCDDisplay0_PrintString(" - ",3);


	//Print out No2
	//Call Component Macro: LCDDisplay(0)::PrintNumber(No2)
	FCD_LCDDisplay0_PrintNumber(FCV_NO2);


	//Print out " = "
	//Call Component Macro: LCDDisplay(0)::PrintString(" = ")
	FCD_LCDDisplay0_PrintString(" = ",3);


	//Comment:
	//The Flowcode simulator cannot simulate the C code block so the 
	//simulated output will always be 0. 
	//However the Program works 100% when sent to the PIC.
	//The .C file can be used to house stored functions which 
	//can be called upon whenever they are needed.


	//Calculate result using supp code
	//C Code:
	FCV_RESULT = Sub_Nums(FCV_NO1, FCV_NO2);

	// Note that when using a C code block, Flowcode variables 
	// have the prefix FCV_ for Flowcode Variable and they are
	// also capitalised.


	//Print out result
	//Call Component Macro: LCDDisplay(0)::PrintNumber(Result)
	FCD_LCDDisplay0_PrintNumber(FCV_RESULT);


	mainendloop: goto mainendloop;
}



