#include <p18f442.h>
#include <stdio.h>
#include <delays.h>
#include <stdlib.h>
#include <adc.h> 
#include "header.h"
#include "lcd.c"

/*	Prototpusok	*/
void init(void);
void float_to_str(float szam, unsigned char *tomb);
short Read_ADC(unsigned char CH);
void Delay_ms(unsigned int ms);

/*	Globlis vltozk	*/
unsigned char v1[7] = {0};		// Trtszm trol
unsigned char v2[7] = {0};		// Trtszm trol
unsigned char Amper[7] = {0};	// Trtszm trol
unsigned char Watt[7] = {0};	// Trtszm trol
unsigned int vref = 1023;		// A VDD-hez tartoz ADC rtk (1023)
unsigned int mp = 0;			// Msodpercek szmolsa

void main(void){
	float temp1, temp2, atlagadc;
	unsigned char i;
	
	init();

	while(1){
		
		atlagadc = 0;
		for(i=0; i<10; i++){
			atlagadc += Read_ADC(ADC_CH0);
			Delay_ms(1);
		}
		atlagadc = (float)atlagadc/10.0;
		float_to_str(((float)atlagadc*50.0)/vref, v1);			// 1. 50V-os mrshatr
		
		atlagadc = 0;
		for(i=0; i<10; i++){
			atlagadc += Read_ADC(ADC_CH1);
			Delay_ms(1);
		}
		atlagadc = (float)atlagadc/10.0;
		temp1 = ((float)atlagadc*50.0)/vref;
		float_to_str(temp1, v2);								// 2. 50V-os mrshatr
		
		atlagadc = 0;
		for(i=0; i<10; i++){
			atlagadc += Read_ADC(ADC_CH3);
			Delay_ms(1);
		}
		atlagadc = (float)atlagadc/10.0;
		//temp2 = ((((float)Read_ADC(ADC_CH3)*50.0)/vref)*250.0)/vref; // 0,098mV
		temp2 = (float)atlagadc*(float)((temp1/vref)/0.47);
		float_to_str(temp2, Amper);
		float_to_str(temp1*temp2, Watt);
		
		printf("                    ");
		lcd_write(0xC0,0,1,1);   
		printf("BV:%s V:%s          ", v1, v2);
		lcd_write(0x94,0,1,1);
		printf("A:%s  W:%s          ", Amper, Watt);
		lcd_write(0xD4,0,1,1);
		printf("                    ");
		lcd_write(0x80,0,1,1);
		
		Delay_ms(500);	// ksleltetnk
	}//while
}//main

/*	Inicializls	*/
void init(void){

    TRISA = 0x0B;			// A0, A1, A3 bemenet
	TRISB = 0;	
	TRISC = 0;
	TRISD = 0;	
	TRISE = 0;		
	
	ADCON1 = 0b11000100;	// Csak A0,A1,A3 analg bemenet, elszr ezt vlasztjuk ki. Vref+- = VDD,VSS
	ADCON0 = 0b00000001;
	
	INTCONbits.GIE = 0;
	
	lcd_init();             	// Az LCD modulinicializlsa 
    lcd_init_cgram();       	// Az kezetes betk feltltse
    stdout = _H_USER;       	// Az LCD legyen a standard kimenetnt
}

/*	Lebegpontos szmok konvertlsa string-be	*/
 void float_to_str(float szam, unsigned char *tomb){
	unsigned char i;
	unsigned short adat;
	adat = szam*1000;
    for(i=0; i<6; i++){
		if(i==3){tomb[5-i]='.'; i++;}	// Tizedespontot kitesszk
	    tomb[5-i] = adat % 10 + '0';
	    adat = adat / 10;
    }
}

/*	Analog port olvassa	*/
short Read_ADC(unsigned char CH){
	//ADCON0 = CH;			// AD csatorna belltsa
	SelChanConvADC(CH);
	Delay_ms(1);
	ConvertADC(); 			// A?-s lbrl jv analog jel konvertlsa
	while( BusyADC() ); 	// Vrunk az eredmnyre
	return(ReadADC()); 		// kiolvassuk s visszatrnk az eredmnnyel
}

/*	Ksleltets	*/
void Delay_ms(unsigned int ms){ //Bemenet*ms vrakozs
   unsigned int i=0;
   for (i=0;i<=ms;i++) Delay1KTCYx(10);
}
