;Tutorial 6_6
;Sequential Read Clock with LCD display, with keys
;Nigel Goodwin 2002

	LIST	p=16F628		;tell assembler what chip we are using
	include "P16F628.inc"		;include the defaults for the chip
	ERRORLEVEL	0,	-302	;suppress bank selection messages
	__config 0x3D18			;sets the configuration settings (oscillator type etc.)




		cblock	0x20			;start of general purpose registers
			count			;used in looping routines
			count1			;used in delay routine
			counta			;used in delay routine
			countb			;used in delay routine
			LoX
			Bit_Cntr
			Cmd_Byte
			Dev_Byte
			Timer_H
			Flags
			Flags2
			tmp1			;temporary storage
			tmp2
			tmp3

			templcd			;temp store for 4 bit mode
			templcd2
			lcdtmp
	
			Adr_Lo			; EEPROM memory address to be accessed
			Adr_Hi
			DAT_VAL
			_N
			N
			InputByte		; byte read from EEPROM is stored in this register
			Data_Page		; EEPROM page, 0-7
			OutputByte		; used for holding byte to be output to EEPROM
			I2Cflags		; flag bit register
			buf			; buffer for sequential write and read
			buf1
			buf2
			buf3
			buf4
			buf5
			buf6
			year
			date
			month
			day
			editindx
			hourten
			hourone
			minten
			minone
			dateten
			dateone
			monthten
			monthone
			yearthou
			yearhund
			yearten
			yearone
		endc

LCD_PORT	Equ	PORTA
LCD_TRIS	Equ	TRISA
LCD_RS		Equ	0x04			;LCD handshake lines
LCD_RW		Equ	0x06
LCD_E		Equ	0x07

I2C_PORT	Equ	PORTB
I2C_TRIS	Equ	TRISB

ErrFlag		Equ	0x00
StartFlag	Equ	0x01			;flags used for received bit
One		Equ	0x02
Zero		Equ	0x03
Time		Equ	0x04			;flag for setting time, line1 or line2


#define		SDA 	7
#define		SCL	6

SW1		Equ	0			;set constants for the switches
SW2		Equ	1
SW3		Equ	2
SW4		Equ	3

Chip_Read	Equ	0xA1			;EEPROM address values
Chip_Write	Equ	0xA0

Buf_Size	Equ	0x07			;buffer 7 bytes long

		org	0x0000
		goto	Start

            	org     0x0004
            	retfie

;TABLES - moved to start of page to avoid paging problems,
;a table must not cross a 256 byte boundary.
HEX_Table  	addwf   PCL       , f
            	retlw   0x30
            	retlw   0x31
            	retlw   0x32
            	retlw   0x33
            	retlw   0x34
            	retlw   0x35
            	retlw   0x36
            	retlw   0x37
            	retlw   0x38
            	retlw   0x39
            	retlw   0x41
            	retlw   0x42
            	retlw   0x43
            	retlw   0x44
            	retlw   0x45
            	retlw   0x46

Start		movlw	0x07
		movwf	CMCON			;turn comparators off (make it like a 16F84)

Initialise	clrf	count
		clrf	PORTA
		clrf	PORTB	



SetPorts	bsf 	STATUS,		RP0	;select bank 1
		movlw	0x00			;make all LCD pins outputs
		movwf	LCD_TRIS
		movlw	b'11111111'		;make all I2C port pins inputs
		movwf	I2C_TRIS
		bcf 	STATUS,		RP0	;select bank 0

		call	LCD_Init		;setup LCD module

Main		;goto	Fill_Text 		;comment out after writing
		goto	Display			;comment out to set clock
						;using values loaded in fill_buf

	

; write 8 byte buffer to EEPROM
		movlw	0x00
		movwf	Data_Page		;set EEPROM page
		movlw	0x00
		movwf	Adr_Lo			;set EEPROM address
		call	Fill_Buf
		call	Seq_Write_EEPROM	;write buffer to EEPROM
		call	Show_Buf	

Fill_Text	movlw	0x00
		movwf	Data_Page		;set EEPROM page
		movlw	0x10
		movwf	Adr_Lo			;set EEPROM address
		call	Fill_Buf2
		call	Seq_Write_EEPROM	;write buffer to EEPROM
		movlw	0x17
		movwf	Adr_Lo			;set EEPROM address
		call	Fill_Buf3
		call	Seq_Write_EEPROM	;write buffer to EEPROM

Display		movlw	0x00
		movwf	Data_Page		;set EEPROM page
		movlw	0x00
		movwf	Adr_Lo			;set EEPROM address		
		call	Seq_Read_EEPROM		;read data in to buffer
		call	Show_Buf		;display clock

		call	ChkKeys			;returns 0-4 (0 = no key)
		addwf   PCL       , f		;add W to program counter
		goto	Display			;and jump depending on key press
		goto	SetPressed		; Set key pressed
		goto	Display
		goto	Display
		goto	Display

SetPressed	call	Time_2_Edit
		call	LCD_CurOn
		clrf	editindx
		bcf	Flags,		Time	; set flag for first line
		movlw 	hourten			; indirect index to edit registers
		movwf 	FSR

NextPressed	movf	editindx,	w
		btfss	Flags,		Time
		call	LCD_Line1W
		btfsc	Flags,		Time
		call	LCD_Line2W
		call	ChkKeys
		addwf   PCL       , f
		goto	NextPressed		;no key pressed
		goto	EditDone		;exit edit routines
		goto	TwoPressed
		goto	ThreePressed
		goto	FourPressed

EditDone	call	LCD_CurOff
		call	Edit_2_Time
		goto	Display

TwoPressed	incf	INDF,	f
		call	Chk_Max
		movf	INDF,	w
		call	LCD_CharD
		goto	NextPressed

ThreePressed	decf	INDF,	f
		btfsc	INDF,	0x07		;check if less than zero
		incf	INDF,	f
		movf	INDF,	w
		call	LCD_CharD
		goto	NextPressed

FourPressed	incf	editindx,	f
		movf	editindx,	w
		xorlw	0x02			;is it equal to 2?
		btfsc	STATUS, Z
		incf	editindx		;if so, incf again
		movf	editindx,	w
		xorlw	0x05			;is it equal to 5?
		btfsc	STATUS, Z
		goto	NextLine
		movf	editindx,	w
		xorlw	0x0A			;is it equal to A?
		btfsc	STATUS, Z
		goto	EditDone		;end of edit
		incf	FSR,		f
		goto	NextPressed
NextLine	incf	FSR,		f
		btfsc	Flags,		Time	;check if already doing date
		goto	NextDate
		clrf	editindx
		bsf	Flags,		Time
		goto	NextPressed
NextDate	incf	editindx
		goto	NextPressed

Chk_Max		movf	INDF,	w
		xorlw	0x0A			;is it equal to A?
		btfsc	STATUS, Z
		decf	INDF,	f
		return

Time_2_Edit	movf	buf4,		w
		andlw	0x0F
		movwf	hourone
		swapf	buf4,		w
		andlw	0x0F
		movwf	hourten
		movf	buf3,		w
		andlw	0x0F
		movwf	minone
		swapf	buf3,		w
		andlw	0x0F
		movwf	minten

; extract year and date
		movf	buf5,		w
		andlw	0x3F
		movwf	date
		andlw	0x0F
		movwf	dateone
		swapf	buf5,		w
		andlw	0x03
		movwf	dateten
		swapf	buf5,		w
		andlw	0x0C
		movwf	year
		rrf	year,		f
		rrf	year,		f	;year now holds 0-3 (0 is leap year)
		movf	year,		w
		movwf	yearone

; extract day and month
		movf	buf6,		w
		andlw	0x1F
		movwf	month
		andlw	0x0F
		movwf	monthone
		swapf	buf6,		w
		andlw	0x01
		movwf	monthten
		swapf	buf6,		w
		andlw	0x0E
		movwf	day
		rrf	day,		f
		return

Edit_2_Time	swapf	hourten,	w
		iorwf	hourone,	w
		movwf	buf4
		swapf	minten,		w
		iorwf	minone,		w
		movwf	buf3
		clrf	buf2			; zero seconds
		clrf	buf1

; encode year and date
		movf	yearone,	w
		movwf	year
		rlf	year,		f
		rlf	year,		f
		swapf	year,		f	;put year bits in correct place
		swapf	dateten,	w	;put tendate in correct place
		iorwf	dateone,	w	;OR with onedate
		iorwf	year,		w	;OR with year
		movwf	buf5

; encode day and month
		rlf	day,		f
		swapf	day,		f	;put day in correct place
		swapf	monthten,	w	;put tenmonth in correct place
		iorwf	monthone,	w	;OR with onemonth
		iorwf	day,		w	;OR with day
		movwf	buf6
		
; write buffer to clock chip
		movlw	0x00
		movwf	Data_Page		;set EEPROM page
		movlw	0x00
		movwf	Adr_Lo			;set EEPROM address
		movlw 	buf
		movwf 	FSR
		movlw 	0x00			
		movwf 	INDF
		call	Seq_Write_EEPROM	;write buffer to EEPROM
		return

; Start of key routines

ChkKeys		btfss	I2C_PORT,	SW1
		goto	Switch1
		btfss	I2C_PORT,	SW2
		goto	Switch2
		btfss	I2C_PORT,	SW3
		goto	Switch3
		btfss	I2C_PORT,	SW4
		goto	Switch4
		retlw	0x00		;return 0, no key pressed

Switch1		call	Delay50				;give switch time to stop bouncing
		btfsc	I2C_PORT,	SW1		;check it's still pressed
		retlw	0x00				;return is not
		

Sw1On		call	Delay50
		btfsc	I2C_PORT,	SW1		;wait until button is released
		retlw	0x01				;return 0x01
		goto	Sw1On	

Switch2		call	Delay50				;give switch time to stop bouncing
		btfsc	I2C_PORT,	SW2		;check it's still pressed
		retlw	0x00				;return is not
		

Sw2On		call	Delay50
		btfsc	I2C_PORT,	SW2		;wait until button is released
		retlw	0x02				;return 0x02
		goto	Sw2On

Switch3		call	Delay50				;give switch time to stop bouncing
		btfsc	I2C_PORT,	SW3		;check it's still pressed
		retlw	0x00				;return is not
		

Sw3On		call	Delay50
		btfsc	I2C_PORT,	SW3		;wait until button is released
		retlw	0x03				;return 0x03
		goto	Sw3On

Switch4		call	Delay50				;give switch time to stop bouncing
		btfsc	I2C_PORT,	SW4		;check it's still pressed
		retlw	0x00				;return is not
		

Sw4On		call	Delay50
		btfsc	I2C_PORT,	SW4		;wait until button is released
		retlw	0x04				;return 0x04
		goto	Sw4On



; End of key routines

Show_Text	movwf	Adr_Lo			;set to start of text
		movlw	0x00
		movwf	Data_Page		;set EEPROM page
NextChar	call	Read_EEPROM		;get a character from the EEPROM
		movwf	count
		xorlw	0x80			;is it an 0x80? (command character)
		btfsc	STATUS, Z
		goto	Command
		movf	count,	w
		xorlw	0x00			;is it a zero? (end of text)
		btfsc	STATUS, Z
		goto	$+4
		call	LCD_Char
		incf	Adr_Lo,	f
		goto	NextChar
		return

Command		incf	Adr_Lo,	f
		call	Read_EEPROM		;get a command from the EEPROM
		call	LCD_Cmd			;execute the command
		goto	NextChar

; Start of Buffer routines

Show_Buf
		call	LCD_Line1
		movf	buf4,	w
		call	LCD_HEX
		movlw	':'
		call	LCD_Char
		movf	buf3,	w
		call	LCD_HEX
		movlw	':'
		call	LCD_Char
		movf	buf2,	w
		call	LCD_HEX

; extract year and date
		movf	buf5,	w
		andlw	0x3F
		movwf	date
		swapf	buf5,	w
		andlw	0x0C
		movwf	year
		rrf	year,	f
		rrf	year,	f
; extract day and month
		movf	buf6,	w
		andlw	0x1F
		movwf	month
		swapf	buf6,	w
		andlw	0x0E
		movwf	day
		rrf	day,	f

		call	LCD_Line2
		movf	date,	w
		call	LCD_HEX
		movlw	'/'
		call	LCD_Char
		movf	month,	w
		call	LCD_HEX
		movlw	'/'
		call	LCD_Char
		movlw	0x20			;always 20xx
		call	LCD_HEX
		movf	year,	w
		call	LCD_HEX
		return

Fill_Buf					; fill up the data buffer with 7 values
		movlw 	buf			; to set the clock values
		movwf 	FSR

		movlw 	0x00			
		movwf 	INDF

		incf 	FSR,	f		; set hundredths
		movlw 	0x00
		movwf 	INDF

		incf 	FSR,	f		; set seconds
		movlw 	0x00
		movwf 	INDF

		incf 	FSR,	f		; set minutes
		movlw 	0x30
		movwf 	INDF

		incf 	FSR,	f		; set hours
		movlw 	0x06	
		movwf 	INDF

		incf 	FSR,	f		; set year/date
		movlw 	0x94
		movwf 	INDF

		incf 	FSR,	f		; set day/month
		movlw 	0x48
		movwf 	INDF

		return

Fill_Buf2					; fill up the data buffer with 7 values
		movlw 	buf			; to set the text values
		movwf 	FSR

		movlw 	'H'			
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'o'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'u'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'r'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	's'	
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'.'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	0x00
		movwf 	INDF

		return

Fill_Buf3					; fill up the data buffer with 7 values
		movlw 	buf			; to set the text values
		movwf 	FSR

		movlw 	'M'			
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'i'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'n'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'u'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	't'	
		movwf 	INDF

		incf 	FSR,	f
		movlw 	'e'
		movwf 	INDF

		incf 	FSR,	f
		movlw 	0x00
		movwf 	INDF

		return

; End of buffer routines

;Start of I2C routines

Write_EEPROM					; write W register to address Adr_Lo
		movwf	DAT_VAL			; save W
		call	I2C_Start
		call	I2C_Set_Write

; If ACK error display 'e'

		btfsc	I2Cflags, 0
		call	Error_Routine

;        	call	I2C_Hi_Adr		; used for extendd addressing (24L64/5)

		call	I2C_Lo_Adr

; If ACK error display 'f'

		btfsc	I2Cflags, 0
		call	Error_Routine1

        	movf	DAT_VAL, 	W	; send the actual data
        	movwf	OutputByte
        	call	I2C_Out
        	call	I2C_NAK

; If ACK error display 'g'

		btfsc	I2Cflags, 0
		call	Error_Routine2

        	call	I2C_Stop 
		call	WaitForWrite
;		call	Delay10			; 10ms delay max. required for EEPROM write cycle
        	return

Read_EEPROM					; reads data at location specified in Adr_Lo (& Adr_Hi for 24LC64)
						; and page specified in Data_Page
						; returns result in W
		call 	I2C_Start

		call	I2C_Set_Write

; If ACK error display 'e'

		btfsc	I2Cflags, 0
		call	Error_Routine

;		call	I2C_Hi_Adr		; used for extended addressing (24LC64/5)
		call	I2C_Lo_Adr

; If ACK error display 'f'

		btfsc	I2Cflags, 0
		call	Error_Routine1

        	call 	I2C_Start		; note there is no STOP
		call	I2C_Set_Read

; If ACK error display 'g'

		btfsc	I2Cflags, 0
		call	Error_Routine2

        	call 	I2C_Read		; fetch the byte
        	call 	I2C_Send_NAK		; send no acknowledgement

        	call 	I2C_Stop
		movf 	InputByte, 	W	; return the byte in W
        	return

Seq_Write_EEPROM				; write buffer to address Adr_Lo
		movwf	DAT_VAL			; save W
		call	I2C_Start
		call	I2C_Set_Write

; If ACK error display 'e'

		btfsc	I2Cflags, 0
		call	Error_Routine

;        	call	I2C_Hi_Adr		; used for extendd addressing (24L64/5)

		call	I2C_Lo_Adr

; If ACK error display 'f'

		btfsc	I2Cflags, 	0
		call	Error_Routine1

		movlw 	buf			; now write Buff_Size bytes to EEPROM
		movwf 	FSR		
		movlw 	Buf_Size
		movwf 	N
SEQ_WRITE_1:
		movf 	INDF, 		w	; fetch the data byte from the buffer
        	movwf	OutputByte
        	call	I2C_Out
        	call 	I2C_NAK

; If ACK error display 'g'

		btfsc	I2Cflags, 0
		call	Error_Routine2

		incf 	FSR, 		f
		decfsz 	N, 		f
		goto 	SEQ_WRITE_1

        	call	I2C_Stop 
		call	WaitForWrite
;		call	Delay10			; 10ms delay max. required for EEPROM write cycle
        	return


Seq_Read_EEPROM					; reads data at location specified in Adr_Lo (& Adr_Hi for 24LC64)
						; and page specified in Data_Page
						; returns 4 byte result in buf
		call 	I2C_Start
		call	I2C_Set_Write

; If ACK error display 'e'

		btfsc	I2Cflags, 0
		call	Error_Routine

;		call	I2C_Hi_Adr		; used for extended addressing (24LC64/5)
		call	I2C_Lo_Adr

; If ACK error display 'f'

		btfsc	I2Cflags, 0
		call	Error_Routine1

        	call 	I2C_Start		; note there is no STOP
		call	I2C_Set_Read

; If ACK error display 'g'

		btfsc	I2Cflags, 0
		call	Error_Routine2

		movlw 	buf			; now sequentially read bytes from EEPROM
		movwf 	FSR		
		movlw 	Buf_Size
		movwf 	N
SEQ_READ_1:
		call 	I2C_Read		; fetch each byte from EEPROM
		movf 	InputByte,	w
		movwf 	INDF			; and save in data buffer
		incf 	FSR,		f
		decfsz 	N, 		f
		goto 	SEQ_READ_2		; not done
		goto 	SEQ_READ_3

SEQ_READ_2:
		call 	I2C_ACK			; if not done, send an ACK and continue
		goto 	SEQ_READ_1
SEQ_READ_3:

        	call 	I2C_Send_NAK		; send no acknowledgement

        	call 	I2C_Stop
		movf 	InputByte, 	w	; return the byte in W
        	return

; The following routines are low level I2C routines applicable to most
; interfaces with I2C devices.

I2C_Read					; read byte on i2c bus
		clrf 	InputByte
		movlw 	0x08
		movwf 	_N			; set index to 8	
		call	HIGH_SDA		; be sure SDA is configured as input
In_Bit
		call 	HIGH_SCL		; clock high
		btfss 	I2C_PORT,	SDA	; test SDA bit
		goto	In_Zero
		goto	In_One

In_Zero
		bcf 	STATUS, 	C	; clear carry
		rlf 	InputByte, 	f	; i_byte = i_byte << 1 | 0
		goto 	Cont_In

In_One
		bsf	STATUS, 	C	; set carry
		rlf 	InputByte, 	f

Cont_In
		call	LOW_SCL			; bring clock low
		decfsz 	_N, 	F		; decrement index
		goto 	In_Bit
		return

I2C_Out:					; send w register on I2C bus
        	movwf 	OutputByte
		movlw 	0x08
		movwf 	_N
Out_Bit:
		bcf 	STATUS,		C	; clear carry
		rlf 	OutputByte, 	f	; left shift, most sig bit is now in carry
		btfss 	STATUS, 	C	; if one, send a one
		goto 	Out_Zero
		goto 	Out_One

Out_Zero:
		call 	LOW_SDA			; SDA at zero
		call 	Clock_Pulse	
		call 	HIGH_SDA
		goto 	Out_Cont

Out_One:
		call 	HIGH_SDA		; SDA at logic one
		call 	Clock_Pulse
Out_Cont:
		decfsz 	_N,		F	; decrement index
		goto 	Out_Bit
		return	

;;;;;;
		
I2C_NAK:					; bring SDA high and clock
		call 	HIGH_SDA
		call 	HIGH_SCL

		clrf	count			; wait for ACK
WaitForACK	incf	count, f		; increase timeout counter each time ACK is not received
		btfsc	STATUS, Z
		goto	No_ACK_Rec
		btfsc	I2C_PORT,	SDA	; test pin. If clear, EEPROM is pulling SDA low for ACK
		goto	WaitForACK		; ...otherwise, continue to wait
		bcf	I2Cflags, 0		; clear flag bit (ACK received)
		call 	LOW_SCL
		return

I2C_Send_NAK:					; bring SDA high and clock
		call 	HIGH_SDA
		call 	Clock_Pulse
		return

WaitForWrite					; poll ACK for write timing
		call 	I2C_Start
		call	I2C_Set_Write
		btfsc	I2Cflags, 0
		goto	WaitForWrite
		return

;------ No ACK received from slave (must use "return" from here)
;; Typically, set a flag bit to indicate failed write and check for it upon return.
No_ACK_Rec
		bsf	I2Cflags, 0		; set flag bit
		return	

;------ No ACK received from slave.  This is the error handler.
Error_Routine
; Output error message, etc. here
		movlw	'e'
		call	LCD_Char
		return				; returns to INITIAL calling routine

Error_Routine1
; Output error message, etc. here
		movlw	'f'
		call	LCD_Char
		return

Error_Routine2
; Output error message, etc. here
		movlw	'g'
		call	LCD_Char
		return

I2C_ACK:
		call 	LOW_SDA
		call 	Clock_Pulse
		return

I2C_Start:				
		call 	LOW_SCL
		call 	HIGH_SDA
		call 	HIGH_SCL
		call 	LOW_SDA			; bring SDA low while SCL is high
		call 	LOW_SCL
		return

I2C_Stop:
		call 	LOW_SCL
		call 	LOW_SDA
		call 	HIGH_SCL
		call 	HIGH_SDA		; bring SDA high while SCL is high
		call 	LOW_SCL
		return

I2C_Set_Write	rlf 	Data_Page, 	W	; shift device page
		andlw	b'00001110'		; AND to make sure in range
        	iorlw 	Chip_Write
        	call 	I2C_Out
        	call 	I2C_NAK
		return

I2C_Set_Read	rlf 	Data_Page, 	W	; shift device page
		andlw	b'00001110'		; AND to make sure in range
        	iorlw 	Chip_Read
        	call 	I2C_Out
        	call 	I2C_NAK
		return

I2C_Lo_Adr      movf 	Adr_Lo, 	W	; send low byte of address
        	call 	I2C_Out
        	call 	I2C_NAK
		return

I2C_Hi_Adr      movf 	Adr_Hi, 	W	; send low byte of address
        	call 	I2C_Out
        	call 	I2C_NAK
		return

Clock_Pulse:					; SCL momentarily to logic one
		call 	HIGH_SCL
		call 	LOW_SCL
		return		

HIGH_SDA:					; high impedance by making SDA an input
		bsf 	STATUS, 	RP0	; bank 1
		bsf 	I2C_TRIS, 	SDA	; make SDA pin an input
		bcf 	STATUS, 	RP0	; back to bank 0
		return

LOW_SDA:
		bcf 	I2C_PORT, 	SDA	
		bsf 	STATUS, 	RP0	; bank 1
		bcf 	I2C_TRIS, 	SDA	; make SDA pin an output
		bcf 	STATUS, 	RP0	; back to bank 0
		return

HIGH_SCL:
		bsf 	STATUS, 	RP0	; bank 1
		bsf 	I2C_TRIS, 	SCL	; make SCL pin an input
		bcf 	STATUS, 	RP0	; back to bank 0
		return

LOW_SCL:
		bcf	I2C_PORT, 	SCL
		bsf 	STATUS, 	RP0	; bank 1
		bcf 	I2C_TRIS, 	SCL	; make SCL pin an output
		bcf 	STATUS, 	RP0	; back to bank 0
		return

; End of I2C routines

;LCD routines

;Initialise LCD
LCD_Init	call 	LCD_Busy		;wait for LCD to settle

		movlw	0x20			;Set 4 bit mode
		call	LCD_Cmd

		movlw	0x28			;Set display shift
		call	LCD_Cmd

		movlw	0x06			;Set display character mode
		call	LCD_Cmd

		movlw	0x0c			;Set display on/off and cursor command
		call	LCD_Cmd			;Set cursor off

		call	LCD_Clr			;clear display

		retlw	0x00

; command set routine
LCD_Cmd		movwf	templcd
		swapf	templcd,	w	;send upper nibble
		andlw	0x0f			;clear upper 4 bits of W
		movwf	LCD_PORT
		bcf	LCD_PORT, LCD_RS	;RS line to 1
		call	Pulse_e			;Pulse the E line high

		movf	templcd,	w	;send lower nibble
		andlw	0x0f			;clear upper 4 bits of W
		movwf	LCD_PORT
		bcf	LCD_PORT, LCD_RS	;RS line to 1
		call	Pulse_e			;Pulse the E line high
		call 	LCD_Busy
		retlw	0x00

LCD_CharD	addlw	0x30			;add 0x30 to convert to ASCII
LCD_Char	movwf	templcd
		swapf	templcd,	w	;send upper nibble
		andlw	0x0f			;clear upper 4 bits of W
		movwf	LCD_PORT
		bsf	LCD_PORT, LCD_RS	;RS line to 1
		call	Pulse_e			;Pulse the E line high

		movf	templcd,	w	;send lower nibble
		andlw	0x0f			;clear upper 4 bits of W
		movwf	LCD_PORT
		bsf	LCD_PORT, LCD_RS	;RS line to 1
		call	Pulse_e			;Pulse the E line high
		call 	LCD_Busy
		retlw	0x00

LCD_Line1	movlw	0x80			;move to 1st row, first column
		call	LCD_Cmd
		retlw	0x00

LCD_Line2	movlw	0xc0			;move to 2nd row, first column
		call	LCD_Cmd
		retlw	0x00

LCD_Line1W	addlw	0x80			;move to 1st row, column W
		call	LCD_Cmd
		retlw	0x00

LCD_Line2W	addlw	0xc0			;move to 2nd row, column W
		call	LCD_Cmd
		retlw	0x00

LCD_CurOn	movlw	0x0d			;Set display on/off and cursor command
		call	LCD_Cmd
		retlw	0x00

LCD_CurOff	movlw	0x0c			;Set display on/off and cursor command
		call	LCD_Cmd
		retlw	0x00

LCD_Clr		movlw	0x01			;Clear display
		call	LCD_Cmd
		retlw	0x00

LCD_HEX		movwf	lcdtmp
		swapf	lcdtmp,	w
		andlw	0x0f
		call	HEX_Table
		call	LCD_Char
		movf	lcdtmp, w
		andlw	0x0f
		call	HEX_Table
		call	LCD_Char
		retlw	0x00

Pulse_e		bsf	LCD_PORT, LCD_E
		nop
		bcf	LCD_PORT, LCD_E
		retlw	0x00

LCD_Busy
		bsf	STATUS,	RP0		;set bank 1
		movlw	0x0f			;set Port for input
		movwf	LCD_TRIS
		bcf	STATUS,	RP0		;set bank 0
		bcf	LCD_PORT, LCD_RS	;set LCD for command mode
		bsf	LCD_PORT, LCD_RW	;setup to read busy flag
		bsf	LCD_PORT, LCD_E
		swapf	LCD_PORT, w		;read upper nibble (busy flag)
		bcf	LCD_PORT, LCD_E		
		movwf	templcd2 
		bsf	LCD_PORT, LCD_E		;dummy read of lower nibble
		bcf	LCD_PORT, LCD_E
		btfsc	templcd2, 7		;check busy flag, high = busy
		goto	LCD_Busy		;if busy check again
		bcf	LCD_PORT, LCD_RW
		bsf	STATUS,	RP0		;set bank 1
		movlw	0x00			;set Port for output
		movwf	LCD_TRIS
		bcf	STATUS,	RP0		;set bank 0
		return

;end of LCD routines


;Delay routines

Long_Delay
		call	Delay255
		call	Delay255
		call	Delay255
		call	Delay255
		return

Delay255	movlw	0xff		;delay 255 mS
		goto	d0
Delay100	movlw	d'100'		;delay 100mS
		goto	d0
Delay50		movlw	d'50'		;delay 50mS
		goto	d0
Delay20		movlw	d'20'		;delay 20mS
		goto	d0
Delay10		movlw	d'10'		;delay 10mS
		goto	d0
Delay1		movlw	d'1'		;delay 1mS
		goto	d0
Delay5		movlw	0x05		;delay 5.000 ms (4 MHz clock)
d0		movwf	count1
d1		movlw	0xC7
		movwf	counta
		movlw	0x01
		movwf	countb
Delay_0		decfsz	counta, f
		goto	$+2
		decfsz	countb, f
		goto	Delay_0

		decfsz	count1	,f
		goto	d1
		retlw	0x00

;end of Delay routines

		end