;**********************************************************
;*  DEMO876.ASM
;**********************************************************
;*  Urbn Elektronika
;*  2002.08.28
;**********************************************************
;*  A 870DEMO krtyra kszlt tesz program
;*
;*  Reset utn a P1 potenciomterrel bellthat a mintavtelezsi id
;*  elfogadsa a SW2 gomb lenyomsval      
;*
;*  A P1 potenciometer rteket a belltsi idnknt beolvassa
;*  s kirja a kperny msodik sorba.
;*  mrs utn sleep llapotba megy
;*  hlozati tplls esetn a mrt adatot kikldi a soros vonalon 115.200 bps
;*  SW2 gomb lenyomsval bekapcsolhat az akkumultor tltse + kikldi az zenetet a soros vonalra
;*  SW3 gomb lenyomsval kikapcsolhat az akkumultor tltse + kikldi az zenetet a soros vonalra
;*  
;*  Bekapcsolt tlts esetn a referencia feszltsg mrsbl kell kiszmolni
;*  hogy az AC adapter fel van e kapcsolva. (a bels referencia bekepcsolsval 
;*  kell megmrni az AN3 lbon lev feszltsget ebbl lehet kvetkeztetni, hogy
;*  valjban mekkora a tpfeszltsg. ha a tpfesz nagyobb mint 4.8 akkor biztos hogy csatlakoztatva
;*  van az AC adapter. Ha kisebb akkor ki kell kapcsolni a tlts modot.
;*
;**********************************************************
	errorlevel -302
	list p=16f870
	include "p16f870.inc"


;****** konstansok meghatrozsa ***********************
idozit	EQU	0xF2	;az egysgnyi idzts

;****** program vltozinak meghetrozsa ***************

w_temp		EQU	0x71 
status_temp		EQU	0x72

;ezek az adatok 0. - 2.  lapon ltszanak
	cblock	020H
	counter
	buffer:16
	Temp
	LowB
	MidB
	HigB
	CHIndex
	HIndex
	Index
	Help
	ora
	SRate
	TxC
	endc

;ezek az adatok a 1. - 3. lapon ltszanak      
        	cblock	0A0H
        	bcount
	ccount
	I2CBuf
	endc
	
;A cimke nev stringet kiirja a 16 byte-os buffer-ba
printxt	macro	cimke
	banksel	EEADRH
	movlw	high cimke
	movwf	EEADRH
	movlw	low cimke
	movwf	EEADR
	call	kiir
	endm

	; Start at the reset vector
	org	0x000
 	nop

	goto	Reset
;****** megszakts kiszolgl rutinok
	ORG     	0x004             ; interrupt vector location

	movwf   	w_temp            ; save off current W register contents
	movf	STATUS,w          ; move status register into W register
TEST	movwf	status_temp       ; save off contents of STATUS register

	banksel	PIR1
	BTFSS	PIR1,TMR1IF	;Timer okozott megszaktst?
	goto        NemTMR1	
	bcf	PIR1,TMR1IF
	banksel	PORTC
	movf	ora,F
	btfss	STATUS,Z	; ora=0 ?
	decf	ora,F	; az ora szmll cskkentse ha nagyobb mint 0
	clrf	TMR1L
	movlw	idozit
	movwf	TMR1H	;a timer1 indul rtke 1 msodpercere
		
NemTMR1
	banksel	PORTC
        	btfss	PORTB,2	;tplls helynek vizsglata (akku - adatapter)
	goto	AKKUi
	goto	TAPi
AKKUi	printxt	akkumod
	call	print1
	goto	EndInt
TAPi	
	banksel	TRISA
	btfss	TRISA,4	;tlts be van kapcsolva?
	goto	tolt
	printxt	acmod
	call	print1
	goto	EndInt

tolt	
;id kell beszurni a specilis AC adapter vizsglatot
	banksel	PORTA
	movlw	b'10011001'	;az AN3 a bemenetre kacsolva Sampling
	movwf	ADCON0
	banksel	TRISA
	bcf	TRISB,2		;a referencia forrst kimenetbe kapcsolni
	printxt	toltes
	call	print1
	movlw	b'00000010'	;balra rendezve bels ref
	movwf	ADCON1
	banksel	PORTA
	bsf	PORTB,2		;a referencia fesz bekapcsolsa
	movlw	b'10011101'		; az AN3 mrsnek elindtsa
	movwf	ADCON0
	

AN3loop
	btfsc	ADCON0,GO
	goto	AN3loop
	
	movlw	0x80
	subwf	ADRESH,W
	btfsc	STATUS,C
	goto	toltesoff		
;Az AD eredeti paramreinek belltsa
eredeti	
	banksel	PORTA
	movlw	B'10001001'	;Fosc/32, A/D enabled
	movwf	ADCON0
	banksel	TRISA
	movlw	B'10000011'		;jobbra igazit,4 analog csatorna
	movwf	ADCON1		;fld s AN3 referencikkal
	bsf	TRISB,2		;a referencia forrst bemenetbe kapcsolni

EndInt	
	printxt potmeter
	movf    status_temp,w     ; retrieve copy of STATUS register
	movwf	STATUS            ; restore pre-isr STATUS register contents
	swapf   w_temp,f
	swapf   w_temp,w          ; restore pre-isr W register contents
	retfie    
toltesoff
	banksel	TRISA
	bsf	TRISA,4
	goto	eredeti
	
	include "math.inc"

szamok
	DA	" ICD Demo Board "
neve
	DA	"for PIC16F870 uC"
akkumod
	DA	"-< Akku mode  >-"
acmod
	DA	"AC Adapter Mode " 
potmeter
	DA	"Result =        "
jobb
	DA	"Toltes bekapcsol"
bal
	DA	"Toltes kikapcsol"
toltes
	DA	"-<Akku toltes>- "
tulcsorg
	DA	"Tulcsorgott !!!!"
setup1
	DA	"Sampling Rate   "
setup2
	DA	"sec/samp=       "

kiir	
	movlw	08H
	movwf	counter
	movlw	buffer+0FH
	movwf	FSR

klop
	banksel	EECON1
	bsf	EECON1,EEPGD
	bsf	EECON1,RD
	NOP
	NOP
	banksel	EEADRH
	
	rlf	EEDATA,W
	rlf	EEDATH,w
	movwf	INDF	
	movlw	07FH
	andwf	EEDATA,w
	decf	FSR,F
	movwf	INDF
	incf	EEADR,F
	btfsc	STATUS,Z
	incf	EEADRH,F
	decf	FSR,F
	decfsz	counter,F
	goto	klop
	return

Reset

	
	call	InitIIC
	call	InitUART
	call	delay2sec
	call	InitLCD
	call	delay200ms
	printxt	szamok
	call	print1
	printxt	neve
	call	print2 
	call	delay2sec
	call	delay2sec
	printxt	Setup1
	call	print1
	printxt	Setup2
	call	print2
	banksel PORTC
	clrf	PORTC		;Clear PORTC
	movlw	B'10001001'	;Fosc/32, A/D enabled 
	movwf	ADCON0
	movlw	B'00001110'	;Presc=1 Oszc1_disable  TMR1_ON
	movwf	T1CON
	movlw	idozit
	movwf	TMR1H
	clrf	PIR1
	banksel	TRISC
 	movlw	B'10000111'	;TMR0 prescaler, 1:256
	movwf	OPTION_REG
	clrf	TRISC
	bsf	TRISC,7
	bsf	TRISC,6

;belltsi men (minatvtelezsi id belltsa) 
	movlw	B'00000011'		;balra igazt  analog csat.
	movwf	ADCON1		; ref+ = AN3     ref- = GND
beall
	banksel	TRISC
	bsf	PORTA,4		;a tlts a kapcsolsa 
	bcf	TRISB,2		;a referencia forrst kimenetbe kapcsolni
	banksel	PORTC
	bcf	PORTA,4		;a tlts kimenet alcsonyra lltva
	bsf	PORTB,2		;a kls referencia tpfesz bekapcsolsa
	call	delay5us
	call	delay5us
	bcf	INTCON,T0IF
	bsf	ADCON0,GO		;Start A/D conversion
Wait0
	btfsc	ADCON0,GO		;Wait for conversion to complete
	goto	Wait0
	banksel	TRISB
	bsf	TRISB,2		;referencia tpfesznek kikapcsolsa
	banksel	PORTC
	movf	ADRESH,W	;
	andlw	0xF8
	movwf	LowB
	bcf	STATUS,C
	rrf	LowB,F
	rrf	LowB,F
	rrf	LowB,F		;/8 (0-31 skla)
	incf	LowB,F		; (1-32 skla)
	movfw	LowB
	movwf	Srate
	movwf	ora
	clrf	MidB
	clrf	HigB
	call	BinDec		;Do it again
	banksel PORTC
	movlw	6
	movwf	Index
	movlw	6
	movwf	Counter
	call	anulal		;az els nullk levgsa
	call	print2
	banksel	PORTC
	btfsc	PORTB,0		;jobb gomb lenyomva?
	goto	beall		;nincs
	clrf	TMR1L
	movlw	idozit
	movwf	TMR1H
	bsf	T1CON,TMR1ON
	printxt	potmeter
	call	print2
	banksel	TRISC
	movlw	B'10000011'		;jobbra igazit,4 analog csatorna
	movwf	ADCON1		;fld s AN3 referencikkal
	bsf	INTCON,GIE
	bsf	INTCON,PEIE
	bsf	PIE1,TMR1IE

	goto	Main

InitUART
	banksel	TRISA
	bcf	TRISC,6
	movlw	B'00000100'	;8bit async
	movwf	TXSTA	;HighSPEED  speed=oszc/16*(BRG+1)	 	
	movlw	05H
	movwf	SPBRG
	return

Main
	sleep
	
MainNo
	;billenty lekezelse (tlts be- s kikapcsolsa)
	banksel	PORTB
	btfsc	PORTB,0		;SW2 gomb lenyomva?
	goto	key2		;nincs
	printxt	jobb
	call	print2
	banksel	0
	movlw	0x10
	movwf	TxC
	call	StartTX
	banksel	TRISA
	bcf	PORTA,4		;tltst bekapcsol
	banksel	PORTA
keylopj	btfss	PORTB,0		;mg mindig nyomod?
	goto	keylopj
	printxt	potmeter
	call	print2
	goto	keyEnd
key2	btfsc	PORTB,1		;sw3 gomb lenyomva?
	goto	keyEnd		;nincs
	printxt	bal
	call	print2
	banksel	0
	movlw	0x10
	movwf	TxC
	call	StartTX
	banksel	TRISA
	bsf	PORTA,4		;tltst kikapcsol
	banksel	PORTB
keylopb	btfss	PORTB,1		;mg mindig nyomod?
	goto	keylopb
	printxt	potmeter
	call	print2	


keyEnd
	banksel	PORTC	;az idzts lejrtnak vizsglata
	movf	ora,F
	btfss	STATUS,Z
	goto	Main	;Nem jrt le, menj aludni

	movfw	SRate
	movwf	ora
	banksel	TRISB
	bcf	TRISB,2
	
	banksel	PORTC
	bsf	PORTB,2		;referencia bekapcsolsa
	call	delay5us		;5usec bellsi id
	call	delay5us		;kivrsa
	bcf	INTCON,T0IF
	bsf	ADCON0,GO		;Start A/D conversion
Wait
	btfsc	ADCON0,GO		;Wait for conversion to complete
	goto	Wait

	banksel	TRISB
	bsf	TRISB,2		;referencia kikapcsolsa
	banksel	PORTC
	movf	ADRESH,W		;Write A/D result to PORTC
	movwf	MidB
	banksel	ADRESL
	movf	ADRESL,W
	banksel ADRESH
	movwf	LowB
	clrf	HigB
	call	BinDec		;Do it again
	banksel PORTC
	movlw	6
	movwf	Index
	movlw	6
	movwf	Counter
	call	anulal		;az els nullk levgsa
	call	print2
	
	banksel	PORTC
        	btfss	PORTB,2
	goto	main2		;akkumultor mod, ne kuldj s soros vonalra
	banksel	0
	movlw	4
	movwf	TxC		;a kikldend karakterek szma
	call	StartTX
main2



Mainv	
	banksel	PORTC
	btfss	PORTB,2
	goto	main
	goto	MainNo		;ne menj sleep modba


; a bufferben lev karakterek kikldse a soros vonalra (max 16 karakter)
; a bufferben visszafel kell elhelyezni az adatot
; a karakterek szma a TxC szmllban

StartTX	
	banksel	TRISA
	bsf	TXSTA,TXEN		;Ads engedlyezs
	banksel	PORTA
	bsf	RCSTA,SPEN
	clrf	PIR1
	movfw	TxC
	movwf	counter		;a kikldend karakterek szma
	movlw	buffer-1
	addwf	counter,W		;az ad buffer kezdcmnek meghatrozsa
	movwf	FSR
stx	
	movf	INDF,W
	movwf	TXREG		
	decf	FSR,F
stxl	btfss	PIR1,TXIF		;ad shift reg res?
	goto	stxl		;nem
	decfsz	counter,F
	goto	stx
	movlw	0DH
	movwf	TXREG
stx2	btfss	PIR1,TXIF
	goto	stx2	
	banksel	TRISA
stx3	btfss	TXSTA,TRMT		;kiment az sszes?
	goto	stx3	
	return
	
	
	include "IICLCD.inc"

	end
