;------------------------------------------------------------------------
; 3 byte-os szmbol kivonja a HIndex ltal meghatrozott decimlis szmot
; 10,100,1000,10000,100 000,1 000 000  Carry jelzi a alulcsorgst
; hasznlt regiszterek : Temp,HIndex,LowB,MidB,HigB
;------------------------------------------------------------------------

Subc24      clrf       Temp        ; it will temporary save CF
            movf       Index,W     ; pointer to low byte of constant
            movwf      HIndex      ; W -> HIndex
	    call       DecTable    ; W returned with low byte of constant
            bsf        Status,C   ; set C
            subwf      LowB,F      ; LowB - W -> LowB
                                   ; if underflow -> C=0
            btfsc      Status,C
            goto       Step1
            bsf        Status,C
            movlw      1
            subwf      MidB,F      ; decrement MidB
                                   ; if underflow -> C=0
            btfsc      Status,C
            goto       Step1

            bsf        Status,C
            movlw      1
            subwf      HigB,F      ; decrement HigB
            btfsc      Status,C   ; if underflow -> C=0
            goto       Step1
            bsf        Temp,C     ; set C

Step1       decf       HIndex,F
            movf       HIndex,W    ; pointer to middle byte of const
            call       DecTable
            bsf        Status,C
            subwf      MidB,F      ; MidB - W -> MidB
            btfsc      Status,C   ; if underflow -> C=0
            goto       Step2
            bsf        Status,C
            movlw      1
            subwf      HigB,1      ; decrement HigB
            btfsc      Status,C   ; if underflow -> C=0
            goto       Step2
            bsf        Temp,C     ; set C

Step2       decf       HIndex,F
            movf       HIndex,W    ; pointer to middle byte of constatnt
            call       DecTable
            bsf        Status,C
            subwf      HigB,F      ; HigB - W -> HigB
            btfsc      Status,C   ; if underflow -> C=0
            goto       ClearC
            bsf        Status,C
            goto       SubEnd
ClearC     rrf        Temp,C     ; C -> Status
SubEnd      retlw      0

; ------------------------------------------------------------------------
; 3 byte-os szmhoz hozzadja a HIndex regiszter ltal meghatrozott
; decimlis szmot (1,10,100,1000,10000,100000,1000000
; carry tlcsorgst jelez
; hasznlt regiszterek : Temp,HIndex,LowB,MidB,HigB
; ------------------------------------------------------------------------

Addc24      clrf       Temp        ; register for temporary storage of C
            movf       Index,W     ; pointer to lower byte of const into W
            movwf      HIndex      ; save it into HIndex
            call       DecTable    ; W contains low byte of const
            bcf        Status,C   ; clear C
            addwf      LowB,1      ; W + LowB -> LowB
            btfss      Status,C   ; test overflow
            goto       Add2
            bcf        Status,C   ; clear C
            movlw      1
            addwf      MidB,F      ; increment MidB
            btfss      Status,C
            goto       Add2
            bcf        Status,C
            movlw      1
            addwf      HigB,F      ; increment HigB
            btfss      Status,C   ; test overflow
            goto       Add2
            bsf        Temp,C     ; store C
Add2        decf       HIndex,F    ; pointer to middle byte into W
            movf       HIndex,W
            call       DecTable
            bcf        Status,C
            addwf      MidB,1      ; W + MidB -> MidB
            btfss      Status,C
            goto       Add3
            bcf        Status,C   ; clear C
            movlw      1
            addwf      HigB,1      ; increment HigB
            btfss      Status,C
            goto       Add3
            bsf        Temp,C
Add3        decf       HIndex,F    ; pointer to higher byte into W
            movf       HIndex,W
            call       DecTable
            bsf        Status,C
            addwf      HigB,F      ; W + HigB -> HigB,
            btfss      Status,C
            goto       ClarC
            bsf        Status,C
            goto       AddEnd
ClarC      rrf        Temp,C     ; C -> Status
AddEnd      retlw      0

; ------------------------------------------------------------------------
; a dekdok hrom Byte-os tblzata
; ------------------------------------------------------------------------

DecTable    
	    addwf      PCL,F        ; W + PC -> PC
            retlw      0           ; 10
            retlw      0           ;
            retlw      0Ah         ;

            retlw      0           ; 100
            retlw      0           ;
            retlw      064h        ;

            retlw      0           ; 1 000
            retlw      03h         ;
            retlw      0E8h        ;

            retlw      0           ; 10 000
            retlw      027h        ;
            retlw      010h        ;

            retlw      01h         ; 100 000
            retlw      086h        ;
            retlw      0A0h        ;

            retlw      0Fh         ; 1 000 000
            retlw      042h        ;
            retlw      040h        ;

; ------------------------------------------------------------------------
; Conversion BCD -> 7 segments
; ------------------------------------------------------------------------

AsciiTable    addwf      PCL,F        ; W + PC -> PC
;                        fbacdheg
            retlw      030H
            retlw      031H
            retlw      032H
            retlw      033H
            retlw      034H
            retlw      035H
            retlw      036H
            retlw      037H
            retlw      038H
            retlw      039H
            retlw      'E'
	
; ------------------------------------------------------------------------
; A kijelezhet legnagyobb szm rtke
; 9999999 = 98 96 7F
; ------------------------------------------------------------------------

MFTable     addwf      PCL,F
            retlw      098h	;HI
            retlw      096h	;MID
            retlw      07fh	;LO
;-------------------------------------------------------------------------
; A kijelezhet a mrt rtk?
;-------------------------------------------------------------------------
BinDec	movlw	098H
	subwf	HigB,W
	btfsc	Status,Z
	goto	Go1	;Hi Byte megegyezik tovbbi vizsglat szksges
	btfsc	Status,C
	goto	over
	goto	Konverz
Go1	movlw	096H
	subwf	MidB,W	
	btfsc	Status,Z	
	goto	Go2	;Mid Byte is megeggyezik tovbbi vizsglat szksges
	btfsc	Status,C
	goto	over
	goto	Konverz
Go2	movlw	07FH
	subwf	LowB,W
	btfsc	Status,Z	;Lo Byte is megegyezik ez lesz a legnagyobb kijeleyhet szm
	goto	Konverz
	btfsc	Status,C
	goto	over
	goto	Konverz
	
over	printxt	tulcsorg
	return
; ------------------------------------------------------------------------
; 3 byte-os szm talaktsa 7 dekdos decimlisra
; haznlt regiszterek: Index,Counter,Help,ChIndex
; ------------------------------------------------------------------------
Konverz
            movlw      6*3-1       ; pointer to dec. table
            movwf      Index       ; 6*3-1 -> Index

            movlw      9           ; a kivonsok maximlis szma
            movwf      Counter     ; 9 -> Szm

            clrf       Help

            movlw      6
            movwf      ChIndex

Divide      call       Subc24      ; substract untill result is negative,
            btfsc      Status,C   ; add last substracted number
            goto       Add24       ; next digit
            incf       Help,F
            decf       Counter,F
            btfss      Status,Z
            goto       Divide
            movlw      3
            subwf      Index,F
            goto       Next

Add24       call       Addc24
            movlw      03h
            subwf      Index,F

Next        movlw      9
            movwf      Counter
            movlw      buffer+1        ; LED1 -> W
            addwf      ChIndex,W  ; LED1 + LEDIndex -> W
            movwf      Temp
            decf       Temp,F      ; LEDIndex+LED1-1 -> TEMP
            movf       Temp,W

            movwf      FSR         ; W -> FSR
            movf       Help,W      ; Help -> W
            clrf       Help        ; save result at LEDx
            call       AsciiTable
            movwf      IndF        ; W -> char(6..1)
            decf       ChIndex,F

            movlw      1
            addwf      Index,W
            btfss      Status,Z
            goto       Divide

            movf       LowB,W
	    Decf       FSR,F
            call       AsciiTable				
            movwf      IndF        ; the rest -> char(0)
	    return	
;a buffer Index	helytl Counter szm nullt kitrl
anulal
	banksel	PORTC
	movlw	Buffer
	addwf	Index,w
	movwf	FSR
anul1	movfw	INDF
	sublw	30H
	btfss	STATUS,Z	;nulla?
	return
	movlw	20H
	movwf	INDF
	decf	FSR,F
	decfsz	Counter,F
	goto	anul1
	return
	
	
