//******************************************************************************
// Kivezrls jelz
//******************************************************************************

#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include "charlcd.h"
#include "bootloaders.h"

volatile unsigned char ADl, ADr = 0;
unsigned char temp;

//******************************************************************************
void init(void)
{
  // idzt inicializlsa
  T0CON = 0b10000001;                   // bekapcs, 16bites, src = CLKO, /2
  INTCON2bits.TMR0IP = 1;               // magas priorits
  INTCONbits.TMR0IE = 1;                // TMR0 megszakts eng

  // megszakts belltsok
  #if LCDTIMERPR18 == -1
  RCONbits.IPEN = 0;                    // ktszint IRQ tilts
  #else
  RCONbits.IPEN = 1;                    // ktszint IRQ eng
  #endif
  INTCONbits.GIEL = 1;                  // globlis LO IRQ eng
  INTCONbits.GIEH = 1;                  // globlis IRQ eng
}
//******************************************************************************
void main(void)
{
  // AN0..AN7 analg, a tbbi digitlis I/O
  unsigned char i, c;

  ADCON0 = 0b00000001;                  // 0.csat, konverzi stop, AD bekapcs
  ADCON1 = 0x00000111;                  // VREF- = GND, VREF+ = VCC, AN0..AN7 be, AN8..AN12 ki (digit I/O)
  ADCON2 = 0b00111110;                  // AD eredmny balra igazt, ACQT = 20TAD, ADCS = FOSC/64

  LcdInit();                            // mkdsre brjuk az LCD-t
  LcdText[0]  = 'L';
  LcdText[1]  = ':';
  LcdText[16] = 'R';
  LcdText[17] = ':';

  init();
  while(1)
  {

    // bal csatorna
    c = ADl;
    for(i = 2; i < 16; i++)
    {
      if(c > 14)
      {
        LcdText[i] = 10;                // hrom vonal
        if(c >= 18)
          c -= 18;
        else
          c = 0;
      }
      else if(c > 9)
      {
        LcdText[i] = 9;                 // kt vonal
        c = 0;
      }
      else if(c > 4)
      {
        LcdText[i] = 8;                 // egy vonal
        c = 0;
      }
      else
      {
        LcdText[i] = ' ';               // szkz
        c = 0;
      }
    }

    // jobb csatorna
    c = ADr;
    for(i = 18; i < 32; i++)
    {
      if(c > 14)
      {
        LcdText[i] = 10;                // hrom vonal
        if(c >= 18)
          c -= 18;
        else
          c = 0;
      }
      else if(c > 9)
      {
        LcdText[i] = 9;                 // kt vonal
        c = 0;
      }
      else if(c > 4)
      {
        LcdText[i] = 8;                 // egy vonal
        c = 0;
      }
      else
      {
        LcdText[i] = ' ';               // szkz
        c = 0;
      }
    }
  }
}

#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
}

#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
  if(INTCONbits.TMR0IF)                 // timer0 interrupt ?
  {
    INTCONbits.TMR0IF = 0;              // nyugtzs

    if(ADCON0 == 0b00000001)            // 0.csat ?
    {
      ADl = ADRESH;
      ADCON0 = 0b00000101;              // 1.csat
      Nop();
      ADCON0bits.GO = 1;
    }
    else if(ADCON0 == 0b00000101)       // 1.csat ?
    {
      ADr = ADRESH;
      ADCON0 = 0b00000001;              // 0.csat
      Nop();
      ADCON0bits.GO = 1;
    }
  }

  LcdIntProcess();                      // frisstjk a kijelz tartalmt
}

