/*
 * usart.c
 *
 * Created: 2015.08.25. 19:43:18
 *  Author: Szabi
 */ 
#include <stdio.h>
#include <avr/io.h>

void USART_Transmit( unsigned char data )
{
while ( !( UCSRA & (1<<UDRE)) )
;
UDR = data;
}

void USART_Init( unsigned int ubrr)
{
UBRRH = (unsigned char)(ubrr>>8);
UBRRL = (unsigned char)ubrr;
UCSRB = (1<<RXEN)|(1<<TXEN);
UCSRC = (1<<URSEL)|(1<<USBS)|(3<<UCSZ0);
}

unsigned char USART_Receive( void )
{
	/* Wait for data to be received */
	while ( !(UCSRA & (1<<RXC)) )
	;
	/* Get and return received data from buffer */
	return UDR;
}

void USART_putstring(char s[])
{
	int i =0;
	
	while (s[i] != 0x00)
	{
		USART_Transmit(s[i]);
		i++;
	}
}
