/*
 * nRF24L01.c
 *
 * Created: 2015.08.25. 19:33:13
 *  Author: Szabi
 */ 
//#define F_CPU 1000000UL
#include <stdio.h>
#include <avr/io.h>
#include <util/delay.h>
#include "usart.h"
#include "SPI.h"
#include "nRF24L01.h"

#define BAUD 9600
#define MYUBRR F_CPU/16/BAUD-1

#define nrf24_CONFIG ((1<<EN_CRC)|(0<<CRCO))


#define nrf24_ADDR_LEN 5


uint8_t SPI_TransferByte(uint8_t data) {
	CSN_lo();
    SPDR = data;
    while((SPSR & (1<<SPIF)) == 0);
    return SPDR;
	CSN_hi();
}
/*
uint8_t nRF_ReadRegister(uint8_t reg)
{           
	CSN_lo();                              
	uint8_t x=SPI_TransferByte(R_REGISTER | (REGISTER_MASK & reg));
	CSN_hi();
	_delay_us(10);
	return x;
}
*/
// send multiple bytes over SPI 
void nRF_TransmitSync(uint8_t* dataout,uint8_t len)
{
    uint8_t i;
    for(i=0;i<len;i++)
    {
        SPI_Send(dataout[i]);
    }
}

void nRF_TransferSync(uint8_t* dataout,uint8_t* datain,uint8_t len)
{
    uint8_t i;

    for(i=0;i<len;i++)
    {
        datain[i] = SPI_TransferByte(dataout[i]);
    }

}


void nRF_TransmitSync2(uint8_t* dataout,uint8_t* datain,uint8_t len)
{
    uint8_t i;

    for(i=0;i<len;i++)
    {
        datain[i] = SPI_TransferByte(dataout[i]);
    }

}

// Read single register from nrf24 
uint8_t nRF_ReadRegister(uint8_t reg)
{
    CSN_lo();
    SPI_TransferByte(R_REGISTER | (REGISTER_MASK & reg));
    uint8_t ret = SPI_TransferByte(0xFF);
    CSN_hi();
	return ret;
}

void nRF_SetRegister(uint8_t reg, uint8_t value) 
{
	CSN_lo(); 
    SPI_Send(W_REGISTER | (REGISTER_MASK & reg));
    SPI_Send(value);
	CSN_hi();
}

void nRF_powerUpRx()
{     
    CSN_lo(); 
    SPI_TransferByte(FLUSH_RX);
    CSN_hi();

    nRF_SetRegister(STATUS,(1<<RX_DR)|(1<<TX_DS)|(1<<MAX_RT)); 

    CE_lo();    
	_delay_us(40);
    nRF_SetRegister(CONFIG,nrf24_CONFIG|((1<<PWR_UP)|(1<<PRIM_RX)));    
    CE_hi();
}

/* send and receive multiple bytes over SPI */
void nrf24_transferSync(uint8_t* dataout,uint8_t* datain,uint8_t len)
{
    uint8_t i;

    for(i=0;i<len;i++)
    {
        datain[i] = SPI_TransferByte(dataout[i]);
    }

}

/* Read single register from nrf24 */
void nrf24_readRegister(uint8_t reg, uint8_t* value, uint8_t len)
{
    CSN_lo(); 
    SPI_TransferByte(R_REGISTER | (REGISTER_MASK & reg));
    nrf24_transferSync(value,value,len);
    CSN_hi();
}

/* Checks if receive FIFO is empty or not */
uint8_t nrf24_rxFifoEmpty()
{
    uint8_t fifoStatus;

    nrf24_readRegister(FIFO_STATUS,&fifoStatus,1);
    
    return (fifoStatus & (1 << RX_EMPTY));
}

/* Checks if data is available for reading */
/* Returns 1 if data is ready ... */
uint8_t nrf24_dataReady() 
{
    // See note in getData() function - just checking RX_DR isn't good enough
    uint8_t status = SPI_TransferByte(0x00);

    // We can short circuit on RX_DR, but if it's not set, we still need
    // to check the FIFO for any pending packets
    if ( status & (1 << RX_DR) ) 
    {
        return 1;
    }

    return !nrf24_rxFifoEmpty();
}

/* Reads payload bytes into data array */
void nrf24_getData(uint8_t* data) 
{
    /* Pull down chip select */
    CSN_lo();

    /* Send cmd to read rx payload */
    SPI_TransferByte(R_RX_PAYLOAD);
    
    /* Read payload */
    nrf24_transferSync(data,data,4);
    
    /* Pull up chip select */
    CSN_hi();

    /* Reset status register */
    nRF_SetRegister(STATUS,(1<<RX_DR));   
}

/* send multiple bytes over SPI */
void nrf24_transmitSync(uint8_t* dataout,uint8_t len)
{
    uint8_t i;
    
    for(i=0;i<len;i++)
    {
        SPI_TransferByte(dataout[i]);
    }

}

/* Write to a single register of nrf24 */
void nrf24_writeRegister(uint8_t reg, uint8_t* value, uint8_t len) 
{
    CSN_lo();
    SPI_TransferByte(W_REGISTER | (REGISTER_MASK & reg));
    nrf24_transmitSync(value,len);
    CSN_hi();
}

void nrf24_rx_address(uint8_t * adr) 
{
    CE_lo();
    nrf24_writeRegister(RX_ADDR_P1,adr,nrf24_ADDR_LEN);
    CE_hi();
}


/* Set the TX address */
void nrf24_tx_address(uint8_t* adr)
{
    /* RX_ADDR_P0 must be set to the sending addr for auto ack to work. */
    nrf24_writeRegister(RX_ADDR_P0,adr,nrf24_ADDR_LEN);
    nrf24_writeRegister(TX_ADDR,adr,nrf24_ADDR_LEN);
}

int main(void)
{ 
	USART_Init(MYUBRR);
	SPI_Init(); 
 	USART_putstring("\n\r");
			_delay_ms(10);
	if( SPI_TransferByte(0x00) == 0x0e)
		USART_putstring("NRF status regiszter OK, kommunikacio OK\n\r");
	else
	{
		USART_putstring("NRF status regiszter HIBA\n\r");
		USART_putstring("Ujraprobalkozas 150ms varakozas utan...\n\r");
		_delay_ms(150);
		if( SPI_TransferByte(0x00) == 0x0e)
		USART_putstring("NRF status regiszter OK, kommunikacio OK\n\r");
		else
		USART_putstring("NRF status regiszter HIBA masodszorra is\n\r");

	}
		_delay_ms(10);
	USART_putstring("Inicializalas kezdete\n\r");

	nRF_SetRegister(RF_CH,5);
		_delay_ms(10);

	    // Set length of incoming payload 
    nRF_SetRegister(RX_PW_P0, 0x00); // Auto-ACK pipe ...
		_delay_ms(10);
    nRF_SetRegister(RX_PW_P1, 4); // Data payload pipe
		_delay_ms(10);
    nRF_SetRegister(RX_PW_P2, 0x00); // Pipe not used 
		_delay_ms(10);
    nRF_SetRegister(RX_PW_P3, 0x00); // Pipe not used 
		_delay_ms(10);
    nRF_SetRegister(RX_PW_P4, 0x00); // Pipe not used 
		_delay_ms(10);
    nRF_SetRegister(RX_PW_P5, 0x00); // Pipe not used 
		_delay_ms(10);

	// 1 Mbps, TX gain: 0dbm
    nRF_SetRegister(RF_SETUP, (0<<RF_DR)|((0x03)<<RF_PWR));
		_delay_ms(10);

    // CRC enable, 1 byte CRC length
    nRF_SetRegister(CONFIG,nrf24_CONFIG);
		_delay_ms(10);

    // Auto Acknowledgment
    nRF_SetRegister(EN_AA,(1<<ENAA_P0)|(1<<ENAA_P1)|(0<<ENAA_P2)|(0<<ENAA_P3)|(0<<ENAA_P4)|(0<<ENAA_P5));
		_delay_ms(10);

    // Enable RX addresses
    nRF_SetRegister(EN_RXADDR,(1<<ERX_P0)|(1<<ERX_P1)|(0<<ERX_P2)|(0<<ERX_P3)|(0<<ERX_P4)|(0<<ERX_P5));
		_delay_ms(10);

    // Auto retransmit delay: 1000 us and Up to 15 retransmit trials
    nRF_SetRegister(SETUP_RETR,(0x04<<ARD)|(0x0F<<ARC));
		_delay_ms(10);

    // Dynamic length configurations: No dynamic length
    nRF_SetRegister(DYNPD,(0<<DPL_P0)|(0<<DPL_P1)|(0<<DPL_P2)|(0<<DPL_P3)|(0<<DPL_P4)|(0<<DPL_P5));
		_delay_ms(10);

	uint8_t tx_mac[5] = {0xE7,0xE7,0xE7,0xE7,0xE7};
	uint8_t rx_mac[5] = {0xD7,0xD7,0xD7,0xD7,0xD7};
	
	USART_putstring("Tx cim beallitasa: E7:E7:E7:E7:E7\n\r");
	/* Set the module's own address */
	nrf24_rx_address(rx_mac);
		_delay_ms(10);

	USART_putstring("Rx cim beallitasa: D7:D7:D7:D7:D7\n\r");
	/* Set the transmit address */
	nrf24_tx_address(tx_mac);
		_delay_ms(10);

	USART_putstring("Inicializalas vege\n\r");

	USART_putstring("Inicializalas vege\n\r");
	nRF_powerUpRx();

	USART_putstring("Belepett hallgato modba\n\r");

	uint8_t data_array[4];

	DDRC = (1<<PC5);

    while(1)
    {
        if(nrf24_dataReady())
		{
    		nrf24_getData(data_array);  
			USART_putstring("Adat beerkezett\n\r");
			/*USART_Transmit(data_array[0]);
			USART_Transmit(data_array[1]);
			USART_Transmit(data_array[2]);
			USART_Transmit(data_array[3]);*/

			if(data_array[0] == 0x04)
				USART_putstring("1. payload: 0x04\n\r"); 
			if(data_array[1] == 0x14)
				USART_putstring("2. payload: 0x14\n\r"); 
			if(data_array[1] == 0x01)
				USART_putstring("3. payload: 0x01\n\r"); 
			if(data_array[2] == 0x02)
				USART_putstring("4. payload: 0x02\n\r"); 
			PORTC |= (1<<PC5);
			_delay_ms(250);
			PORTC &= ~(1<<PC5);
		}
    }
}
