/*
 * SPI.c
 *
 * Created: 2015.08.25. 19:51:42
 *  Author: Szabi
 */ 
#include <stdio.h>
#include <avr/io.h>
#include "spi.h"
#include "usart.h"

void SPI_Init(void)
{
	/* Set MOSI, SCK, CE (PB2) and CSN (PB1) output, all others input */
	DDRB |= (1<<PB3) | (1<<PB5) | (1<<PB1) | (1<<PB2);
	/* Enable SPI, Master, set clock rate fck/4 */
	SPCR = (1<<SPE) | (1<<MSTR);
	CE_lo();
	CSN_hi();
}

uint8_t SPI_Send(char cData)
{
	/* Start transmission */
	SPDR = cData;
	/* Wait for transmission complete */
	while(!(SPSR & (1<<SPIF)));
	
	return SPDR;
}


char SPI_Receive(void)
{
/* Wait for reception complete */
USART_putstring("adatra var\r");
while(!(SPSR & (1<<SPIF)))
;
USART_putstring("adat megjott\r");
/* Return data register */
return SPDR;
}
